/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.reportmapping.client.util;

import com.kingdee.eas.csinterface.reportmapping.ReportMappingEntryCollection;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingEntryInfo;
import com.kingdee.eas.csinterface.reportmapping.ReportMappingInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MidFieldNameSet {
    private Set<String> all = new HashSet<String>();
    private Set<String> visible = new HashSet<String>();

    public MidFieldNameSet(ReportMappingInfo info) {
        ReportMappingEntryCollection coll = info.getEntrys();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            ReportMappingEntryInfo entry = (ReportMappingEntryInfo)iterator.next();
            String midFieldName = entry.getMidFieldName();
            this.all.add(midFieldName);
            if (entry.isDropped()) continue;
            this.visible.add(midFieldName);
        }
    }

    public boolean isVisible() {
        return true;
    }

    public String generateFieldNameWhenExists(String fieldName) {
        String newFieldName = fieldName;
        while (this.all.contains(newFieldName)) {
            newFieldName = this.calcNewFieldName(newFieldName);
        }
        return newFieldName;
    }

    private String calcNewFieldName(String fieldName) {
        if (fieldName.endsWith("_")) {
            return fieldName + "1";
        }
        int index = fieldName.lastIndexOf("_");
        if (-1 == index) {
            return this.addInitialSuffix(fieldName);
        }
        String str = fieldName.substring(index + 1);
        String fieldRealName = fieldName.substring(0, index);
        try {
            int currentSuffix = Integer.parseInt(str);
            return fieldRealName + "_" + ++currentSuffix;
        }
        catch (Exception e) {
            return this.addInitialSuffix(fieldName);
        }
    }

    private String addInitialSuffix(String fieldName) {
        return fieldName + "_1";
    }
}

