/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.csinterface.basedatasyn.client.BaseDataSynValueMapEditUI;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractBaseDataMappingImportUI;
import com.kingdee.eas.csinterface.syncdatabase.client.BaseDataMapingEditUI;
import com.kingdee.eas.csinterface.util.Export2FileUtil;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class BaseDataMappingImportUI
extends AbstractBaseDataMappingImportUI {
    private static final long serialVersionUID = 7543984079439367999L;
    private static final Logger logger = CoreUIObject.getLogger(BaseDataMappingImportUI.class);
    private Class clz = null;
    private String filename = null;
    private String message = null;

    public BaseDataMappingImportUI builderInfo(Class clz, String filename, String message) {
        this.clz = clz;
        this.filename = filename;
        this.message = message;
        return this;
    }

    public void onLoad() throws Exception {
        this.btnChoose.setLimitedSize(false);
        this.btnChoose.setSize(27, 21);
        super.onLoad();
        this.templateTipLabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BaseDataMappingImportUI.this.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseDataMappingImportUI.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BaseDataMappingImportUI.this.downloadExcelTemplate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadExcelTemplate() {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            File file = Export2FileUtil.getExportFileWithOverrideTip((Component)((Object)this), this.message + "\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d", "\u4fdd\u5b58", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c", this.message + "\u5bfc\u5165\u6a21\u677f.xls");
            if (null != file) {
                inputStream = this.clz.getResourceAsStream(this.filename);
                outputStream = new FileOutputStream(file);
                IOUtils.copy(inputStream, outputStream);
                MsgBox.showInfo((Component)((Object)this), (String)(this.message + "\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u6210\u529f\u3002"));
            }
        }
        catch (Exception ex) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)(this.message + "\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\u3002"), (String)ex.getMessage(), (int)8188);
        }
        finally {
            IOUtils.closeInputStreamQuietly(inputStream);
            IOUtils.closeOutputStreamQuietly(outputStream);
        }
    }

    @Override
    protected void btnChoose_actionPerformed(ActionEvent e) throws Exception {
        File file = Export2FileUtil.getDialogFile((Component)((Object)this), "\u9009\u62e9\u5bfc\u5165\u6587\u4ef6", "\u6253\u5f00", new String[]{"xls"}, "Excel 1997\u62162003\u7248\u672c");
        if (null != file) {
            this.importFilePath.setText(file.getPath());
        } else {
            this.importFilePath.setText(null);
        }
    }

    @Override
    protected void btnImport_actionPerformed(ActionEvent e) throws Exception {
        String filePath = this.importFilePath.getText();
        if (null == filePath || filePath.trim().length() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u6587\u4ef6\u3002");
            return;
        }
        try {
            this.loadExcelData(filePath);
            this.destroyWindow();
        }
        catch (Exception ex) {
            MsgBox.showInfo((Component)((Object)this), (String)("\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\u3002" + ex.getMessage()));
        }
    }

    private void loadExcelData(String filePath) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (null != object && object instanceof BaseDataMapingEditUI) {
            BaseDataMapingEditUI editUI = (BaseDataMapingEditUI)((Object)object);
            editUI.loadDataFromExcel(filePath);
        } else if (null != object && object instanceof BaseDataSynValueMapEditUI) {
            BaseDataSynValueMapEditUI editUI = (BaseDataSynValueMapEditUI)((Object)object);
            editUI.loadDataFromExcel(filePath);
        } else {
            throw new Exception("\u627e\u4e0d\u5230\u5f15\u7528\u7684BaseDataMapingEditUI\u5bf9\u8c61\u3002\u5f00\u53d1\u9519\u8bef\u3002");
        }
    }

    @Override
    protected void exitButton_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

