/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.csinterface.agent.EipUserFactory;
import com.kingdee.eas.csinterface.agent.EipUserInfo;
import com.kingdee.eas.csinterface.business.client.BizWizardEditUI;
import com.kingdee.eas.csinterface.business.common.BusinessConstants;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractSrcDBViewEditUI;
import com.kingdee.eas.csinterface.syncdatabase.client.ConnectionListUI;
import com.kingdee.eas.csinterface.syncdatabase.client.util.CheckMainViewAfterSave;
import com.kingdee.eas.csinterface.syncdatabase.client.util.DBViewValidateUtils;
import com.kingdee.eas.csinterface.syncdatabase.client.util.KSQLFacadeClientUtil;
import com.kingdee.eas.csinterface.syncdatabase.client.util.OptionalPromptDataSourceType;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.EIPUIClassParamUtil;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.ThrowableHelper;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.IKSQLFacade;
import com.kingdee.eas.csinterface.utils.ViewSQLSimpleParser;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SrcDBViewEditUI
extends AbstractSrcDBViewEditUI {
    private static final Logger logger = CoreUIObject.getLogger(SrcDBViewEditUI.class);
    private Component[] components;

    public SrcDBViewEditUI() throws Exception {
        this.components = new Component[]{this.txtNumber, this.txtName, this.prmtconnection, this.dbType, this.txtcreateViewSql};
        this.dsType = OptionalPromptDataSourceType.initDataSourceType(new Object[]{DataSourceType.jdbc, DataSourceType.agent}, this.dataBinder);
        this.dsType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SrcDBViewEditUI.this.beforeActionPerformed(e);
                try {
                    SrcDBViewEditUI.this.dsType_actionPerformed(e);
                }
                catch (Exception exc) {
                    SrcDBViewEditUI.this.handUIException(exc);
                }
                finally {
                    SrcDBViewEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setEnabled(false);
        ComponentHelper.setFocusTraversalPolicy((Container)((Object)this), this.components);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contmainView.setEnabled(false);
    }

    @Override
    protected void dsType_actionPerformed(ActionEvent e) throws Exception {
        this.dsTypeChangeUpdatePrmtState();
    }

    public void dsTypeChangeUpdatePrmtState() throws Exception {
        DataSourceType dsType = (DataSourceType)((Object)this.dsType.getSelectedItem());
        if (dsType == null) {
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            this.updatePrmtState(true);
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            this.updatePrmtState(false);
        } else {
            throw new Exception("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
        }
    }

    public void updatePrmtState(boolean flag) {
        this.prmtconnection.setEnabled(flag);
        this.prmtagentUser.setEnabled(!flag);
        if (flag) {
            this.prmtagentUser.setValue(null);
        } else {
            this.prmtconnection.setValue(null);
        }
    }

    public void initPrmtState() {
        this.prmtconnection.setHistoryRecordEnabled(false);
        this.prmtagentUser.setHistoryRecordEnabled(false);
        String oprtState = this.getOprtState();
        if (OprtState.VIEW.equalsIgnoreCase(oprtState)) {
            this.prmtagentUser.setEnabled(false);
            this.prmtconnection.setEnabled(false);
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (OprtState.EDIT.equalsIgnoreCase(this.getOprtState())) {
            this.disabledFields();
        }
        this.components[0].requestFocusInWindow();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SrcDBViewFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        SrcDBViewInfo objectValue = new SrcDBViewInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        if (obj instanceof BizWizardEditUI) {
            String dbConnId = (String)uiContext.get(BusinessConstants.getBtnCodeEntryColName("srcView"));
            if (!StringUtils.isEmpty((String)dbConnId)) {
                uiContext.put("ID", dbConnId);
            }
            if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
                this.disabledSpecial();
            }
            this.contdsType.setEnabled(false);
            if (uiContext.get("rootOprtState").equals(OprtState.VIEW)) {
                this.initialBarItem(false);
            }
        }
        super.onLoad();
        this.btnAttachment.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.prmtconnection.setRequired(true);
        this.prmtagentUser.setRequired(true);
        this.dbType.setAccessAuthority(0);
        this.dbType.setEditable(false);
        this.dbType.setEnabled(false);
        this.dbType.setSelectedIndex(-1);
        this.setDBTypeValue();
        final SrcDBViewEditUI outter = this;
        this.prmtconnection.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                outter.changeFileter4F7Connection();
            }
        });
        this.prmtconnection.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SrcDBViewEditUI.this.setDBTypeValue();
            }
        });
        this.initPrmtState();
        if (obj instanceof BizWizardEditUI && (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState()) || OprtState.VIEW.equalsIgnoreCase(this.getOprtState()))) {
            if (OprtState.ADDNEW.equalsIgnoreCase(this.getOprtState())) {
                this.txtNumber.setText((String)uiContext.get("txtNumber"));
                this.txtName.setSelectedItemData(uiContext.get("txtName"));
            }
            this.dsType.setSelectedItem((Object)((DataSourceType)((Object)uiContext.get("dsType"))));
            String txtConnId = (String)uiContext.get("txtdbConnId");
            if (!StringUtils.isEmpty((String)txtConnId)) {
                IObjectPK connId = CommonUtil.convert2PK(txtConnId);
                if (DataSourceType.jdbc.equals((Object)((DataSourceType)((Object)this.dsType.getSelectedItem())))) {
                    ConnectionInfo connInfo = ConnectionFactory.getRemoteInstance().getConnectionInfo(connId);
                    this.prmtconnection.setData((Object)connInfo);
                    this.prmtconnection.setEnabled(false);
                } else {
                    this.prmtagentUser.setData((Object)EipUserFactory.getRemoteInstance().getEipUserInfo(connId));
                    this.prmtagentUser.setEnabled(false);
                }
            }
        }
    }

    private void setDBTypeValue() {
        this.dbType.setAccessAuthority(0);
        this.dbType.setEditable(false);
        this.dbType.setEnabled(false);
        this.dbType.setSelectedIndex(-1);
        ConnectionInfo connectionInfo = (ConnectionInfo)this.prmtconnection.getValue();
        if (null != connectionInfo) {
            DBType targetDbType = connectionInfo.getDBType();
            this.btnExcuteKSQL.setEnabled(true);
            if (DBType.MySql.equals((Object)targetDbType)) {
                this.btnExcuteKSQL.setEnabled(false);
            }
            if (null != targetDbType) {
                int count = this.dbType.getItemCount();
                for (int i = 0; i < count; ++i) {
                    if (targetDbType.compareTo(this.dbType.getItemAt(i)) != 0) continue;
                    this.dbType.setSelectedIndex(i);
                    break;
                }
            }
        }
    }

    private void changeFileter4F7Connection() {
        ConnectionListUI listUI = null;
        try {
            listUI = new ConnectionListUI();
        }
        catch (Exception e1) {
            logger.error((Object)ThrowableHelper.toString(e1));
        }
        FilterInfo filterInfo = new FilterInfo();
        HashMap<String, FilterInfo> ctx = new HashMap<String, FilterInfo>();
        ctx.put("ConnectionListUI_FilterInfo", filterInfo);
        if (null != listUI) {
            listUI.setF7Use(true, ctx);
            this.prmtconnection.setSelector((KDPromptSelector)listUI);
        }
    }

    @Override
    public void actionExcuteKSQL_actionPerformed(ActionEvent e) throws Exception {
        String ksql = this.txtcreateViewSql.getText();
        this.excuteKSQL(ksql, false);
    }

    private void excuteKSQL(String ksql, boolean dialect) throws EASBizException {
        block21: {
            try {
                if (this.isModify()) {
                    MsgBox.showWarning((String)"\u89c6\u56fe\u4fe1\u606f\u5df2\u4fee\u6539\uff0c\u8bf7\u4fdd\u5b58\u540e\u518d\u6267\u884c");
                    return;
                }
                if (StringUtils.isEmpty((String)ksql)) {
                    MsgBox.showWarning((String)"\u8bf7\u8f93\u5165\u521b\u5efa\u89c6\u56fe\u8bed\u53e5\u540e\u518d\u6267\u884c");
                    return;
                }
                ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(ksql);
                ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
                ArrayList<String> ksqls = new ArrayList<String>();
                ArrayList<String> viewNames = new ArrayList<String>();
                String mainViewName = null;
                int index = 0;
                for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
                    ++index;
                    if (!parseResult.isCreateViewSql()) {
                        MsgBox.showWarning((String)((index > 1 ? "(\u4ee5;\u53f7\u5207\u5206\u7684\u7b2c" + index + "\u6761)" : "") + "\u4e0d\u652f\u6301\u7684\u8bed\u53e5\u201c" + parseResult.getFrontWordString() + "\u201d\uff0c\u8bf7\u4f7f\u7528\u201ccreate view...\u201d\u8bed\u53e5"));
                        return;
                    }
                    if (parseResult.hasHeadpk) {
                        mainViewName = parseResult.viewName;
                    }
                    viewNames.add(parseResult.viewName);
                    ksqls.add(dialect ? "/*dialect*/ ".intern() + parseResult.viewSql : parseResult.viewSql);
                }
                DataSourceType dsType = (DataSourceType)((Object)this.dsType.getSelectedItem());
                if (DataSourceType.jdbc.equals((Object)dsType)) {
                    ConnectionInfo conn = (ConnectionInfo)this.prmtconnection.getData();
                    if (null == conn) {
                        MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5!");
                        return;
                    }
                    ObjectUuidPK pk = new ObjectUuidPK(conn.getId());
                    conn = ConnectionFactory.getRemoteInstance().getConnectionInfo((IObjectPK)pk);
                    DataBaseType dbType = DataBaseType.getInstance(conn.getDBType().getName());
                    KSQLFacadeClientUtil ksqlFacadeUtil = new KSQLFacadeClientUtil(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword());
                    Object[] existViews = ksqlFacadeUtil.existViews(viewNames.toArray(new String[0]));
                    if (existViews != null && existViews.length > 0) {
                        String viewNamesStr = StringUtils.arrayToString((Object[])existViews, (String)",\n");
                        int result = MsgBox.showConfirm2((String)("\u8981\u521b\u5efa\u7684" + parseResults.size() + "\u4e2a\u89c6\u56fe\u4e2d\uff0c\u6709" + existViews.length + "\u4e2a\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u5206\u522b\u4e3a\uff1a" + viewNamesStr + "\u3002\n\u662f\u5426\u8981\u5f3a\u5236\u5220\u9664\u8fd9\u4e9b\u89c6\u56fe\uff0c\u91cd\u65b0\u6267\u884c\u521b\u5efa\uff1f"));
                        if (0 != result) {
                            logger.info((Object)"\u9009\u62e9\u4e86\u4e0d\u5f3a\u5236\u5220\u9664\u89c6\u56fe");
                            return;
                        }
                        logger.info((Object)("\u9009\u62e9\u4e86\u5f3a\u5236\u5220\u9664\u89c6\u56fe:" + viewNamesStr));
                    }
                    try {
                        String msg = ksqlFacadeUtil.executeUpdate(ksqls.toArray(new String[0]), (String[])existViews);
                        if (msg == null) {
                            MsgBox.showInfo((String)"SQL\u6267\u884c\u6210\u529f!");
                            this.checkMainViewCorrect();
                        } else {
                            MsgBox.showDetailAndOK((Component)((Object)this), (String)"SQL\u6267\u884c\u5931\u8d25!", (String)msg, (int)1);
                        }
                    }
                    catch (Exception e) {
                        MsgBox.showDetailAndOK((Component)((Object)this), (String)"SQL\u6267\u884c\u5931\u8d25!", (String)e.getMessage(), (int)1);
                    }
                    DBViewValidateUtils.validateSrcViewAll((Component)((Object)this), mainViewName, viewNames, conn.getId().toString());
                    break block21;
                }
                if (DataSourceType.agent.equals((Object)dsType)) {
                    EipUserInfo eipUser = (EipUserInfo)this.prmtagentUser.getValue();
                    if (null == eipUser) {
                        MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u7aef\u4ee3\u7406!");
                        return;
                    }
                    if (StringUtils.isEmpty((String)mainViewName)) {
                        MsgBox.showWarning((String)"\u4e3b\u89c6\u56fe(\u5355\u636e)\u540d\u79f0\u4e3a\u7a7a");
                        return;
                    }
                    if (0 != MsgBox.showConfirm2((String)("\u662f\u5426\u5206\u914d\u89c6\u56fe\u521b\u5efa\u4efb\u52a1\u7ed9\u5ba2\u6237\u7aef\u4ee3\u7406'" + eipUser.getNumber() + "'?"))) {
                        return;
                    }
                    IKSQLFacade ksqlFacade = (IKSQLFacade)RpcProxy.wrapRequired(IKSQLFacade.class, (String)"com.kingdee.eas.csinterface.utils.KSQLFacade");
                    String msg = ksqlFacade.createViewAssignToAgent(eipUser, ksqls.toArray(new String[0]), viewNames.toArray(new String[0]), mainViewName);
                    if (!StringUtils.isEmpty((String)msg)) {
                        MsgBox.showWarning((String)msg);
                    } else {
                        MsgBox.showInfo((String)("\u89c6\u56fe\u521b\u5efa\u4efb\u52a1\u5df2\u6210\u529f\u5206\u914d\u7ed9\u5ba2\u6237\u4ee3\u7406'" + eipUser.getNumber() + "'"));
                    }
                    break block21;
                }
                throw new BOSException("\u4e0d\u652f\u6301\u7684\u8d44\u6e90\u7c7b\u522b'" + dsType.getAlias() + "'");
            }
            catch (Exception ex) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u6267\u884c\u5931\u8d25\u3002", (String)ex.getMessage(), (int)0);
            }
        }
    }

    @Override
    public void actionExcuteDialectSQL_actionPerformed(ActionEvent e) throws Exception {
        String dialectSQL = this.txtcreateViewSql.getText();
        this.excuteKSQL(dialectSQL, true);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        String mainViewName;
        ConnectionInfo conn;
        String ksql = this.txtcreateViewSql.getText();
        String number = this.txtNumber.getStringValue();
        String name = this.txtName.getSelectedItem().toString();
        DataSourceType dsType = (DataSourceType)((Object)this.dsType.getSelectedItem());
        if (StringUtil.isEmpty((String)number)) {
            MsgBox.showWarning((String)"\u8bf7\u8f93\u5165\u7f16\u7801");
            return;
        }
        if (StringUtil.isEmpty((String)name)) {
            MsgBox.showWarning((String)"\u8bf7\u8f93\u5165\u540d\u79f0");
            return;
        }
        if (StringUtil.isEmpty((String)ksql)) {
            MsgBox.showWarning((String)"\u8bf7\u8f93\u5165\u521b\u5efa\u89c6\u56fe\u7684SQL");
            return;
        }
        if (DataSourceType.agent.equals((Object)dsType)) {
            EipUserInfo eipUser = (EipUserInfo)this.prmtagentUser.getValue();
            if (null == eipUser) {
                MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u7aef\u4ee3\u7406!");
                return;
            }
        } else if (DataSourceType.jdbc.equals((Object)dsType) && null == (conn = (ConnectionInfo)this.prmtconnection.getValue())) {
            MsgBox.showWarning((String)"\u8bf7\u9009\u62e9\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5!");
            return;
        }
        ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(ksql);
        ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
        ViewSQLSimpleParser.ViewParseResult mainSqlView = null;
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            if (!parseResult.hasHeadpk || StringUtils.isEmpty((String)parseResult.viewName) || parseResult.viewName.endsWith("_all")) continue;
            if (mainSqlView != null) {
                MsgBox.showWarning((String)"\u6700\u591a\u53ea\u80fd\u8f93\u5165\u4e00\u4e2a\u521b\u5efa\u4e1a\u52a1\u5355\u636e\u89c6\u56fe\u7684\u8bed\u53e5(\u8bed\u53e5\u4e2d\u5305\u542b\u201cas headpk\u201d)");
                return;
            }
            if (!parseResult.headpkName.equals("headpk") && !parseResult.headpkName.equals("HEADPK")) {
                MsgBox.showWarning((String)"\u6e90\u89c6\u56fe\u4e2d\u7684headpk\u522b\u540d\u5fc5\u987b\u5168\u5927\u5199\u6216\u5168\u5c0f\u5199");
                return;
            }
            mainSqlView = parseResult;
        }
        String string = mainViewName = mainSqlView == null ? null : mainSqlView.viewName;
        if (StringUtils.isEmpty((String)mainViewName)) {
            MsgBox.showError((String)"\u5355\u636e\u89c6\u56fe\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        this.txtmainView.setText(mainViewName);
        this.editData.setMainView(mainViewName);
        if (this.editData.getId() == null && DataSourceType.agent.equals((Object)((DataSourceType)((Object)this.dsType.getSelectedItem())))) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("dsType", (Object)DataSourceType.agent.getName(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("agentUser.id", (Object)((EipUserInfo)this.prmtagentUser.getData()).getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("mainView", (Object)mainViewName, CompareType.EQUALS));
            ObjectBaseCollection coll = SrcDBViewFactory.getRemoteInstance().getObjectBaseCollection(viewInfo);
            if (coll != null && coll.size() > 0) {
                MsgBox.showWarning((String)("\u8be5\u5ba2\u6237\u4ee3\u7406\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a'" + mainViewName + "'\u7684\u89c6\u56fe!"));
                return;
            }
        }
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.editData.setNumber(number);
        this.editData.setName(name);
        SrcDBViewFactory.getRemoteInstance().checkNumberDup(this.editData);
        SrcDBViewFactory.getRemoteInstance().checkNameDup(this.editData);
        super.actionSubmit_actionPerformed(e);
    }

    private void checkMainViewCorrect() {
        DataSourceType dsType = (DataSourceType)((Object)this.dsType.getSelectedItem());
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            final LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u6821\u9a8c\u4e3b\u89c6\u56fe\u662f\u5426\u6b63\u786e,\u8bf7\u7a0d\u540e...");
            dialog.setLongTimeTask(new ILongTimeTask2(){
                private Exception exception = null;

                @Override
                public Object exec() throws Exception {
                    try {
                        CheckMainViewAfterSave.checkMainViewAfterSave(SrcDBViewEditUI.this.editData.getMainView());
                        return "success";
                    }
                    catch (Exception exc) {
                        logger.error((Object)exc.getMessage());
                        this.exception = exc;
                        return "fail";
                    }
                }

                @Override
                public void afterExec(Object result) throws Exception {
                    if (this.exception != null) {
                        String message = null;
                        Throwable cause = this.exception;
                        while (StringUtils.isEmpty((String)(message = cause.getMessage())) && (cause = cause.getCause()) != null) {
                        }
                        MsgBox.showDetailAndOK((Component)dialog.getParent(), (String)message, (String)ThrowableHelper.toString(cause), (int)2);
                    }
                }
            });
            dialog.show();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.disabledFields();
        this.disabledSpecial();
        this.dsTypeChangeUpdatePrmtState();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtName.setSelectedItemData(null);
    }

    public void disabledFields() {
        this.txtNumber.setEnabled(false);
        this.txtName.setEnabled(false);
    }

    protected void doAfterSave(IObjectPK pk) throws Exception {
        super.doAfterSave(pk);
        this.writeBackData(pk);
        this.disabledSpecial();
        this.disabledFields();
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        super.doAfterSubmit(pk);
        this.writeBackData(pk);
        this.disabledSpecial();
        this.disabledFields();
    }

    private void writeBackData(IObjectPK pk) {
        Map uiContext = this.getUIContext();
        Object obj = uiContext.get("BizWizardEditUiKey");
        if (obj instanceof BizWizardEditUI) {
            BizWizardEditUI editUi = (BizWizardEditUI)((Object)obj);
            editUi.setValueAfterSubmit("srcView", pk.toString());
        }
    }

    public void disabledSpecial() {
        Object obj = this.getUIContext().get("BizWizardEditUiKey");
        if (obj instanceof BizWizardEditUI) {
            this.kDLabelContainer1.setEnabled(false);
            this.kDLabelContainer2.setEnabled(false);
            this.contdsType.setEnabled(false);
            this.contagentUser.setEnabled(false);
            this.contconnection.setEnabled(false);
        }
    }

    private void initialBarItem(boolean enable) {
        this.btnCopy.setEnabled(enable);
        this.btnSave.setEnabled(enable);
        this.btnEdit.setEnabled(enable);
        this.btnExcuteKSQL.setEnabled(enable);
        this.btnExcuteDialectSQL.setEnabled(enable);
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        super.applyDefaultValue(vo);
        EIPUIClassParamUtil.applyDefaultValue(this.getUIContext(), "configType", "configType", vo, "applicationScope", null);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("applicationScope"));
        return sic;
    }
}

