/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.UserDiscreteAccreditUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.business.client.BizWizardEditUI;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionFactory;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.syncdatabase.DataSourceType;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewFactory;
import com.kingdee.eas.csinterface.syncdatabase.SrcDBViewInfo;
import com.kingdee.eas.csinterface.syncdatabase.client.AbstractSrcDBViewListUI;
import com.kingdee.eas.csinterface.syncdatabase.client.util.KSQLFacadeClientUtil;
import com.kingdee.eas.csinterface.util.BtnEASPivot;
import com.kingdee.eas.csinterface.util.EIPUIClassParamUtil;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.eas.csinterface.utils.KSQLUtil;
import com.kingdee.eas.csinterface.utils.ViewSQLSimpleParser;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.F7Render;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SrcDBViewListUI
extends AbstractSrcDBViewListUI
implements KDPromptSelector {
    private static final Logger logger = CoreUIObject.getLogger(SrcDBViewListUI.class);
    private boolean isF7Use;
    private F7Render f7Delegate;

    public SrcDBViewListUI() throws Exception {
    }

    public SrcDBViewListUI(HashMap ctx) throws Exception {
        this.isF7Use = true;
        this.f7Delegate = new F7Render((ListUI)this, (Map)ctx);
        this.f7Delegate.init();
    }

    public void show() {
        if (this.isF7Use) {
            this.f7Delegate.show();
        } else {
            super.show();
        }
    }

    protected boolean initDefaultFilter() {
        if (this.isF7Use) {
            return true;
        }
        return super.initDefaultFilter();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor f7QueryExecutor;
        if (this.isF7Use && this.mainQueryPK.equals(queryPK) && (f7QueryExecutor = this.f7Delegate.getF7QueryExecutor(queryPK, viewInfo)) != null) {
            return f7QueryExecutor;
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void beforeExcutQuery(EntityViewInfo queryFilter) {
        super.beforeExcutQuery(queryFilter);
        if (this.isF7Use) {
            this.f7Delegate.mergeF7Filter(queryFilter);
        }
        EIPUIClassParamUtil.setFilterByUIParamValue(this.getUIContext(), "configType", "configType", queryFilter, "applicationScope", null, "AND");
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.isF7Use) {
            this.f7Delegate.actionConfirm();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    public boolean isCanceled() {
        return this.f7Delegate.isF7Cancel();
    }

    public Object getData() {
        return this.f7Delegate.getF7Data();
    }

    public void setF7Use(boolean isF7Use, HashMap ctx) {
        this.isF7Use = isF7Use;
        if (isF7Use) {
            try {
                this.setPreferredSize(new Dimension(800, 600));
                if (ctx == null) {
                    ctx = new HashMap();
                }
                this.f7Delegate = new F7Render((ListUI)this, ctx);
                this.f7Delegate.init();
                this.initLayout();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return SrcDBViewFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        SrcDBViewInfo objectValue = new SrcDBViewInfo();
        return objectValue;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        EntityViewInfo view = (EntityViewInfo)dataObject;
        if (view.getSorter() == null || view.getSorter().size() == 0) {
            SorterItemCollection sorterColl = new SorterItemCollection();
            SorterItemInfo orderTimeSorter = new SorterItemInfo("lastUpdateTime");
            orderTimeSorter.setSortType(SortType.DESCEND);
            sorterColl.add(orderTimeSorter);
            view.setSorter(sorterColl);
        }
        super.setDataObject(dataObject);
    }

    protected EntityViewInfo getDefaultEntityViewInfo() {
        FilterInfo filter;
        EntityViewInfo view = super.getDefaultEntityViewInfo();
        if (null == view) {
            view = new EntityViewInfo();
        }
        if (null == (filter = view.getFilter())) {
            filter = new FilterInfo();
            view.setFilter(filter);
        }
        return view;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object menuName = this.getUIContext().get("MainMenuName");
        if (menuName != null && !StringUtils.isEmpty((String)menuName.toString())) {
            super.setUITitle(menuName.toString());
        }
        this.tblMain.getHead().setRowHeight(0, 20);
        ObjectStringPK userPK = new ObjectStringPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        ObjectStringPK orgPK = new ObjectStringPK(SysContext.getSysContext().getCurrentOrgUnit().getId().toString());
        boolean hasFuncPerm = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "\u6e90\u7cfb\u7edf\u89c6\u56fe_\u7528\u6237\u6570\u636e\u6743\u9650");
        if (hasFuncPerm) {
            this.btnUserPermission.setVisible(true);
            this.btnUserPermission.setEnabled(true);
        } else {
            this.btnUserPermission.setVisible(false);
            this.btnUserPermission.setEnabled(false);
        }
        BtnEASPivot.btnInVisible(this);
    }

    @Override
    public void actionUserPermission_actionPerformed(ActionEvent e) throws Exception {
        super.actionUserPermission_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bosObjectType", (Object)new SrcDBViewInfo().getBOSType());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(UserDiscreteAccreditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        window.show();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        Object bizward = this.getUIContext().get("BizWizardEditUiKey");
        if (bizward != null) {
            BizWizardEditUI wizardUi = (BizWizardEditUI)((Object)bizward);
            wizardUi.setHasModified(true);
        }
    }

    public void deleteSrcViews(boolean dialect, SrcDBViewInfo info) throws BOSException, EASBizException {
        String ksql = info.getCreateViewSql();
        if (StringUtils.isEmpty((String)ksql)) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u89c6\u56fe\u8bed\u53e5\u4e3a\u7a7a\uff0c\u4e0d\u5fc5\u5220\u9664\u89c6\u56fe\u3002"));
            return;
        }
        ViewSQLSimpleParser simpleParser = new ViewSQLSimpleParser(ksql);
        ArrayList<ViewSQLSimpleParser.ViewParseResult> parseResults = simpleParser.getParseResult();
        ArrayList<String> ksqls = new ArrayList<String>();
        ArrayList<String> viewNames = new ArrayList<String>();
        Object mainViewName = null;
        int index = 0;
        for (ViewSQLSimpleParser.ViewParseResult parseResult : parseResults) {
            ++index;
            viewNames.add(parseResult.viewName);
            ksqls.add(dialect ? "/*dialect*/" + parseResult.viewSql : parseResult.viewSql);
        }
        DataSourceType dsType = info.getDsType();
        if (dsType == null) {
            logger.info((Object)("\u6267\u884c\u65f6\u95f4\uff1a" + new Date() + ",\u7f51\u7edc\u7c7b\u578b\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\u89c6\u56fe"));
            return;
        }
        if (DataSourceType.jdbc.equals((Object)dsType)) {
            ConnectionInfo conn = info.getConnection();
            if (null == conn) {
                return;
            }
            ObjectUuidPK pk = new ObjectUuidPK(conn.getId());
            conn = ConnectionFactory.getRemoteInstance().getConnectionInfo((IObjectPK)pk);
            DataBaseType dbType = DataBaseType.getInstance(info.getDbType().getName());
            KSQLFacadeClientUtil ksqlFacadeUtil = new KSQLFacadeClientUtil(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword());
            Object[] existViews = ksqlFacadeUtil.existViews(viewNames.toArray(new String[0]));
            if (existViews != null && existViews.length > 0) {
                String viewNamesStr = StringUtils.arrayToString((Object[])existViews, (String)",");
                logger.info((Object)("\u9009\u62e9\u4e86\u5f3a\u5236\u5220\u9664\u89c6\u56fe:" + viewNamesStr));
                for (int i = 0; i < existViews.length; ++i) {
                    if (((String)existViews[i]).charAt(0) != '\"') {
                        existViews[i] = ((String)existViews[i]).toUpperCase();
                    }
                    existViews[i] = "drop view " + (String)existViews[i];
                }
                try {
                    KSQLUtil.executeUpdate(dbType, conn.getIP(), conn.getPort(), conn.getInstance(), conn.getUsername(), conn.getPassword(), (String[])existViews);
                    logger.info((Object)"\u5220\u9664\u89c6\u56fe\u6210\u529f\u3002");
                }
                catch (Exception e) {
                    MsgBox.showInfo((String)e.getMessage());
                    logger.error((Object)("\u5220\u9664\u89c6\u56fe\u5931\u8d25\u3002\n" + e));
                }
            }
        } else if (DataSourceType.agent.equals((Object)dsType)) {
            // empty if block
        }
    }
}

