/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.client.util;

import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.syncdatabase.DBType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CSInterfaceFilter {
    public static final String[] LEFTBRACKET = new String[]{"   ", "  ( ", " (( ", "((( ", "(((("};
    public static final String[] RIGHTBRACKET = new String[]{"   ", "  ) ", " )) ", "))) ", "))))"};
    public static final String[] COMPORE = new String[]{" ", " = ", "> ", ">= ", "<", "<=", "\u4e3a\u7a7a", "\u4e0d\u4e3a\u7a7a"};
    public static final String[] RELATION = new String[]{"\u4e14", "\u6216", "   "};
    public static final String ISNULL = " is null";
    public static final String ISNOTNULL = " is  not null";
    static final String AND = " and ";
    static final String OR = " or";
    static final String BLANK = " ";
    static final String NULL = "";
    private DBType dbType;
    private String leftBracket;
    private BillMappingEntryInfo feild;
    private String compare;
    private Object value;
    private String rightBracket;
    private String relation;

    public CSInterfaceFilter() {
    }

    public void setDBType(DBType dbType) {
        this.dbType = dbType;
    }

    public CSInterfaceFilter(String leftBracket, BillMappingEntryInfo feild, String compare, String value, String rightBracket, String relation) {
        this.leftBracket = leftBracket;
        this.feild = feild;
        this.compare = compare;
        this.value = value;
        this.rightBracket = rightBracket;
        this.relation = relation;
    }

    public String getCompare() {
        if (COMPORE[6].equals(this.compare)) {
            return ISNULL;
        }
        if (COMPORE[7].equals(this.compare)) {
            return ISNOTNULL;
        }
        if (this.compare == null) {
            return NULL;
        }
        if (ISNULL.equals(this.compare)) {
            return COMPORE[6];
        }
        if (ISNOTNULL.equals(this.compare)) {
            return COMPORE[7];
        }
        if (NULL.equals(this.compare)) {
            return null;
        }
        return this.compare;
    }

    public void setCompare(String compare) {
        this.compare = compare;
    }

    public BillMappingEntryInfo getFeild() {
        return this.feild;
    }

    public void setFeild(BillMappingEntryInfo feild) {
        this.feild = feild;
    }

    public String getLeftBracket() {
        if (this.leftBracket == null) {
            return NULL;
        }
        return this.leftBracket;
    }

    public void setLeftBracket(String leftBracket) {
        this.leftBracket = leftBracket;
    }

    public String getRelation() {
        return this.relation;
    }

    public String getRelationVal() {
        if (RELATION[0].equals(this.relation)) {
            return AND;
        }
        if (RELATION[1].equals(this.relation)) {
            return OR;
        }
        if (this.relation == null) {
            return NULL;
        }
        if (NULL.equals(this.relation.trim())) {
            return NULL;
        }
        throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u5173\u7cfb\uff1a" + this.relation);
    }

    public void setRelation(String relation) {
        this.relation = relation;
    }

    public String getRightBracket() {
        if (this.rightBracket == null) {
            return NULL;
        }
        return this.rightBracket;
    }

    public void setRightBracket(String rightBracket) {
        this.rightBracket = rightBracket;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValueByDBType(Object value) {
        if (value instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateValue = sdf.format(value);
            return "{ts'" + dateValue + "'}";
        }
        return value;
    }

    public static String getFilterValue(List list) {
        StringBuffer sb = new StringBuffer();
        if (list.size() <= 0 || !(list.get(0) instanceof CSInterfaceFilter)) {
            return null;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CSInterfaceFilter filter = (CSInterfaceFilter)list.get(i);
            if (filter.compare == null) continue;
            sb.append(CSInterfaceFilter.analyseRecord(filter));
        }
        return sb.toString();
    }

    private static String analyseRecord(CSInterfaceFilter filter) {
        StringBuffer sb = new StringBuffer();
        sb.append(filter.getLeftBracket());
        sb.append(filter.getFeild().getSrcFieldName());
        sb.append(BLANK);
        if (filter.compare.equals(COMPORE[6])) {
            sb.append(ISNULL);
        } else if (filter.compare.equals(COMPORE[7])) {
            sb.append(ISNOTNULL);
        } else if (!filter.compare.equals(COMPORE[7]) && !filter.compare.equals(COMPORE[6])) {
            sb.append(filter.getCompare());
            sb.append(BLANK);
            if (filter.value instanceof Date) {
                sb.append(filter.getValueByDBType(filter.value));
            } else {
                sb.append("'");
                sb.append(filter.getValue());
                sb.append("'");
            }
        }
        sb.append(BLANK);
        sb.append(filter.getRightBracket());
        sb.append(BLANK);
        sb.append(filter.getRelationVal());
        sb.append(BLANK);
        return sb.toString();
    }
}

