/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.syncdatabase.converter;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.converter.core.Converter;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapInfo;
import com.kingdee.eas.csinterface.syncdatabase.MultiToMultiMapType;
import com.kingdee.eas.csinterface.syncdatabase.util.BaseDataMultiToMultiMapHelper;
import com.kingdee.eas.csinterface.util.CustColor;
import com.kingdee.eas.csinterface.utils.BaseDataMappingUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.NumberFormats;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class BaseDataMultiToMultiMapExcelConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        return MultiToMultiMapInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        try {
            MultiToMultiMapInfo baseDataMapingInfo = (MultiToMultiMapInfo)source;
            WritableWorkbook writableWorkbook = (WritableWorkbook)context.get("WritableWorkbook");
            WritableSheet writableSheet = writableWorkbook.getSheet(0);
            this.marshalHeader(context, baseDataMapingInfo, writableSheet);
            this.marshalEntry(context, baseDataMapingInfo, writableSheet);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void marshalHeader(MarshallingContext context, MultiToMultiMapInfo multiToMultiMapInfo, WritableSheet writableSheet) throws Exception {
        WritableCellFormat cellFormat = this.getCellFormat(CustColor.CustColor_Yellow);
        String number = multiToMultiMapInfo.getNumber();
        writableSheet.addCell((WritableCell)new Label(1, 0, number, (CellFormat)cellFormat));
        String name = multiToMultiMapInfo.getName();
        writableSheet.addCell((WritableCell)new Label(1, 1, name, (CellFormat)cellFormat));
        String billMappingNumber = "";
        BillMappingInfo billMappingInfo = multiToMultiMapInfo.getStrategy();
        if (null != billMappingInfo) {
            billMappingNumber = billMappingInfo.getNumber();
        }
        writableSheet.addCell((WritableCell)new Label(1, 2, billMappingNumber, (CellFormat)cellFormat));
        String CompanyOrgUnitNo = "";
        CompanyOrgUnitInfo companyOrgUnitInfo = multiToMultiMapInfo.getCompanyOrgUnit();
        if (null != companyOrgUnitInfo) {
            CompanyOrgUnitNo = companyOrgUnitInfo.getNumber();
        }
        writableSheet.addCell((WritableCell)new Label(1, 3, CompanyOrgUnitNo, (CellFormat)cellFormat));
        String isAssistAccountOnly = "\u662f";
        writableSheet.addCell((WritableCell)new Label(1, 4, isAssistAccountOnly, (CellFormat)cellFormat));
        String baseDataType = "";
        if (multiToMultiMapInfo.getBaseDataType() != null) {
            baseDataType = multiToMultiMapInfo.getBaseDataType().getName();
        }
        writableSheet.addCell((WritableCell)new Label(1, 5, baseDataType, (CellFormat)cellFormat));
        String note = "";
        if (!StringUtils.isEmpty((String)multiToMultiMapInfo.getNote())) {
            note = multiToMultiMapInfo.getNote();
        }
        writableSheet.addCell((WritableCell)new Label(1, 6, note, (CellFormat)cellFormat));
    }

    private void marshalEntry(MarshallingContext context, MultiToMultiMapInfo baseDataMapingInfo, WritableSheet writableSheet) throws Exception {
        KDTable kdtEntrys = (KDTable)context.get("MergeEntryTable");
        int rowCount = kdtEntrys.getRowCount();
        int targetExcelLine = 8;
        for (int i = 0; i < rowCount; ++i) {
            IRow row = kdtEntrys.getRow(i);
            int srcLenth = BaseDataMultiToMultiMapHelper.split(this.getCellValueNullAsBlank(row, "srcField")).length;
            int destLength = BaseDataMultiToMultiMapHelper.split(this.getCellValueNullAsBlank(row, "destField")).length;
            int groupLineCount = Math.max(srcLenth, destLength);
            this.marshalSrcEntry(row, i, writableSheet, targetExcelLine, groupLineCount, baseDataMapingInfo);
            this.marshalDestEntry(row, writableSheet, targetExcelLine, groupLineCount, baseDataMapingInfo);
            targetExcelLine += groupLineCount;
        }
    }

    private void marshalSrcEntry(IRow row, int groupId, WritableSheet writableSheet, int targetExcelLine, int groupLineCount, MultiToMultiMapInfo baseDataMapingInfo) throws Exception {
        WritableCellFormat cellFormat = this.getCellFormat(CustColor.CustColor_Red);
        CoreBaseInfo srcAccount = (CoreBaseInfo)row.getCell("srcAccount").getValue();
        String srcField = this.getCellValueNullAsBlank(row, "srcField");
        String srcFieldType = this.getCellValueNullAsBlank(row, "srcFieldType");
        String srcFieldValue = this.getCellValueNullAsBlank(row, "srcFieldValue");
        String[] fieldRecords = BaseDataMultiToMultiMapHelper.split(srcField);
        String[] fieldTypeRecords = BaseDataMultiToMultiMapHelper.split(srcFieldType);
        String[] fieldValueRecords = BaseDataMultiToMultiMapHelper.split(srcFieldValue);
        String group = "" + (groupId + 1);
        MultiToMultiMapType type = baseDataMapingInfo.getIsAssistAccountOnly();
        int fixSize = 0;
        boolean flag = false;
        if (MultiToMultiMapType.easAssistAccount.equals((Object)type) || MultiToMultiMapType.easCashFlower.equals((Object)type)) {
            flag = true;
            ++fixSize;
        }
        for (int i = 0; i < fieldRecords.length; ++i) {
            writableSheet.addCell((WritableCell)new Label(0, targetExcelLine + i, group, (CellFormat)cellFormat));
            if (i == 0 && flag) {
                writableSheet.addCell((WritableCell)new Label(1, targetExcelLine + i, (String)(srcAccount == null ? "" : srcAccount.get("srcID")), (CellFormat)cellFormat));
            }
            writableSheet.addCell((WritableCell)new Label(1 + fixSize, targetExcelLine + i, fieldRecords[i], (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(2 + fixSize, targetExcelLine + i, fieldTypeRecords[i], (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(3 + fixSize, targetExcelLine + i, fieldValueRecords[i], (CellFormat)cellFormat));
        }
        int fillCount = groupLineCount - fieldRecords.length;
        targetExcelLine += fieldRecords.length;
        for (int i = 0; i < fillCount; ++i) {
            writableSheet.addCell((WritableCell)new Label(0, targetExcelLine + i, group, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(1, targetExcelLine + i, "", (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(2, targetExcelLine + i, "", (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(3, targetExcelLine + i, "", (CellFormat)cellFormat));
            if (!flag) continue;
            writableSheet.addCell((WritableCell)new Label(4, targetExcelLine + i, "", (CellFormat)cellFormat));
        }
        if (fieldRecords.length <= 0 && flag) {
            writableSheet.addCell((WritableCell)new Label(0, targetExcelLine, group, (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(1, targetExcelLine, (String)(srcAccount == null ? "" : srcAccount.get("srcID")), (CellFormat)cellFormat));
        }
    }

    private void marshalDestEntry(IRow row, WritableSheet writableSheet, int targetExcelLine, int groupLineCount, MultiToMultiMapInfo baseDataMapingInfo) throws Exception {
        WritableCellFormat cellFormat = this.getCellFormat(CustColor.CustColor_Green);
        String destField = this.getCellValueNullAsBlank(row, "destField");
        String destFieldType = this.getCellValueNullAsBlank(row, "destFieldType");
        String destFieldValue = this.getCellValueNullAsBlank(row, "destFieldValue");
        String[] fieldRecords = BaseDataMultiToMultiMapHelper.split(destField);
        String[] fieldTypeRecords = BaseDataMultiToMultiMapHelper.split(destFieldType);
        String[] fieldValueRecords = BaseDataMultiToMultiMapHelper.split(destFieldValue);
        MultiToMultiMapType type = baseDataMapingInfo.getIsAssistAccountOnly();
        int fixSize = 0;
        if (MultiToMultiMapType.easAssistAccount.equals((Object)type) || MultiToMultiMapType.easCashFlower.equals((Object)type)) {
            ++fixSize;
        }
        for (int i = 0; i < fieldRecords.length; ++i) {
            writableSheet.addCell((WritableCell)new Label(4 + fixSize, targetExcelLine + i, fieldRecords[i], (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(5 + fixSize, targetExcelLine + i, fieldTypeRecords[i], (CellFormat)cellFormat));
            String destValue = fieldValueRecords[i];
            CoreBaseInfo info = BaseDataMappingUtil.convertFid2CoreBase(destValue);
            if (null != info) {
                destValue = (String)info.get("number");
            }
            writableSheet.addCell((WritableCell)new Label(6 + fixSize, targetExcelLine + i, destValue, (CellFormat)cellFormat));
        }
        int fillCount = groupLineCount - fieldRecords.length;
        targetExcelLine += fieldRecords.length;
        for (int i = 0; i < fillCount; ++i) {
            writableSheet.addCell((WritableCell)new Label(5 + fixSize, targetExcelLine + i, "", (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(6 + fixSize, targetExcelLine + i, "", (CellFormat)cellFormat));
            writableSheet.addCell((WritableCell)new Label(7 + fixSize, targetExcelLine + i, "", (CellFormat)cellFormat));
        }
    }

    private WritableCellFormat getCellFormat(Colour bgColor) throws Exception {
        WritableCellFormat cellFormat = new WritableCellFormat(NumberFormats.TEXT);
        cellFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
        cellFormat.setBackground(bgColor);
        return cellFormat;
    }

    private String getCellValueNullAsBlank(IRow row, String key) {
        Object value = row.getCell(key).getValue();
        if (null == value) {
            return "";
        }
        return value.toString();
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        return null;
    }
}

