/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.cloud.CloudParser;
import com.kingdee.eas.csinterface.cloud.FileElement;
import com.kingdee.eas.csinterface.cloud.Web20AppClient;
import com.kingdee.eas.csinterface.converter.core.XMLStream;
import com.kingdee.eas.csinterface.planmanager.PlanManagerInfo;
import com.kingdee.eas.csinterface.planmanagergroup.IPlanManagerGroup;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupEntryCollection;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupEntryInfo;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupFactory;
import com.kingdee.eas.csinterface.planmanagergroup.PlanManagerGroupInfo;
import com.kingdee.eas.csinterface.util.EncodingUtils;
import java.util.Iterator;

public class PlanManagerGroupHelper {
    private static XMLStream xmlStream = null;
    public static final String PLAN_GROUP_RESOURCE_ID_IN_CLOUD = "plan-group-test";
    public static final String VERSION_CLOUD = "1";

    private static XMLStream getXMLStream() {
        if (null == xmlStream) {
            xmlStream = new XMLStream();
        }
        return xmlStream;
    }

    public static PlanManagerGroupInfo getPlanManagerGroupInfoWithAllValue(String id) throws EASBizException, BOSException {
        SelectorItemCollection selector = PlanManagerGroupHelper.getExportSelectorItemCollection();
        IPlanManagerGroup remoteInstance = PlanManagerGroupFactory.getRemoteInstance();
        return remoteInstance.getPlanManagerGroupInfo((IObjectPK)new ObjectUuidPK(id), selector);
    }

    private static SelectorItemCollection getExportSelectorItemCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("Entry.*");
        selector.add("Entry.planManager.*");
        selector.add("Entry.planManager.createsourceviewsql.*");
        selector.add("Entry.planManager.bizbillmapping.*");
        selector.add("Entry.planManager.bizbillmapping.entrys.*");
        selector.add("Entry.planManager.createsourceviewsql.*");
        selector.add("Entry.planManager.botprule.*");
        return selector;
    }

    public static void replaceBOTMappingInfo(PlanManagerGroupInfo info) throws BOSException, EASBizException {
        PlanManagerGroupEntryCollection coll = info.getEntry();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            PlanManagerGroupEntryInfo entry = (PlanManagerGroupEntryInfo)iterator.next();
            PlanManagerInfo planManagerInfo = entry.getPlanManager();
            BOTMappingInfo orgBOTMappingInfo = planManagerInfo.getBotprule();
            if (null == orgBOTMappingInfo) continue;
            IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
            BOTMappingInfo botMappingInfo = iBotMapping.getBOTMappingInfo((IObjectPK)new ObjectStringPK(orgBOTMappingInfo.getId().toString()));
            planManagerInfo.setBotprule(botMappingInfo);
        }
    }

    public static String convertPlanToXML(PlanManagerGroupInfo info) {
        return PlanManagerGroupHelper.getXMLStream().toXMLString(info);
    }

    public static PlanManagerGroupInfo convertXMLToPlan(String docXML) {
        return (PlanManagerGroupInfo)PlanManagerGroupHelper.getXMLStream().fromXML(docXML);
    }

    public static String queryPlanResource() throws BOSException {
        try {
            byte[] data = Web20AppClient.queryResourceFile(PLAN_GROUP_RESOURCE_ID_IN_CLOUD, VERSION_CLOUD);
            String message = EncodingUtils.bytes2StrUTF8(data);
            return message;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String downloadFileFromURI2StrUTF8(String uri) throws BOSException {
        try {
            byte[] data = Web20AppClient.downloadFileFromURI(uri);
            String message = EncodingUtils.bytes2StrUTF8(data);
            return message;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static byte[] uploadFile(String fileName, String filedesc, byte[] fileData) throws BOSException {
        try {
            fileName = Web20AppClient.urlEncodedUTF8(fileName);
            filedesc = Web20AppClient.urlEncodedUTF8(filedesc);
            return Web20AppClient.uploadFileByte(PLAN_GROUP_RESOURCE_ID_IN_CLOUD, VERSION_CLOUD, fileName, filedesc, fileData);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isPlanExistInCloud(String targetFileName) throws BOSException {
        String resoureXML = PlanManagerGroupHelper.queryPlanResource();
        FileElement[] fileElements = CloudParser.parseFile(resoureXML);
        for (int i = 0; i < fileElements.length; ++i) {
            if (!fileElements[i].getFilename().equals(targetFileName)) continue;
            return true;
        }
        return false;
    }

    public static String getPlanGroupTargetFileNameInCloud(PlanManagerGroupInfo info) {
        String SEPARATOR = "_";
        String srcSysName = info.getSrcSysName();
        String srcSysVersion = info.getSrcSysVersion();
        String srcSysBillName = info.getSrcBill();
        String destSysName = info.getDestSysName();
        String destSysVersion = info.getDestSysVersion();
        String destSysBillName = info.getDestBill();
        String name = info.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(PlanManagerGroupHelper.replaceChar(srcSysName));
        sb.append("_");
        sb.append(PlanManagerGroupHelper.replaceChar(srcSysVersion));
        sb.append("_");
        sb.append(PlanManagerGroupHelper.replaceChar(srcSysBillName));
        sb.append("_");
        sb.append(PlanManagerGroupHelper.replaceChar(destSysName));
        sb.append("_");
        sb.append(PlanManagerGroupHelper.replaceChar(destSysVersion));
        sb.append("_");
        sb.append(PlanManagerGroupHelper.replaceChar(destSysBillName));
        sb.append("_");
        sb.append(PlanManagerGroupHelper.replaceChar(name));
        return sb.toString();
    }

    private static String replaceChar(String message) {
        if (null == message) {
            return "null";
        }
        return message.replace('_', '-');
    }
}

