/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.syncdatabase.ConnectionInfo;
import com.kingdee.eas.csinterface.util.ColumnInfo;
import com.kingdee.eas.csinterface.utils.DBConParam;
import com.kingdee.eas.csinterface.utils.DataBaseType;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class KSQLUtil {
    public static IRowSet executeQuery(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd, String ksql) throws BOSException {
        IRowSet iRowSet;
        Statement statement = null;
        Connection con = null;
        ResultSet rs = null;
        try {
            IRowSet rsReturn;
            try {
                con = KSQLUtil.getKSQLConnection(dbType, ip, port, dbName, userName, pwd);
            }
            catch (Exception e) {
                throw new Exception("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u3010\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u3011\u7684\u914d\u7f6e\u3002");
            }
            statement = con.createStatement();
            System.out.println("executeQuery ksql :" + ksql);
            rs = statement.executeQuery(ksql);
            iRowSet = rsReturn = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
        return iRowSet;
    }

    public static List<ColumnInfo> getMySqlSchema(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd, String tableName) throws BOSException {
        ArrayList<ColumnInfo> result = new ArrayList<ColumnInfo>();
        Connection con = null;
        PreparedStatement stss = null;
        try {
            try {
                con = KSQLUtil.getKSQLConnection(dbType, ip, port, dbName, userName, pwd);
            }
            catch (Exception e) {
                throw new Exception("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u3010\u6e90\u7cfb\u7edf\u6570\u636e\u5e93\u8fde\u63a5\u3011\u7684\u914d\u7f6e\u3002");
            }
            stss = con.prepareStatement("select * from " + tableName);
            ResultSetMetaData rsmd = stss.getMetaData();
            int j = rsmd.getColumnCount();
            for (int i = 0; i < j; ++i) {
                ColumnInfo colInfo = new ColumnInfo();
                String colName = rsmd.getColumnName(i + 1);
                String type = rsmd.getColumnTypeName(i + 1);
                int dataLength = rsmd.getColumnDisplaySize(i + 1);
                int precision = rsmd.getPrecision(i + 1);
                int scale = rsmd.getScale(i + 1);
                int nullable = rsmd.isNullable(i + 1);
                colInfo.setCOLUMN_NAME(colName);
                colInfo.setDATA_TYPE(type.toUpperCase());
                colInfo.setDEFAULT_LENGTH(dataLength + "");
                colInfo.setDATA_LENGTH(dataLength + "");
                colInfo.setDATA_PRECISION(precision + "");
                colInfo.setDATA_SCALE(scale + "");
                colInfo.setNULLABLE(nullable + "");
                result.add(colInfo);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(con);
                SQLUtils.cleanup(stss);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        SQLUtils.cleanup((Statement)stss);
        return result;
    }

    public static IRowSet executeQuery(Connection con, String ksql) throws BOSException {
        Statement statement = null;
        try {
            IRowSet rsReturn;
            statement = con.createStatement();
            System.out.println("executeQuery ksql :" + ksql);
            ResultSet rs = statement.executeQuery(ksql);
            IRowSet iRowSet = rsReturn = (IRowSet)DBUtil.makeRowSet((ResultSet)rs);
            return iRowSet;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
            SQLUtils.cleanup((Connection)con);
        }
    }

    public static void executeUpdate(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd, String ksql) throws BOSException, SQLException {
        KSQLUtil.executeUpdate(dbType, ip, port, dbName, userName, pwd, new String[]{ksql});
    }

    public static void executeUpdate(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd, String[] ksqls) throws BOSException, SQLException {
        Statement statement = null;
        Connection con = null;
        try {
            con = KSQLUtil.getKSQLConnection(dbType, ip, port, dbName, userName, pwd);
            statement = con.createStatement();
            for (String ksql : ksqls) {
                if (StringUtils.isEmpty((String)ksql)) continue;
                statement.executeUpdate(ksql);
            }
        }
        catch (ClassNotFoundException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup(con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
    }

    public static Connection getConnection(ConnectionInfo connectionInfo) throws Exception {
        String IP = connectionInfo.getIP();
        String dBName = connectionInfo.getInstance();
        String username = connectionInfo.getUsername();
        int port = connectionInfo.getPort();
        String password = connectionInfo.getPassword();
        String DBtype = connectionInfo.getDBType().getName().toString();
        DataBaseType dataBaseType = DataBaseType.getInstance(DBtype);
        return KSQLUtil.getKSQLConnection(dataBaseType, IP, port, dBName, username, password);
    }

    public static Connection getKSQLConnection(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd) throws SQLException, ClassNotFoundException {
        if (DataBaseType.MySql.equals((Object)dbType)) {
            return KSQLUtil.getDLinkConnection(dbType, ip, port, dbName, userName, pwd);
        }
        Class.forName("com.kingdee.bos.sql.shell.Driver");
        String url = KSQLUtil.getConnectionURL(dbType, ip, port, dbName);
        Properties properties = new Properties();
        properties.put("user", userName);
        properties.put("password", pwd);
        Connection conn = DriverManager.getConnection(url, properties);
        DriverManager.setLoginTimeout(300);
        return conn;
    }

    public static Connection getDLinkConnection(DataBaseType dbType, String ip, int port, String dbName, String userName, String pwd) throws SQLException, ClassNotFoundException {
        StringBuffer append = new StringBuffer();
        String url = null;
        if (DataBaseType.Oracle.equals((Object)dbType)) {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            append.append("jdbc:oracle:thin");
            append.append(":@" + ip);
            append.append(":" + port);
            append.append(":" + dbName);
            url = append.toString();
        } else if (DataBaseType.SQLServer.equals((Object)dbType)) {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            append.append("jdbc:jtds:sqlserver");
            append.append("://" + ip);
            append.append(":" + port);
            append.append(";DatabaseName=" + dbName);
            url = append.toString();
        } else if (DataBaseType.DB2.equals((Object)dbType)) {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
            append.append("jdbc:db2");
            append.append("://" + ip);
            append.append(":" + port);
            append.append("/" + dbName);
            url = append.toString();
        } else if (DataBaseType.MySql.equals((Object)dbType)) {
            Class.forName("com.mysql.jdbc.Driver");
            append.append("jdbc:mysql");
            append.append("://" + ip);
            append.append(":" + port);
            append.append("/" + dbName);
            url = append.toString();
            String paramInfo = DBConParam.getParamInfo();
            if (!StringUtil.isEmpty((String)paramInfo)) {
                append.append(paramInfo);
            }
        }
        Properties properties = new Properties();
        properties.put("user", userName);
        properties.put("password", pwd);
        Connection conn = DriverManager.getConnection(url, properties);
        DriverManager.setLoginTimeout(300);
        return conn;
    }

    private static String getConnectionURL(DataBaseType dbType, String ip, int port, String dbName) {
        if (DataBaseType.SQLServer.equals((Object)dbType)) {
            return KSQLUtil.getMSSQL(ip, port, dbName);
        }
        if (DataBaseType.Oracle.equals((Object)dbType)) {
            return KSQLUtil.getOracle(ip, port, dbName);
        }
        if (DataBaseType.DB2.equals((Object)dbType)) {
            return KSQLUtil.getDB2(ip, port, dbName);
        }
        if (DataBaseType.PostgreSQL.equals((Object)dbType)) {
            return KSQLUtil.getPGSQL(ip, port, dbName);
        }
        return "Unsupport database type '" + (Object)((Object)dbType) + "'";
    }

    private static String getPGSQL(String ip, int port, String dbName) {
        StringBuilder builder = new StringBuilder("jdbc:ksql:org.postgresql.Driver:dbtype=postgresql:jdbc:postgresql");
        builder.append("://" + ip);
        builder.append(":" + port);
        builder.append("/" + dbName);
        return builder.toString();
    }

    private static String getMSSQL(String ip, int port, String dbName) {
        StringBuffer sb = new StringBuffer("jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver:jdbc:jtds:sqlserver");
        sb.append("://" + ip);
        sb.append(":" + port);
        sb.append(";DatabaseName=" + dbName);
        return sb.toString();
    }

    private static String getPOSTGRE(String ip, int port, String dbName) {
        StringBuffer sb = new StringBuffer("jdbc:postgresql://");
        sb.append(ip);
        sb.append(":");
        sb.append(port);
        sb.append("/");
        sb.append(dbName);
        return sb.toString();
    }

    private static String getOracle(String ip, int port, String SID) {
        String[] ipArr = ip.split(",");
        StringBuffer sb = new StringBuffer("jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle9:trace=on:file=console:jdbc:oracle:thin:@(DESCRIPTION=");
        for (String eachIP : ipArr) {
            sb.append("(ADDRESS=(PROTOCOL=TCP)(HOST=" + eachIP + ")(PORT=" + port + "))");
        }
        sb.append("(LOAD_BALANCE=YES)");
        sb.append("(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=" + SID + ")))");
        return sb.toString();
    }

    private static String getDB2(String ip, int port, String dbName) {
        StringBuffer sb = new StringBuffer("jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2:DBSchema=DB2ADMIN:jdbc:db2");
        sb.append("://" + ip);
        sb.append(":" + port);
        sb.append("/" + dbName);
        return sb.toString();
    }
}

