/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.client;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewTabFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataUtils;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.util.ComponentHelper;
import com.kingdee.eas.csinterface.util.ILongTimeTask2;
import com.kingdee.eas.csinterface.util.LongTimeDialog2;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.UITools2;
import com.kingdee.eas.csinterface.webservice.DataType;
import com.kingdee.eas.csinterface.webservice.ImplType;
import com.kingdee.eas.csinterface.webservice.Region;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingFactory;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.client.AbstractWSBillMappingEditUI;
import com.kingdee.eas.csinterface.webservice.client.util.EditUICheckUtil;
import com.kingdee.eas.csinterface.webservice.client.util.TypeDefaultValue;
import com.kingdee.eas.csinterface.webservice.client.util.WSBillMappingEditUIHelper;
import com.kingdee.eas.csinterface.webservice.model.metadata.WsMetadata;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WSBillMappingEditUI
extends AbstractWSBillMappingEditUI {
    private static final Logger logger = CoreUIObject.getLogger(WSBillMappingEditUI.class);
    public WSBillMappingEntryCollection drop = new WSBillMappingEntryCollection();

    @Override
    public void loadFields() {
        WSBillMappingEntryCollection coll = this.editData.getEntrys();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)its.next();
            if (entryInfo.isDropped()) {
                its.remove();
            }
            this.drop.add(entryInfo);
        }
        super.loadFields();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (dataObject != null) {
            WSBillMappingInfo info = (WSBillMappingInfo)dataObject;
            WSBillMappingEditUIHelper.sortDropped2TheEnd(info);
            info.copyNewToOld();
        }
        super.setDataObject(dataObject);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        int maxRowNumber = this.kdtEntrys.getRowCount();
        for (int i = 0; i < this.drop.size(); ++i) {
            this.drop.get(i).setSeq(maxRowNumber + i + 1);
        }
        this.editData.getEntrys().addCollection(this.drop);
        this.editData.copyNewToOld();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getEditData().getId() != null) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
        }
        ComponentHelper.setVisible(new JComponent[]{this.btnAttachment, this.btnSubmit, this.btnFirst, this.btnPre, this.btnNext, this.btnLast, this.btnPrint, this.btnPrintPreview, this.btnWorkFlowG, this.btnCreateFrom, this.btnCreateTo, this.btnAuditResult, this.btnMultiapprove, this.btnNextPerson}, false);
        this.btnPublished.setEnabled(true);
        if (this.editData.isPublished()) {
            this.btnViewModeldata.setEnabled(true);
            this.btnViewModeldata.setVisible(true);
            this.needSrcTable.setEnabled(false);
            this.kDNeedMidData.setEnabled(false);
        } else {
            this.btnViewModeldata.setEnabled(false);
            this.btnViewModeldata.setVisible(false);
        }
        this.kdtEntrys.getSelectManager().setSelectMode(2);
        KDWorkButton removeButton = this.kdtEntrys_detailPanel.getRemoveLinesButton();
        WSBillMappingEditUIHelper.replaceKdtRangeRemoveMethod(this.editData, this.kdtEntrys, removeButton);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.initTableState();
    }

    private void initTableState() {
        if (this.editData.getId() == null) {
            this.implClassType.setSelectedIndex(0);
        }
        KDTColumns columns = this.kdtEntrys.getColumns();
        int columnSize = columns.size();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            WSBillMappingEntryInfo info = (WSBillMappingEntryInfo)row.getUserObject();
            if (info.isPublished()) {
                MyKDTableUtil.setRowLocked(row);
                for (int j = 0; j < columnSize; ++j) {
                    MyKDTableUtil.setCellLockedBackground(row.getCell(columns.getColumnKey(j)));
                }
            }
            if (!info.isDropped()) continue;
            MyKDTableUtil.removeRow(this.kdtEntrys, i);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        boolean isExist;
        String number = this.txtNumber.getText();
        EditUICheckUtil.verifyInput((Object)this.txtNumber, this.contNumber);
        EditUICheckUtil.verifyInput((Object)this.txtName, this.contName);
        this.txtNumber.setText(number.substring(0, 1).toUpperCase() + number.substring(1));
        if (!MetadataUtils.checkBillName(number.trim())) {
            MsgBox.showInfo((String)"\u7f16\u7801\u53ea\u80fd\u7531\u6570\u5b57\u3001\u5b57\u6bcd\u6216\u8005\u4e0b\u5212\u7ebf\u7ec4\u6210\uff0c\u5e76\u4e14\u4ee5\u5927\u5199\u5b57\u6bcd\u5f00\u5934\u3002");
            SysUtil.abort();
        }
        if (isExist = EditUICheckUtil.isExists(this.getBizInterface(), "number", this.contNumber, this.txtNumber.getText(), this.editData.getId())) {
            this.txtNumber.requestFocusInWindow();
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
        this.initTableState();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        boolean flag = ImplType.userClass.equals(this.implClassType.getSelectedItem());
        if (flag && StringUtils.isEmpty((CharSequence)this.ctxImplClass.getText())) {
            MsgBox.showError((String)"\u81ea\u5b9a\u4e49\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            IRow row = this.kdtEntrys.getRow(i);
            WSBillMappingEntryInfo info = (WSBillMappingEntryInfo)row.getUserObject();
            if (info.isDropped()) continue;
            Region region = info.getRegion();
            String srcField = info.getSrcField();
            String srcAlias = info.getSrcAlias();
            String destField = info.getDestField();
            String destAlias = info.getDestAlias();
            DataType dataType = info.getFieldType();
            int dataLength = info.getFieldLength();
            if (region == null) {
                MsgBox.showError((String)("\u7b2c " + (i + 1) + " \u884c\u5206\u5f55\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a"));
                SysUtil.abort();
            }
            if (Region.head.equals((Object)region)) {
                if (StringUtils.isEmpty((CharSequence)destField) || StringUtils.isEmpty((CharSequence)destAlias) || dataType == null || StringUtils.isEmpty((CharSequence)srcField)) {
                    MsgBox.showError((String)("\u7b2c " + (i + 1) + " \u884c\u5206\u5f55\u5fc5\u586b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
                    SysUtil.abort();
                }
            } else if (region == null || StringUtils.isEmpty((CharSequence)srcField) || StringUtils.isEmpty((CharSequence)srcAlias) || StringUtils.isEmpty((CharSequence)destField) || StringUtils.isEmpty((CharSequence)destAlias) || dataType == null || StringUtils.isEmpty((CharSequence)srcField)) {
                MsgBox.showError((String)("\u7b2c " + (i + 1) + " \u884c\u5206\u5f55\u5fc5\u586b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
                SysUtil.abort();
            }
            if (dataLength > 0) continue;
            MsgBox.showError((String)("\u7b2c " + (i + 1) + " \u884c\u5206\u5f55\u5b57\u6bb5\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0"));
            SysUtil.abort();
        }
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.resetEditUI();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.resetEditUI();
    }

    private void resetEditUI() {
        this.txtNumber.setEnabled(true);
        this.txtNumber.setText(null);
        this.txtName.setEnabled(true);
        this.txtName.setText(null);
        this.editData.setPublished(false);
        this.implClassType.setSelectedIndex(0);
        this.needSrcTable.setEnabled(true);
        this.kDNeedMidData.setEnabled(true);
        WSBillMappingEntryCollection coll = this.editData.getEntrys();
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            WSBillMappingEntryInfo entry = (WSBillMappingEntryInfo)iterator.next();
            entry.setPublished(false);
            if (!entry.isDropped()) continue;
            iterator.remove();
        }
        this.drop.clear();
    }

    @Override
    public void actionPulished_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null || this.isModify()) {
            MsgBox.showWarning((String)"\u5df2\u7ecf\u4fee\u6539,\u8bf7\u5148\u4fdd\u5b58.");
            return;
        }
        if (!this.editData.isPublished() && 0 != MsgBox.showConfirm2((String)"\u53d1\u5e03\u540e,\u7f16\u7801\u548c\u89c4\u5219\u540d\u79f0\u4e0d\u53ef\u4fee\u6539,\u786e\u8ba4\u8981\u53d1\u5e03\u5417?")) {
            return;
        }
        LongTimeDialog2 dialog = UITools2.getDialog((Component)((Object)this), "\u540e\u53f0\u5904\u7406", "\u6b63\u5728\u53d1\u5e03,\u8bf7\u7a0d\u540e...");
        dialog.setLongTimeTask(new ILongTimeTask2(){
            private Exception exception;

            @Override
            public Object exec() throws Exception {
                try {
                    String id = WSBillMappingEditUI.this.editData.getId().toString();
                    WSBillMappingFactory.getRemoteInstance().publish(id);
                    String string = "success";
                    return string;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.exception = exc;
                    String string = "fail";
                    return string;
                }
                finally {
                    System.out.println("\u6b63\u5728\u6e05\u9664\u5ba2\u6237\u7aef\u5143\u6570\u636e\u7f13\u5b58...");
                    MetadataUtils.clearClientMetadataCache();
                    MetadataUtils.clearServerMetadataCache();
                }
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (null == this.exception) {
                    MsgBox.showInfo((String)"\u53d1\u5e03\u6210\u529f!");
                    WSBillMappingEditUI.this.txtNumber.setEnabled(false);
                    WSBillMappingEditUI.this.txtName.setEnabled(false);
                } else {
                    MsgBox.showError((String)"\u53d1\u5e03\u5931\u8d25\uff1a", (String)this.exception.getMessage());
                }
            }
        });
        dialog.show();
        this.refreshDataFromServer();
    }

    private void refreshDataFromServer() throws BOSException, EASBizException, Exception {
        IObjectPK pk = CommonUtil.convert2PK(this.editData.getId().toString());
        this.editData = WSBillMappingFactory.getRemoteInstance().getWSBillMappingInfo(pk);
        if (this.getUIContext().get("InitDataObject") != null && this.getUIContext().get("InitDataObject") instanceof IObjectValue) {
            this.getUIContext().put("InitDataObject", null);
        }
        this.setDataObject((IObjectValue)this.editData);
        this.onLoad();
        this.initTableState();
    }

    @Override
    public void actionViewModelData_actionPerformed(ActionEvent e) throws Exception {
        String number = this.editData.getNumber();
        WsMetadata dm = new WsMetadata(number);
        String listUIName = "com.kingdee.eas.csinterface.webservice.model.client.WSDynamicBillTemplateListUI";
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UINewTabFactory.class.getName());
        HashMap<String, Object> uiContext = new HashMap<String, Object>();
        HashMap dataObjects = new HashMap();
        uiContext.put("Owner", this.getParent());
        uiContext.put("UIClassParam", "uipk=" + dm.getListUIPK());
        uiContext.put("dm", dm);
        IUIWindow uiWindow = uiFactory.create(listUIName, uiContext, dataObjects, OprtState.VIEW);
        uiWindow.show();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("published"));
        return sic;
    }

    protected void initListener() {
        ActionMap entryActionMap = this.getActionMap();
        entryActionMap.put("format", new FormateListener());
        InputMap imEntry = this.getInputMap(2);
        KeyStroke ctrl_shift_f09 = KeyStroke.getKeyStroke(74, 2);
        imEntry.put(ctrl_shift_f09, "format");
    }

    class FormateListener
    extends AbstractAction {
        FormateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList<Map> list;
                HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>();
                for (int i = 0; i < WSBillMappingEditUI.this.kdtEntrys.getRowCount(); ++i) {
                    IRow row = WSBillMappingEditUI.this.kdtEntrys.getRow(i);
                    WSBillMappingEntryInfo info = (WSBillMappingEntryInfo)row.getUserObject();
                    HashMap<String, Object> rmap = (HashMap<String, Object>)map.get(info.getRegion().getValue());
                    if (rmap == null) {
                        rmap = new HashMap<String, Object>();
                        map.put(info.getRegion().getValue(), rmap);
                    }
                    rmap.put(info.getSrcField(), TypeDefaultValue.getValue(info.getFieldType()));
                }
                Map head = (Map)map.get("200");
                Map entry = (Map)map.get("210");
                Map subentry = (Map)map.get("220");
                if (entry != null) {
                    list = new ArrayList<Map>();
                    list.add(entry);
                    head.put("entrys", list);
                }
                if (subentry != null) {
                    list = new ArrayList();
                    list.add(subentry);
                    entry.put("entrys", list);
                }
                StringSelection ss = new StringSelection(JSONObject.toJSONString((Object)head));
                Clipboard sysClb = null;
                sysClb = Toolkit.getDefaultToolkit().getSystemClipboard();
                sysClb.setContents(ss, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

