/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.agent.service.base.util.DateTimeUtils;
import com.kingdee.eas.csinterface.monitor.app.MonitorManager;
import com.kingdee.eas.csinterface.util.EncodingUtils;
import com.kingdee.eas.csinterface.util.IOUtils;
import com.kingdee.eas.csinterface.util.MyKDTableUtil;
import com.kingdee.eas.csinterface.util.PlanManagerHelper;
import com.kingdee.eas.csinterface.webservice.IWSInterface;
import com.kingdee.eas.csinterface.webservice.WSInterfaceCollection;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ConverterUtil {
    private static final ThreadLocal<KDTextArea> compment = new ThreadLocal();
    private static final ThreadLocal<Integer> current_count = new ThreadLocal();
    private static final ThreadLocal<Integer> total_count = new ThreadLocal();
    private static final ThreadLocal<String> planName = new ThreadLocal();
    private static final ThreadLocal<KDProgressBar> progressBar = new ThreadLocal();
    private static final ThreadLocal<Set<String>> idsList = new ThreadLocal();
    private static final ThreadLocal<IDataBase> instance = new ThreadLocal();
    private static final ThreadLocal<String> currentMsg = new ThreadLocal();
    private static final ThreadLocal<String> oldMsg = new ThreadLocal();
    private static final ThreadLocal<Map<String, Boolean>> selectedMap = new ThreadLocal();
    private static final ThreadLocal<Set<String>> baseDataTypeIDList = new ThreadLocal();
    public static ThreadLocal<Exception> excpetion = new ThreadLocal();
    public static final String getData = "\u67e5\u8be2\u6570\u636e";
    public static final String process = "\u5bfc\u51fa:";
    public static final String processing = "\u6b63\u5728\u6267\u884c";
    public static final String complete = "\u5df2\u5b8c\u6210";
    public static final String identification = "\u8bc6\u522b\u7801";
    public static final String wsbillmapping = "EAS\u6570\u636e\u6a21\u578b";
    public static final String localService = "\u672c\u5730\u670d\u52a1";
    public static final String remoteService = "\u8fdc\u7a0b\u670d\u52a1";
    public static final String querMarker = "EAS\u67e5\u8be2\u6a21\u677f";
    public static final String returnMarker = "EAS\u8fd4\u56de\u503c\u6a21\u677f";
    public static final String baseDataType = "\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u6620\u5c04";
    public static final String baseDataMapping = "\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04";
    public static final String schedule = "\u8c03\u5ea6\u7b56\u7565";
    public static final String SCHEDULEFIELD = "schedule";
    public static final String BASEDATAFIELD = "baseDataMapping";

    public static void exportData(KDTextArea kdProgress, KDProgressBar kdProgressBar, Set<String> idList, IDataBase inst, String filePath, Map<String, Boolean> selectedMap) throws BOSException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        long beginTime = System.currentTimeMillis();
        ConverterUtil.initExport(kdProgress, kdProgressBar, idList, inst, selectedMap);
        WSInterfaceCollection coll = ConverterUtil.queryData();
        ConverterUtil.exportToFile(coll, filePath);
        ConverterUtil.showTotalTime(beginTime);
    }

    private static void showTotalTime(long beginTime) {
        long endTime = System.currentTimeMillis();
        long total = endTime - beginTime;
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5bfc\u51fa\u603b\u8017\u65f6: ");
        buffer.append(MonitorManager.getDurationDesc((long)total));
        buffer.append("\r\n");
        buffer.append(compment.get().getText());
        compment.get().setText(buffer.toString());
    }

    private static void initExport(KDTextArea kdProgress, KDProgressBar kdProgressBar, Set<String> idList, IDataBase inst, Map<String, Boolean> selected) {
        progressBar.set(kdProgressBar);
        idsList.set(idList);
        compment.set(kdProgress);
        instance.set(inst);
        selectedMap.set(selected);
        progressBar.get().setValue(0);
        progressBar.get().setString("0%");
    }

    private static WSInterfaceCollection queryData() {
        WSInterfaceCollection coll = null;
        ConverterUtil.queryText();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsList.get(), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selecters = new SelectorItemCollection();
        selecters.add(new SelectorItemInfo("*"));
        selecters.add(new SelectorItemInfo("tree.*"));
        selecters.add(new SelectorItemInfo("tree.parent.*"));
        selecters.add(new SelectorItemInfo("queryFreeMarker.*"));
        selecters.add(new SelectorItemInfo("queryFreeMarker.tree.*"));
        selecters.add(new SelectorItemInfo("returnMapping.*"));
        selecters.add(new SelectorItemInfo("returnMapping.entrys.*"));
        selecters.add(new SelectorItemInfo("wsbillMapping.*"));
        selecters.add(new SelectorItemInfo("wsbillMapping.entrys.*"));
        selecters.add(new SelectorItemInfo("wsbillMapping.entrys.baseDataType.*"));
        selecters.add(new SelectorItemInfo("freeMarker.*"));
        selecters.add(new SelectorItemInfo("freeMarker.tree.*"));
        selecters.add(new SelectorItemInfo("webservice.*"));
        selecters.add(new SelectorItemInfo("webservice.tree.*"));
        selecters.add(new SelectorItemInfo("webservice.entrys.*"));
        selecters.add(new SelectorItemInfo("webservice.entrys.freeMarker.*"));
        selecters.add(new SelectorItemInfo("webservice.entrys.freeMarker.tree.*"));
        selecters.add(new SelectorItemInfo("webservice.entrys.loginService.*"));
        selecters.add(new SelectorItemInfo("webservice.entrys.loginService.entrys.*"));
        selecters.add(new SelectorItemInfo("webservice.entrys.loginService.entrys.tree.*"));
        view.setSelector(selecters);
        try {
            coll = ((IWSInterface)instance.get()).getWSInterfaceCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        ConverterUtil.complete();
        return coll;
    }

    private static void exportToFile(WSInterfaceCollection coll, String filePath) {
        StringBuffer xmlData = new StringBuffer();
        xmlData.append(PlanManagerHelper.convertPlanToXML(coll));
        xmlData.append("\r\n");
        byte[] data = EncodingUtils.str2BytesUTF8(xmlData.toString());
        IOUtils.writeToFile(data, filePath);
    }

    public static void currentPercent(int current, int total) {
        Integer percent = current++ * 100 / total;
        ConverterUtil.getProcessBar().setString(percent + "%");
        ConverterUtil.getProcessBar().setValue(percent.intValue());
    }

    public static void currentPlan(WSInterfaceInfo info, int current, int total) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(").append(current).append("/").append(total).append(") ");
        buffer.append(info.getNumber()).append("(").append(info.getName()).append(" )");
        buffer.append("\r\n");
        if (oldMsg.get() != null) {
            buffer.append(oldMsg.get());
        }
        compment.get().setText(buffer.toString());
        oldMsg.set(buffer.toString());
    }

    private static void queryText() {
        String msg = ConverterUtil.getTime() + "\t\t" + getData + "\t\t";
        compment.get().setText(msg + processing);
        currentMsg.set(msg);
    }

    public static void displayTask(String text) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(ConverterUtil.getTime());
        buffer.append("\t\t");
        buffer.append(text);
        buffer.append("\t\t");
        currentMsg.set(buffer.toString());
        buffer.append(processing);
        buffer.append("\r\n");
        if (oldMsg.get() != null) {
            buffer.append(oldMsg.get());
        }
        compment.get().setText(buffer.toString());
    }

    private static String getTime() {
        return DateTimeUtils.format(new Date(), "HH:mm:ss");
    }

    public static void complete() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(currentMsg.get());
        buffer.append(complete);
        buffer.append("\r\n");
        if (oldMsg.get() != null) {
            buffer.append(oldMsg.get());
        }
        compment.get().setText(buffer.toString());
        oldMsg.set(buffer.toString());
    }

    public static Set<String> getSelectedIds(KDTable tblMain) {
        HashSet<String> selectedIds = new HashSet<String>();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        Object id = "";
        for (int i = 0; i < selectRows.length; ++i) {
            try {
                id = MyKDTableUtil.getTableCellValue(tblMain, selectRows[i], "id");
                selectedIds.add(id.toString());
                continue;
            }
            catch (Exception e2) {
                MsgBox.showError((String)e2.getMessage());
            }
        }
        return selectedIds;
    }

    public static void setProgessString(String compentName) {
        Integer percent = current_count.get() * 100 / total_count.get();
        progressBar.get().setValue(percent.intValue());
        StringBuffer message = new StringBuffer(50);
        message.append("(").append(current_count.get()).append("/").append(total_count.get()).append(") ");
        message.append(planName.get());
        progressBar.get().setString(message.toString());
        StringBuffer currentCompent = new StringBuffer(20);
        currentCompent.append(process).append(compentName).append("\u2026\u2026");
        compment.get().setText(currentCompent.toString());
    }

    public static KDProgressBar getProcessBar() {
        return progressBar.get();
    }

    public static Map<String, Boolean> getSelectedMap() {
        Map<String, Boolean> map = selectedMap.get();
        if (map == null) {
            map = new HashMap<String, Boolean>();
        }
        selectedMap.set(map);
        return map;
    }

    public static Set<String> getBaseDataTypeIdList() {
        Set<String> idList = baseDataTypeIDList.get();
        if (idList == null) {
            idList = new HashSet<String>();
        }
        baseDataTypeIDList.set(idList);
        return idList;
    }
}

