/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerTreeInfo;
import org.jdom2.Element;

public class WSFreeMarkerConverter
extends AbstractDataBaseInfoConverter {
    private String[] header_string = new String[]{"number", "name", "description", "context"};

    @Override
    public boolean canConvert(Class type) {
        return WSFreeMarkerInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        WSFreeMarkerInfo info = (WSFreeMarkerInfo)source;
        Element root = new Element(info.getClass().getName());
        for (int i = 0; i < this.header_string.length; ++i) {
            this.addChild(root, this.header_string[i], info.getString(this.header_string[i]));
        }
        this.addChild(root, "preset", info.getBoolean("preset"));
        WSFreeMarkerTreeInfo treeInfo = info.getTree();
        if (treeInfo != null) {
            Element treeRoot = JDomB9Utils.addChild(root, "tree");
            Object object = context.marshall(treeInfo);
            this.addChild(root, treeInfo.getClass().getSimpleName(), (Element)object);
        }
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        WSFreeMarkerInfo info = new WSFreeMarkerInfo();
        for (int i = 0; i < this.header_string.length; ++i) {
            String value = this.getElementTextByName(data, this.header_string[i]);
            info.setString(this.header_string[i], value);
        }
        info.setBoolean("preset", WSFreeMarkerConverter.changeStringToBoolean(this.getElementTextByName(data, "preset")));
        Element tree = data.getChild("WSFreeMarkerTreeInfo");
        if (tree != null && tree.getChild(WSFreeMarkerTreeInfo.class.getName()) != null) {
            WSFreeMarkerTreeInfo item = (WSFreeMarkerTreeInfo)context.unmarshall(tree.getChild(WSFreeMarkerTreeInfo.class.getName()));
            info.setTree(item);
        }
        return info;
    }
}

