/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.jdom2.Element;

public class WSIdentificationConverter
extends AbstractDataBaseInfoConverter {
    private String[] header_string = new String[]{"number", "name", "apiKey", "description"};
    private String[] header_boolean = new String[]{"preset"};

    @Override
    public boolean canConvert(Class type) {
        return WSIdentificationCodeInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        WSIdentificationCodeInfo info = (WSIdentificationCodeInfo)source;
        Element root = new Element(info.getClass().getName());
        this.marshalHeader(root, info);
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        WSIdentificationCodeInfo info = new WSIdentificationCodeInfo();
        List children = data.getChildren();
        this.unmarshalHeader(info, children);
        return info;
    }

    private void marshalHeader(Element root, WSIdentificationCodeInfo info) {
        int i;
        AdminOrgUnitInfo unitInfo = info.getUnit();
        String unitId = unitInfo == null ? "" : unitInfo.getId().toString();
        this.addChild(root, "unit", unitId);
        for (i = 0; i < this.header_string.length; ++i) {
            this.addChild(root, this.header_string[i], info.getString(this.header_string[i]));
        }
        for (i = 0; i < this.header_boolean.length; ++i) {
            this.addChild(root, this.header_boolean[i], info.getBoolean(this.header_boolean[i]));
        }
    }

    public void unmarshalHeader(WSIdentificationCodeInfo info, List<Element> children) {
        IObjectPK pk;
        int i;
        for (i = 0; i < this.header_string.length; ++i) {
            info.setString(this.header_string[i], this.getElementTextByName(children, this.header_string[i]));
        }
        for (i = 0; i < this.header_boolean.length; ++i) {
            info.setBoolean(this.header_boolean[i], WSIdentificationConverter.changeStringToBoolean(this.getElementTextByName(children, this.header_boolean[i])));
        }
        String adminOrgId = this.getElementTextByName(children, "unit");
        if (!StringUtils.isEmpty((String)adminOrgId) && (pk = CommonUtil.convert2PK(adminOrgId)) != null) {
            try {
                info.setUnit(AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo(pk));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

