/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryCollection;
import com.kingdee.eas.csinterface.billmapping.BillMappingEntryInfo;
import com.kingdee.eas.csinterface.billmapping.BillMappingInfo;
import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.schedule.ScheduleCollection;
import com.kingdee.eas.csinterface.schedule.ScheduleFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingCollection;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataMapingFactory;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.eas.csinterface.webservice.ServiceType;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceTreeInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceURLInfo;
import com.kingdee.eas.csinterface.webservice.converter.ConverterUtil;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom2.Element;

public class WSInterfaceConverter
extends AbstractDataBaseInfoConverter {
    private String[] header_string = new String[]{"number", "name", "description", "serviceType"};
    private String[] entryStrFields = new String[]{"head", "srcFieldName", "srcFieldAlias", "srcFieldDataType", "srcFieldDataLength", "srcFieldDataPrecision", "srcFieldDataScale", "midFieldName", "midFieldAlias", "midFieldDataType", "midFieldDataLength", "midFieldDataPrecision", "midFieldDataScale", "dropped", "published", "pkField", "changeful"};

    @Override
    public boolean canConvert(Class type) {
        return WSInterfaceInfo.class == type;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        WSInterfaceInfo info = new WSInterfaceInfo();
        List children = data.getChildren();
        this.unmarshallHeader(children, info);
        this.unmarshalWSInterfaceTree(children, info, context);
        this.unmarshalBillMapping(children, info, context);
        this.unmarshalQueryMarker(children, info, context);
        this.unmarshalReturnMarker(children, info, context);
        this.unmarshalService(children, info, context);
        return info;
    }

    private void unmarshallHeader(List<Element> children, WSInterfaceInfo info) {
        info.setNumber(this.getElementTextByName(children, "number"));
        info.setName(this.getElementTextByName(children, "name"));
        info.setDescription(this.getElementTextByName(children, "description"));
        info.setServiceType(ServiceType.getEnum(this.getElementTextByName(children, "serviceType")));
        info.setPreset(WSInterfaceConverter.changeStringToBoolean(this.getElementTextByName(children, "preset")));
    }

    private void unmarshalWSInterfaceTree(List<Element> children, WSInterfaceInfo info, UnmarshallingContext context) {
        Element wsInterfaceTree = this.getElementByName(children, "WSInterfaceTreeInfo");
        if (null == wsInterfaceTree) {
            return;
        }
        Element wsinterfaceTreeElement = wsInterfaceTree.getChild(WSInterfaceTreeInfo.class.getName());
        if (null != wsinterfaceTreeElement) {
            WSInterfaceTreeInfo item = (WSInterfaceTreeInfo)context.unmarshall(wsinterfaceTreeElement);
            info.setTree(item);
        }
    }

    private void unmarshalBillMapping(List<Element> children, WSInterfaceInfo info, UnmarshallingContext context) {
        Element wsbillmapping = this.getElementByName(children, "WSBillMappingInfo");
        if (null == wsbillmapping) {
            return;
        }
        Element wsbillmappingElement = wsbillmapping.getChild(WSBillMappingInfo.class.getName());
        if (null != wsbillmappingElement) {
            WSBillMappingInfo item = (WSBillMappingInfo)context.unmarshall(wsbillmappingElement);
            info.setWsbillMapping(item);
        }
    }

    private void unmarshalQueryMarker(List<Element> children, WSInterfaceInfo info, UnmarshallingContext context) {
        Element queryMarker = this.getElementByName(children, "queryMarker");
        if (null == queryMarker) {
            return;
        }
        Element queryMarkerElement = queryMarker.getChild(WSFreeMarkerInfo.class.getName());
        if (null != queryMarker) {
            WSFreeMarkerInfo item = (WSFreeMarkerInfo)context.unmarshall(queryMarkerElement);
            info.setQueryFreeMarker(item);
        }
    }

    private void unmarshalReturnMarker(List<Element> children, WSInterfaceInfo info, UnmarshallingContext context) {
        Element returnMarker = this.getElementByName(children, "returnMarker");
        if (null == returnMarker) {
            return;
        }
        Element returnMarkerElement = returnMarker.getChild(WSFreeMarkerInfo.class.getName());
        if (null != returnMarkerElement) {
            WSFreeMarkerInfo item = (WSFreeMarkerInfo)context.unmarshall(returnMarkerElement);
            info.setFreeMarker(item);
        }
    }

    private void unmarshalService(List<Element> children, WSInterfaceInfo info, UnmarshallingContext context) {
        Element wsServiceInfo = this.getElementByName(children, "WSServiceInfo");
        if (null == wsServiceInfo) {
            return;
        }
        Element wsServiceInfoElement = wsServiceInfo.getChild(WSServiceInfo.class.getName());
        if (null != wsServiceInfoElement) {
            WSServiceInfo item = (WSServiceInfo)context.unmarshall(wsServiceInfoElement);
            info.setWebservice(item);
        }
    }

    public Object unmarshalInterface(List<Element> children, WSInterfaceInfo info) {
        for (int i = 0; i < this.header_string.length; ++i) {
            info.setString(this.header_string[i], this.getElementTextByName(children, this.header_string[i]));
        }
        return info;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        Boolean needBaseDataMapping;
        WSInterfaceInfo info = (WSInterfaceInfo)source;
        Element root = new Element(info.getClass().getName());
        ConverterUtil.displayTask("\u672c\u5730\u670d\u52a1");
        this.marshalInterface(root, info);
        if (null != info.getTree()) {
            this.marshalInterfaceTree(root, info, context);
        }
        ConverterUtil.complete();
        ConverterUtil.displayTask("EAS\u6570\u636e\u6a21\u578b");
        this.marshalBillMapping(root, info, context);
        ConverterUtil.complete();
        ConverterUtil.displayTask("EAS\u67e5\u8be2\u6a21\u677f");
        this.marshalQueryMarker(root, info, context);
        ConverterUtil.complete();
        ConverterUtil.displayTask("EAS\u8fd4\u56de\u503c\u6a21\u677f");
        this.marshalReturnMarker(root, info, context);
        ConverterUtil.complete();
        ConverterUtil.displayTask("\u8fdc\u7a0b\u670d\u52a1");
        this.marshalService(root, info, context);
        ConverterUtil.complete();
        Map<String, Boolean> converMap = ConverterUtil.getSelectedMap();
        Boolean needSchedule = converMap.get("schedule");
        if (converMap != null && needSchedule != null && needSchedule.booleanValue()) {
            ConverterUtil.displayTask("\u8c03\u5ea6\u7b56\u7565");
            this.marshalSchedule(root, info, context);
            ConverterUtil.complete();
        }
        if ((needBaseDataMapping = converMap.get("baseDataMapping")) != null && needBaseDataMapping.booleanValue()) {
            ConverterUtil.displayTask("\u57fa\u7840\u8d44\u6599\u503c\u6620\u5c04");
            this.marshalBaseDataMapping(root, context);
            ConverterUtil.complete();
        }
        return root;
    }

    private void marshalInterface(Element root, WSInterfaceInfo info) {
        for (int i = 0; i < this.header_string.length; ++i) {
            this.addChild(root, this.header_string[i], info.getString(this.header_string[i]));
        }
        this.addChild(root, "preset", info.getBoolean("preset"));
    }

    private void marshalBillMapping(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSBillMappingInfo billInfo = info.getWsbillMapping();
        if (null == billInfo) {
            return;
        }
        Object object = context.marshall(billInfo);
        this.addChild(root, billInfo.getClass().getSimpleName(), (Element)object);
    }

    private void marshalInterfaceTree(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSInterfaceTreeInfo treeInfo = info.getTree();
        if (null == treeInfo) {
            return;
        }
        Object object = context.marshall(treeInfo);
        this.addChild(root, treeInfo.getClass().getSimpleName(), (Element)object);
    }

    private void marshalQueryMarker(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSFreeMarkerInfo queryMarker = info.getQueryFreeMarker();
        if (null == queryMarker) {
            return;
        }
        Object object = context.marshall(queryMarker);
        this.addChild(root, "queryMarker", (Element)object);
    }

    private void marshalReturnMarker(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSFreeMarkerInfo returnMarker = info.getFreeMarker();
        if (null == returnMarker) {
            return;
        }
        Object object = context.marshall(returnMarker);
        this.addChild(root, "returnMarker", (Element)object);
    }

    private void marshalService(Element root, WSInterfaceInfo info, MarshallingContext context) {
        WSServiceInfo service = info.getWebservice();
        if (null == service) {
            return;
        }
        Object object = context.marshall(service);
        this.addChild(root, service.getClass().getSimpleName(), (Element)object);
    }

    private void marshalServiceURL(Element root, WSServiceURLInfo info, MarshallingContext context) {
        if (null == info) {
            return;
        }
        Object object = context.marshall(info);
        this.addChild(root, info.getClass().getSimpleName(), (Element)object);
    }

    private void marshalSchedule(Element root, WSInterfaceInfo info, MarshallingContext context) {
        if (null == info) {
            return;
        }
        ScheduleCollection schedules = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("wsinterface", (Object)info.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selecters = new SelectorItemCollection();
            selecters.add(new SelectorItemInfo("*"));
            selecters.add(new SelectorItemInfo("wsinterface.id"));
            selecters.add(new SelectorItemInfo("wsinterface.number"));
            selecters.add(new SelectorItemInfo("wsIdentificationCode.*"));
            view.setSelector(selecters);
            schedules = ScheduleFactory.getRemoteInstance().getScheduleCollection(view);
            if (schedules == null || schedules.size() == 0) {
                return;
            }
            Object object = context.marshall((Object)schedules);
            this.addChild(root, (Element)object);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    private void marshalBaseDataMapping(Element root, MarshallingContext context) {
        Set<String> idList = ConverterUtil.getBaseDataTypeIdList();
        if (idList.size() == 0) {
            return;
        }
        BaseDataMapingCollection mappings = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseDataType", idList, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selecters = new SelectorItemCollection();
            selecters.add(new SelectorItemInfo("*"));
            selecters.add(new SelectorItemInfo("entrys.*"));
            view.setSelector(selecters);
            mappings = BaseDataMapingFactory.getRemoteInstance().getBaseDataMapingCollection(view);
            if (mappings == null || mappings.size() == 0) {
                return;
            }
            Object object = context.marshall((Object)mappings);
            this.addChild(root, (Element)object);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
    }

    public void unmarshalHeader(BillMappingInfo info, List<Element> children) {
    }

    private void marshalEntrys(Element root, BillMappingInfo info) {
        Element entryRoot = JDomB9Utils.addChild(root, "entrys");
        Iterator iterator = info.getEntrys().iterator();
        while (iterator.hasNext()) {
            Element entry = JDomB9Utils.addChild(entryRoot, "entry");
            BillMappingEntryInfo entryInfo = (BillMappingEntryInfo)iterator.next();
            String tmpValue = "";
            for (int i = 0; i < this.entryStrFields.length; ++i) {
                tmpValue = entryInfo.getString(this.entryStrFields[i]);
                tmpValue = StringUtils.equals((String)tmpValue, (String)"true") ? "1" : tmpValue;
                tmpValue = StringUtils.equals((String)tmpValue, (String)"false") ? "0" : tmpValue;
                this.addChild(entry, this.entryStrFields[i], tmpValue);
            }
            BaseDataTypeInfo baseDataTypeInfo = entryInfo.getBaseDataType();
            if (null == baseDataTypeInfo) continue;
            this.addChild(entry, "baseDataTypeFID", baseDataTypeInfo.getId().toString());
        }
    }

    private void unmarshalEntrys(BillMappingInfo info, List<Element> children) {
        Element entryRoot = this.getElementByName(children, "entrys");
        if (null == entryRoot) {
            return;
        }
        BillMappingEntryCollection entryCollection = new BillMappingEntryCollection();
        List entryList = entryRoot.getChildren("entry");
        boolean isOldVersion = false;
        boolean swatch = true;
        for (Element entry : entryList) {
            BillMappingEntryInfo entryInfo = new BillMappingEntryInfo();
            if (swatch) {
                swatch = false;
                isOldVersion = StringUtils.isEmpty((String)this.getElementTextByName(entry, "changeful"));
            }
            for (int i = 0; i < this.entryStrFields.length; ++i) {
                String value = this.getElementTextByName(entry, this.entryStrFields[i]);
                entryInfo.setString(this.entryStrFields[i], value);
            }
            if (isOldVersion) {
                boolean isPK = StringUtils.endsWithIgnoreCase((String)"headpk", (String)this.getElementTextByName(entry, this.entryStrFields[1])) || StringUtils.endsWithIgnoreCase((String)"entrypk", (String)this.getElementTextByName(entry, this.entryStrFields[1]));
                entryInfo.setString("changeful", isPK ? "1" : "0");
                entryInfo.setString("pkfield", isPK ? "1" : "0");
            }
            entryInfo.setHead(entryInfo.getBoolean("head"));
            entryInfo.setPublished(false);
            entryInfo.setDropped(entryInfo.getBoolean("dropped"));
            String FID = this.getElementTextByName(entry, "baseDataTypeFID");
            entryInfo.put("baseDataTypeFID_TO_BE_REPLACED", FID);
            entryCollection.add(entryInfo);
        }
        info.getEntrys().addCollection(entryCollection);
    }

    public static String changeBooleanToString(Boolean value) {
        return value != false ? "1" : "0";
    }

    public static Boolean changeStringToBoolean(String value) {
        return StringUtils.equals((String)value, (String)"1");
    }
}

