/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.converter;

import com.kingdee.eas.csinterface.converter.core.MarshallingContext;
import com.kingdee.eas.csinterface.converter.core.UnmarshallingContext;
import com.kingdee.eas.csinterface.planmanager.converter.AbstractDataBaseInfoConverter;
import com.kingdee.eas.csinterface.util.JDomB9Utils;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSServiceEntryFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceFactory;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceURLInfo;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Element;

public class WSServiceConverter
extends AbstractDataBaseInfoConverter {
    private String[] header_string = new String[]{"number", "name", "description", "implClass", "serviceMethod", "nameSpace", "serviceUser", "servicePwd"};
    private String[] header_boolean = new String[]{"serviceType", "preset", "login"};
    private String[] entry_string = new String[]{"number", "name", "defaultValue", "returnDataType", "region"};
    private String[] entry_boolean = new String[]{"isLogin", "preset"};
    StringBuffer str = new StringBuffer();

    @Override
    public boolean canConvert(Class type) {
        return WSServiceInfo.class == type;
    }

    @Override
    public Object marshal(Object source, MarshallingContext context) {
        WSServiceInfo info = (WSServiceInfo)source;
        Element root = new Element(info.getClass().getName());
        this.marshalHeader(root, info, context);
        this.marshalEntrys(root, info, context);
        return root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element data = (Element)source;
        WSServiceInfo info = new WSServiceInfo();
        List children = data.getChildren();
        this.unmarshalHeader(info, children, context);
        this.unmarshalEntrys(info, children, context);
        return info;
    }

    private void marshalHeader(Element root, WSServiceInfo info, MarshallingContext context) {
        int i;
        if (this.str.length() > 0) {
            this.str.setLength(0);
        }
        for (i = 0; i < this.header_string.length; ++i) {
            this.addChild(root, this.header_string[i], info.getString(this.header_string[i]));
            this.str.append(this.header_string[i] + ",");
        }
        for (i = 0; i < this.header_boolean.length; ++i) {
            this.addChild(root, this.header_boolean[i], info.getBoolean(this.header_boolean[i]));
            this.str.append(this.header_boolean[i] + ",");
        }
        WSServiceURLInfo treeInfo = info.getTree();
        if (treeInfo != null) {
            Element treeRoot = JDomB9Utils.addChild(root, "tree");
            Object object = context.marshall(treeInfo);
            this.addChild(root, treeInfo.getClass().getSimpleName(), (Element)object);
        }
    }

    private void marshalEntrys(Element root, WSServiceInfo info, MarshallingContext context) {
        Element entryRoot = JDomB9Utils.addChild(root, "entrys");
        Iterator iterator = info.getEntrys().iterator();
        while (iterator.hasNext()) {
            int i;
            Element entry = JDomB9Utils.addChild(entryRoot, "entry");
            WSServiceEntryInfo entryInfo = (WSServiceEntryInfo)iterator.next();
            if (entryInfo.isIsLogin()) {
                try {
                    String str = "select preset,number,name,defaultValue,isLogin,returnDataType,region,loginService.*,freeMarker.*,freeMarker.tree.*,freeMarker.tree.parent.* where id = '" + entryInfo.getId().toString() + "'";
                    entryInfo = WSServiceEntryFactory.getRemoteInstance().getWSServiceEntryInfo(str);
                }
                catch (Exception str) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.entry_string.length; ++i) {
                this.addChild(entry, this.entry_string[i], entryInfo.getString(this.entry_string[i]));
                this.str.append("entrys." + this.entry_string[i] + ",");
            }
            for (i = 0; i < this.entry_boolean.length; ++i) {
                this.addChild(entry, this.entry_boolean[i], entryInfo.getBoolean(this.entry_boolean[i]));
                this.str.append("entrys." + this.entry_boolean[i] + ",");
            }
            this.marshalFreeMarker(entry, entryInfo.getFreeMarker(), context);
            this.marshalLoginService(entry, entryInfo.getLoginService(), context);
        }
    }

    private void marshalFreeMarker(Element root, WSFreeMarkerInfo marker, MarshallingContext context) {
        if (null == marker) {
            return;
        }
        Object object = context.marshall(marker);
        this.addChild(root, "marker", (Element)object);
    }

    private void marshalLoginService(Element root, WSServiceInfo service, MarshallingContext context) {
        if (null == service) {
            return;
        }
        try {
            service = WSServiceFactory.getRemoteInstance().getWSServiceInfo("select " + this.str + "tree.*,entrys.*,entrys.freeMarker.*,entrys.freeMarker.tree.*,entrys.freeMarker.tree.parent.*  where id = '" + service.getId().toString() + "'");
            Object object = context.marshall(service);
            this.addChild(root, "loginService", (Element)object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unmarshalHeader(WSServiceInfo info, List<Element> children, UnmarshallingContext context) {
        for (int i = 0; i < this.header_string.length; ++i) {
            info.setString(this.header_string[i], this.getElementTextByName(children, this.header_string[i]));
        }
        for (int k = 0; k < this.header_boolean.length; ++k) {
            info.setBoolean(this.header_boolean[k], WSServiceConverter.changeStringToBoolean(this.getElementTextByName(children, this.header_boolean[k])));
        }
        Element tree = this.getElementByName(children, "WSServiceURLInfo");
        if (tree != null && tree.getChild(WSServiceURLInfo.class.getName()) != null) {
            WSServiceURLInfo item = (WSServiceURLInfo)context.unmarshall(tree.getChild(WSServiceURLInfo.class.getName()));
            info.setTree(item);
        }
    }

    private void unmarshalEntrys(WSServiceInfo info, List<Element> children, UnmarshallingContext context) {
        Element entrys = this.getElementByName(children, "entrys");
        if (null == entrys) {
            return;
        }
        WSServiceEntryCollection collInfo = new WSServiceEntryCollection();
        List entryList = entrys.getChildren("entry");
        for (Element entry : entryList) {
            WSServiceEntryInfo entryInfo = new WSServiceEntryInfo();
            for (int i = 0; i < this.entry_string.length; ++i) {
                String value = this.getElementTextByName(entry, this.entry_string[i]);
                entryInfo.setString(this.entry_string[i], value);
            }
            for (int k = 0; k < this.entry_boolean.length; ++k) {
                entryInfo.setBoolean(this.entry_boolean[k], WSServiceConverter.changeStringToBoolean(this.getElementTextByName(entry, this.entry_boolean[k])));
            }
            this.unmarshalMarker(entry, entryInfo, context);
            this.unmarshalLoginService(entry, entryInfo, context);
            collInfo.add(entryInfo);
        }
        info.getEntrys().addCollection(collInfo);
    }

    private void unmarshalMarker(Element entry, WSServiceEntryInfo entryInfo, UnmarshallingContext context) {
        if (entry != null && entry.getChild("marker") == null) {
            return;
        }
        WSFreeMarkerInfo item = (WSFreeMarkerInfo)context.unmarshall(entry.getChild("marker").getChild(WSFreeMarkerInfo.class.getName()));
        entryInfo.setFreeMarker(item);
    }

    private void unmarshalLoginService(Element entry, WSServiceEntryInfo entryInfo, UnmarshallingContext context) {
        if (entry != null && entry.getChild("loginService") == null) {
            return;
        }
        WSServiceInfo item = (WSServiceInfo)context.unmarshall(entry.getChild("loginService").getChild(WSServiceInfo.class.getName()));
        entryInfo.setLoginService(item);
    }
}

