/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.desc.convert;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.TypeData;
import dm.jdbc.desc.TypeDescriptor;
import dm.jdbc.desc.convert.Data;
import dm.jdbc.desc.convert.OffRowBlobData;
import dm.jdbc.desc.convert.OffRowBytesData;
import dm.jdbc.desc.convert.OffRowClobData;
import dm.jdbc.desc.convert.OffRowData;
import dm.jdbc.desc.convert.OffRowReaderData;
import dm.jdbc.desc.convert.OffRowStreamData;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbRowId;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StreamUtil;
import dm.jdbc.util.StringUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class J2DB {
    public static final double MAX_REAL = 3.4E38;
    public static final double MIN_REAL = -3.4E38;
    public static final BigDecimal MAX_REAL_VALUE = new BigDecimal("3.4E+38");
    public static final BigDecimal MIN_REAL_VALUE = new BigDecimal("-3.4E+38");
    public static final BigDecimal MAX_TINYINT_VALUE = new BigDecimal(127);
    public static final BigDecimal MIN_TINYINT_VALUE = new BigDecimal(-128);
    public static final BigDecimal MAX_SMALLINT_VALUE = new BigDecimal(Short.MAX_VALUE);
    public static final BigDecimal MIN_SMALLINT_VALUE = new BigDecimal(Short.MIN_VALUE);
    public static final BigDecimal MAX_INT_VALUE = new BigDecimal(Integer.MAX_VALUE);
    public static final BigDecimal MIN_INT_VALUE = new BigDecimal(Integer.MIN_VALUE);
    public static final BigDecimal MAX_BIGINT_VALUE = new BigDecimal(Long.MAX_VALUE);
    public static final BigDecimal MIN_BIGINT_VALUE = new BigDecimal(Long.MIN_VALUE);

    public static byte[] fromBoolean(boolean val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    return J2DB.fromLong(val ? 1 : 0, param, connection);
                }
                case 12: 
                case 17: 
                case 18: {
                    if (DmdbType.isComplexType(param.type, param.scale)) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    bytes = J2DB.toBit(val ? 1 : 0);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromLong(long val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 3: 
                case 13: {
                    bytes = J2DB.toBit(val);
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(val);
                    bytes = J2DB.toTinyint((byte)val);
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(val);
                    bytes = J2DB.toSmallint((short)val);
                    break;
                }
                case 7: {
                    J2DB.checkInt(val);
                    bytes = J2DB.toInt((int)val);
                    break;
                }
                case 8: {
                    J2DB.checkBigint(val);
                    bytes = J2DB.toBigint(val);
                    break;
                }
                case 10: {
                    J2DB.checkReal(val);
                    bytes = J2DB.toReal(val);
                    break;
                }
                case 11: {
                    bytes = J2DB.toDouble(val);
                    break;
                }
                case 9: {
                    bytes = DmdbNumeric.valueOf(val, param.prec, param.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(String.valueOf(val), connection.getServerEncoding());
                    break;
                }
                case 12: 
                case 17: 
                case 18: {
                    if (DmdbType.isComplexType(param.type, param.scale)) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    bytes = J2DB.toBinary(val, param.prec);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 26: {
                    bytes = J2DB.toDate(val, param, connection);
                    break;
                }
                case 28: {
                    bytes = DmdbRowId.valueOf(val).encode(connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromFloat(float val, Column param, DmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 3: 
                case 13: {
                    bytes = J2DB.toTinyint((byte)((double)val != 0.0 ? 1 : 0));
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(val);
                    bytes = J2DB.toTinyint((byte)val);
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(val);
                    bytes = J2DB.toSmallint((short)val);
                    break;
                }
                case 7: {
                    J2DB.checkInt(val);
                    bytes = J2DB.toInt((int)val);
                    break;
                }
                case 8: {
                    J2DB.checkBigint(val);
                    bytes = J2DB.toBigint((long)val);
                    break;
                }
                case 10: {
                    J2DB.checkReal(val);
                    bytes = J2DB.toReal(val);
                    break;
                }
                case 11: {
                    bytes = J2DB.toDouble(val);
                    break;
                }
                case 9: {
                    bytes = DmdbNumeric.valueOf(String.valueOf(val), param.prec, param.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(String.valueOf(val), connection.getServerEncoding());
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromDouble(double val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 3: 
                case 13: {
                    bytes = J2DB.toTinyint((byte)(val != 0.0 ? 1 : 0));
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(val);
                    bytes = J2DB.toTinyint((byte)val);
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(val);
                    bytes = J2DB.toSmallint((short)val);
                    break;
                }
                case 7: {
                    J2DB.checkInt(val);
                    bytes = J2DB.toInt((int)val);
                    break;
                }
                case 8: {
                    J2DB.checkBigint(val);
                    bytes = J2DB.toBigint((long)val);
                    break;
                }
                case 10: {
                    J2DB.checkReal(val);
                    bytes = J2DB.toReal((float)val);
                    break;
                }
                case 11: {
                    bytes = J2DB.toDouble(val);
                    break;
                }
                case 9: {
                    bytes = DmdbNumeric.valueOf(String.valueOf(val), param.prec, param.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(String.valueOf(val), connection.getServerEncoding());
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromBigDecimal(BigDecimal val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 3: 
                case 13: {
                    bytes = J2DB.toBit(val.equals(new BigDecimal(0)) ? 0 : 1);
                    break;
                }
                case 5: {
                    J2DB.checkTinyint(val);
                    bytes = J2DB.toTinyint(val.setScale(0, 4).byteValue());
                    break;
                }
                case 6: {
                    J2DB.checkSmallint(val);
                    bytes = J2DB.toSmallint(val.setScale(0, 4).shortValue());
                    break;
                }
                case 7: {
                    J2DB.checkInt(val);
                    bytes = J2DB.toInt(val.setScale(0, 4).intValue());
                    break;
                }
                case 8: {
                    J2DB.checkBigint(val);
                    bytes = J2DB.toBigint(val.setScale(0, 4).longValue());
                    break;
                }
                case 10: {
                    J2DB.checkReal(val);
                    bytes = J2DB.toReal(val.floatValue());
                    break;
                }
                case 11: {
                    bytes = J2DB.toDouble(val.doubleValue());
                    break;
                }
                case 9: {
                    bytes = DmdbNumeric.valueOf(val, param.prec, param.scale).encode();
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(String.valueOf(val), connection.getServerEncoding());
                    break;
                }
                case 28: {
                    bytes = DmdbRowId.valueOf(val.longValue()).encode(connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromString(String val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            Object bytes = null;
            switch (param.type) {
                case 3: 
                case 13: {
                    bytes = J2DB.toBit(ConvertUtil.toBoolean(val) ? 1 : 0);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return J2DB.fromBigDecimal(new BigDecimal(val), param, connection);
                }
                case 10: {
                    Float f2 = Float.valueOf(val);
                    return J2DB.toReal(f2.floatValue());
                }
                case 11: {
                    Double d2 = Double.valueOf(val);
                    return J2DB.toDouble(d2);
                }
                case 9: {
                    bytes = J2DB.toDecimal(val, param.prec, param.scale);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3 && !DmdbBFile.isValidBFileStr(val)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(val, connection.getServerEncoding());
                    break;
                }
                case 19: {
                    bytes = J2DB.toClob(val, param, connection);
                    break;
                }
                case 17: 
                case 18: {
                    bytes = J2DB.toVarbinary(val);
                    break;
                }
                case 12: {
                    if (DmdbType.isComplexType(param.type, param.scale)) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    bytes = J2DB.toBlob(J2DB.toVarbinary(val), param, connection);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 26: 
                case 27: {
                    DmdbTimestamp ts = DmdbTimestamp.valueOf(val, param, connection);
                    bytes = ts.encode(param, connection);
                    break;
                }
                case 21: {
                    DmdbIntervalDT dt = new DmdbIntervalDT(val);
                    bytes = dt.encode(param.scale);
                    break;
                }
                case 20: {
                    DmdbIntervalYM ym = new DmdbIntervalYM(val);
                    bytes = ym.encode(param.scale);
                    break;
                }
                case 28: {
                    bytes = DmdbRowId.valueOf(val).encode(connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return bytes instanceof byte[] ? J2DB.checkLength(param, bytes, connection.getServerEncoding()) : bytes;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromBytes(byte[] val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 5: {
                    if (val.length > 1) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    ret = val;
                    break;
                }
                case 6: {
                    if (val.length > 2) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    ret = val;
                    break;
                }
                case 7: {
                    if (val.length > 4) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    ret = val;
                    break;
                }
                case 8: {
                    if (val.length > 8) {
                        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    }
                    ret = val;
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    ret = J2DB.toVarchar(val);
                    break;
                }
                case 19: {
                    ret = J2DB.toClob(val, param, connection);
                    break;
                }
                case 17: 
                case 18: {
                    ret = J2DB.toVarbinary(val);
                    break;
                }
                case 12: {
                    ret = J2DB.toBlob(val, param, connection);
                    break;
                }
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    TypeDescriptor typeDesc = param.typeDescriptor;
                    if (typeDesc != null) {
                        ret = TypeData.objBlobToBytes(val, typeDesc);
                        break;
                    }
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    break;
                }
                case 28: {
                    ret = DmdbRowId.valueOf(val).encode(connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromDate(java.util.Date val, Column param, IDmdbConnection connection, Calendar calendar) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(val.toString(), connection.getServerEncoding());
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 26: 
                case 27: {
                    DmdbTimestamp dt = DmdbTimestamp.valueOf(val, param.mask == 4 ? null : calendar);
                    bytes = dt.encode(param, connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromDmdbTimestamp(DmdbTimestamp val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(val.toString(), connection.getServerEncoding());
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 26: 
                case 27: {
                    bytes = val.encode(param, connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromDmdbIntervalDT(DmdbIntervalDT val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(val.toString(), connection.getServerEncoding());
                    break;
                }
                case 21: {
                    bytes = val.encode(param.scale);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromDmdbIntervalYM(DmdbIntervalYM val, Column param, IDmdbConnection connection) throws SQLException {
        try {
            byte[] bytes = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: 
                case 19: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    bytes = J2DB.toVarchar(val.toString(), connection.getServerEncoding());
                    break;
                }
                case 20: {
                    bytes = val.encode(param.scale);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromBlob(DmdbBlob x2, Column param, DmdbConnection connection) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 17: 
                case 18: {
                    ret = x2.do_getBytes(1L, (int)x2.do_length());
                    break;
                }
                case 12: {
                    if (connection.lobEmptyCompOrcl && x2 instanceof DmdbBlob && x2.empty) {
                        return Data.EMPTY_LOB;
                    }
                    ret = J2DB.toBlob(x2, param, connection);
                    break;
                }
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    TypeDescriptor typeDesc = param.typeDescriptor;
                    if (typeDesc != null) {
                        byte[] lobBuf = x2.do_getBytes(1L, (int)x2.do_length());
                        ret = TypeData.objBlobToBytes(lobBuf, typeDesc);
                        break;
                    }
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromClob(DmdbClob x2, Column param, DmdbConnection connection) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    String str = x2.do_getSubString(1L, (int)x2.do_length());
                    if (param.mask == 3 && !DmdbBFile.isValidBFileStr(str)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    ret = ByteUtil.fromString(str, connection.getServerEncoding());
                    break;
                }
                case 19: {
                    if (connection.lobEmptyCompOrcl && x2 instanceof DmdbClob && x2.empty) {
                        return Data.EMPTY_LOB;
                    }
                    ret = J2DB.toClob(x2, param, connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? (Object)J2DB.checkLength(param, (byte[])ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromBinaryStream(InputStream x2, Column param, DmdbConnection connection, long length) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    ret = StreamUtil.readBytes(x2, (int)length);
                    break;
                }
                case 17: 
                case 18: {
                    ret = J2DB.toVarbinary(StreamUtil.readBytes(x2, (int)length));
                    break;
                }
                case 19: {
                    OffRowStreamData binder = new OffRowStreamData(x2, connection, length, 1);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                case 12: {
                    OffRowStreamData binder = new OffRowStreamData(x2, connection, length, 1);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                case 117: 
                case 119: 
                case 121: 
                case 122: {
                    TypeDescriptor typeDesc = param.typeDescriptor;
                    if (typeDesc != null) {
                        ret = StreamUtil.readBytes(x2, (int)length);
                        ret = TypeData.objBlobToBytes(ret, typeDesc);
                        break;
                    }
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromAsciiStream(InputStream x2, Column param, DmdbConnection connection, long length) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byte[] asciiBytes = StreamUtil.readBytes(x2, (int)length);
                    char[] javaChars = ConvertUtil.ASCIIBytesToJavaChars(asciiBytes, 0, asciiBytes.length);
                    ret = ByteUtil.fromString(String.valueOf(javaChars), connection.getServerEncoding());
                    break;
                }
                case 19: {
                    OffRowStreamData binder = new OffRowStreamData(x2, connection, length, 2);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                case 17: 
                case 18: {
                    ret = J2DB.toVarbinary(StreamUtil.readBytes(x2, (int)length));
                    break;
                }
                case 12: {
                    OffRowStreamData binder = new OffRowStreamData(x2, connection, length, 2);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromUnicodeStream(InputStream x2, Column param, DmdbConnection connection, long length) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    if (param.mask == 3) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    byte[] bytes = StreamUtil.readBytes(x2, (int)length);
                    String str = ConvertUtil.UnicodeBytesToString(bytes, bytes.length);
                    ret = ByteUtil.fromString(str, connection.getServerEncoding());
                    break;
                }
                case 19: {
                    OffRowStreamData binder = new OffRowStreamData(x2, connection, length, 3);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                case 17: 
                case 18: {
                    ret = J2DB.toVarbinary(StreamUtil.readBytes(x2, (int)length));
                    break;
                }
                case 12: {
                    OffRowStreamData binder = new OffRowStreamData(x2, connection, length, 3);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromReader(Reader x2, Column param, DmdbConnection connection, long length) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 0: 
                case 1: 
                case 2: {
                    String str = StreamUtil.readString(x2, (int)length);
                    if (param.mask == 3 && !DmdbBFile.isValidBFileStr(str)) {
                        DBError.ECJDBC_INVALID_BFILE.throwz(new Object[0]);
                    }
                    ret = J2DB.toVarchar(str, connection.getServerEncoding());
                    break;
                }
                case 17: 
                case 18: {
                    ret = ByteUtil.fromString(StreamUtil.readString(x2, (int)length), connection.getServerEncoding());
                    break;
                }
                case 12: 
                case 19: {
                    OffRowReaderData binder = new OffRowReaderData(x2, (IDmdbConnection)connection, length);
                    ret = binder.offRow ? binder : (Object)binder.readAll();
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromArray(DmdbArray x2, Column param, DmdbConnection connection) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 122: {
                    ret = TypeData.sarrayToBytes(x2, param.typeDescriptor);
                    break;
                }
                case 117: 
                case 119: {
                    ret = TypeData.arrayToBytes(x2, param.typeDescriptor);
                    break;
                }
                case 12: {
                    ret = J2DB.toBlob(TypeData.toBytes(x2, param.typeDescriptor), param, (IDmdbConnection)connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromStruct(DmdbStruct x2, Column param, DmdbConnection connection) throws SQLException {
        try {
            Object ret = null;
            switch (param.type) {
                case 119: {
                    ret = TypeData.structToBytes(x2, param.typeDescriptor);
                    break;
                }
                case 121: {
                    ret = TypeData.recordToBytes(x2, param.typeDescriptor);
                    break;
                }
                case 12: {
                    ret = J2DB.toBlob(TypeData.toBytes(x2, param.typeDescriptor), param, (IDmdbConnection)connection);
                    break;
                }
                default: {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static Object fromRowId(RowId val, Column param, IDmdbConnection connection) throws SQLException {
        if (!(val instanceof DmdbRowId)) {
            return J2DB.fromBytes(val.getBytes(), param, connection);
        }
        try {
            byte[] ret = null;
            switch (param.type) {
                case 28: {
                    ret = ((DmdbRowId)val).encode(connection);
                    break;
                }
                case 8: {
                    ret = ByteUtil.fromLong(((DmdbRowId)val).longValue(connection));
                    break;
                }
                default: {
                    return J2DB.fromBytes(val.getBytes(), param, connection);
                }
            }
            return ret instanceof byte[] ? J2DB.checkLength(param, ret, connection.getServerEncoding()) : ret;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] fromObject(Object mem, Column param, IDmdbConnection connection) throws SQLException {
        byte[] bytes;
        block29: {
            bytes = null;
            if (mem instanceof String) {
                Object ret = J2DB.fromString((String)mem, param, connection);
                return ret instanceof OffRowData ? ((OffRowData)ret).readAll() : (byte[])ret;
            }
            if (mem instanceof Integer) {
                return J2DB.fromLong(((Integer)mem).intValue(), param, connection);
            }
            if (mem instanceof Short) {
                return J2DB.fromLong(((Short)mem).shortValue(), param, connection);
            }
            if (mem instanceof Long) {
                return J2DB.fromLong((Long)mem, param, connection);
            }
            if (mem instanceof Double) {
                return J2DB.fromDouble((Double)mem, param, connection);
            }
            if (mem instanceof Float) {
                return J2DB.fromDouble(((Float)mem).floatValue(), param, connection);
            }
            if (mem instanceof Byte) {
                return J2DB.fromLong(((Byte)mem).byteValue(), param, connection);
            }
            if (mem instanceof BigDecimal) {
                return J2DB.fromBigDecimal((BigDecimal)mem, param, connection);
            }
            if (mem instanceof Number) {
                BigDecimal tmp = new BigDecimal(String.valueOf(mem));
                return J2DB.fromBigDecimal(tmp, param, connection);
            }
            if (mem instanceof Date) {
                return J2DB.fromDate((java.util.Date)mem, param, connection, null);
            }
            if (mem instanceof Time) {
                return J2DB.fromDate((Time)mem, param, connection, null);
            }
            if (mem instanceof Timestamp) {
                return J2DB.fromDate((Timestamp)mem, param, connection, null);
            }
            if (mem instanceof DmdbBlob) {
                Blob x2 = (Blob)mem;
                bytes = x2.getBytes(1L, (int)x2.length());
                break block29;
            }
            if (mem instanceof Blob) {
                Blob x3 = (Blob)mem;
                bytes = x3.getBytes(1L, (int)x3.length());
                break block29;
            }
            if (mem instanceof Clob) {
                Clob x4 = (Clob)mem;
                String str = x4.getSubString(1L, (int)x4.length());
                bytes = ByteUtil.fromString(str, connection.getServerEncoding());
                break block29;
            }
            if (mem instanceof InputStream) {
                OffRowStreamData binder = new OffRowStreamData((InputStream)mem, connection, -1L, 1);
                bytes = ((OffRowData)binder).readAll();
                break block29;
            }
            if (mem instanceof Reader) {
                OffRowReaderData binder = new OffRowReaderData((Reader)mem, connection, -1L);
                bytes = ((OffRowData)binder).readAll();
                break block29;
            }
            if (mem instanceof byte[]) {
                Object ret = J2DB.fromBytes((byte[])mem, param, connection);
                return ret instanceof OffRowData ? ((OffRowData)ret).readAll() : (byte[])ret;
            }
            if (mem instanceof Boolean) {
                return J2DB.fromBoolean((Boolean)mem, param, connection);
            }
            if (mem instanceof DmdbIntervalDT) {
                return J2DB.fromDmdbIntervalDT((DmdbIntervalDT)mem, param, connection);
            }
            if (mem instanceof DmdbIntervalYM) {
                return J2DB.fromDmdbIntervalYM((DmdbIntervalYM)mem, param, connection);
            }
            if (mem instanceof DmdbTimestamp) {
                return J2DB.fromDmdbTimestamp((DmdbTimestamp)mem, param, connection);
            }
            if (mem instanceof Character) {
                Object ret = J2DB.fromString(String.valueOf(mem), param, connection);
                return ret instanceof OffRowData ? ((OffRowData)ret).readAll() : (byte[])ret;
            }
            if (mem instanceof java.util.Date) {
                return J2DB.fromDate((java.util.Date)mem, param, connection, null);
            }
            if (mem instanceof RowId) {
                Object ret = J2DB.fromRowId((RowId)mem, param, connection);
                return ret instanceof OffRowData ? ((OffRowData)ret).readAll() : (byte[])ret;
            }
            DBError.ECJDBC_UNSUPPORTED_TYPE.throwz(new Object[0]);
            return null;
        }
        try {
            return J2DB.checkLength(param, bytes, connection.getServerEncoding());
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    public static byte[] toDate(long x2, Column column, IDmdbConnection connection) throws SQLException {
        byte[] ret = null;
        int dtype = column.type;
        if (column.mask == 1) {
            dtype = 14;
        }
        switch (dtype) {
            case 16: 
            case 26: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(x2 * 1000L - 2209017600000L, column);
                ret = dt.encode(column, connection);
                break;
            }
            case 15: {
                if (x2 < Integer.MIN_VALUE || x2 > Integer.MAX_VALUE) {
                    DBError.EC_DATETIME_OVERFLOW.throwz(new Object[0]);
                }
                DmdbTimestamp dt = DmdbTimestamp.valueOf(x2 * 1000L, column);
                ret = dt.encode(column, connection);
                break;
            }
            case 14: {
                DmdbTimestamp dt = DmdbTimestamp.valueOf(x2 * 24L * 60L * 60L * 1000L - 2209017600000L, column);
                ret = dt.encode(column, connection);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
            }
        }
        return ret;
    }

    public static byte[] toBit(long val) {
        byte[] bytes = new byte[]{(byte)(val != 0L ? 1 : 0)};
        return bytes;
    }

    public static byte[] toTinyint(long val) {
        byte[] bytes = new byte[1];
        ByteUtil.setByte(bytes, 0, (byte)val);
        return bytes;
    }

    public static byte[] toSmallint(long val) {
        byte[] bytes = new byte[2];
        ByteUtil.setShort(bytes, 0, (short)val);
        return bytes;
    }

    public static byte[] toInt(long val) {
        byte[] bytes = new byte[4];
        ByteUtil.setInt(bytes, 0, (int)val);
        return bytes;
    }

    public static byte[] toBigint(long val) {
        byte[] bytes = new byte[8];
        ByteUtil.setLong(bytes, 0, val);
        return bytes;
    }

    public static byte[] toReal(float val) {
        byte[] bytes = new byte[4];
        ByteUtil.setInt(bytes, 0, Float.floatToIntBits(val));
        return bytes;
    }

    public static byte[] toDouble(double val) {
        byte[] bytes = new byte[8];
        ByteUtil.setLong(bytes, 0, Double.doubleToLongBits(val));
        return bytes;
    }

    public static byte[] toDecimal(String val, int prec, int scale) throws SQLException {
        return DmdbNumeric.valueOf(val, prec, scale).encode();
    }

    public static byte[] toVarchar(String val, Charset serverEncoding) throws SQLException {
        byte[] bytes = ByteUtil.fromString(val, serverEncoding);
        return bytes;
    }

    private static byte[] toVarchar(byte[] bsArr) throws SQLException {
        if (bsArr == null || bsArr.length == 0) {
            return new byte[0];
        }
        int realLen = bsArr.length * 2;
        byte[] bsRet = new byte[realLen];
        int i2 = 0;
        while (i2 < bsArr.length) {
            byte[] bsTemp = J2DB.toChar(bsArr[i2]);
            bsRet[i2 * 2] = bsTemp[0];
            bsRet[i2 * 2 + 1] = bsTemp[1];
            ++i2;
        }
        return bsRet;
    }

    private static byte[] toChar(byte bt) throws SQLException {
        byte[] bytes = new byte[]{J2DB.getCharByNumVal(bt >> 4 & 0xF), J2DB.getCharByNumVal(bt & 0xF)};
        return bytes;
    }

    private static byte getCharByNumVal(int val) throws SQLException {
        if (val >= 0 && val <= 9) {
            return (byte)(val + 48);
        }
        if (val >= 10 && val <= 15) {
            return (byte)(val + 65 - 10);
        }
        DBError.ECJDBC_INVALID_HEX.throwz(new Object[0]);
        return 0;
    }

    private static byte[] toBinary(long x2, int prec) {
        byte[] b2 = new byte[8];
        int position = 7;
        b2[position--] = (byte)(x2 & 0xFFL);
        b2[position--] = (byte)(x2 >>> 8);
        b2[position--] = (byte)(x2 >>> 16);
        b2[position--] = (byte)(x2 >>> 24);
        b2[position--] = (byte)(x2 >>> 32);
        b2[position--] = (byte)(x2 >>> 40);
        b2[position--] = (byte)(x2 >>> 48);
        b2[position--] = (byte)(x2 >>> 56);
        if (prec > 0 && prec < b2.length) {
            byte[] c2 = new byte[prec];
            System.arraycopy(b2, b2.length - prec, c2, 0, prec);
            return c2;
        }
        return b2;
    }

    private static Object toBlob(Blob x2, Column param, DmdbConnection connection) throws SQLException {
        if (J2DB.isOffRow(param.type, x2.length(), connection)) {
            return new OffRowBlobData(x2, connection);
        }
        return x2.getBytes(1L, (int)x2.length());
    }

    private static Object toBlob(byte[] bytes, Column param, IDmdbConnection connection) throws SQLException {
        return J2DB.changeOffRowData(param, bytes, connection);
    }

    private static Object toClob(Clob x2, Column param, DmdbConnection connection) throws SQLException {
        if (J2DB.isOffRow(param.type, x2.length(), connection)) {
            return new OffRowClobData(x2, connection);
        }
        String str = x2.getSubString(1L, (int)x2.length());
        return ByteUtil.fromString(str, connection.getServerEncoding());
    }

    private static Object toClob(String val, Column param, IDmdbConnection connection) throws SQLException {
        return J2DB.changeOffRowData(param, ByteUtil.fromString(val, connection.getServerEncoding()), connection);
    }

    private static Object toClob(byte[] bytes, Column param, IDmdbConnection connection) throws SQLException {
        return J2DB.changeOffRowData(param, J2DB.toVarchar(bytes), connection);
    }

    private static byte[] toVarbinary(byte[] bs) throws SQLException {
        return bs;
    }

    private static byte[] toVarbinary(String str) throws SQLException {
        return StringUtil.hexStringToBytes(str);
    }

    private static boolean isOffRow(int dtype, long len, IDmdbConnection conn) {
        return (dtype == 12 || dtype == 19) && len > (long)conn.getLobOffRowLen();
    }

    private static Object changeOffRowData(Column paramDesc, byte[] paramData, IDmdbConnection conn) throws SQLException {
        Object object;
        if (J2DB.isOffRow(paramDesc.type, paramData.length, conn)) {
            OffRowBytesData offRowBytesData;
            object = offRowBytesData;
            offRowBytesData = new OffRowBytesData(paramData, conn);
        } else {
            object = paramData;
        }
        return object;
    }

    private static void checkReal(double val) throws SQLException {
        if (val < -3.4E38 || val > 3.4E38) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkBigint(double val) throws SQLException {
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkInt(double val) throws SQLException {
        if (val < -2.147483648E9 || val > 2.147483647E9) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkSmallint(double val) throws SQLException {
        if (val < -32768.0 || val > 32767.0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkTinyint(double val) throws SQLException {
        if (val < -128.0 || val > 127.0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkReal(BigDecimal val) throws SQLException {
        if (val.compareTo(MIN_REAL_VALUE) < 0 || val.compareTo(MAX_REAL_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkBigint(BigDecimal val) throws SQLException {
        if (val.compareTo(MIN_BIGINT_VALUE) < 0 || val.compareTo(MAX_BIGINT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkInt(BigDecimal val) throws SQLException {
        if (val.compareTo(MIN_INT_VALUE) < 0 || val.compareTo(MAX_INT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkSmallint(BigDecimal val) throws SQLException {
        if (val.compareTo(MIN_SMALLINT_VALUE) < 0 || val.compareTo(MAX_SMALLINT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static void checkTinyint(BigDecimal val) throws SQLException {
        if (val.compareTo(MIN_TINYINT_VALUE) < 0 || val.compareTo(MAX_TINYINT_VALUE) > 0) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
    }

    private static byte[] checkLength(Column param, byte[] dataBytes, Charset serverEncoding) throws SQLException {
        return dataBytes;
    }
}

