/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.MetaSQL;
import dm.jdbc.desc.MetaSQL2Gateway;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.filter.Filterable;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.StringUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbDatabaseMetaData
extends Filterable
implements DatabaseMetaData {
    public DmdbConnection connection = null;
    private MetaSQL sqlBuilder;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    public DmdbDatabaseMetaData(DmdbConnection connection) {
        super(connection, null);
        this.connection = connection;
        this.sqlBuilder = connection.serverSeries == Integer.MAX_VALUE ? new MetaSQL2Gateway(connection.do_getSchema(), connection.compatibleOracle()) : new MetaSQL(connection.do_getSchema(), connection.compatibleOracle());
    }

    public DmdbResultSet do_getCatalogs() throws SQLException {
        String sql = this.sqlBuilder.getCatalogs();
        return DriverUtil.executeQuery(this.connection, sql);
    }

    public DmdbResultSet do_getSchemas() throws SQLException {
        String sql = this.sqlBuilder.getSchemas();
        return DriverUtil.executeQuery(this.connection, sql);
    }

    public DmdbResultSet do_getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (StringUtil.isEmpty(catalog) && StringUtil.isEmpty(schemaPattern)) {
            return this.do_getSchemas();
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getSchemas(paramList, catalog, schemaPattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getTableTypes() throws SQLException {
        String sql = this.sqlBuilder.getTableTypes();
        return DriverUtil.executeQuery(this.connection, sql);
    }

    public DmdbResultSet do_getTypeInfo() throws SQLException {
        String sql = this.sqlBuilder.getTypeInfo();
        return DriverUtil.executeQuery(this.connection, sql);
    }

    public DmdbResultSet do_getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getAttributes(paramList, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        DmdbResultSet pk = this.do_getPrimaryKeys(catalog, schema, table);
        LinkedList<String> tabids = new LinkedList<String>();
        LinkedList<String> colids = new LinkedList<String>();
        while (pk.next()) {
            tabids.add(pk.getString("TABID"));
            colids.add(pk.getString("COLID"));
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = null;
        sql = colids.size() > 0 ? this.sqlBuilder.getBestRowIdentifier(paramList, tabids, colids, scope) : this.sqlBuilder.getBestRowIdentifier(paramList, catalog, schema, table, scope, nullable);
        return DriverUtil.executeQueryWithConst(this.connection, sql.toString(), paramList.toArray());
    }

    public DmdbResultSet do_getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getTables(paramList, catalog, schemaPattern, tableNamePattern, types);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getTablePrivileges(paramList, catalog, schemaPattern, tableNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql.toString(), paramList.toArray());
    }

    public DmdbResultSet do_getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getColumns(paramList, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getColumnPrivileges(paramList, catalog, schema, table, columnNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getVersionColumns(String catalog, String schema, String table) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getVersionColumns(paramList, catalog, schema, table);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getPrimaryKeys(paramList, catalog, schema, table);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getImportedKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getImportedKeys(paramList, catalog, schema, table);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getExportedKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getExportedKeys(paramList, catalog, schema, table);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getCrossReference(paramList, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getIndexInfo(paramList, catalog, schema, table, unique, approximate);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getUDTs(paramList, catalog, schemaPattern, typeNamePattern, types);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getSuperTypes(paramList, catalog, schemaPattern, typeNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getSuperTables(paramList, catalog, schemaPattern, tableNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(catalog)) {
            return this.do_getPkgProcedures(schemaPattern, catalog, procedureNamePattern, 0);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getProcedures(paramList, catalog, schemaPattern, procedureNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql.toString(), paramList.toArray());
    }

    public DmdbResultSet do_getPkgProcedures(String schemaPattern, String pkgPattern, String procedureNamePattern, int procType) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getPkgProcedures(paramList, schemaPattern, pkgPattern, procedureNamePattern, procType);
        return DriverUtil.executeQueryWithConst(this.connection, sql.toString(), paramList.toArray());
    }

    public DmdbResultSet do_getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getProcedureColumns(paramList, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        if (this.connection.compatibleOracle() && StringUtil.isNotEmpty(catalog)) {
            return this.do_getPkgProcedures(schemaPattern, catalog, functionNamePattern, 2);
        }
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getFunctions(paramList, catalog, schemaPattern, functionNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql.toString(), paramList.toArray());
    }

    public DmdbResultSet do_getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String sql = this.sqlBuilder.getFunctionColumns(paramList, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        return DriverUtil.executeQueryWithConst(this.connection, sql, paramList.toArray());
    }

    public DmdbResultSet do_getClientInfoProperties() throws SQLException {
        String sql = this.sqlBuilder.getClientInfoProperties();
        return DriverUtil.executeQuery(this.connection, sql);
    }

    public boolean do_allProceduresAreCallable() {
        return true;
    }

    public boolean do_allTablesAreSelectable() {
        return true;
    }

    public boolean do_autoCommitFailureClosesAllResultSets() {
        return false;
    }

    public boolean do_dataDefinitionCausesTransactionCommit() {
        return this.connection.ddlAutoCommit;
    }

    public boolean do_dataDefinitionIgnoredInTransactions() {
        return !this.connection.ddlAutoCommit;
    }

    public String do_getDatabaseProductName() {
        if (StringUtil.isNotEmpty(this.connection.databaseProductName)) {
            return this.connection.databaseProductName;
        }
        if (this.connection.compatibleOracle()) {
            return "Oracle";
        }
        return "DM DBMS";
    }

    public String do_getDatabaseProductVersion() throws SQLException {
        return this.connection.do_getClientInfo("serverVersion");
    }

    public int do_getDatabaseMajorVersion() throws SQLException {
        if (this.connection.compatibleOracle()) {
            return 11;
        }
        String[] versions = this.connection.do_getClientInfo("serverVersion").split("\\.");
        return Integer.parseInt(versions[0]);
    }

    public int do_getDatabaseMinorVersion() throws SQLException {
        if (this.connection.compatibleOracle()) {
            return 1;
        }
        String[] versions = this.connection.do_getClientInfo("serverVersion").split("\\.");
        return Integer.parseInt(versions[1]);
    }

    public String do_getDriverName() {
        return DmDriver.class.getName();
    }

    public String do_getDriverVersion() {
        return "8.1.3.12";
    }

    public int do_getDriverMajorVersion() {
        String[] versions = this.do_getDriverVersion().split("\\.");
        return Integer.valueOf(versions[0]);
    }

    public int do_getDriverMinorVersion() {
        String[] versions = this.do_getDriverVersion().split("\\.");
        return Integer.valueOf(versions[1]);
    }

    public int do_getJDBCMajorVersion() {
        String[] versions = "4.0".split("\\.");
        return Integer.valueOf(versions[0]);
    }

    public int do_getJDBCMinorVersion() {
        String[] versions = "4.0".split("\\.");
        return Integer.valueOf(versions[1]);
    }

    public String do_getURL() {
        return this.connection.url;
    }

    public String do_getUserName() {
        return this.connection.user;
    }

    public DmdbConnection do_getConnection() {
        return this.connection;
    }

    public int do_getResultSetHoldability() {
        return 1;
    }

    public int do_getSQLStateType() {
        return 1;
    }

    public String do_getIdentifierQuoteString() {
        return "\"";
    }

    public String do_getSQLKeywords() {
        StringBuffer sql = new StringBuffer("");
        sql.append("BREAK,BROWSE,BULK,CHECKPOINT,CLUSTERED,COMMITTED,COMPUTE,");
        sql.append(" CONFIRM,CONTROLROW,DATABASE,DBCC,DISK,DISTRIBUTED,DUMMY,");
        sql.append(" DUMP,ERRLVL,ERROREXIT,EXIT,FILE,FILLFACTOR,FLOPPY,HOLDLOCK,");
        sql.append(" IDENTITY_INSERT,IDENTITYCOL,IF,KILL,LINENO,LOAD,MIRROREXIT,");
        sql.append("NONCLUSTERED,OFF,OFFSETS,ONCE,OVER,PERCENT,PERM,PERMANENT,PLAN, PRINT,");
        sql.append("AFTER,ASSIGN,AUDIT,BEFORE,BITMAP,CACHE,CALL,CHAIN,CLUSTER,CYCLE,");
        sql.append(" DATABASE, DATAFILE, DEBUG, #DECODE, #DELETING, DISABLE,");
        sql.append(" EACH,ELSEIF,END,EXCLUSIVE, EXIT,FILLFACTOR, FUNCTION,");
        sql.append(" HEXTORAW,IDENTIFIED,IF, IFNULL,INCREASE, INDEX, ");
        sql.append(" INITIAL,INTENTION,ISNULL,ISOPEN,MAXVALUE,");
        sql.append(" MINVALUE,MODIFY,NATURAL,NEW, NEXT, NOAUDIT, NOCACHE,NOCYCLE,");
        sql.append(" NOTFOUND,  NVL, OFF, OLD, OUT,PENDANT, PERCENT, PRINT, PRIOR,");
        sql.append("RAISE,RAWTOHEX,READ,RENAME,RETURN,REVERSE,ROLE,ROWCOUNT,ROWNUM,SAVEPOINT,SERIALIZABLE,");
        sql.append(" SEQUENCE, SHARE, STATEMENT,TIES, TIMESTAMPADD, TIMESTAMPDIFF,");
        sql.append("TOP,TRIGGER,TRIGGERS,TRUNCATE,TYPECAST,UNCOMMITTED,UNTIL,VSIZE,WHILE,LOGIN,");
        sql.append("EXTERNALLY,SESSION_PER_USER,CONNECT_IDLE_TIME,FAILED_LOGIN_ATTEMPS,");
        sql.append("PASSWORD_LIFE_TIME,PASSWORD_REUSE_TIME,PASSWORD_REUSE_MAX,");
        sql.append("PASSWORD_LOCK_TIME,PASSWORD_GRACE_TIME,POLICY,CATEGORY,UNLIMITED");
        return sql.toString();
    }

    public String do_getNumericFunctions() {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MOD,PI,POWER,RADIANS,RAND,ROUND,SIGN,SIN,SQRT,TAN,TRUNCATE,CEIL,COSH,LN,SINH,TANH";
    }

    public String do_getStringFunctions() {
        return "ASCII,CHAR,CONCAT,DIFFERENCE,INSERT,LCASE,LEFT,LENGTH,LOCATE,LTRIM,REPEAT,REPLACE,RIGHT,RTRIM,SOUNDEX,SPACE,UCASE,BIT_LENGTH,CHAR_LENGTH,CHARACTER_LENGTH,CHR,INITCAP,INSSTR,INSTR,INSTRB,LEFTSTR,LENGTHB,OCTET_LENGTH,LOWER,LPAD,POSITION,REPEATSTR,REVERSE,RIGHTSTR,RPAD,SUBSTR,SUBSTRB,TO_CHAR,TRANSLATE,TRIM,UPPER";
    }

    public String do_getSystemFunctions() {
        return "IFNULL,USER,CUR_DATABASE,DBID,EXTENT,PAGE,SESSID,UID,TABLEDEF,VSIZE,SET_TABLE_OPTION,SET_INDEX_OPTION,CFALGORITHMSENCRYPT,CFALGORITHMSDECRYPT,BFALGORITHMSENCRYPT,BFALGORITHMSDECRYPT,LABEL_TO_CHAR,LABEL_FROM_CHAR,LABEL_CMP,LABEL_STR_CMP";
    }

    public String do_getTimeDateFunctions() {
        return "CURDATE,CURTIME,DAYNAME,DAYOFMONTH,DAYOFWEEK,DAYOFYEAR,HOUR,MINUTE,MONTH,MONTHNAME,NOW,QUARTER,SECOND,TIMESTAMPADD,TIMESTAMPDIFF,WEEK,YEAR,ADD_DAYS,ADD_MONTHS,ADD_WEEKS,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,DATEADD,DATEDIFF,DATEPART,DAYS_BETWEEN,EXTRACT,GETDATE,LAST_DAY,MONTHS_BETWEEN,NEXT_DAY,ROUND,SYSDATE,TO_DATE,TRUNC,WEEKDAY,YEARS_BETWEEN";
    }

    public String do_getSearchStringEscape() {
        return "!";
    }

    public String do_getExtraNameCharacters() {
        return "";
    }

    public int do_getMaxBinaryLiteralLength() {
        return Integer.MAX_VALUE;
    }

    public int do_getMaxCharLiteralLength() {
        return this.connection.maxRowSize;
    }

    public int do_getMaxColumnNameLength() {
        return 128;
    }

    public int do_getMaxColumnsInGroupBy() {
        return 64;
    }

    public int do_getMaxColumnsInIndex() {
        return 16;
    }

    public int do_getMaxColumnsInOrderBy() {
        return 64;
    }

    public int do_getMaxColumnsInSelect() {
        return 1024;
    }

    public int do_getMaxColumnsInTable() {
        return 1024;
    }

    public int do_getMaxConnections() {
        return this.connection.maxSession;
    }

    public int do_getMaxCursorNameLength() {
        return 128;
    }

    public int do_getMaxIndexLength() {
        return 1020;
    }

    public int do_getMaxSchemaNameLength() {
        return 128;
    }

    public int do_getMaxProcedureNameLength() {
        return 128;
    }

    public int do_getMaxCatalogNameLength() {
        return 0;
    }

    public int do_getMaxRowSize() {
        return 0;
    }

    public int do_getMaxStatementLength() {
        return 8000;
    }

    public int do_getMaxStatements() {
        return 128;
    }

    public int do_getMaxTableNameLength() {
        return 128;
    }

    public int do_getMaxTablesInSelect() {
        return 50;
    }

    public int do_getMaxUserNameLength() {
        return 128;
    }

    public int do_getDefaultTransactionIsolation() {
        return 2;
    }

    public String do_getSchemaTerm() {
        return "SCHEMA";
    }

    public String do_getProcedureTerm() {
        return "PROCEDURE";
    }

    public String do_getCatalogTerm() {
        return "CATALOG";
    }

    public String do_getCatalogSeparator() {
        return "";
    }

    public boolean do_isCatalogAtStart() {
        return false;
    }

    public boolean do_isReadOnly() {
        return this.connection.readOnly;
    }

    public boolean do_locatorsUpdateCopy() {
        return false;
    }

    public boolean do_nullsAreSortedHigh() {
        return false;
    }

    public boolean do_nullsAreSortedLow() {
        return true;
    }

    public boolean do_nullsAreSortedAtStart() {
        return false;
    }

    public boolean do_nullsAreSortedAtEnd() {
        return false;
    }

    public boolean do_nullPlusNonNullIsNull() {
        return true;
    }

    public boolean do_usesLocalFiles() {
        return false;
    }

    public boolean do_usesLocalFilePerTable() {
        return false;
    }

    public boolean do_storesUpperCaseIdentifiers() {
        return true;
    }

    public boolean do_storesLowerCaseIdentifiers() {
        return false;
    }

    public boolean do_storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean do_storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean do_storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean do_storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean do_supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean do_supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean do_supportsColumnAliasing() {
        return true;
    }

    public boolean do_supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean do_supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean do_supportsConvert() {
        return true;
    }

    public boolean do_supportsConvert(int fromType, int toType) {
        boolean supportsconvert = false;
        if (toType == 3 || toType == 2 || toType == -6 || toType == 4 || toType == 6 || toType == 8 || toType == 7 || toType == 5 || toType == -5 || toType == 1 || toType == 12 || toType == -7 || toType == 16 || toType == -1) {
            switch (fromType) {
                case -7: 
                case -6: 
                case -5: 
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 12: 
                case 16: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 91) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 92) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 92: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 93) {
            switch (fromType) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 91: 
                case 92: 
                case 93: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 2004) {
            switch (fromType) {
                case -4: 
                case 2004: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        if (toType == 2005) {
            switch (fromType) {
                case -1: 
                case 2005: {
                    supportsconvert = true;
                    break;
                }
            }
            return supportsconvert;
        }
        return supportsconvert;
    }

    public boolean do_supportsTableCorrelationNames() {
        return true;
    }

    public boolean do_supportsDifferentTableCorrelationNames() {
        return true;
    }

    public boolean do_supportsExpressionsInOrderBy() {
        return true;
    }

    public boolean do_supportsOrderByUnrelated() {
        return true;
    }

    public boolean do_supportsGroupBy() {
        return true;
    }

    public boolean do_supportsGroupByUnrelated() {
        return true;
    }

    public boolean do_supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean do_supportsLikeEscapeClause() {
        return true;
    }

    public boolean do_supportsMultipleResultSets() {
        return true;
    }

    public boolean do_supportsMultipleTransactions() {
        return true;
    }

    public boolean do_supportsNonNullableColumns() {
        return true;
    }

    public boolean do_supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean do_supportsCoreSQLGrammar() {
        return true;
    }

    public boolean do_supportsExtendedSQLGrammar() {
        return true;
    }

    public boolean do_supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean do_supportsANSI92IntermediateSQL() {
        return true;
    }

    public boolean do_supportsANSI92FullSQL() {
        return false;
    }

    public boolean do_supportsIntegrityEnhancementFacility() {
        return true;
    }

    public boolean do_supportsOuterJoins() {
        return true;
    }

    public boolean do_supportsFullOuterJoins() {
        return true;
    }

    public boolean do_supportsLimitedOuterJoins() {
        return true;
    }

    public boolean do_supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean do_supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean do_supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean do_supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean do_supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean do_supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean do_supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean do_supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean do_supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean do_supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean do_supportsPositionedDelete() {
        return true;
    }

    public boolean do_supportsPositionedUpdate() {
        return true;
    }

    public boolean do_supportsSelectForUpdate() {
        return true;
    }

    public boolean do_supportsStoredProcedures() {
        return true;
    }

    public boolean do_supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean do_supportsSubqueriesInExists() {
        return true;
    }

    public boolean do_supportsSubqueriesInIns() {
        return true;
    }

    public boolean do_supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean do_supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean do_supportsUnion() {
        return true;
    }

    public boolean do_supportsUnionAll() {
        return true;
    }

    public boolean do_supportsOpenCursorsAcrossCommit() {
        return true;
    }

    public boolean do_supportsOpenCursorsAcrossRollback() {
        return true;
    }

    public boolean do_supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean do_supportsOpenStatementsAcrossRollback() {
        return true;
    }

    public boolean do_supportsTransactions() {
        return true;
    }

    public boolean do_supportsTransactionIsolationLevel(int level) {
        return level == 2 || level == 1 || level == 4 || level == 8;
    }

    public boolean do_supportsDataDefinitionAndDataManipulationTransactions() {
        return !this.connection.ddlAutoCommit;
    }

    public boolean do_supportsDataManipulationTransactionsOnly() {
        return this.connection.ddlAutoCommit;
    }

    public boolean do_supportsResultSetType(int type) {
        return type == 1003 || type == 1004;
    }

    public boolean do_supportsResultSetConcurrency(int type, int concurrency) {
        return true;
    }

    public boolean do_supportsBatchUpdates() {
        return true;
    }

    public boolean do_supportsSavepoints() {
        return true;
    }

    public boolean do_supportsNamedParameters() {
        return true;
    }

    public boolean do_supportsMultipleOpenResults() {
        return false;
    }

    public boolean do_supportsGetGeneratedKeys() {
        return true;
    }

    public boolean do_supportsResultSetHoldability(int holdability) {
        return holdability == 2 || holdability == 1;
    }

    public boolean do_supportsStatementPooling() {
        return true;
    }

    public boolean do_supportsStoredFunctionsUsingCallSyntax() {
        return true;
    }

    public boolean do_ownUpdatesAreVisible(int type) {
        return false;
    }

    public boolean do_ownDeletesAreVisible(int type) {
        return false;
    }

    public boolean do_ownInsertsAreVisible(int type) {
        return false;
    }

    public boolean do_othersUpdatesAreVisible(int type) {
        return false;
    }

    public boolean do_othersDeletesAreVisible(int type) {
        return false;
    }

    public boolean do_othersInsertsAreVisible(int type) {
        return false;
    }

    public boolean do_updatesAreDetected(int type) {
        return false;
    }

    public boolean do_deletesAreDetected(int type) {
        return false;
    }

    public boolean do_insertsAreDetected(int type) {
        return false;
    }

    public boolean do_doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    public DmdbResultSet do_getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    public boolean do_generatedKeyAlwaysReturned() {
        return false;
    }

    public long do_getMaxLogicalLobSize() {
        return Integer.MAX_VALUE;
    }

    public boolean do_supportsRefCursors() {
        return true;
    }

    public RowIdLifetime do_getRowIdLifetime() {
        return RowIdLifetime.ROWID_VALID_FOREVER;
    }

    @Override
    @Deprecated
    public boolean allProceduresAreCallable() throws SQLException {
        if (this.filterChain == null) {
            return this.do_allProceduresAreCallable();
        }
        return this.filterChain.reset().DatabaseMetaData_allProceduresAreCallable(this);
    }

    @Override
    @Deprecated
    public boolean allTablesAreSelectable() throws SQLException {
        if (this.filterChain == null) {
            return this.do_allTablesAreSelectable();
        }
        return this.filterChain.reset().DatabaseMetaData_allTablesAreSelectable(this);
    }

    @Override
    @Deprecated
    public String getURL() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getURL();
        }
        return this.filterChain.reset().DatabaseMetaData_getURL(this);
    }

    @Override
    @Deprecated
    public String getUserName() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getUserName();
        }
        return this.filterChain.reset().DatabaseMetaData_getUserName(this);
    }

    @Override
    @Deprecated
    public boolean isReadOnly() throws SQLException {
        if (this.filterChain == null) {
            return this.do_isReadOnly();
        }
        return this.filterChain.reset().DatabaseMetaData_isReadOnly(this);
    }

    @Override
    @Deprecated
    public boolean nullsAreSortedHigh() throws SQLException {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedHigh();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedHigh(this);
    }

    @Override
    @Deprecated
    public boolean nullsAreSortedLow() throws SQLException {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedLow();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedLow(this);
    }

    @Override
    @Deprecated
    public boolean nullsAreSortedAtStart() throws SQLException {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedAtStart();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedAtStart(this);
    }

    @Override
    @Deprecated
    public boolean nullsAreSortedAtEnd() throws SQLException {
        if (this.filterChain == null) {
            return this.do_nullsAreSortedAtEnd();
        }
        return this.filterChain.reset().DatabaseMetaData_nullsAreSortedAtEnd(this);
    }

    @Override
    @Deprecated
    public String getDatabaseProductName() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDatabaseProductName();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseProductName(this);
    }

    @Override
    @Deprecated
    public String getDatabaseProductVersion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDatabaseProductVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseProductVersion(this);
    }

    @Override
    @Deprecated
    public String getDriverName() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDriverName();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverName(this);
    }

    @Override
    @Deprecated
    public String getDriverVersion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDriverVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverVersion(this);
    }

    @Override
    @Deprecated
    public int getDriverMajorVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverMajorVersion(this);
    }

    @Override
    @Deprecated
    public int getDriverMinorVersion() {
        if (this.filterChain == null) {
            return this.do_getDriverMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDriverMinorVersion(this);
    }

    @Override
    @Deprecated
    public boolean usesLocalFiles() throws SQLException {
        if (this.filterChain == null) {
            return this.do_usesLocalFiles();
        }
        return this.filterChain.reset().DatabaseMetaData_usesLocalFiles(this);
    }

    @Override
    @Deprecated
    public boolean usesLocalFilePerTable() throws SQLException {
        if (this.filterChain == null) {
            return this.do_usesLocalFilePerTable();
        }
        return this.filterChain.reset().DatabaseMetaData_usesLocalFilePerTable(this);
    }

    @Override
    @Deprecated
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsMixedCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMixedCaseIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_storesUpperCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesUpperCaseIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_storesLowerCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesLowerCaseIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_storesMixedCaseIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesMixedCaseIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsMixedCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMixedCaseQuotedIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_storesUpperCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesUpperCaseQuotedIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_storesLowerCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesLowerCaseQuotedIdentifiers(this);
    }

    @Override
    @Deprecated
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.filterChain == null) {
            return this.do_storesMixedCaseQuotedIdentifiers();
        }
        return this.filterChain.reset().DatabaseMetaData_storesMixedCaseQuotedIdentifiers(this);
    }

    @Override
    @Deprecated
    public String getIdentifierQuoteString() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getIdentifierQuoteString();
        }
        return this.filterChain.reset().DatabaseMetaData_getIdentifierQuoteString(this);
    }

    @Override
    @Deprecated
    public String getSQLKeywords() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSQLKeywords();
        }
        return this.filterChain.reset().DatabaseMetaData_getSQLKeywords(this);
    }

    @Override
    @Deprecated
    public String getNumericFunctions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getNumericFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getNumericFunctions(this);
    }

    @Override
    @Deprecated
    public String getStringFunctions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getStringFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getStringFunctions(this);
    }

    @Override
    @Deprecated
    public String getSystemFunctions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSystemFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getSystemFunctions(this);
    }

    @Override
    @Deprecated
    public String getTimeDateFunctions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getTimeDateFunctions();
        }
        return this.filterChain.reset().DatabaseMetaData_getTimeDateFunctions(this);
    }

    @Override
    @Deprecated
    public String getSearchStringEscape() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSearchStringEscape();
        }
        return this.filterChain.reset().DatabaseMetaData_getSearchStringEscape(this);
    }

    @Override
    @Deprecated
    public String getExtraNameCharacters() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getExtraNameCharacters();
        }
        return this.filterChain.reset().DatabaseMetaData_getExtraNameCharacters(this);
    }

    @Override
    @Deprecated
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsAlterTableWithAddColumn();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsAlterTableWithAddColumn(this);
    }

    @Override
    @Deprecated
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsAlterTableWithDropColumn();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsAlterTableWithDropColumn(this);
    }

    @Override
    @Deprecated
    public boolean supportsColumnAliasing() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsColumnAliasing();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsColumnAliasing(this);
    }

    @Override
    @Deprecated
    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (this.filterChain == null) {
            return this.do_nullPlusNonNullIsNull();
        }
        return this.filterChain.reset().DatabaseMetaData_nullPlusNonNullIsNull(this);
    }

    @Override
    @Deprecated
    public boolean supportsConvert() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsConvert();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsConvert(this);
    }

    @Override
    @Deprecated
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsConvert(fromType, toType);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsConvert(this, fromType, toType);
    }

    @Override
    @Deprecated
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsTableCorrelationNames();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTableCorrelationNames(this);
    }

    @Override
    @Deprecated
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsDifferentTableCorrelationNames();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDifferentTableCorrelationNames(this);
    }

    @Override
    @Deprecated
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsExpressionsInOrderBy();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsExpressionsInOrderBy(this);
    }

    @Override
    @Deprecated
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsOrderByUnrelated();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOrderByUnrelated(this);
    }

    @Override
    @Deprecated
    public boolean supportsGroupBy() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsGroupBy();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupBy(this);
    }

    @Override
    @Deprecated
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsGroupByUnrelated();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupByUnrelated(this);
    }

    @Override
    @Deprecated
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsGroupByBeyondSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGroupByBeyondSelect(this);
    }

    @Override
    @Deprecated
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsLikeEscapeClause();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsLikeEscapeClause(this);
    }

    @Override
    @Deprecated
    public boolean supportsMultipleResultSets() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsMultipleResultSets();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleResultSets(this);
    }

    @Override
    @Deprecated
    public boolean supportsMultipleTransactions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsMultipleTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleTransactions(this);
    }

    @Override
    @Deprecated
    public boolean supportsNonNullableColumns() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsNonNullableColumns();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsNonNullableColumns(this);
    }

    @Override
    @Deprecated
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsMinimumSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMinimumSQLGrammar(this);
    }

    @Override
    @Deprecated
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCoreSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCoreSQLGrammar(this);
    }

    @Override
    @Deprecated
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsExtendedSQLGrammar();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsExtendedSQLGrammar(this);
    }

    @Override
    @Deprecated
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsANSI92EntryLevelSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92EntryLevelSQL(this);
    }

    @Override
    @Deprecated
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsANSI92IntermediateSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92IntermediateSQL(this);
    }

    @Override
    @Deprecated
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsANSI92FullSQL();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsANSI92FullSQL(this);
    }

    @Override
    @Deprecated
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsIntegrityEnhancementFacility();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsIntegrityEnhancementFacility(this);
    }

    @Override
    @Deprecated
    public boolean supportsOuterJoins() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOuterJoins(this);
    }

    @Override
    @Deprecated
    public boolean supportsFullOuterJoins() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsFullOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsFullOuterJoins(this);
    }

    @Override
    @Deprecated
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsLimitedOuterJoins();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsLimitedOuterJoins(this);
    }

    @Override
    @Deprecated
    public String getSchemaTerm() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSchemaTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getSchemaTerm(this);
    }

    @Override
    @Deprecated
    public String getProcedureTerm() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getProcedureTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getProcedureTerm(this);
    }

    @Override
    @Deprecated
    public String getCatalogTerm() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getCatalogTerm();
        }
        return this.filterChain.reset().DatabaseMetaData_getCatalogTerm(this);
    }

    @Override
    @Deprecated
    public boolean isCatalogAtStart() throws SQLException {
        if (this.filterChain == null) {
            return this.do_isCatalogAtStart();
        }
        return this.filterChain.reset().DatabaseMetaData_isCatalogAtStart(this);
    }

    @Override
    @Deprecated
    public String getCatalogSeparator() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getCatalogSeparator();
        }
        return this.filterChain.reset().DatabaseMetaData_getCatalogSeparator(this);
    }

    @Override
    @Deprecated
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInDataManipulation();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInDataManipulation(this);
    }

    @Override
    @Deprecated
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInProcedureCalls();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInProcedureCalls(this);
    }

    @Override
    @Deprecated
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInTableDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInTableDefinitions(this);
    }

    @Override
    @Deprecated
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInIndexDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInIndexDefinitions(this);
    }

    @Override
    @Deprecated
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSchemasInPrivilegeDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSchemasInPrivilegeDefinitions(this);
    }

    @Override
    @Deprecated
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInDataManipulation();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInDataManipulation(this);
    }

    @Override
    @Deprecated
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInProcedureCalls();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInProcedureCalls(this);
    }

    @Override
    @Deprecated
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInTableDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInTableDefinitions(this);
    }

    @Override
    @Deprecated
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInIndexDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInIndexDefinitions(this);
    }

    @Override
    @Deprecated
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCatalogsInPrivilegeDefinitions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCatalogsInPrivilegeDefinitions(this);
    }

    @Override
    @Deprecated
    public boolean supportsPositionedDelete() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsPositionedDelete();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsPositionedDelete(this);
    }

    @Override
    @Deprecated
    public boolean supportsPositionedUpdate() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsPositionedUpdate();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsPositionedUpdate(this);
    }

    @Override
    @Deprecated
    public boolean supportsSelectForUpdate() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSelectForUpdate();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSelectForUpdate(this);
    }

    @Override
    @Deprecated
    public boolean supportsStoredProcedures() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsStoredProcedures();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStoredProcedures(this);
    }

    @Override
    @Deprecated
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInComparisons();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInComparisons(this);
    }

    @Override
    @Deprecated
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInExists();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInExists(this);
    }

    @Override
    @Deprecated
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInIns();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInIns(this);
    }

    @Override
    @Deprecated
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSubqueriesInQuantifieds();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSubqueriesInQuantifieds(this);
    }

    @Override
    @Deprecated
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsCorrelatedSubqueries();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsCorrelatedSubqueries(this);
    }

    @Override
    @Deprecated
    public boolean supportsUnion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsUnion();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsUnion(this);
    }

    @Override
    @Deprecated
    public boolean supportsUnionAll() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsUnionAll();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsUnionAll(this);
    }

    @Override
    @Deprecated
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsOpenCursorsAcrossCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenCursorsAcrossCommit(this);
    }

    @Override
    @Deprecated
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsOpenCursorsAcrossRollback();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenCursorsAcrossRollback(this);
    }

    @Override
    @Deprecated
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsOpenStatementsAcrossCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenStatementsAcrossCommit(this);
    }

    @Override
    @Deprecated
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsOpenStatementsAcrossRollback();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsOpenStatementsAcrossRollback(this);
    }

    @Override
    @Deprecated
    public int getMaxBinaryLiteralLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxBinaryLiteralLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxBinaryLiteralLength(this);
    }

    @Override
    @Deprecated
    public int getMaxCharLiteralLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxCharLiteralLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCharLiteralLength(this);
    }

    @Override
    @Deprecated
    public int getMaxColumnNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxColumnNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnNameLength(this);
    }

    @Override
    @Deprecated
    public int getMaxColumnsInGroupBy() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInGroupBy();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInGroupBy(this);
    }

    @Override
    @Deprecated
    public int getMaxColumnsInIndex() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInIndex();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInIndex(this);
    }

    @Override
    @Deprecated
    public int getMaxColumnsInOrderBy() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInOrderBy();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInOrderBy(this);
    }

    @Override
    @Deprecated
    public int getMaxColumnsInSelect() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInSelect(this);
    }

    @Override
    @Deprecated
    public int getMaxColumnsInTable() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxColumnsInTable();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxColumnsInTable(this);
    }

    @Override
    @Deprecated
    public int getMaxConnections() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxConnections();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxConnections(this);
    }

    @Override
    @Deprecated
    public int getMaxCursorNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxCursorNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCursorNameLength(this);
    }

    @Override
    @Deprecated
    public int getMaxIndexLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxIndexLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxIndexLength(this);
    }

    @Override
    @Deprecated
    public int getMaxSchemaNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxSchemaNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxSchemaNameLength(this);
    }

    @Override
    @Deprecated
    public int getMaxProcedureNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxProcedureNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxProcedureNameLength(this);
    }

    @Override
    @Deprecated
    public int getMaxCatalogNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxCatalogNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxCatalogNameLength(this);
    }

    @Override
    @Deprecated
    public int getMaxRowSize() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxRowSize();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxRowSize(this);
    }

    @Override
    @Deprecated
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (this.filterChain == null) {
            return this.do_doesMaxRowSizeIncludeBlobs();
        }
        return this.filterChain.reset().DatabaseMetaData_doesMaxRowSizeIncludeBlobs(this);
    }

    @Override
    @Deprecated
    public int getMaxStatementLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxStatementLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxStatementLength(this);
    }

    @Override
    @Deprecated
    public int getMaxStatements() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxStatements();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxStatements(this);
    }

    @Override
    @Deprecated
    public int getMaxTableNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxTableNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxTableNameLength(this);
    }

    @Override
    @Deprecated
    public int getMaxTablesInSelect() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxTablesInSelect();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxTablesInSelect(this);
    }

    @Override
    @Deprecated
    public int getMaxUserNameLength() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxUserNameLength();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxUserNameLength(this);
    }

    @Override
    @Deprecated
    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDefaultTransactionIsolation();
        }
        return this.filterChain.reset().DatabaseMetaData_getDefaultTransactionIsolation(this);
    }

    @Override
    @Deprecated
    public boolean supportsTransactions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTransactions(this);
    }

    @Override
    @Deprecated
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsTransactionIsolationLevel(level);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsTransactionIsolationLevel(this, level);
    }

    @Override
    @Deprecated
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsDataDefinitionAndDataManipulationTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDataDefinitionAndDataManipulationTransactions(this);
    }

    @Override
    @Deprecated
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsDataManipulationTransactionsOnly();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsDataManipulationTransactionsOnly(this);
    }

    @Override
    @Deprecated
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        if (this.filterChain == null) {
            return this.do_dataDefinitionCausesTransactionCommit();
        }
        return this.filterChain.reset().DatabaseMetaData_dataDefinitionCausesTransactionCommit(this);
    }

    @Override
    @Deprecated
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        if (this.filterChain == null) {
            return this.do_dataDefinitionIgnoredInTransactions();
        }
        return this.filterChain.reset().DatabaseMetaData_dataDefinitionIgnoredInTransactions(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getProcedures(catalog, schemaPattern, procedureNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getProcedures(this, catalog, schemaPattern, procedureNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getProcedureColumns(this, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTables(catalog, schemaPattern, tableNamePattern, types);
            }
            return this.filterChain.reset().DatabaseMetaData_getTables(this, catalog, schemaPattern, tableNamePattern, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getSchemas() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchemas();
            }
            return this.filterChain.reset().DatabaseMetaData_getSchemas(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getCatalogs() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCatalogs();
            }
            return this.filterChain.reset().DatabaseMetaData_getCatalogs(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getTableTypes() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTableTypes();
            }
            return this.filterChain.reset().DatabaseMetaData_getTableTypes(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getColumns(this, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getColumnPrivileges(catalog, schema, table, columnNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getColumnPrivileges(this, catalog, schema, table, columnNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTablePrivileges(catalog, schemaPattern, tableNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getTablePrivileges(this, catalog, schemaPattern, tableNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            DmdbConnection dmdbConnection2 = this.connection;
            synchronized (dmdbConnection2) {
                if (this.filterChain == null) {
                    return this.do_getBestRowIdentifier(catalog, schema, table, scope, nullable);
                }
                return this.filterChain.reset().DatabaseMetaData_getBestRowIdentifier(this, catalog, schema, table, scope, nullable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getVersionColumns(catalog, schema, table);
            }
            return this.filterChain.reset().DatabaseMetaData_getVersionColumns(this, catalog, schema, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getPrimaryKeys(catalog, schema, table);
            }
            return this.filterChain.reset().DatabaseMetaData_getPrimaryKeys(this, catalog, schema, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getImportedKeys(catalog, schema, table);
            }
            return this.filterChain.reset().DatabaseMetaData_getImportedKeys(this, catalog, schema, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getExportedKeys(catalog, schema, table);
            }
            return this.filterChain.reset().DatabaseMetaData_getExportedKeys(this, catalog, schema, table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
            }
            return this.filterChain.reset().DatabaseMetaData_getCrossReference(this, parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getTypeInfo() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getTypeInfo();
            }
            return this.filterChain.reset().DatabaseMetaData_getTypeInfo(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getIndexInfo(catalog, schema, table, unique, approximate);
            }
            return this.filterChain.reset().DatabaseMetaData_getIndexInfo(this, catalog, schema, table, unique, approximate);
        }
    }

    @Override
    @Deprecated
    public boolean supportsResultSetType(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsResultSetType(type);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetType(this, type);
    }

    @Override
    @Deprecated
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsResultSetConcurrency(type, concurrency);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetConcurrency(this, type, concurrency);
    }

    @Override
    @Deprecated
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_ownUpdatesAreVisible(type);
        }
        return this.filterChain.reset().DatabaseMetaData_ownUpdatesAreVisible(this, type);
    }

    @Override
    @Deprecated
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_ownDeletesAreVisible(type);
        }
        return this.filterChain.reset().DatabaseMetaData_ownDeletesAreVisible(this, type);
    }

    @Override
    @Deprecated
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_ownInsertsAreVisible(type);
        }
        return this.filterChain.reset().DatabaseMetaData_ownInsertsAreVisible(this, type);
    }

    @Override
    @Deprecated
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_othersUpdatesAreVisible(type);
        }
        return this.filterChain.reset().DatabaseMetaData_othersUpdatesAreVisible(this, type);
    }

    @Override
    @Deprecated
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_othersDeletesAreVisible(type);
        }
        return this.filterChain.reset().DatabaseMetaData_othersDeletesAreVisible(this, type);
    }

    @Override
    @Deprecated
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_othersInsertsAreVisible(type);
        }
        return this.filterChain.reset().DatabaseMetaData_othersInsertsAreVisible(this, type);
    }

    @Override
    @Deprecated
    public boolean updatesAreDetected(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_updatesAreDetected(type);
        }
        return this.filterChain.reset().DatabaseMetaData_updatesAreDetected(this, type);
    }

    @Override
    @Deprecated
    public boolean deletesAreDetected(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_deletesAreDetected(type);
        }
        return this.filterChain.reset().DatabaseMetaData_deletesAreDetected(this, type);
    }

    @Override
    @Deprecated
    public boolean insertsAreDetected(int type) throws SQLException {
        if (this.filterChain == null) {
            return this.do_insertsAreDetected(type);
        }
        return this.filterChain.reset().DatabaseMetaData_insertsAreDetected(this, type);
    }

    @Override
    @Deprecated
    public boolean supportsBatchUpdates() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsBatchUpdates();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsBatchUpdates(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getUDTs(catalog, schemaPattern, typeNamePattern, types);
            }
            return this.filterChain.reset().DatabaseMetaData_getUDTs(this, catalog, schemaPattern, typeNamePattern, types);
        }
    }

    @Override
    @Deprecated
    public Connection getConnection() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getConnection();
        }
        return this.filterChain.reset().DatabaseMetaData_getConnection(this);
    }

    @Override
    @Deprecated
    public boolean supportsSavepoints() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsSavepoints();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsSavepoints(this);
    }

    @Override
    @Deprecated
    public boolean supportsNamedParameters() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsNamedParameters();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsNamedParameters(this);
    }

    @Override
    @Deprecated
    public boolean supportsMultipleOpenResults() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsMultipleOpenResults();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsMultipleOpenResults(this);
    }

    @Override
    @Deprecated
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsGetGeneratedKeys();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsGetGeneratedKeys(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSuperTypes(catalog, schemaPattern, typeNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getSuperTypes(this, catalog, schemaPattern, typeNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSuperTables(catalog, schemaPattern, tableNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getSuperTables(this, catalog, schemaPattern, tableNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getAttributes(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getAttributes(this, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        }
    }

    @Override
    @Deprecated
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsResultSetHoldability(holdability);
        }
        return this.filterChain.reset().DatabaseMetaData_supportsResultSetHoldability(this, holdability);
    }

    @Override
    @Deprecated
    public int getResultSetHoldability() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getResultSetHoldability();
        }
        return this.filterChain.reset().DatabaseMetaData_getResultSetHoldability(this);
    }

    @Override
    @Deprecated
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDatabaseMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseMajorVersion(this);
    }

    @Override
    @Deprecated
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getDatabaseMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getDatabaseMinorVersion(this);
    }

    @Override
    @Deprecated
    public int getJDBCMajorVersion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getJDBCMajorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getJDBCMajorVersion(this);
    }

    @Override
    @Deprecated
    public int getJDBCMinorVersion() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getJDBCMinorVersion();
        }
        return this.filterChain.reset().DatabaseMetaData_getJDBCMinorVersion(this);
    }

    @Override
    @Deprecated
    public int getSQLStateType() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getSQLStateType();
        }
        return this.filterChain.reset().DatabaseMetaData_getSQLStateType(this);
    }

    @Override
    @Deprecated
    public boolean locatorsUpdateCopy() throws SQLException {
        if (this.filterChain == null) {
            return this.do_locatorsUpdateCopy();
        }
        return this.filterChain.reset().DatabaseMetaData_locatorsUpdateCopy(this);
    }

    @Override
    @Deprecated
    public boolean supportsStatementPooling() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsStatementPooling();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStatementPooling(this);
    }

    @Override
    @Deprecated
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getRowIdLifetime();
        }
        return this.filterChain.reset().DatabaseMetaData_getRowIdLifetime(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getSchemas(catalog, schemaPattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getSchemas(this, catalog, schemaPattern);
        }
    }

    @Override
    @Deprecated
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsStoredFunctionsUsingCallSyntax();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsStoredFunctionsUsingCallSyntax(this);
    }

    @Override
    @Deprecated
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (this.filterChain == null) {
            return this.do_autoCommitFailureClosesAllResultSets();
        }
        return this.filterChain.reset().DatabaseMetaData_autoCommitFailureClosesAllResultSets(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getClientInfoProperties() throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getClientInfoProperties();
            }
            return this.filterChain.reset().DatabaseMetaData_getClientInfoProperties(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFunctions(catalog, schemaPattern, functionNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getFunctions(this, catalog, schemaPattern, functionNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getFunctionColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getFunctionColumns(this, catalog, schemaPattern, functionNamePattern, columnNamePattern);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getPseudoColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            return this.filterChain.reset().DatabaseMetaData_getPseudoColumns(this, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
    }

    @Override
    @Deprecated
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        if (this.filterChain == null) {
            return this.do_generatedKeyAlwaysReturned();
        }
        return this.filterChain.reset().DatabaseMetaData_generatedKeyAlwaysReturned(this);
    }

    @Override
    @Deprecated
    public long getMaxLogicalLobSize() throws SQLException {
        if (this.filterChain == null) {
            return this.do_getMaxLogicalLobSize();
        }
        return this.filterChain.reset().DatabaseMetaData_getMaxLogicalLobSize(this);
    }

    @Override
    @Deprecated
    public boolean supportsRefCursors() throws SQLException {
        if (this.filterChain == null) {
            return this.do_supportsRefCursors();
        }
        return this.filterChain.reset().DatabaseMetaData_supportsRefCursors(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

