/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.MathUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.SQLException;

public class DmdbIntervalDT
implements Serializable {
    private static final long serialVersionUID = 3402150044485419841L;
    public static final int LOADPREC_DEFAULT = 2;
    public static final int LOADPREC_MAX = 9;
    public static final int SECDPREC_DEFAULT = 6;
    public static final int SECDPREC_MAX = 6;
    public static final byte QUA_D = 3;
    public static final byte QUA_DH = 4;
    public static final byte QUA_DHM = 5;
    public static final byte QUA_DHMS = 6;
    public static final byte QUA_H = 7;
    public static final byte QUA_HM = 8;
    public static final byte QUA_HMS = 9;
    public static final byte QUA_M = 10;
    public static final byte QUA_MS = 11;
    public static final byte QUA_S = 12;
    public byte type = (byte)3;
    private int leadScale = 2;
    private int secScale = 6;
    private boolean negative = false;
    public int days = 0;
    public int hours = 0;
    public int minutes = 0;
    public int seconds = 0;
    public int fraction = 0;
    private int scaleForSvr = 0;

    private DmdbIntervalDT(byte type, boolean negative, int day, int hour, int minute, int second, int fraction, int scale) {
        this.type = type;
        this.negative = negative;
        this.leadScale = scale >> 4 & 0xF;
        this.secScale = scale & 0xF;
        this.days = day;
        this.hours = hour;
        this.minutes = minute;
        this.seconds = second;
        this.fraction = fraction;
        this.scaleForSvr = scale;
    }

    public DmdbIntervalDT(byte[] interval) {
        this.reset(interval);
    }

    public DmdbIntervalDT(String str) throws SQLException {
        this.parseIntervDTString(str);
    }

    public int hashCode() {
        return this.getDTString().hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof DmdbIntervalDT) {
            DmdbIntervalDT tm = (DmdbIntervalDT)o2;
            if (tm.negative == this.negative && tm.type == this.type) {
                switch (this.type) {
                    case 3: {
                        if (this.days != tm.days) break;
                        return true;
                    }
                    case 4: {
                        if (this.days != tm.days || this.hours != tm.hours) break;
                        return true;
                    }
                    case 5: {
                        if (this.days != tm.days || this.hours != tm.hours || this.minutes != tm.minutes) break;
                        return true;
                    }
                    case 6: {
                        if (this.days != tm.days || this.hours != tm.hours || this.minutes != tm.minutes || this.seconds != tm.seconds) break;
                        return true;
                    }
                    case 7: {
                        if (this.hours != tm.hours) break;
                        return true;
                    }
                    case 8: {
                        if (this.hours != tm.hours || this.minutes != tm.minutes) break;
                        return true;
                    }
                    case 9: {
                        if (this.hours != tm.hours || this.minutes != tm.minutes || this.seconds != tm.seconds) break;
                        return true;
                    }
                    case 10: {
                        if (this.minutes != tm.minutes) break;
                        return true;
                    }
                    case 11: {
                        if (this.minutes != tm.minutes || this.seconds != tm.seconds) break;
                        return true;
                    }
                    case 12: {
                        if (this.seconds != tm.seconds) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int getScaleForSvr() {
        return this.scaleForSvr;
    }

    public void reset(byte[] interval) {
        this.type = interval[21];
        this.scaleForSvr = ByteUtil.getInt(interval, 20);
        this.leadScale = this.scaleForSvr >> 4 & 0xF;
        this.secScale = this.scaleForSvr & 0xF;
        switch (this.type) {
            case 3: {
                this.days = ByteUtil.getInt(interval, 0);
                break;
            }
            case 4: {
                this.days = ByteUtil.getInt(interval, 0);
                this.hours = ByteUtil.getInt(interval, 4);
                break;
            }
            case 5: {
                this.days = ByteUtil.getInt(interval, 0);
                this.hours = ByteUtil.getInt(interval, 4);
                this.minutes = ByteUtil.getInt(interval, 8);
                break;
            }
            case 6: {
                this.days = ByteUtil.getInt(interval, 0);
                this.hours = ByteUtil.getInt(interval, 4);
                this.minutes = ByteUtil.getInt(interval, 8);
                this.seconds = ByteUtil.getInt(interval, 12);
                this.fraction = ByteUtil.getInt(interval, 16);
                break;
            }
            case 7: {
                this.hours = ByteUtil.getInt(interval, 4);
                break;
            }
            case 8: {
                this.hours = ByteUtil.getInt(interval, 4);
                this.minutes = ByteUtil.getInt(interval, 8);
                break;
            }
            case 9: {
                this.hours = ByteUtil.getInt(interval, 4);
                this.minutes = ByteUtil.getInt(interval, 8);
                this.seconds = ByteUtil.getInt(interval, 12);
                this.fraction = ByteUtil.getInt(interval, 16);
                break;
            }
            case 10: {
                this.minutes = ByteUtil.getInt(interval, 8);
                break;
            }
            case 11: {
                this.minutes = ByteUtil.getInt(interval, 8);
                this.seconds = ByteUtil.getInt(interval, 12);
                this.fraction = ByteUtil.getInt(interval, 16);
                break;
            }
            case 12: {
                this.seconds = ByteUtil.getInt(interval, 12);
                this.fraction = ByteUtil.getInt(interval, 16);
            }
        }
        if (this.days < 0) {
            this.days = -this.days;
            this.negative = true;
        }
        if (this.hours < 0) {
            this.hours = -this.hours;
            this.negative = true;
        }
        if (this.minutes < 0) {
            this.minutes = -this.minutes;
            this.negative = true;
        }
        if (this.seconds < 0) {
            this.seconds = -this.seconds;
            this.negative = true;
        }
        if (this.fraction < 0) {
            this.fraction = -this.fraction;
            this.negative = true;
        }
    }

    private void setDay(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 1) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)3;
        int i2 = Integer.parseInt(value);
        int n2 = this.days = i2 < 0 ? -i2 : i2;
        if (i2 < 0) {
            this.negative = true;
        }
    }

    private void setHour(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 1) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)7;
        int i2 = Integer.parseInt(value);
        int n2 = this.hours = i2 < 0 ? -i2 : i2;
        if (i2 < 0) {
            this.negative = true;
        }
    }

    private void setMinute(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 1) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)10;
        int i2 = Integer.parseInt(value);
        int n2 = this.minutes = i2 < 0 ? -i2 : i2;
        if (i2 < 0) {
            this.negative = true;
        }
    }

    private void setSecond(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)12;
        int i2 = Integer.parseInt(list[0]);
        int nano = 0;
        if (list.length > 1) {
            String strNano = "0." + list[1];
            double d_v = Double.valueOf(strNano);
            int nx = (int)Math.pow(10.0, this.secScale);
            nano = (int)(d_v * (double)nx);
        }
        this.seconds = i2 < 0 ? -i2 : i2;
        int n2 = this.fraction = nano < 0 ? -nano : nano;
        if (i2 < 0 || nano < 0) {
            this.negative = true;
        }
    }

    private void setHourToSecond(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 4) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)9;
        int h2 = Integer.parseInt(list[0]);
        int m2 = Integer.parseInt(list[1]);
        int s2 = Integer.parseInt(list[2]);
        int nano = 0;
        if (list.length > 3) {
            String strNano = "0." + list[3];
            double d_v = Double.valueOf(strNano);
            int nx = (int)Math.pow(10.0, this.secScale);
            nano = (int)(d_v * (double)nx);
        }
        this.hours = h2 < 0 ? -h2 : h2;
        this.minutes = m2 < 0 ? -m2 : m2;
        this.seconds = s2 < 0 ? -s2 : s2;
        int n2 = this.fraction = nano < 0 ? -nano : nano;
        if (h2 < 0 || m2 < 0 || s2 < 0 || nano < 0) {
            this.negative = true;
        }
    }

    private void setHourToMinute(String value) throws SQLException {
        String[] list = DriverUtil.split(value = value.trim(), " :.");
        if (list.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)8;
        int h2 = Integer.parseInt(list[0]);
        int m2 = Integer.parseInt(list[1]);
        if (list.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.hours = h2 < 0 ? -h2 : h2;
        int n2 = this.minutes = m2 < 0 ? -m2 : m2;
        if (h2 < 0 || m2 < 0) {
            this.negative = true;
        }
    }

    private void setMinuteToSecond(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 3) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)11;
        int m2 = Integer.parseInt(list[0]);
        int s2 = Integer.parseInt(list[1]);
        int nano = 0;
        if (list.length > 2) {
            String strNano = "0." + list[2];
            double d_v = Double.valueOf(strNano);
            int nx = (int)Math.pow(10.0, this.secScale);
            nano = (int)(d_v * (double)nx);
        }
        this.minutes = m2 < 0 ? -m2 : m2;
        this.seconds = s2 < 0 ? -s2 : s2;
        int n2 = this.fraction = nano < 0 ? -nano : nano;
        if (m2 < 0 || s2 < 0 || nano < 0) {
            this.negative = true;
        }
    }

    private void setDayToHour(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 2) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)4;
        int d2 = Integer.parseInt(list[0]);
        int h2 = Integer.parseInt(list[1]);
        this.days = d2 < 0 ? -d2 : d2;
        int n2 = this.hours = h2 < 0 ? -h2 : h2;
        if (d2 < 0 || h2 < 0) {
            this.negative = true;
        }
    }

    private void setDayToMinute(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 3) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)5;
        int d2 = Integer.parseInt(list[0]);
        int h2 = Integer.parseInt(list[1]);
        int m2 = Integer.parseInt(list[2]);
        this.days = d2 < 0 ? -d2 : d2;
        this.hours = h2 < 0 ? -h2 : h2;
        int n2 = this.minutes = m2 < 0 ? -m2 : m2;
        if (d2 < 0 || h2 < 0 || m2 < 0) {
            this.negative = true;
        }
    }

    private void setDayToSecond(String value) throws SQLException {
        String[] list = DriverUtil.split(value, " :.");
        if (list.length > 5) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        this.type = (byte)6;
        int d2 = Integer.parseInt(list[0]);
        int h2 = Integer.parseInt(list[1]);
        int m2 = Integer.parseInt(list[2]);
        int s2 = Integer.parseInt(list[3]);
        int nano = 0;
        if (list.length > 4) {
            String strNano = "0." + list[4];
            double d_v = Double.valueOf(strNano);
            int nx = (int)Math.pow(10.0, this.secScale);
            nano = (int)(d_v * (double)nx);
        }
        this.days = d2 < 0 ? -d2 : d2;
        this.hours = h2 < 0 ? -h2 : h2;
        this.minutes = m2 < 0 ? -m2 : m2;
        this.seconds = s2 < 0 ? -s2 : s2;
        int n2 = this.fraction = nano < 0 ? -nano : nano;
        if (d2 < 0 || h2 < 0 || m2 < 0 || s2 < 0 || nano < 0) {
            this.negative = true;
        }
    }

    public final int getDay() {
        return this.days;
    }

    public final int getHour() {
        return this.hours;
    }

    public final int getMinute() {
        return this.minutes;
    }

    public final int getSecond() {
        return this.seconds;
    }

    public final int getMsec() {
        return this.fraction;
    }

    public final byte getDTType() {
        return this.type;
    }

    public final int getSecPrec() {
        return this.secScale;
    }

    public final int getLeadScale() {
        return this.leadScale;
    }

    public final String getDTString() {
        String interval = "INTERVAL ";
        switch (this.type) {
            case 3: {
                String dStr = String.valueOf(this.days);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (dStr.length() < this.leadScale) {
                    int len = dStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                interval = String.valueOf(interval) + "'" + dStr + "' DAY(" + this.leadScale + ")";
                break;
            }
            case 4: {
                String dStr = String.valueOf(this.days);
                String hStr = String.valueOf(this.hours);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (dStr.length() < this.leadScale) {
                    int len = dStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                if (hStr.length() < 2) {
                    hStr = "0" + hStr;
                }
                interval = String.valueOf(interval) + "'" + dStr + " " + hStr + "' DAY(" + this.leadScale + ") TO HOUR";
                break;
            }
            case 5: {
                String dStr = String.valueOf(this.days);
                String hStr = String.valueOf(this.hours);
                String mStr = String.valueOf(this.minutes);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (dStr.length() < this.leadScale) {
                    int len = dStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                if (hStr.length() < 2) {
                    hStr = "0" + hStr;
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                interval = String.valueOf(interval) + "'" + dStr + " " + hStr + ":" + mStr + "' DAY(" + this.leadScale + ") TO MINUTE";
                break;
            }
            case 6: {
                String dStr = String.valueOf(this.days);
                String hStr = String.valueOf(this.hours);
                String mStr = String.valueOf(this.minutes);
                String sStr = String.valueOf(this.seconds);
                String nStr = this.getMsecString();
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (dStr.length() < this.leadScale) {
                    int len = dStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        dStr = "0" + dStr;
                    }
                }
                if (hStr.length() < 2) {
                    hStr = "0" + hStr;
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                if (sStr.length() < 2) {
                    sStr = "0" + sStr;
                }
                interval = String.valueOf(interval) + "'" + dStr + " " + hStr + ":" + mStr + ":" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' DAY(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
                break;
            }
            case 7: {
                String hStr = String.valueOf(this.hours);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (hStr.length() < this.leadScale) {
                    int len = hStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        hStr = "0" + hStr;
                    }
                }
                interval = String.valueOf(interval) + "'" + hStr + "' HOUR(" + this.leadScale + ")";
                break;
            }
            case 8: {
                String hStr = String.valueOf(this.hours);
                String mStr = String.valueOf(this.minutes);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (hStr.length() < this.leadScale) {
                    int len = hStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        hStr = "0" + hStr;
                    }
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                interval = String.valueOf(interval) + "'" + hStr + ":" + mStr + "' HOUR(" + this.leadScale + ") TO MINUTE";
                break;
            }
            case 9: {
                String nStr = this.getMsecString();
                String hStr = String.valueOf(this.hours);
                String mStr = String.valueOf(this.minutes);
                String sStr = String.valueOf(this.seconds);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (hStr.length() < this.leadScale) {
                    int len = hStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        hStr = "0" + hStr;
                    }
                }
                if (mStr.length() < 2) {
                    mStr = "0" + mStr;
                }
                if (sStr.length() < 2) {
                    sStr = "0" + sStr;
                }
                interval = String.valueOf(interval) + "'" + hStr + ":" + mStr + ":" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' HOUR(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
                break;
            }
            case 10: {
                String mStr = String.valueOf(this.minutes);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (mStr.length() < this.leadScale) {
                    int len = mStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        mStr = "0" + mStr;
                    }
                }
                interval = String.valueOf(interval) + "'" + mStr + "' MINUTE(" + this.leadScale + ")";
                break;
            }
            case 11: {
                String nStr = this.getMsecString();
                String mStr = String.valueOf(this.minutes);
                String sStr = String.valueOf(this.seconds);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (mStr.length() < this.leadScale) {
                    int len = mStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        mStr = "0" + mStr;
                    }
                }
                if (sStr.length() < 2) {
                    sStr = "0" + sStr;
                }
                interval = String.valueOf(interval) + "'" + mStr + ":" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' MINUTE(" + this.leadScale + ") TO SECOND(" + this.secScale + ")";
                break;
            }
            case 12: {
                String nStr = this.getMsecString();
                String sStr = String.valueOf(this.seconds);
                if (this.negative) {
                    interval = String.valueOf(interval) + "-";
                }
                if (sStr.length() < this.leadScale) {
                    int len = sStr.length();
                    int destLen = this.leadScale;
                    while (destLen-- > len) {
                        sStr = "0" + sStr;
                    }
                }
                interval = String.valueOf(interval) + "'" + sStr + (StringUtil.isNotEmpty(nStr) ? "." + nStr : "") + "' SECOND(" + this.leadScale + ", " + this.secScale + ")";
            }
        }
        return interval;
    }

    private String getMsecString() {
        String nano = "" + this.fraction;
        int i2 = 6 - nano.length();
        while (i2 > 0) {
            nano = "0" + nano;
            --i2;
        }
        if (nano.length() > this.secScale) {
            nano = nano.substring(0, this.secScale);
        }
        return nano;
    }

    public final String toString() {
        return this.getDTString();
    }

    public byte[] encode(int scale) throws SQLException {
        if (scale == 0) {
            scale = this.scaleForSvr;
        }
        int day = this.days;
        int hour = this.hours;
        int minute = this.minutes;
        int second = this.seconds;
        int f2 = this.fraction;
        if (scale != this.scaleForSvr) {
            DmdbIntervalDT dt = this.convertTo(scale);
            day = dt.days;
            hour = dt.hours;
            minute = dt.minutes;
            second = dt.seconds;
            f2 = dt.fraction;
        } else {
            int loadPrec = scale >> 4 & 0xF;
            this.checkScale(loadPrec);
        }
        byte[] ym = new byte[24];
        ByteUtil.setInt(ym, 0, this.negative ? -day : day);
        ByteUtil.setInt(ym, 4, this.negative ? -hour : hour);
        ByteUtil.setInt(ym, 8, this.negative ? -minute : minute);
        ByteUtil.setInt(ym, 12, this.negative ? -second : second);
        ByteUtil.setInt(ym, 16, this.negative ? -f2 : f2);
        ByteUtil.setInt(ym, 20, scale);
        return ym;
    }

    public DmdbIntervalDT convertTo(int scale) throws SQLException {
        int destType = (scale & 0xFF00) >> 8;
        int leadPrec = scale >> 4 & 0xF;
        int secScale = scale & 0xF;
        int dayIndex = 0;
        int hourIndex = 1;
        int minuteIndex = 2;
        int secondIndex = 3;
        int fractionIndex = 4;
        long[] orgDT = new long[5];
        long[] destDT = new long[5];
        switch (this.type) {
            case 3: {
                orgDT[dayIndex] = this.days;
                break;
            }
            case 4: {
                orgDT[dayIndex] = this.days;
                orgDT[hourIndex] = this.hours;
                break;
            }
            case 5: {
                orgDT[dayIndex] = this.days;
                orgDT[hourIndex] = this.hours;
                orgDT[minuteIndex] = this.minutes;
                break;
            }
            case 6: {
                orgDT[dayIndex] = this.days;
                orgDT[hourIndex] = this.hours;
                orgDT[minuteIndex] = this.minutes;
                orgDT[secondIndex] = this.seconds;
                orgDT[fractionIndex] = this.fraction;
                break;
            }
            case 7: {
                orgDT[dayIndex] = this.hours / 24;
                orgDT[hourIndex] = this.hours % 24;
                break;
            }
            case 8: {
                orgDT[dayIndex] = this.hours / 24;
                orgDT[hourIndex] = this.hours % 24;
                orgDT[minuteIndex] = this.minutes;
                break;
            }
            case 9: {
                orgDT[dayIndex] = this.hours / 24;
                orgDT[hourIndex] = this.hours % 24;
                orgDT[minuteIndex] = this.minutes;
                orgDT[secondIndex] = this.seconds;
                orgDT[fractionIndex] = this.fraction;
                break;
            }
            case 10: {
                orgDT[dayIndex] = this.minutes / 1440;
                orgDT[hourIndex] = this.minutes % 1440 / 60;
                orgDT[minuteIndex] = this.minutes % 1440 % 60;
                break;
            }
            case 11: {
                orgDT[dayIndex] = this.minutes / 1440;
                orgDT[hourIndex] = this.minutes % 1440 / 60;
                orgDT[minuteIndex] = this.minutes % 1440 % 60;
                orgDT[secondIndex] = this.seconds;
                orgDT[fractionIndex] = this.fraction;
                break;
            }
            case 12: {
                orgDT[dayIndex] = this.seconds / 86400;
                orgDT[hourIndex] = this.seconds % 86400 / 3600;
                orgDT[minuteIndex] = this.seconds % 86400 % 3600 / 60;
                orgDT[secondIndex] = this.seconds % 86400 % 3600 % 60;
                orgDT[fractionIndex] = this.fraction;
                break;
            }
        }
        switch (destType) {
            case 3: {
                destDT[dayIndex] = orgDT[dayIndex];
                if (orgDT[hourIndex] >= 12L) {
                    this.incrementDay(3, destDT);
                }
                if (leadPrec >= String.valueOf(Math.abs(destDT[dayIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 4: {
                destDT[dayIndex] = orgDT[dayIndex];
                destDT[hourIndex] = orgDT[hourIndex];
                if (orgDT[minuteIndex] >= 30L) {
                    this.incrementHour(4, destDT);
                }
                if (leadPrec >= String.valueOf(Math.abs(destDT[dayIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 5: {
                destDT[dayIndex] = orgDT[dayIndex];
                destDT[hourIndex] = orgDT[hourIndex];
                destDT[minuteIndex] = orgDT[minuteIndex];
                if (orgDT[secondIndex] >= 30L) {
                    this.incrementMinute(5, destDT);
                }
                if (leadPrec >= String.valueOf(Math.abs(destDT[dayIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 6: {
                destDT[dayIndex] = orgDT[dayIndex];
                destDT[hourIndex] = orgDT[hourIndex];
                destDT[minuteIndex] = orgDT[minuteIndex];
                destDT[secondIndex] = orgDT[secondIndex];
                destDT[fractionIndex] = orgDT[fractionIndex];
                this.convertMSecond(6, destDT, secScale);
                if (leadPrec >= String.valueOf(Math.abs(destDT[dayIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 7: {
                destDT[hourIndex] = orgDT[dayIndex] * 24L + orgDT[hourIndex];
                if (orgDT[minuteIndex] >= 30L) {
                    this.incrementHour(7, destDT);
                }
                if (leadPrec >= String.valueOf(Math.abs(destDT[hourIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 8: {
                destDT[hourIndex] = orgDT[dayIndex] * 24L + orgDT[hourIndex];
                destDT[minuteIndex] = orgDT[minuteIndex];
                if (orgDT[secondIndex] >= 30L) {
                    this.incrementMinute(8, destDT);
                }
                if (leadPrec >= String.valueOf(Math.abs(destDT[hourIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 9: {
                destDT[hourIndex] = orgDT[dayIndex] * 24L + orgDT[hourIndex];
                destDT[minuteIndex] = orgDT[minuteIndex];
                destDT[secondIndex] = orgDT[secondIndex];
                destDT[fractionIndex] = orgDT[fractionIndex];
                this.convertMSecond(9, destDT, secScale);
                if (leadPrec >= String.valueOf(Math.abs(destDT[hourIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 10: {
                destDT[minuteIndex] = orgDT[dayIndex] * 24L * 60L + orgDT[hourIndex] * 60L + orgDT[minuteIndex];
                if (orgDT[secondIndex] >= 30L) {
                    this.incrementMinute(10, destDT);
                }
                if (leadPrec >= String.valueOf(Math.abs(destDT[minuteIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 11: {
                destDT[minuteIndex] = orgDT[dayIndex] * 24L * 60L + orgDT[hourIndex] * 60L + orgDT[minuteIndex];
                destDT[secondIndex] = orgDT[secondIndex];
                destDT[fractionIndex] = orgDT[fractionIndex];
                this.convertMSecond(11, destDT, secScale);
                if (leadPrec >= String.valueOf(Math.abs(destDT[minuteIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
            case 12: {
                destDT[secondIndex] = orgDT[dayIndex] * 24L * 60L * 60L + orgDT[hourIndex] * 60L * 60L + orgDT[minuteIndex] * 60L + orgDT[secondIndex];
                destDT[fractionIndex] = orgDT[fractionIndex];
                this.convertMSecond(12, destDT, secScale);
                if (leadPrec >= String.valueOf(Math.abs(destDT[secondIndex])).length()) break;
                DBError.ECJDBC_INTERVAL_OVERFLOW.throwz(new Object[0]);
                break;
            }
        }
        return new DmdbIntervalDT((byte)destType, this.negative, (int)destDT[dayIndex], (int)destDT[hourIndex], (int)destDT[minuteIndex], (int)destDT[secondIndex], (int)destDT[fractionIndex], scale);
    }

    private void convertMSecond(int destType, long[] destDT, int destSecScale) {
        int fractionIndex = 4;
        long orgFraction = destDT[fractionIndex];
        if (destSecScale == 0 || destSecScale < this.secScale) {
            long n2 = MathUtil.pow(10, 6 - destSecScale - 1);
            int f2 = (int)(orgFraction / n2 / 10L);
            if (orgFraction / n2 % 10L >= 5L) {
                ++f2;
                if ((f2 = (int)((long)f2 * n2 * 10L)) == 1000000) {
                    destDT[fractionIndex] = 0L;
                    this.incrementSecond(destType, destDT);
                    return;
                }
            }
            destDT[fractionIndex] = f2;
        }
    }

    private void incrementDay(int destType, long[] dt) {
        int dayIndex;
        int n2 = dayIndex = 0;
        dt[n2] = dt[n2] + 1L;
    }

    private void incrementHour(int destType, long[] dt) {
        int hourIndex;
        int n2 = hourIndex = 1;
        dt[n2] = dt[n2] + 1L;
        if (dt[hourIndex] == 24L && destType < 7) {
            this.incrementDay(destType, dt);
            dt[hourIndex] = 0L;
        }
    }

    private void incrementMinute(int destType, long[] dt) {
        int minuteIndex;
        int n2 = minuteIndex = 2;
        dt[n2] = dt[n2] + 1L;
        if (dt[minuteIndex] == 60L && destType < 10) {
            this.incrementHour(destType, dt);
            dt[minuteIndex] = 0L;
        }
    }

    private void incrementSecond(int destType, long[] dt) {
        int secondIndex;
        int n2 = secondIndex = 3;
        dt[n2] = dt[n2] + 1L;
        if (dt[secondIndex] == 60L && destType < 12) {
            this.incrementMinute(destType, dt);
            dt[secondIndex] = 0L;
        }
    }

    public void clear() {
        this.days = 0;
        this.hours = 0;
        this.minutes = 0;
        this.seconds = 0;
        this.fraction = 0;
        this.negative = false;
    }

    private int parsePrec(String leadStr) throws SQLException {
        int leftBtId = leadStr.indexOf("(");
        int rightBtId = leadStr.indexOf(")");
        int prec = -1;
        if (rightBtId != -1 && leftBtId != -1 && rightBtId > leftBtId + 1) {
            String strPrec = leadStr.substring(leftBtId + 1, rightBtId).trim();
            prec = Integer.parseInt(strPrec);
        }
        return prec;
    }

    private int checkScale(int leadScale) throws SQLException {
        switch (this.type) {
            case 3: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.days)).length();
                    break;
                }
                if (leadScale >= String.valueOf(Math.abs(this.days)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 4: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.days)).length();
                } else if (leadScale < String.valueOf(Math.abs(this.days)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.hours) <= 23) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 5: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.days)).length();
                } else if (leadScale < String.valueOf(Math.abs(this.days)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.hours) <= 23 && Math.abs(this.minutes) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 6: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.days)).length();
                } else if (leadScale < String.valueOf(Math.abs(this.days)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.hours) <= 23 && Math.abs(this.minutes) <= 59 && Math.abs(this.seconds) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 7: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.hours)).length();
                    break;
                }
                if (leadScale >= String.valueOf(Math.abs(this.hours)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 8: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.hours)).length();
                } else if (leadScale < String.valueOf(Math.abs(this.hours)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.minutes) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 9: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.hours)).length();
                } else if (leadScale < String.valueOf(Math.abs(this.hours)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.minutes) <= 59 && Math.abs(this.seconds) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 10: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.minutes)).length();
                    break;
                }
                if (leadScale >= String.valueOf(Math.abs(this.minutes)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 11: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.minutes)).length();
                } else if (leadScale < String.valueOf(Math.abs(this.minutes)).length()) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                if (Math.abs(this.seconds) <= 59) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                break;
            }
            case 12: {
                if (leadScale == -1) {
                    leadScale = String.valueOf(Math.abs(this.seconds)).length();
                    break;
                }
                if (leadScale >= String.valueOf(Math.abs(this.seconds)).length()) break;
                DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
            }
        }
        if (leadScale > 9) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        return leadScale;
    }

    private void setPrecForSvr(String fullStr, String leadScale, String secScale) throws SQLException {
        int prec = this.checkScale(this.parsePrec(leadScale));
        this.leadScale = prec < 2 ? 2 : prec;
        prec = this.parsePrec(secScale);
        this.secScale = prec > 0 && prec < 6 ? prec : 6;
        this.scaleForSvr = (this.type << 8) + (this.leadScale << 4) + this.secScale;
    }

    private String checkSign(String str) throws SQLException {
        if (str.charAt(0) == '-') {
            str = str.substring(1).trim();
            this.negative = true;
        } else if (str.charAt(0) == '+') {
            str = str.substring(1).trim();
            this.negative = false;
        }
        return str;
    }

    private void parseIntervDTString(String str) throws SQLException {
        String leadStr;
        if (StringUtil.isEmpty(str)) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        if (!(leadStr = str.toUpperCase().trim()).startsWith("INTERVAL ")) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
        }
        try {
            leadStr = leadStr.substring(leadStr.indexOf(" ")).trim();
            int endIndex = 0;
            String valueStr = null;
            if (leadStr.charAt(0) == '\'' && (endIndex = leadStr.indexOf("'", 1)) != -1) {
                valueStr = leadStr.substring(1, endIndex).trim();
                valueStr = this.checkSign(valueStr);
                leadStr = leadStr.substring(endIndex + 1).trim();
            }
            if (valueStr == null) {
                if ((leadStr = this.checkSign(leadStr)).charAt(0) != '\'' || (endIndex = leadStr.indexOf("'", 1)) == -1) {
                    DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                }
                valueStr = leadStr.substring(1, endIndex).trim();
                leadStr = leadStr.substring(endIndex + 1).trim();
            }
            String strLeadPrec = "";
            String strSecPrec = "";
            int leadPrecIndex = 0;
            int secPrecIndex = 0;
            int toIndex = 0;
            leadPrecIndex = leadStr.indexOf("DAY");
            if (leadPrecIndex != -1) {
                toIndex = leadStr.indexOf("TO", leadPrecIndex);
                if (toIndex == -1) {
                    strLeadPrec = leadStr.substring(leadPrecIndex).trim();
                    this.setDay(valueStr);
                } else {
                    strLeadPrec = leadStr.substring(leadPrecIndex, toIndex).trim();
                    if (leadStr.indexOf("HOUR", toIndex) != -1) {
                        this.setDayToHour(valueStr);
                    } else if (leadStr.indexOf("MINUTE", toIndex) != -1) {
                        this.setDayToMinute(valueStr);
                    } else {
                        secPrecIndex = leadStr.indexOf("SECOND", toIndex);
                        if (secPrecIndex != -1) {
                            strSecPrec = leadStr.substring(secPrecIndex);
                            this.setDayToSecond(valueStr);
                        } else {
                            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                        }
                    }
                }
                this.setPrecForSvr(leadStr, strLeadPrec, strSecPrec);
                return;
            }
            leadPrecIndex = leadStr.indexOf("HOUR");
            if (leadPrecIndex != -1) {
                toIndex = leadStr.indexOf("TO", leadPrecIndex);
                if (toIndex == -1) {
                    strLeadPrec = leadStr.substring(leadPrecIndex);
                    this.setHour(valueStr);
                } else {
                    strLeadPrec = leadStr.substring(leadPrecIndex, toIndex);
                    if (leadStr.indexOf("MINUTE", toIndex) != -1) {
                        this.setHourToMinute(valueStr);
                    } else {
                        secPrecIndex = leadStr.indexOf("SECOND", toIndex);
                        if (secPrecIndex != -1) {
                            strSecPrec = leadStr.substring(secPrecIndex);
                            this.setHourToSecond(valueStr);
                        } else {
                            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                        }
                    }
                }
                this.setPrecForSvr(leadStr, strLeadPrec, strSecPrec);
                return;
            }
            leadPrecIndex = leadStr.indexOf("MINUTE");
            if (leadPrecIndex != -1) {
                toIndex = leadStr.indexOf("TO", leadPrecIndex);
                if (toIndex == -1) {
                    strLeadPrec = leadStr.substring(leadPrecIndex);
                    this.setMinute(valueStr);
                } else {
                    strLeadPrec = leadStr.substring(leadPrecIndex, toIndex);
                    secPrecIndex = leadStr.indexOf("SECOND", toIndex);
                    if (secPrecIndex != -1) {
                        strSecPrec = leadStr.substring(secPrecIndex);
                        this.setMinuteToSecond(valueStr);
                    } else {
                        DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
                    }
                }
                this.setPrecForSvr(leadStr, strLeadPrec, strSecPrec);
                return;
            }
            leadPrecIndex = leadStr.indexOf("SECOND");
            if (leadPrecIndex != -1) {
                this.setSecond(valueStr);
                leadStr = leadStr.substring(leadPrecIndex).trim();
                int colonIndex = leadStr.indexOf(",");
                if (colonIndex != -1) {
                    strLeadPrec = String.valueOf(leadStr.substring(0, colonIndex).trim()) + ")";
                    strSecPrec = "(" + leadStr.substring(colonIndex + 1).trim();
                }
                this.setPrecForSvr(leadStr, strLeadPrec, strSecPrec);
                return;
            }
        }
        catch (SQLException e2) {
            throw e2;
        }
        catch (Exception e3) {
            DBError.ECJDBC_INVALID_TIME_INTERVAL.throwException(e3);
        }
        DBError.ECJDBC_INVALID_TIME_INTERVAL.throwz(new Object[0]);
    }

    public static void main(String[] args) throws SQLException {
        DmdbIntervalDT dt = new DmdbIntervalDT("interval -'122222' second(2, 4)");
        System.out.println(dt.convertTo(550));
    }
}

