/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.stat;

import dm.jdbc.desc.enums.ExecuteType;
import dm.jdbc.filter.stat.BaseStat;
import dm.jdbc.filter.stat.SqlStatValue;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.IDGenerator;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.management.JMException;

public final class SqlStat
extends BaseStat {
    private final String sql;
    private long sqlHash;
    private String id;
    private long executeLastStartTime;
    private volatile long executeBatchSizeTotal;
    private volatile int executeBatchSizeMax;
    private volatile long executeSuccessCount;
    private volatile long executeSpanNanoTotal;
    private volatile long executeSpanNanoMax;
    private volatile int runningCount;
    private volatile int concurrentMax;
    private volatile long resultSetHoldTimeNano;
    private volatile long executeAndResultSetHoldTime;
    static final AtomicLongFieldUpdater<SqlStat> executeBatchSizeTotalUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeBatchSizeTotal");
    static final AtomicIntegerFieldUpdater<SqlStat> executeBatchSizeMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeBatchSizeMax");
    static final AtomicLongFieldUpdater<SqlStat> executeSuccessCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeSuccessCount");
    static final AtomicLongFieldUpdater<SqlStat> executeSpanNanoTotalUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeSpanNanoTotal");
    static final AtomicLongFieldUpdater<SqlStat> executeSpanNanoMaxUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeSpanNanoMax");
    static final AtomicIntegerFieldUpdater<SqlStat> runningCountUpdater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "runningCount");
    static final AtomicIntegerFieldUpdater<SqlStat> concurrentMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "concurrentMax");
    static final AtomicLongFieldUpdater<SqlStat> resultSetHoldTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "resultSetHoldTimeNano");
    static final AtomicLongFieldUpdater<SqlStat> executeAndResultSetHoldTimeUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeAndResultSetHoldTime");
    private String dataSource;
    private String file;
    private volatile long executeNanoSpanMaxOccurTime;
    private volatile long executeErrorCount;
    private volatile Throwable executeErrorLast;
    private volatile long executeErrorLastTime;
    private volatile long updateCount;
    private volatile long updateCountMax;
    private volatile long fetchRowCount;
    private volatile long fetchRowCountMax;
    private volatile long inTransactionCount;
    private volatile String lastSlowParameters;
    private boolean removed = false;
    private volatile long clobOpenCount;
    private volatile long blobOpenCount;
    private volatile long readStringLength;
    private volatile long readBytesLength;
    private volatile long inputStreamOpenCount;
    private volatile long readerOpenCount;
    static final AtomicLongFieldUpdater<SqlStat> executeErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeErrorCount");
    static final AtomicLongFieldUpdater<SqlStat> updateCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount");
    static final AtomicLongFieldUpdater<SqlStat> updateCountMaxUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCountMax");
    static final AtomicLongFieldUpdater<SqlStat> fetchRowCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount");
    static final AtomicLongFieldUpdater<SqlStat> fetchRowCountMaxUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCountMax");
    static final AtomicLongFieldUpdater<SqlStat> inTransactionCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "inTransactionCount");
    static final AtomicLongFieldUpdater<SqlStat> clobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "clobOpenCount");
    static final AtomicLongFieldUpdater<SqlStat> blobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "blobOpenCount");
    static final AtomicLongFieldUpdater<SqlStat> readStringLengthUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "readStringLength");
    static final AtomicLongFieldUpdater<SqlStat> readBytesLengthUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "readBytesLength");
    static final AtomicLongFieldUpdater<SqlStat> inputStreamOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "inputStreamOpenCount");
    static final AtomicLongFieldUpdater<SqlStat> readerOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "readerOpenCount");
    private volatile long histogram_0_1;
    private volatile long histogram_1_10;
    private volatile int histogram_10_100;
    private volatile int histogram_100_1000;
    private volatile int histogram_1000_10000;
    private volatile int histogram_10000_100000;
    private volatile int histogram_100000_1000000;
    private volatile int histogram_1000000_more;
    static final AtomicLongFieldUpdater<SqlStat> histogram_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "histogram_0_1");
    static final AtomicLongFieldUpdater<SqlStat> histogram_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "histogram_1_10");
    static final AtomicIntegerFieldUpdater<SqlStat> histogram_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_10_100");
    static final AtomicIntegerFieldUpdater<SqlStat> histogram_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_100_1000");
    static final AtomicIntegerFieldUpdater<SqlStat> histogram_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_1000_10000");
    static final AtomicIntegerFieldUpdater<SqlStat> histogram_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_10000_100000");
    static final AtomicIntegerFieldUpdater<SqlStat> histogram_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_100000_1000000");
    static final AtomicIntegerFieldUpdater<SqlStat> histogram_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "histogram_1000000_more");
    private volatile long executeAndResultHoldTime_0_1;
    private volatile long executeAndResultHoldTime_1_10;
    private volatile int executeAndResultHoldTime_10_100;
    private volatile int executeAndResultHoldTime_100_1000;
    private volatile int executeAndResultHoldTime_1000_10000;
    private volatile int executeAndResultHoldTime_10000_100000;
    private volatile int executeAndResultHoldTime_100000_1000000;
    private volatile int executeAndResultHoldTime_1000000_more;
    static final AtomicLongFieldUpdater<SqlStat> executeAndResultHoldTime_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_0_1");
    static final AtomicLongFieldUpdater<SqlStat> executeAndResultHoldTime_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_1_10");
    static final AtomicIntegerFieldUpdater<SqlStat> executeAndResultHoldTime_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_10_100");
    static final AtomicIntegerFieldUpdater<SqlStat> executeAndResultHoldTime_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_100_1000");
    static final AtomicIntegerFieldUpdater<SqlStat> executeAndResultHoldTime_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_1000_10000");
    static final AtomicIntegerFieldUpdater<SqlStat> executeAndResultHoldTime_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_10000_100000");
    static final AtomicIntegerFieldUpdater<SqlStat> executeAndResultHoldTime_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_100000_1000000");
    static final AtomicIntegerFieldUpdater<SqlStat> executeAndResultHoldTime_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "executeAndResultHoldTime_1000000_more");
    private volatile long fetchRowCount_0_1;
    private volatile long fetchRowCount_1_10;
    private volatile long fetchRowCount_10_100;
    private volatile int fetchRowCount_100_1000;
    private volatile int fetchRowCount_1000_10000;
    private volatile int fetchRowCount_10000_more;
    static final AtomicLongFieldUpdater<SqlStat> fetchRowCount_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_0_1");
    static final AtomicLongFieldUpdater<SqlStat> fetchRowCount_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_1_10");
    static final AtomicLongFieldUpdater<SqlStat> fetchRowCount_10_100_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_10_100");
    static final AtomicIntegerFieldUpdater<SqlStat> fetchRowCount_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_100_1000");
    static final AtomicIntegerFieldUpdater<SqlStat> fetchRowCount_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_1000_10000");
    static final AtomicIntegerFieldUpdater<SqlStat> fetchRowCount_10000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "fetchRowCount_10000_more");
    private volatile long updateCount_0_1;
    private volatile long updateCount_1_10;
    private volatile long updateCount_10_100;
    private volatile int updateCount_100_1000;
    private volatile int updateCount_1000_10000;
    private volatile int updateCount_10000_more;
    private String dataSourceId;
    static final AtomicLongFieldUpdater<SqlStat> updateCount_0_1_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount_0_1");
    static final AtomicLongFieldUpdater<SqlStat> updateCount_1_10_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount_1_10");
    static final AtomicLongFieldUpdater<SqlStat> updateCount_10_100_Updater = AtomicLongFieldUpdater.newUpdater(SqlStat.class, "updateCount_10_100");
    static final AtomicIntegerFieldUpdater<SqlStat> updateCount_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "updateCount_100_1000");
    static final AtomicIntegerFieldUpdater<SqlStat> updateCount_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "updateCount_1000_10000");
    static final AtomicIntegerFieldUpdater<SqlStat> updateCount_10000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(SqlStat.class, "updateCount_10000_more");

    public SqlStat(String sql) {
        this.sql = sql;
        this.id = "SQL" + IDGenerator.generateId();
    }

    public String getLastSlowParameters() {
        return this.lastSlowParameters;
    }

    public void setLastSlowParameters(String lastSlowParameters) {
        this.lastSlowParameters = lastSlowParameters;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String name) {
        this.dataSource = name;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public void setDataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void reset() {
        this.executeLastStartTime = 0L;
        executeBatchSizeTotalUpdater.set(this, 0L);
        executeBatchSizeMaxUpdater.set(this, 0);
        executeSuccessCountUpdater.set(this, 0L);
        executeSpanNanoTotalUpdater.set(this, 0L);
        executeSpanNanoMaxUpdater.set(this, 0L);
        this.executeNanoSpanMaxOccurTime = 0L;
        concurrentMaxUpdater.set(this, 0);
        executeErrorCountUpdater.set(this, 0L);
        this.executeErrorLast = null;
        this.executeErrorLastTime = 0L;
        updateCountUpdater.set(this, 0L);
        updateCountMaxUpdater.set(this, 0L);
        fetchRowCountUpdater.set(this, 0L);
        fetchRowCountMaxUpdater.set(this, 0L);
        histogram_0_1_Updater.set(this, 0L);
        histogram_1_10_Updater.set(this, 0L);
        histogram_10_100_Updater.set(this, 0);
        histogram_100_1000_Updater.set(this, 0);
        histogram_1000_10000_Updater.set(this, 0);
        histogram_10000_100000_Updater.set(this, 0);
        histogram_100000_1000000_Updater.set(this, 0);
        histogram_1000000_more_Updater.set(this, 0);
        this.lastSlowParameters = null;
        inTransactionCountUpdater.set(this, 0L);
        resultSetHoldTimeNanoUpdater.set(this, 0L);
        executeAndResultSetHoldTimeUpdater.set(this, 0L);
        fetchRowCount_0_1_Updater.set(this, 0L);
        fetchRowCount_1_10_Updater.set(this, 0L);
        fetchRowCount_10_100_Updater.set(this, 0L);
        fetchRowCount_100_1000_Updater.set(this, 0);
        fetchRowCount_1000_10000_Updater.set(this, 0);
        fetchRowCount_10000_more_Updater.set(this, 0);
        updateCount_0_1_Updater.set(this, 0L);
        updateCount_1_10_Updater.set(this, 0L);
        updateCount_10_100_Updater.set(this, 0L);
        updateCount_100_1000_Updater.set(this, 0);
        updateCount_1000_10000_Updater.set(this, 0);
        updateCount_10000_more_Updater.set(this, 0);
        executeAndResultHoldTime_0_1_Updater.set(this, 0L);
        executeAndResultHoldTime_1_10_Updater.set(this, 0L);
        executeAndResultHoldTime_10_100_Updater.set(this, 0);
        executeAndResultHoldTime_100_1000_Updater.set(this, 0);
        executeAndResultHoldTime_1000_10000_Updater.set(this, 0);
        executeAndResultHoldTime_10000_100000_Updater.set(this, 0);
        executeAndResultHoldTime_100000_1000000_Updater.set(this, 0);
        executeAndResultHoldTime_1000000_more_Updater.set(this, 0);
        blobOpenCountUpdater.set(this, 0L);
        clobOpenCountUpdater.set(this, 0L);
        readStringLengthUpdater.set(this, 0L);
        readBytesLengthUpdater.set(this, 0L);
        inputStreamOpenCountUpdater.set(this, 0L);
        readerOpenCountUpdater.set(this, 0L);
    }

    public SqlStatValue getValueAndReset() {
        return this.getValue(true);
    }

    public SqlStatValue getValue(boolean reset) {
        SqlStatValue val = new SqlStatValue();
        val.setDataSource(this.dataSource);
        val.setDataSourceId(this.dataSourceId);
        val.setSql(this.sql);
        val.setSqlHash(this.getSqlHash());
        val.setId(this.id);
        val.setExecuteLastStartTime(this.executeLastStartTime);
        if (reset) {
            this.executeLastStartTime = 0L;
        }
        val.setExecuteBatchSizeTotal(SqlStat.get(this, executeBatchSizeTotalUpdater, reset));
        val.setExecuteBatchSizeMax(SqlStat.get(this, executeBatchSizeMaxUpdater, reset));
        val.setExecuteSuccessCount(SqlStat.get(this, executeSuccessCountUpdater, reset));
        val.setExecuteSpanNanoTotal(SqlStat.get(this, executeSpanNanoTotalUpdater, reset));
        val.setExecuteSpanNanoMax(SqlStat.get(this, executeSpanNanoMaxUpdater, reset));
        val.setExecuteNanoSpanMaxOccurTime(this.executeNanoSpanMaxOccurTime);
        if (reset) {
            this.executeNanoSpanMaxOccurTime = 0L;
        }
        val.setRunningCount(this.runningCount);
        val.setConcurrentMax(SqlStat.get(this, concurrentMaxUpdater, reset));
        val.setExecuteErrorCount(SqlStat.get(this, executeErrorCountUpdater, reset));
        val.setExecuteErrorLast(this.executeErrorLast);
        if (reset) {
            this.executeErrorLast = null;
        }
        val.setExecuteErrorLastTime(this.executeErrorLastTime);
        if (reset) {
            this.executeErrorLastTime = 0L;
        }
        val.setUpdateCount(SqlStat.get(this, updateCountUpdater, reset));
        val.setUpdateCountMax(SqlStat.get(this, updateCountMaxUpdater, reset));
        val.setFetchRowCount(SqlStat.get(this, fetchRowCountUpdater, reset));
        val.setFetchRowCountMax(SqlStat.get(this, fetchRowCountMaxUpdater, reset));
        val.histogram_0_1 = SqlStat.get(this, histogram_0_1_Updater, reset);
        val.histogram_1_10 = SqlStat.get(this, histogram_1_10_Updater, reset);
        val.histogram_10_100 = SqlStat.get(this, histogram_10_100_Updater, reset);
        val.histogram_100_1000 = SqlStat.get(this, histogram_100_1000_Updater, reset);
        val.histogram_1000_10000 = SqlStat.get(this, histogram_1000_10000_Updater, reset);
        val.histogram_10000_100000 = SqlStat.get(this, histogram_10000_100000_Updater, reset);
        val.histogram_100000_1000000 = SqlStat.get(this, histogram_100000_1000000_Updater, reset);
        val.histogram_1000000_more = SqlStat.get(this, histogram_1000000_more_Updater, reset);
        val.setLastSlowParameters(this.lastSlowParameters);
        if (reset) {
            this.lastSlowParameters = null;
        }
        val.setInTransactionCount(SqlStat.get(this, inTransactionCountUpdater, reset));
        val.setResultSetHoldTimeNano(SqlStat.get(this, resultSetHoldTimeNanoUpdater, reset));
        val.setExecuteAndResultSetHoldTime(SqlStat.get(this, executeAndResultSetHoldTimeUpdater, reset));
        val.fetchRowCount_0_1 = SqlStat.get(this, fetchRowCount_0_1_Updater, reset);
        val.fetchRowCount_1_10 = SqlStat.get(this, fetchRowCount_1_10_Updater, reset);
        val.fetchRowCount_10_100 = SqlStat.get(this, fetchRowCount_10_100_Updater, reset);
        val.fetchRowCount_100_1000 = SqlStat.get(this, fetchRowCount_100_1000_Updater, reset);
        val.fetchRowCount_1000_10000 = SqlStat.get(this, fetchRowCount_1000_10000_Updater, reset);
        val.fetchRowCount_10000_more = SqlStat.get(this, fetchRowCount_10000_more_Updater, reset);
        val.updateCount_0_1 = SqlStat.get(this, updateCount_0_1_Updater, reset);
        val.updateCount_1_10 = SqlStat.get(this, updateCount_1_10_Updater, reset);
        val.updateCount_10_100 = SqlStat.get(this, updateCount_10_100_Updater, reset);
        val.updateCount_100_1000 = SqlStat.get(this, updateCount_100_1000_Updater, reset);
        val.updateCount_1000_10000 = SqlStat.get(this, updateCount_1000_10000_Updater, reset);
        val.updateCount_10000_more = SqlStat.get(this, updateCount_10000_more_Updater, reset);
        val.executeAndResultHoldTime_0_1 = SqlStat.get(this, executeAndResultHoldTime_0_1_Updater, reset);
        val.executeAndResultHoldTime_1_10 = SqlStat.get(this, executeAndResultHoldTime_1_10_Updater, reset);
        val.executeAndResultHoldTime_10_100 = SqlStat.get(this, executeAndResultHoldTime_10_100_Updater, reset);
        val.executeAndResultHoldTime_100_1000 = SqlStat.get(this, executeAndResultHoldTime_100_1000_Updater, reset);
        val.executeAndResultHoldTime_1000_10000 = SqlStat.get(this, executeAndResultHoldTime_1000_10000_Updater, reset);
        val.executeAndResultHoldTime_10000_100000 = SqlStat.get(this, executeAndResultHoldTime_10000_100000_Updater, reset);
        val.executeAndResultHoldTime_100000_1000000 = SqlStat.get(this, executeAndResultHoldTime_100000_1000000_Updater, reset);
        val.executeAndResultHoldTime_1000000_more = SqlStat.get(this, executeAndResultHoldTime_1000000_more_Updater, reset);
        val.setBlobOpenCount(SqlStat.get(this, blobOpenCountUpdater, reset));
        val.setClobOpenCount(SqlStat.get(this, clobOpenCountUpdater, reset));
        val.setReadStringLength(SqlStat.get(this, readStringLengthUpdater, reset));
        val.setReadBytesLength(SqlStat.get(this, readBytesLengthUpdater, reset));
        val.setInputStreamOpenCount(SqlStat.get(this, inputStreamOpenCountUpdater, reset));
        val.setReaderOpenCount(SqlStat.get(this, readerOpenCountUpdater, reset));
        return val;
    }

    public long getConcurrentMax() {
        return this.concurrentMax;
    }

    public long getRunningCount() {
        return this.runningCount;
    }

    public void addUpdateCount(int delta) {
        long max;
        if (delta > 0) {
            updateCountUpdater.addAndGet(this, delta);
        }
        while ((long)delta > (max = updateCountMaxUpdater.get(this)) && !updateCountMaxUpdater.compareAndSet(this, max, delta)) {
        }
        if (delta < 1) {
            updateCount_0_1_Updater.incrementAndGet(this);
        } else if (delta < 10) {
            updateCount_1_10_Updater.incrementAndGet(this);
        } else if (delta < 100) {
            updateCount_10_100_Updater.incrementAndGet(this);
        } else if (delta < 1000) {
            updateCount_100_1000_Updater.incrementAndGet(this);
        } else if (delta < 10000) {
            updateCount_1000_10000_Updater.incrementAndGet(this);
        } else {
            updateCount_10000_more_Updater.incrementAndGet(this);
        }
    }

    public long getUpdateCount() {
        return this.updateCount;
    }

    public long getUpdateCountMax() {
        return this.updateCountMax;
    }

    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public long getFetchRowCountMax() {
        return this.fetchRowCountMax;
    }

    public long getClobOpenCount() {
        return this.clobOpenCount;
    }

    public void incrementClobOpenCount() {
        clobOpenCountUpdater.incrementAndGet(this);
    }

    public long getBlobOpenCount() {
        return this.blobOpenCount;
    }

    public void incrementBlobOpenCount() {
        blobOpenCountUpdater.incrementAndGet(this);
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void addStringReadLength(long length) {
        readStringLengthUpdater.addAndGet(this, length);
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void addReadBytesLength(long length) {
        readBytesLengthUpdater.addAndGet(this, length);
    }

    public long getReaderOpenCount() {
        return this.readerOpenCount;
    }

    public void addReaderOpenCount(int count) {
        readerOpenCountUpdater.addAndGet(this, count);
    }

    public long getInputStreamOpenCount() {
        return this.inputStreamOpenCount;
    }

    public void addInputStreamOpenCount(int count) {
        inputStreamOpenCountUpdater.addAndGet(this, count);
    }

    public String getId() {
        return this.id;
    }

    public String getSql() {
        return this.sql;
    }

    public long getSqlHash() {
        if (this.sqlHash == 0L) {
            this.sqlHash = DriverUtil.murmurhash2_64(this.sql);
        }
        return this.sqlHash;
    }

    public Date getExecuteLastStartTime() {
        if (this.executeLastStartTime <= 0L) {
            return null;
        }
        return new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long executeLastStartTime) {
        this.executeLastStartTime = executeLastStartTime;
    }

    public Date getExecuteNanoSpanMaxOccurTime() {
        if (this.executeNanoSpanMaxOccurTime <= 0L) {
            return null;
        }
        return new Date(this.executeNanoSpanMaxOccurTime);
    }

    public Date getExecuteErrorLastTime() {
        if (this.executeErrorLastTime <= 0L) {
            return null;
        }
        return new Date(this.executeErrorLastTime);
    }

    public void addFetchRowCount(long delta) {
        long max;
        fetchRowCountUpdater.addAndGet(this, delta);
        while (delta > (max = fetchRowCountMaxUpdater.get(this)) && !fetchRowCountMaxUpdater.compareAndSet(this, max, delta)) {
        }
        if (delta < 1L) {
            fetchRowCount_0_1_Updater.incrementAndGet(this);
        } else if (delta < 10L) {
            fetchRowCount_1_10_Updater.incrementAndGet(this);
        } else if (delta < 100L) {
            fetchRowCount_10_100_Updater.incrementAndGet(this);
        } else if (delta < 1000L) {
            fetchRowCount_100_1000_Updater.incrementAndGet(this);
        } else if (delta < 10000L) {
            fetchRowCount_1000_10000_Updater.incrementAndGet(this);
        } else {
            fetchRowCount_10000_more_Updater.incrementAndGet(this);
        }
    }

    public void addExecuteBatchCount(long batchSize) {
        int current;
        executeBatchSizeTotalUpdater.addAndGet(this, batchSize);
        while ((long)(current = executeBatchSizeMaxUpdater.get(this)) < batchSize && !executeBatchSizeMaxUpdater.compareAndSet(this, current, (int)batchSize)) {
        }
    }

    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal;
    }

    public void incrementExecuteSuccessCount() {
        executeSuccessCountUpdater.incrementAndGet(this);
    }

    public void incrementRunningCount() {
        int max;
        int val = runningCountUpdater.incrementAndGet(this);
        while (val > (max = concurrentMaxUpdater.get(this)) && !concurrentMaxUpdater.compareAndSet(this, max, val)) {
        }
    }

    public void decrementRunningCount() {
        runningCountUpdater.decrementAndGet(this);
    }

    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public void addExecuteTime(ExecuteType executeType, boolean firstResultSet, long nanoSpan, String parameters) {
        this.addExecuteTime(nanoSpan, parameters);
        if (ExecuteType.QUERY != executeType && !firstResultSet) {
            this.executeAndResultHoldTimeHistogramRecord(nanoSpan);
        }
    }

    private void executeAndResultHoldTimeHistogramRecord(long nanoSpan) {
        long millis = nanoSpan / 1000L / 1000L;
        if (millis < 1L) {
            executeAndResultHoldTime_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            executeAndResultHoldTime_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            executeAndResultHoldTime_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            executeAndResultHoldTime_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            executeAndResultHoldTime_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            executeAndResultHoldTime_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            executeAndResultHoldTime_100000_1000000_Updater.incrementAndGet(this);
        } else {
            executeAndResultHoldTime_1000000_more_Updater.incrementAndGet(this);
        }
    }

    private void histogramRecord(long nanoSpan) {
        long millis = nanoSpan / 1000L / 1000L;
        if (millis < 1L) {
            histogram_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            histogram_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            histogram_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            histogram_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            histogram_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            histogram_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            histogram_100000_1000000_Updater.incrementAndGet(this);
        } else {
            histogram_1000000_more_Updater.incrementAndGet(this);
        }
    }

    public void addExecuteTime(long nanoSpan, String parameters) {
        long current;
        executeSpanNanoTotalUpdater.addAndGet(this, nanoSpan);
        while ((current = executeSpanNanoMaxUpdater.get(this)) < nanoSpan) {
            if (!executeSpanNanoMaxUpdater.compareAndSet(this, current, nanoSpan)) continue;
            this.executeNanoSpanMaxOccurTime = System.currentTimeMillis();
            this.lastSlowParameters = parameters;
            break;
        }
        this.histogramRecord(nanoSpan);
    }

    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal / 1000000L;
    }

    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax / 1000000L;
    }

    public long getErrorCount() {
        return this.executeErrorCount;
    }

    public long getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax;
    }

    public long getInTransactionCount() {
        return this.inTransactionCount;
    }

    public void incrementInTransactionCount() {
        inTransactionCountUpdater.incrementAndGet(this);
    }

    public long getExecuteCount() {
        return this.getErrorCount() + this.getExecuteSuccessCount();
    }

    public Map<String, Object> getData() throws JMException {
        return this.getValue(false).getData();
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long getHistogramSum() {
        long[] values = this.getHistogramValues();
        long sum = 0L;
        int i2 = 0;
        while (i2 < values.length) {
            sum += values[i2];
            ++i2;
        }
        return sum;
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void error(Throwable error) {
        executeErrorCountUpdater.incrementAndGet(this);
        this.executeErrorLastTime = System.currentTimeMillis();
        this.executeErrorLast = error;
    }

    public long getResultSetHoldTimeMilis() {
        return this.getResultSetHoldTimeNano() / 1000000L;
    }

    public long getExecuteAndResultSetHoldTimeMilis() {
        return this.getExecuteAndResultSetHoldTimeNano() / 1000000L;
    }

    public long[] getFetchRowCountHistogramValues() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateCountHistogramValues() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long[] getExecuteAndResultHoldTimeHistogramValues() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long getExecuteAndResultHoldTimeHistogramSum() {
        long[] values = this.getExecuteAndResultHoldTimeHistogramValues();
        long sum = 0L;
        int i2 = 0;
        while (i2 < values.length) {
            sum += values[i2];
            ++i2;
        }
        return sum;
    }

    public long getResultSetHoldTimeNano() {
        return this.resultSetHoldTimeNano;
    }

    public long getExecuteAndResultSetHoldTimeNano() {
        return this.executeAndResultSetHoldTime;
    }

    public void addResultSetHoldTimeNano(long nano) {
        resultSetHoldTimeNanoUpdater.addAndGet(this, nano);
    }

    public void addResultSetHoldTimeNano(long statementExecuteNano, long resultHoldTimeNano) {
        resultSetHoldTimeNanoUpdater.addAndGet(this, resultHoldTimeNano);
        executeAndResultSetHoldTimeUpdater.addAndGet(this, statementExecuteNano + resultHoldTimeNano);
        this.executeAndResultHoldTimeHistogramRecord((statementExecuteNano + resultHoldTimeNano) / 1000L / 1000L);
        updateCount_0_1_Updater.incrementAndGet(this);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public static Map<String, Object> getData(Object jdbcSqlStat) {
        try {
            if (jdbcSqlStat.getClass() == SqlStat.class) {
                return ((SqlStat)jdbcSqlStat).getData();
            }
            Method method = jdbcSqlStat.getClass().getMethod("getData", new Class[0]);
            Object obj = method.invoke(jdbcSqlStat, new Object[0]);
            return (Map)obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long[] rtrim(long[] array) {
        int notZeroLen = array.length;
        int i2 = array.length - 1;
        while (i2 >= 0) {
            if (array[i2] != 0L) break;
            --i2;
            --notZeroLen;
        }
        if (notZeroLen != array.length) {
            long[] copy = new long[notZeroLen];
            System.arraycopy(array, 0, copy, 0, Math.min(array.length, notZeroLen));
            array = copy;
        }
        return array;
    }
}

