/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.jdbc4.internal.apache.commons.codec.binary.Base64;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class DelegationToken {
    public static int FOUR_BYTES = 4;
    private String m_identifier = null;
    private char[] m_password = null;

    public DelegationToken() {
    }

    public DelegationToken(String string, char[] cArray) {
        this.m_identifier = string;
        this.m_password = cArray;
    }

    public static int decodeLength(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        int n = 0;
        if (by >= -112) {
            return by;
        }
        n = by < -120 ? -(119 + by) : -(111 + by);
        long l = 0L;
        for (int i = 0; i < n - 1; ++i) {
            byte by2 = dataInputStream.readByte();
            l <<= 8;
            l |= (long)(by2 & 0xFF);
        }
        if (by < -120 || by >= -112 && by < 0) {
            return DelegationToken.isInt(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return DelegationToken.isInt(l);
    }

    public static DelegationToken decodeToken(String string) throws IOException {
        String string2 = DelegationToken.makeStandardEncoding(string);
        Base64 base64 = new Base64();
        byte[] byArray = string2.getBytes("UTF-8");
        byte[] byArray2 = base64.decode(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = DelegationToken.decodeLength(dataInputStream);
        byte[] byArray3 = new byte[n];
        dataInputStream.readFully(byArray3);
        n = DelegationToken.decodeLength(dataInputStream);
        byte[] byArray4 = new byte[n];
        dataInputStream.readFully(byArray4);
        String string3 = new String(Base64.encodeBase64(byArray3));
        char[] cArray = new String(Base64.encodeBase64(byArray4)).toCharArray();
        DelegationToken delegationToken = new DelegationToken(string3, cArray);
        return delegationToken;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public char[] getPassword() {
        return this.m_password;
    }

    public void setIdentifier(String string) {
        this.m_identifier = string;
    }

    public void setPassword(char[] cArray) {
        this.m_password = cArray;
    }

    public static String makeStandardEncoding(String string) throws UnsupportedEncodingException {
        String string2 = string.replace("-", "+").replace("_", "/");
        StringBuilder stringBuilder = new StringBuilder(string2);
        int n = string2.getBytes("UTF-8").length % FOUR_BYTES;
        if (0 != n) {
            for (int i = 0; i < FOUR_BYTES - n; ++i) {
                stringBuilder.append("=");
            }
        }
        string2 = stringBuilder.toString();
        return string2;
    }

    private static int isInt(long l) throws IOException {
        if (l < Integer.MAX_VALUE && l > Integer.MIN_VALUE) {
            return (int)l;
        }
        throw new IOException("Value is too long to be an integer");
    }
}

