/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.jdbc.common.HttpErrorCode;
import com.cloudera.impala.jdbc.common.HttpRetrySettings;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class TEHTTPSettings {
    private static final String USER_AGENT_REGEX = "[^\\/\\s]+(\\/\\d+(\\.\\d+)*)? ?(\\([^\\(\\)\\n]*\\))?";
    private static final String THRIFT_SESSION_TAG_HEADER = "X-Thriftserver-Session-Tag";
    private static final String THRIFT_USER_ENTRY = " Java/THttpClient/HC ";
    public boolean m_enableSessionTag = false;
    private Map<String, String> m_customHeaders = null;
    public Map<HttpErrorCode, HttpRetrySettings> m_httpErrorRetrySettings = null;
    public String m_userAgentEntry = TEHTTPSettings.createUserAgentDefault();
    public boolean m_isOAuth;

    public TEHTTPSettings() {
        this.m_httpErrorRetrySettings = new HashMap<HttpErrorCode, HttpRetrySettings>();
        this.m_httpErrorRetrySettings.put(HttpErrorCode.Http503, new HttpRetrySettings(900));
        this.m_httpErrorRetrySettings.put(HttpErrorCode.Http429, new HttpRetrySettings(120));
    }

    public void addCustomHeader(String string, String string2) {
        if (null == this.m_customHeaders) {
            this.m_customHeaders = new HashMap<String, String>();
        }
        this.m_customHeaders.put(string, string2);
    }

    public Map<String, String> getCustomHeaders() {
        return this.m_customHeaders;
    }

    public String removeCustomHeader(String string) {
        if (null != this.m_customHeaders) {
            return this.m_customHeaders.remove(string);
        }
        return null;
    }

    public void removeThriftSessionTag(ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        String string = this.removeCustomHeader(THRIFT_SESSION_TAG_HEADER);
        LogUtilities.logDebug("Removed Thrift session tag in HTTP header: " + string, iLogger);
    }

    public void setLegacyUserAgent() {
        this.m_userAgentEntry = THRIFT_USER_ENTRY;
    }

    public void setCustomHeaders(Map<String, String> map) {
        this.m_customHeaders = map;
    }

    public void setThriftSessionTag(ILogger iLogger) {
        String string = UUID.randomUUID().toString();
        LogUtilities.logDebug("Setting Thrift session tag in HTTP header: " + string, iLogger);
        this.addCustomHeader(THRIFT_SESSION_TAG_HEADER, string);
    }

    public void setUserAgentEntry(Variant variant) throws ErrorException {
        Object object;
        Exception exception = null;
        try {
            object = variant.getString();
            if (this.validUserAgentEntry((String)object)) {
                this.m_userAgentEntry = this.m_userAgentEntry.concat((String)object);
                return;
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.USER_AGENT_ENTRY_ERROR.name(), variant.getString());
        if (null != exception) {
            ((Throwable)object).initCause(exception);
        }
        throw object;
    }

    private static String createUserAgentDefault() {
        String string = MessageFormat.format("{0,number,0}.{1,number,00}.{2,number,00}", 2, 6, 18);
        String string2 = "ImpalaJDBC";
        string2 = string2.replace("JDBC", "JDBCDriver");
        string2 = string2.replaceAll("\\s", "");
        String string3 = "Cloudera" + string2;
        return string3 + "/" + string + THRIFT_USER_ENTRY;
    }

    private boolean validUserAgentEntry(String string) {
        return Pattern.matches(USER_AGENT_REGEX, string);
    }
}

