/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.api;

import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.ServiceDiscoveryMode;
import com.cloudera.impala.hivecommon.api.ServiceDiscoveryFactory;
import com.cloudera.impala.hivecommon.api.ZookeeperDynamicDiscovery;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZooKeeperEnabledExtendedHS2Factory
extends ServiceDiscoveryFactory {
    public static final String PARSEING_REGEX = "(.+):(\\d+)(.*)";
    public static final int IP_INDEX = 1;
    public static final int PORT_INDEX = 2;
    public static final int NAMESPACE_INDEX = 3;
    private int m_zkEndpointIdx = 0;
    private Stack<String> m_hiveServers = new Stack();

    @Override
    public boolean supportServiceDiscoveryMode(ServiceDiscoveryMode serviceDiscoveryMode, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, new Object[]{serviceDiscoveryMode, iLogger});
        switch (serviceDiscoveryMode) {
            case ZOOKEEPER: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getNextServer(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        StringBuilder stringBuilder = new StringBuilder();
        while (0 == stringBuilder.length()) {
            String[] stringArray;
            if (this.m_hiveServers.empty()) {
                this.getServersFromZooKeeper(hiveJDBCSettings, iLogger);
                if (null == this.m_hiveServers) {
                    return null;
                }
            }
            if (2 != (stringArray = this.m_hiveServers.pop().split(":")).length) {
                ErrorException errorException;
                this.m_cacheExp = errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ERROR.name(), new String[]{ServiceDiscoveryMode.ZOOKEEPER.toString()});
                continue;
            }
            stringBuilder.append(stringArray[0] + ":" + stringArray[1]);
        }
        return stringBuilder.toString();
    }

    private void getServersFromZooKeeper(HiveJDBCSettings hiveJDBCSettings, ILogger iLogger) {
        ZookeeperDynamicDiscovery zookeeperDynamicDiscovery = null;
        Pattern pattern = null;
        while (this.m_zkEndpointIdx < hiveJDBCSettings.m_serviceDiscoveryEndpoints.length) {
            Object object;
            try {
                Matcher matcher;
                if (null == zookeeperDynamicDiscovery) {
                    zookeeperDynamicDiscovery = new ZookeeperDynamicDiscovery();
                }
                if (null == pattern) {
                    pattern = Pattern.compile(PARSEING_REGEX);
                }
                if ((matcher = pattern.matcher(hiveJDBCSettings.m_serviceDiscoveryEndpoints[this.m_zkEndpointIdx])).matches()) {
                    object = matcher.group(1);
                    int n = Integer.parseInt(matcher.group(2));
                    String string = matcher.group(3);
                    this.m_hiveServers = zookeeperDynamicDiscovery.retrieveInfoFromZooKeeper((String)object, n, string, hiveJDBCSettings.m_timeout);
                    if (!this.m_hiveServers.empty()) {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                iLogger.logWarning(this.getClass().getPackage().toString(), this.getClass().getName(), "createClient", exception.getMessage());
                this.m_cacheExp = object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DYNAMIC_DISCOVERY_ZOOKEEPER_CONNECTION_ERROR.name(), new String[]{hiveJDBCSettings.m_serviceDiscoveryEndpoints[this.m_zkEndpointIdx], exception.getMessage()});
            }
            ++this.m_zkEndpointIdx;
        }
        this.m_hiveServers = null;
    }
}

