/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.core;

import com.cloudera.impala.dsi.core.impl.DSIStatement;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.dataengine.interfaces.IDataEngine;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCDataEngine;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.exceptions.ErrorException;

public class HiveJDBCStatement
extends DSIStatement {
    private ConnSettingRequestMap m_requestMap;
    private boolean m_isAsyncExecution = false;
    private boolean m_isCanceled = false;

    HiveJDBCStatement(HiveJDBCCommonConnection hiveJDBCCommonConnection, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(hiveJDBCCommonConnection);
        this.m_requestMap = connSettingRequestMap;
    }

    public void cancel() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        this.m_isCanceled = true;
    }

    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        this.m_isCanceled = false;
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
    }

    @Override
    public IDataEngine createDataEngine() throws ErrorException {
        this.clearCancel();
        return new HiveJDBCDataEngine(this, this.m_requestMap);
    }

    public boolean getAsyncExecution() {
        return this.m_isAsyncExecution;
    }

    public boolean isCanceled() {
        return this.m_isCanceled;
    }

    public void setAsyncExecution(boolean bl) {
        this.m_isAsyncExecution = bl;
    }
}

