/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import com.cloudera.impala.dsi.core.impl.DSIDriverSingleton;
import com.cloudera.impala.dsi.core.utilities.ConnSettingRequestMap;
import com.cloudera.impala.dsi.core.utilities.Variant;
import com.cloudera.impala.dsi.core.utilities.Variants;
import com.cloudera.impala.dsi.dataengine.filters.DSIMetadataFilterFactory;
import com.cloudera.impala.dsi.dataengine.filters.IFilter;
import com.cloudera.impala.dsi.dataengine.impl.DSIEmptyMetadataSource;
import com.cloudera.impala.dsi.dataengine.impl.DSITableTypeOnlyMetadataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.impala.dsi.dataengine.interfaces.IQueryExecutor;
import com.cloudera.impala.dsi.dataengine.interfaces.IResultSet;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.impala.dsi.dataengine.utilities.MetadataSourceID;
import com.cloudera.impala.dsi.dataengine.utilities.OrderType;
import com.cloudera.impala.dsi.exceptions.ParsingException;
import com.cloudera.impala.dsi.utilities.DSIMessageKey;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCCoercionHandler;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCDSIExtQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCLimitZeroPreparedStatementMetadataUtils;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCNativeQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCCatalogOnlyMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCCatalogSchemaOnlyMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCColumnsMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCSchemaOnlyMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCTablesMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.HiveJDBCTypeInfoMetadataSource;
import com.cloudera.impala.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.hivecommon.querytranslation.hql.SimpleQueryAnalyzer;
import com.cloudera.impala.jdbc.utils.ParseQueryUtils;
import com.cloudera.impala.sqlengine.SQLEngineGenericContext;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEDelete;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEInsert;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AERowCountStatement;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEStatements;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.AEUpdate;
import com.cloudera.impala.sqlengine.aeprocessor.aetree.statement.IAEStatement;
import com.cloudera.impala.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.cloudera.impala.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.impala.sqlengine.dsiext.dataengine.ICoercionHandler;
import com.cloudera.impala.sqlengine.dsiext.dataengine.OpenTableType;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlDataEngine;
import com.cloudera.impala.sqlengine.dsiext.dataengine.SqlQueryExecutor;
import com.cloudera.impala.sqlengine.dsiext.dataengine.StoredProcedure;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.parser.DefaultLimitChecker;
import com.cloudera.impala.sqlengine.parser.IPTLimitChecker;
import com.cloudera.impala.sqlengine.parser.PTParser;
import com.cloudera.impala.sqlengine.parser.parsetree.AbstractPTNonterminalNode;
import com.cloudera.impala.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.cloudera.impala.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.impala.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.impala.support.LogUtilities;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HiveJDBCDataEngine
extends SqlDataEngine {
    private HiveJDBCSettings m_settings;
    private IHiveClient m_hiveClient;
    private HiveJDBCCommonConnection m_connection;
    private String m_originalQuery;
    private boolean m_isDirectExecuteQuery;
    private HiveJDBCStatement m_statement;
    private ConnSettingRequestMap m_requestMap;
    private String m_cachedCurrentSchema;
    private ArrayList<String> m_restrictionPatterns = null;
    private ArrayList<IFilter> m_filters = null;
    private boolean m_queryTranslationFailed = false;

    public HiveJDBCDataEngine(HiveJDBCStatement hiveJDBCStatement, ConnSettingRequestMap connSettingRequestMap) throws ErrorException {
        super(hiveJDBCStatement);
        this.setProperty(3, Variants.makeWString("N"));
        this.m_requestMap = connSettingRequestMap;
        LogUtilities.logFunctionEntrance(this.getLog(), hiveJDBCStatement);
        this.m_connection = (HiveJDBCCommonConnection)hiveJDBCStatement.getParentConnection();
        this.m_settings = this.m_connection.getSettings();
        this.m_hiveClient = this.m_connection.getHiveClient();
        this.m_isDirectExecuteQuery = false;
        this.m_statement = hiveJDBCStatement;
        try {
            this.initDatabaseMetadataInfo();
        }
        catch (Exception exception) {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.CONN_DEFAULT_PROP_SETTING_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
        }
    }

    @Override
    public ICoercionHandler createCoercionHandler() {
        return new HiveJDBCCoercionHandler(this.m_settings.m_useCustomCoercionMap, this.getLog());
    }

    @Override
    public IResultSet makeNewMetadataResult(MetadataSourceID metadataSourceID, ArrayList<String> arrayList, String string, String string2, boolean bl, OrderType orderType) throws ErrorException {
        if (this.hasCatalogAndSchemaRestrictions(metadataSourceID)) {
            this.convertToCaseInsensitiveCatalogAndSchemaRestrictions(MetadataUtils.CATALOG_PATTERN_IDX, MetadataUtils.SCHEMA_PATTERN_IDX, arrayList);
        }
        if (this.isConvertThirdRestrictionToLowerCase(metadataSourceID)) {
            this.convertRestrictionToLowerCase(2, arrayList);
        }
        if (this.isConvertFourthRestrictionToLowerCase(metadataSourceID)) {
            this.convertRestrictionToLowerCase(3, arrayList);
        }
        this.m_restrictionPatterns = arrayList;
        return super.makeNewMetadataResult(metadataSourceID, arrayList, string, string2, bl, orderType);
    }

    @Override
    public StoredProcedure openProcedure(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, string2, string3);
        return null;
    }

    @Override
    public CustomScalarFunction openScalarFunction(String string, int n) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string, n);
        IHiveCustomScalarFnFactory iHiveCustomScalarFnFactory = this.m_connection.getScalarFnHelper();
        if (null != iHiveCustomScalarFnFactory) {
            return iHiveCustomScalarFnFactory.createScalarFunction(string, n);
        }
        return null;
    }

    @Override
    public DSIExtJResultSet openTable(String string, String string2, String string3, OpenTableType openTableType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{string, string2, string3, openTableType});
        if (null == string2 || "".equals(string2)) {
            string2 = this.m_cachedCurrentSchema;
        }
        return this.m_hiveClient.getTable(string, string2, string3);
    }

    @Override
    public IQueryExecutor prepare(String string) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), string);
        String string2 = string.trim();
        LogUtilities.logInfo("Removing semicolons from query: " + string2, this.getLog());
        string2 = ParseQueryUtils.stripSemiColons(string2);
        Boolean bl = false;
        if (string2.toUpperCase().startsWith("UPSERT")) {
            bl = true;
            string2 = string2.replaceFirst("(?i)UPSERT", "INSERT");
        }
        if (this.m_settings.m_useNativeQuery || string2.isEmpty()) {
            return new HiveJDBCNativeQueryExecutor(this.getLog(), this.m_hiveClient, this.m_statement, string2, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap, bl, this.m_queryTranslationFailed);
        }
        try {
            if (this.m_settings.m_platformVersionUtils.needsInsertOptimization(this.m_settings.m_serverVersion) && this.m_settings.m_optimizedInsert) {
                Object object;
                boolean bl2 = false;
                boolean bl3 = false;
                IPTNode iPTNode = null;
                if (string2.toUpperCase().startsWith("INSERT")) {
                    bl2 = true;
                    object = new DefaultLimitChecker();
                    ((DefaultLimitChecker)object).initLimitCheckValues(this.getParentStatement().getParentConnection());
                    iPTNode = PTParser.parse(string2, (IPTLimitChecker)object);
                    if (null == iPTNode) {
                        throw SQLEngineExceptionFactory.invalidParseTreeException();
                    }
                    LinkedList<IPTNode> linkedList = new LinkedList<IPTNode>();
                    linkedList.add(iPTNode);
                    while (!linkedList.isEmpty()) {
                        IPTNode iPTNode2 = (IPTNode)linkedList.remove();
                        if (!iPTNode2.isTerminalNode()) {
                            if (iPTNode2 instanceof PTNonterminalNode && ((PTNonterminalNode)iPTNode2).getNonterminalType() == PTNonterminalType.SELECT_STATEMENT) {
                                bl2 = false;
                            }
                            Iterator<IPTNode> iterator = ((AbstractPTNonterminalNode)iPTNode2).getChildItr();
                            while (iterator.hasNext()) {
                                IPTNode iPTNode3 = iterator.next();
                                if (null == iPTNode3) {
                                    throw SQLEngineExceptionFactory.invalidParseTreeException();
                                }
                                linkedList.add(iPTNode3);
                            }
                            continue;
                        }
                        if (!(iPTNode2 instanceof PTDynamicParameterNode)) continue;
                        bl3 = true;
                    }
                }
                if (bl2) {
                    try {
                        object = ((HiveJDBCCommonDriver)DSIDriverSingleton.getInstance()).getQueryGenerator();
                        object.generate(iPTNode, this.m_settings, null);
                        return new HiveJDBCNativeQueryExecutor(this.getLog(), this.m_hiveClient, this.m_statement, string2, iPTNode, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap, bl3, bl);
                    }
                    catch (ErrorException errorException) {
                        if (errorException instanceof SQLEngineException) {
                            errorException.loadMessage(SQLEngineGenericContext.getDefaultMsgSource(), this.m_hiveClient.getWarningListener().getLocale());
                            LogUtilities.logWarning(errorException, this.getLog());
                        }
                        if (bl.booleanValue()) {
                            string2 = string2.replaceFirst("(?i)INSERT", "UPSERT");
                        }
                        return this.translateThroughEngine(string2);
                    }
                }
                if (bl.booleanValue()) {
                    string2 = string2.replaceFirst("(?i)INSERT", "UPSERT");
                }
                return this.translateThroughEngine(string2);
            }
            if (bl.booleanValue()) {
                string2 = string2.replaceFirst("(?i)INSERT", "UPSERT");
            }
            return this.translateThroughEngine(string2);
        }
        catch (SQLEngineException sQLEngineException) {
            sQLEngineException.loadMessage(SQLEngineGenericContext.getDefaultMsgSource(), this.m_hiveClient.getWarningListener().getLocale());
            LogUtilities.logWarning(sQLEngineException, this.getLog());
            int n = sQLEngineException.getNativeErrorCode(SQLEngineGenericContext.getDefaultMsgSource(), this.m_hiveClient.getWarningListener().getLocale());
            if (12010 == n && !this.m_settings.m_platformVersionUtils.supportsNestedDataTypes(this.m_settings.m_serverVersion)) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_QUERY_EXE_ERR.name(), new String[]{sQLEngineException.getMessage(), "HY000", string2});
                throw errorException;
            }
            this.m_queryTranslationFailed = true;
            this.m_hiveClient.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), new String[]{sQLEngineException.getMessage()}));
            return new HiveJDBCNativeQueryExecutor(this.getLog(), this.m_hiveClient, this.m_statement, string2, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap, bl, this.m_queryTranslationFailed);
        }
        catch (ParsingException parsingException) {
            CoreUtils.postWarning(parsingException, this.m_hiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name());
            return new HiveJDBCNativeQueryExecutor(this.getLog(), this.m_hiveClient, this.m_statement, string2, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap, bl, this.m_queryTranslationFailed);
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, this.m_hiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.HIVE_TRANSLATION_PREPARE_ERR.name());
            return new HiveJDBCNativeQueryExecutor(this.getLog(), this.m_hiveClient, this.m_statement, string2, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap, bl, this.m_queryTranslationFailed);
        }
    }

    @Override
    public IQueryExecutor prepareBatch(List<String> list) throws ParsingException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), list);
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void setDirectExecute() {
        this.m_isDirectExecuteQuery = true;
    }

    @Override
    protected IMetadataSource makeNewMetadataSource(MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[]{metadataSourceID, map, string, string2, bl});
        this.m_filters = new ArrayList();
        DSIMetadataFilterFactory dSIMetadataFilterFactory = new DSIMetadataFilterFactory(true);
        dSIMetadataFilterFactory.createFilters(metadataSourceID, this.m_restrictionPatterns, string, string2, bl, this.m_filters, map);
        switch (metadataSourceID) {
            case TYPE_INFO: {
                return new HiveJDBCTypeInfoMetadataSource(this.getLog(), this.m_settings);
            }
            case CATALOG_SCHEMA_ONLY: {
                return new HiveJDBCCatalogSchemaOnlyMetadataSource(this.getLog(), this.m_hiveClient);
            }
            case SCHEMA_ONLY: {
                return new HiveJDBCSchemaOnlyMetadataSource(this.getLog());
            }
            case CATALOG_ONLY: {
                return new HiveJDBCCatalogOnlyMetadataSource(this.getLog(), this.m_hiveClient);
            }
            case COLUMNS: {
                return new HiveJDBCColumnsMetadataSource(this.getLog(), map, this.m_restrictionPatterns, this.m_filters, this.m_hiveClient, this.m_settings);
            }
            case TABLES: {
                return new HiveJDBCTablesMetadataSource(this.getLog(), map, this.m_restrictionPatterns, this.m_filters, this.m_hiveClient, this.m_settings);
            }
            case TABLETYPE_ONLY: {
                return new DSITableTypeOnlyMetadataSource(this.getLog());
            }
        }
        return new DSIEmptyMetadataSource(this.getLog());
    }

    @Override
    protected SqlQueryExecutor createQueryExecutor(AEStatements aEStatements) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.getLog(), aEStatements);
        Iterator<IAEStatement> iterator = aEStatements.getStatementItr();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof AERowCountStatement) || object instanceof AEInsert || object instanceof AEUpdate || object instanceof AEDelete) continue;
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), "translation not currently supported");
            throw errorException;
        }
        object = null;
        boolean bl = false;
        if (this.m_settings.m_platformVersionUtils.isDisableLimitZeroForSimpleQuery()) {
            bl = SimpleQueryAnalyzer.isSimpleQuery(aEStatements);
        }
        if (!this.m_isDirectExecuteQuery && this.m_settings.m_preparedStmtGetMetadataLimitZero && !bl) {
            String string = this.m_originalQuery;
            string = HiveJDBCLimitZeroPreparedStatementMetadataUtils.translationLimitZeroQueryBuilder(string, this.m_hiveClient);
            HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata hiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata = new HiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata(this.m_statement, aEStatements, this.getContext(), this.m_hiveClient, this.m_settings, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap);
            return (SqlQueryExecutor)hiveJDBCDataEngineWithLimitZeroPreparedStatementMetadata.prepare(string);
        }
        object = new HiveJDBCDSIExtQueryExecutor(aEStatements, this.getContext(), this.getLog(), this.m_settings, this.m_hiveClient, this.m_statement, this.m_connection, this.m_isDirectExecuteQuery, this.m_requestMap);
        ((SqlQueryExecutor)object).prepareResults();
        return object;
    }

    private void convertToCaseInsensitiveCatalogAndSchemaRestrictions(int n, int n2, ArrayList<String> arrayList) {
        if (this.m_hiveClient.isSwitchRestrict()) {
            arrayList.set(n2, this.convertToCaseInsensitiveCatalogRestriction(arrayList.get(n2)));
            this.convertRestrictionToLowerCase(n, arrayList);
        } else {
            arrayList.set(n, this.convertToCaseInsensitiveCatalogRestriction(arrayList.get(n)));
            this.convertRestrictionToLowerCase(n2, arrayList);
        }
    }

    private void convertRestrictionToLowerCase(int n, ArrayList<String> arrayList) {
        if (null != arrayList.get(n)) {
            arrayList.set(n, arrayList.get(n).toLowerCase());
        }
    }

    private String convertToCaseInsensitiveCatalogRestriction(String string) {
        String string2 = string;
        if (null != string2 && 0 != string2.length()) {
            string2 = string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
        }
        return string2;
    }

    private boolean hasCatalogAndSchemaRestrictions(MetadataSourceID metadataSourceID) {
        return MetadataSourceID.TABLES == metadataSourceID || MetadataSourceID.TABLE_PRIVILEGES == metadataSourceID || MetadataSourceID.COLUMNS == metadataSourceID || MetadataSourceID.COLUMN_PRIVILEGES == metadataSourceID || MetadataSourceID.FOREIGN_KEYS == metadataSourceID || MetadataSourceID.PRIMARY_KEYS == metadataSourceID || MetadataSourceID.STATISTICS == metadataSourceID || MetadataSourceID.PROCEDURES == metadataSourceID || MetadataSourceID.PROCEDURE_COLUMNS == metadataSourceID || MetadataSourceID.CATALOG_SCHEMA_ONLY == metadataSourceID || MetadataSourceID.FUNCTIONS_JDBC4 == metadataSourceID || MetadataSourceID.FUNCTION_COLUMNS_JDBC4 == metadataSourceID;
    }

    private void initDatabaseMetadataInfo() throws Exception {
        if (null != this.m_hiveClient.getDatabaseMetadataInfo().getDbmdProductName() && null != this.m_hiveClient.getDatabaseMetadataInfo().getDbmdProductVersion()) {
            this.m_connection.setProperty(41, new Variant(0, this.m_hiveClient.getDatabaseMetadataInfo().getDbmdProductName()));
            this.m_connection.setProperty(42, new Variant(0, this.m_hiveClient.getDatabaseMetadataInfo().getDbmdProductVersion()));
        }
    }

    private boolean isConvertFourthRestrictionToLowerCase(MetadataSourceID metadataSourceID) {
        return MetadataSourceID.COLUMNS == metadataSourceID || MetadataSourceID.COLUMN_PRIVILEGES == metadataSourceID || MetadataSourceID.SPECIAL_COLUMNS == metadataSourceID || MetadataSourceID.PROCEDURE_COLUMNS == metadataSourceID || MetadataSourceID.FUNCTION_COLUMNS_JDBC4 == metadataSourceID;
    }

    private boolean isConvertThirdRestrictionToLowerCase(MetadataSourceID metadataSourceID) {
        return MetadataSourceID.TABLES == metadataSourceID || MetadataSourceID.TABLE_PRIVILEGES == metadataSourceID || MetadataSourceID.COLUMNS == metadataSourceID || MetadataSourceID.COLUMN_PRIVILEGES == metadataSourceID || MetadataSourceID.FOREIGN_KEYS == metadataSourceID || MetadataSourceID.PRIMARY_KEYS == metadataSourceID || MetadataSourceID.STATISTICS == metadataSourceID || MetadataSourceID.PROCEDURES == metadataSourceID || MetadataSourceID.PROCEDURE_COLUMNS == metadataSourceID || MetadataSourceID.FUNCTIONS_JDBC4 == metadataSourceID || MetadataSourceID.FUNCTION_COLUMNS_JDBC4 == metadataSourceID;
    }

    private IQueryExecutor translateThroughEngine(String string) throws ErrorException {
        this.m_originalQuery = string;
        this.m_cachedCurrentSchema = this.m_hiveClient.getCurrentSchema();
        return super.prepare(string);
    }
}

