/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.dataengine;

import com.cloudera.impala.hivecommon.api.IHiveClient;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCQueryAnalyserUtils;
import com.cloudera.impala.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.impala.support.Warning;
import com.cloudera.impala.support.WarningCode;

public class HiveJDBCLimitZeroPreparedStatementMetadataUtils {
    private static final String SELECT_CASE = "SELECT";
    private static String WITH_CASE = "WITH";

    public static String nativeLimitZeroQueryBuilder(String string, IHiveClient iHiveClient) {
        String string2 = string.trim().toUpperCase();
        if (string2.startsWith(WITH_CASE)) {
            string2 = HiveJDBCQueryAnalyserUtils.removeWithExpression(string);
        }
        if (!string2.startsWith(SELECT_CASE)) {
            return string;
        }
        String[] stringArray = string2.trim().split("\\s+");
        String string3 = "";
        try {
            String string4;
            Integer.parseInt(stringArray[stringArray.length - 1].trim());
            int n = 0;
            for (int i = 1; i < stringArray.length - 1 && !(string4 = stringArray[stringArray.length - 1 - i]).contains("LIMIT"); ++i) {
                if (!string4.equals("") && !string4.contains("\n") && !string4.contains("\t")) continue;
                ++n;
            }
            if (stringArray[stringArray.length - 2 - n].trim().toUpperCase().contains("LIMIT")) {
                stringArray[stringArray.length - 1] = "0";
                for (String string5 : stringArray) {
                    string3 = string3 + string5 + " ";
                }
            } else {
                string3 = string + " LIMIT 0";
            }
        }
        catch (NumberFormatException numberFormatException) {
            iHiveClient.getWarningListener().postWarning(new Warning(WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), new String[]{"query not ending with number, limit 0 is attached"}));
            string = string + " LIMIT 0";
            return string;
        }
        catch (Exception exception) {
            CoreUtils.postWarning(exception, iHiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), "query is not valid");
            return string;
        }
        return string3;
    }

    public static String translationLimitZeroQueryBuilder(String string, IHiveClient iHiveClient) {
        String string2;
        block15: {
            String string3 = string.trim().toUpperCase();
            if (string3.startsWith(WITH_CASE)) {
                string3 = HiveJDBCQueryAnalyserUtils.removeWithExpression(string);
            }
            if (!string3.startsWith(SELECT_CASE)) {
                return string;
            }
            String[] stringArray = string.trim().split("\\s+");
            string2 = "";
            try {
                if (stringArray[1].trim().toUpperCase().equals("TOP")) {
                    try {
                        Integer.parseInt(stringArray[2].trim());
                        stringArray[2] = "0";
                        for (String string4 : stringArray) {
                            string2 = string2 + string4 + " ";
                        }
                        break block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        CoreUtils.postWarning(numberFormatException, iHiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), "query is not valid");
                        return string;
                    }
                }
                if (stringArray[1].trim().toUpperCase().equals("DISTINCT")) {
                    if (stringArray[2].trim().toUpperCase().equals("TOP")) {
                        try {
                            Integer.parseInt(stringArray[3].trim());
                            stringArray[3] = "0";
                            for (String string5 : stringArray) {
                                string2 = string2 + string5 + " ";
                            }
                            break block15;
                        }
                        catch (NumberFormatException numberFormatException) {
                            CoreUtils.postWarning(numberFormatException, iHiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), "query is not valid");
                            return string;
                        }
                    }
                    string2 = string2 + stringArray[0] + " " + stringArray[1] + " TOP 0 ";
                    for (int i = 2; i < stringArray.length; ++i) {
                        string2 = string2 + stringArray[i] + " ";
                    }
                    break block15;
                }
                string2 = string2 + stringArray[0] + " TOP 0 ";
                for (int i = 1; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
            }
            catch (Exception exception) {
                CoreUtils.postWarning(exception, iHiveClient.getWarningListener(), WarningCode.GENERAL_WARNING, 101, HiveJDBCMessageKey.DATABASE_TABLE_GENERAL_ERR.name(), "query is not valid");
                return string;
            }
        }
        return string2;
    }
}

