/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.jdbc4;

import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.impala.hivecommon.HiveJDBCSettings;
import com.cloudera.impala.hivecommon.core.CoreUtils;
import com.cloudera.impala.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.impala.hivecommon.jdbc4.Hive4ForwardResultSet;
import com.cloudera.impala.jdbc.common.SConnection;
import com.cloudera.impala.jdbc.common.SStatement;
import com.cloudera.impala.jdbc.jdbc4.S4PreparedStatement;
import com.cloudera.impala.support.LogUtilities;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Hive4PreparedStatement
extends S4PreparedStatement {
    public Hive4PreparedStatement(String string, HiveJDBCStatement hiveJDBCStatement, SConnection sConnection, int n) throws SQLException {
        super(string, hiveJDBCStatement, sConnection, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        super.cancel();
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_statement instanceof HiveJDBCStatement && this.m_isInCancelableFunction) {
                ((HiveJDBCStatement)this.m_statement).cancel();
            }
        }
    }

    public boolean getAsyncExecution() {
        return ((HiveJDBCStatement)this.m_statement).getAsyncExecution();
    }

    public HiveJDBCSettings getSettings() throws SQLException {
        Connection connection = this.getConnection();
        if (connection instanceof HiveJDBCCommonConnection) {
            return ((HiveJDBCCommonConnection)((Object)connection)).getSettings();
        }
        return null;
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        super.setBigDecimal(n, bigDecimal);
        CoreUtils.alterBigDecimalMetadata(n, bigDecimal, this.m_setMetadata, this.getSettings());
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object);
        if (!CoreUtils.setBigDecimalObject(this, n, object, this.getSettings())) {
            super.setObject(n, object);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
        if (!CoreUtils.setBigDecimalObject(this, n, object, this.getSettings())) {
            super.setObject(n, object, n2);
        }
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        ResultSet resultSet = null;
        if (this.getAsyncExecution() && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive4ForwardResultSet((SStatement)this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger);
            resultSet.setFetchSize(this.getFetchSize());
        } else {
            resultSet = super.createResultSet(executionResult);
        }
        return resultSet;
    }
}

