/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.hivecommon.jdbc4;

import com.cloudera.impala.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.impala.hivecommon.core.HiveJDBCStatement;
import com.cloudera.impala.hivecommon.core.IHadoopStatement;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCDSIExtQueryExecutor;
import com.cloudera.impala.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.impala.hivecommon.jdbc4.Hive4ForwardResultSet;
import com.cloudera.impala.jdbc.common.SConnection;
import com.cloudera.impala.jdbc.common.SStatement;
import com.cloudera.impala.jdbc.jdbc4.S4Statement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Hive4Statement
extends S4Statement
implements IHadoopStatement {
    public Hive4Statement(HiveJDBCStatement hiveJDBCStatement, SConnection sConnection, int n) {
        super(hiveJDBCStatement, sConnection, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        super.cancel();
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_statement instanceof HiveJDBCStatement && this.m_isInCancelableFunction) {
                ((HiveJDBCStatement)this.m_statement).cancel();
            }
        }
    }

    @Override
    public synchronized ResultSet executeAsync(String string) throws SQLException {
        this.setAsyncExecution(true);
        return super.executeQuery(string);
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.setAsyncExecution(false);
        return super.executeQuery(string);
    }

    public boolean getAsyncExecution() {
        return ((HiveJDBCStatement)this.m_statement).getAsyncExecution();
    }

    public void setAsyncExecution(boolean bl) {
        ((HiveJDBCStatement)this.m_statement).setAsyncExecution(bl);
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        ResultSet resultSet = null;
        if (this.getAsyncExecution() && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive4ForwardResultSet((SStatement)this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger);
            resultSet.setFetchSize(this.getFetchSize());
        } else {
            resultSet = super.createResultSet(executionResult);
        }
        return resultSet;
    }

    @Override
    public String getYarnATSGuid() {
        if (null != this.m_queryExecutor && this.m_queryExecutor instanceof HiveJDBCDSIExtQueryExecutor) {
            return ((HiveJDBCDSIExtQueryExecutor)this.m_queryExecutor).getYarnATSGuid();
        }
        return null;
    }
}

