/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.impala.dataengine;

import com.cloudera.impala.dsi.dataengine.utilities.ColumnMetadata;
import com.cloudera.impala.dsi.dataengine.utilities.TypeMetadata;
import com.cloudera.impala.hivecommon.dataengine.IHiveCustomScalarFnFactory;
import com.cloudera.impala.impala.dataengine.ImpalaCustomScalarFunction;
import com.cloudera.impala.sqlengine.aeprocessor.aebuilder.value.AEScalarFnMetadataFactory;
import com.cloudera.impala.sqlengine.dsiext.dataengine.CustomScalarFunction;
import com.cloudera.impala.sqlengine.dsiext.dataengine.utils.ScalarFunctionArgType;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ImpalaCustomScalarHelper
implements IHiveCustomScalarFnFactory {
    @Override
    public CustomScalarFunction createScalarFunction(String string, int n) throws ErrorException {
        ImpalaFnID impalaFnID;
        try {
            impalaFnID = ImpalaFnID.valueOf(string.toLowerCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return new ImpalaCustomScalarFunction(string, this.createCustomMetadata(string, n, impalaFnID));
    }

    protected AEScalarFnMetadataFactory.ScalarFnMetadata createCustomMetadata(String string, int n, ImpalaFnID impalaFnID) throws ErrorException {
        AEScalarFnMetadataFactory.ScalarFnMetadata scalarFnMetadata;
        switch (impalaFnID) {
            case appx_median: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAppxMedianMetadata();
                break;
            }
            case group_concat: {
                if (1 != n && 2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createGroupConcatMetadata(n);
                break;
            }
            case ndv: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNDVMetadata();
                break;
            }
            case variance: 
            case variance_samp: 
            case variance_pop: 
            case var_samp: 
            case stddev_samp: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createVarianceMetadata();
                break;
            }
            case typeof: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTypeOfMetadata();
                break;
            }
            case bitand: 
            case bitor: 
            case bitxor: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBitOpMetadata();
                break;
            }
            case bitnot: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBitNotMetadata();
                break;
            }
            case countset: {
                if (1 != n && 2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCountSetMetadata(n);
                break;
            }
            case getbit: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createGetBitMetadata();
                break;
            }
            case rotateleft: 
            case rotateright: 
            case shiftleft: 
            case shiftright: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRotateShiftMetadata();
                break;
            }
            case setbit: {
                if (2 != n && 3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSetBitMetadata(n);
                break;
            }
            case decode: {
                if (3 > n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDecodeMetadata(n);
                break;
            }
            case isnull: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIfNullMetadata();
                break;
            }
            case isfalse: 
            case isnotfalse: 
            case istrue: 
            case isnottrue: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIsBooleanMetadata();
                break;
            }
            case nonnullvalue: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNonNullValueMetadata();
                break;
            }
            case nullifzero: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNullIfZeroMetadata();
                break;
            }
            case nullvalue: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNullValueMetadata();
                break;
            }
            case nvl: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNvlMetadata();
                break;
            }
            case zeroifnull: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createZeroIfNullMetadata();
                break;
            }
            case btrim: {
                if (1 != n && 2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBTrimMetadata(n);
                break;
            }
            case character_length: 
            case char_length: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLengthMetadata();
                break;
            }
            case chr: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createChrMetadata();
                break;
            }
            case concat_ws: {
                if (3 > n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConcatWSMetadata(n);
                break;
            }
            case find_in_set: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFindInSetMetadata();
                break;
            }
            case initcap: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createInitCapMetadata();
                break;
            }
            case instr: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createInStrMetadata();
                break;
            }
            case lpad: 
            case rpad: {
                if (3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPadMetadata();
                break;
            }
            case parse_url: {
                if (2 != n && 3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createParseUrlMetadata(n);
                break;
            }
            case regexp_extract: {
                if (3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRegExpExtractMetadata();
                break;
            }
            case regexp_like: {
                if (2 != n && 3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createRegExpLikeMetadata(n);
                break;
            }
            case regexp_replace: {
                if (3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createReplaceMetadata();
                break;
            }
            case reverse: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createReverseMetadata();
                break;
            }
            case split_part: {
                if (3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSplitPartMetadata();
                break;
            }
            case strleft: 
            case strright: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createStrShiftMetadata();
                break;
            }
            case substr: {
                if (2 == n || 3 == n) {
                    scalarFnMetadata = this.createSubstringMetadata(n);
                    break;
                }
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            case translate: {
                if (3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTranslateMetadata();
                break;
            }
            case trim: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLTrimMetadata();
                break;
            }
            case bin: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createBinMetadata();
                break;
            }
            case ceil: 
            case dceil: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCeilMetadata();
                break;
            }
            case conv: {
                if (3 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createConvMetadata();
                break;
            }
            case cosh: 
            case sinh: 
            case tanh: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createCoshMetadata();
                break;
            }
            case e: {
                if (0 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createEMetadata();
                break;
            }
            case dexp: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExpMetadata();
                break;
            }
            case factorial: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFactorialMetadata();
                break;
            }
            case dfloor: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFloorMetadata();
                break;
            }
            case fmod: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createModMetadata();
                break;
            }
            case fnv_hash: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFnvHashMetadata();
                break;
            }
            case greatest: 
            case least: {
                if (n < 1) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createGreatestMetadata(n);
                break;
            }
            case hex: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createHexMetadata();
                break;
            }
            case is_inf: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIsInfMetadata();
                break;
            }
            case is_nan: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIsNaNMetadata();
                break;
            }
            case ln: 
            case dlog1: 
            case log2: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createLogBaseMetadata();
                break;
            }
            case max_int: 
            case min_int: {
                if (0 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinIntMetadata();
                break;
            }
            case max_tinyint: 
            case min_tinyint: {
                if (0 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinTinyIntMetadata();
                break;
            }
            case max_smallint: 
            case min_smallint: {
                if (0 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinSmallIntMetadata();
                break;
            }
            case max_bigint: 
            case min_bigint: {
                if (0 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMaxMinBigIntMetadata();
                break;
            }
            case negative: 
            case positive: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createNegativeMetadata();
                break;
            }
            case pmod: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createModMetadata();
                break;
            }
            case pow: 
            case dpow: 
            case fpow: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPowerMetadata();
                break;
            }
            case precision: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createPrecisionMetadata();
                break;
            }
            case quotient: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createQuotientMetadata();
                break;
            }
            case random: {
                if (0 == n || 1 == n) {
                    scalarFnMetadata = this.createRandMetadata(n);
                    break;
                }
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            case dround: {
                if (1 == n || 2 == n) {
                    scalarFnMetadata = this.createRoundMetadata(n);
                    break;
                }
                throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
            }
            case scale: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createScaleMetadata();
                break;
            }
            case dsqrt: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createSqrtMetadata();
                break;
            }
            case unhex: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUnhexMetadata();
                break;
            }
            case add_months: 
            case adddate: 
            case date_add: 
            case date_sub: 
            case days_add: 
            case days_sub: 
            case hours_add: 
            case hours_sub: 
            case microseconds_add: 
            case microseconds_sub: 
            case milliseconds_add: 
            case milliseconds_sub: 
            case minutes_add: 
            case minutes_sub: 
            case months_add: 
            case months_sub: 
            case nanoseconds_add: 
            case nanoseconds_sub: 
            case seconds_add: 
            case seconds_sub: 
            case subdate: 
            case weeks_add: 
            case weeks_sub: 
            case years_add: 
            case years_sub: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createAlterDateMetadata();
                break;
            }
            case date_part: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDatePartMetadata();
                break;
            }
            case datediff: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDateDiffMetadata();
                break;
            }
            case day: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createDayOfMonthMetadata();
                break;
            }
            case extract: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createExtractMetadata();
                break;
            }
            case from_unixtime: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFromUnixTimeMetadata();
                break;
            }
            case from_utc_timestamp: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createFromUTCTimestampMetadata();
                break;
            }
            case int_months_between: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createIntMonthsBetweenMetadata();
                break;
            }
            case millisecond: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMillisecondMetadata();
                break;
            }
            case months_between: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createMonthsBetweenMetadata();
                break;
            }
            case timeofday: {
                if (0 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTimeOfDayMetadata();
                break;
            }
            case timestamp_cmp: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTimestampCmpMetadata();
                break;
            }
            case to_date: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createToDateMetadata();
                break;
            }
            case to_utc_timestamp: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createToUTCTimestampMetadata();
                break;
            }
            case trunc: {
                if (2 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createTruncMetadata();
                break;
            }
            case unix_timestamp: {
                if (0 < n && n > 2) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createUnixTimestampMetadata(n);
                break;
            }
            case weekofyear: {
                if (1 != n) {
                    throw SQLEngineExceptionFactory.invalidScalarFnArgumentCountException(string);
                }
                scalarFnMetadata = this.createWeekOfYearMetadata();
                break;
            }
            default: {
                scalarFnMetadata = null;
            }
        }
        return scalarFnMetadata;
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createAppxMedianMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNullMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createGroupConcatMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        if (2 == n) {
            arrayList.add(this.createStringMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createNDVMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createVarianceMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createTypeOfMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createBitNotMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), Arrays.asList(this.createNumericMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createBitOpMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        arrayList.add(this.createNumericMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createCountSetMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        if (2 == n) {
            arrayList.add(this.createIntegerMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createGetBitMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        arrayList.add(this.createIntegerMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createRotateShiftMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        arrayList.add(this.createIntegerMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createSetBitMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        arrayList.add(this.createIntegerMetadata());
        if (3 == n) {
            arrayList.add(this.createIntegerMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createDecodeMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.createNullMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNullMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createIfNullMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNullMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createIsBooleanMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBooleanMetadata(), Arrays.asList(this.createBooleanMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createNonNullValueMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNullMetadata(), Arrays.asList(this.createBooleanMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createNullIfZeroMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createNumericMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createNullValueMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBooleanMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createNvlMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBooleanMetadata(), Arrays.asList(this.createNullMetadata(), this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createZeroIfNullMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createNumericMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createBTrimMetadata(int n) throws ErrorException {
        if (1 == n) {
            return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createStringMetadata()));
        }
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createChrMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createIntegerMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createConcatWSMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.createStringMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createFindInSetMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createInitCapMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createInStrMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createLengthMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createLTrimMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createPadMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntegerMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createParseUrlMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        if (3 == n) {
            arrayList.add(this.createStringMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createRegExpExtractMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntegerMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createRegExpLikeMetadata(int n) throws ErrorException {
        TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(16);
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        if (3 == n) {
            arrayList.add(this.createStringMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(new ColumnMetadata(typeMetadata), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createBinMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createReplaceMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createReverseMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createSplitPartMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createBigIntMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createStrShiftMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntegerMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createSubstringMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createIntegerMetadata());
        if (3 == n) {
            arrayList.add(this.createIntegerMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createTranslateMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createCeilMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createBigIntMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createConvMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNullMetadata());
        arrayList.add(this.createIntegerMetadata());
        arrayList.add(this.createIntegerMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createCoshMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createEMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Collections.emptyList());
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createExpMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createFnvHashMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createFactorialMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), Arrays.asList(this.createNumericMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createGreatestMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.createNullMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNullMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createFloorMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createHexMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createNullMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createIsInfMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBooleanMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createModMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        arrayList.add(this.createNumericMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createIsNaNMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBooleanMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createLogBaseMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createMaxMinBigIntMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), Collections.emptyList());
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createMaxMinIntMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), Collections.emptyList());
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createMaxMinSmallIntMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createSmallIntMetadata(), Collections.emptyList());
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createMaxMinTinyIntMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTinyIntMetadata(), Collections.emptyList());
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createNegativeMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), Arrays.asList(this.createNumericMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createPowerMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createDoubleMetadata());
        arrayList.add(this.createDoubleMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createPrecisionMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), Arrays.asList(this.createNumericMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createQuotientMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createNumericMetadata());
        arrayList.add(this.createNumericMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createRandMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        if (1 == n) {
            arrayList.add(this.createIntegerMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createScaleMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createNumericMetadata(), Arrays.asList(this.createIntegerMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createSqrtMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), Arrays.asList(this.createDoubleMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createRoundMetadata(int n) throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createDoubleMetadata());
        if (2 == n) {
            arrayList.add(this.createIntegerMetadata());
        }
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createUnhexMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createAlterDateMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createNumericMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createDateDiffMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createDatePartMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createStringMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createExtractMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createDayOfMonthMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), Arrays.asList(this.createIntegerMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createFromUnixTimeMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createBigIntMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createFromUTCTimestampMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createIntMonthsBetweenMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createMillisecondMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), Arrays.asList(this.createIntegerMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createMonthsBetweenMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createDoubleMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createTimeOfDayMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createStringMetadata(), Collections.emptyList());
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createTimestampCmpMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createTimestampMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createIntegerMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createToDateMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), Arrays.asList(this.createStringMetadata()));
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createToUTCTimestampMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createTruncMetadata() throws ErrorException {
        ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
        arrayList.add(this.createTimestampMetadata());
        arrayList.add(this.createStringMetadata());
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), arrayList);
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createUnixTimestampMetadata(int n) throws ErrorException {
        if (0 == n) {
            return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), Collections.emptyList());
        }
        if (1 == n) {
            return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), Arrays.asList(this.createNullMetadata()));
        }
        if (2 == n) {
            ArrayList<ColumnMetadata> arrayList = new ArrayList<ColumnMetadata>();
            arrayList.add(this.createStringMetadata());
            arrayList.add(this.createStringMetadata());
            return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createBigIntMetadata(), arrayList);
        }
        return null;
    }

    private AEScalarFnMetadataFactory.ScalarFnMetadata createWeekOfYearMetadata() throws ErrorException {
        return new AEScalarFnMetadataFactory.ScalarFnMetadata(this.createTimestampMetadata(), Arrays.asList(this.createIntegerMetadata()));
    }

    protected ColumnMetadata createBigIntMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(-5));
    }

    protected ColumnMetadata createBooleanMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(16));
    }

    protected ColumnMetadata createDoubleMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(8));
    }

    protected ColumnMetadata createIntegerMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(4));
    }

    protected ColumnMetadata createNullMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(0));
    }

    protected ColumnMetadata createNumericMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(2));
    }

    protected ColumnMetadata createStringMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(12));
    }

    protected ColumnMetadata createSmallIntMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(5));
    }

    protected ColumnMetadata createTimestampMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(93));
    }

    protected ColumnMetadata createTinyIntMetadata() throws ErrorException {
        return new ColumnMetadata(TypeMetadata.createTypeMetadata(-6));
    }

    private static enum ImpalaFnID {
        add_months(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        adddate(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        date_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        date_part(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        date_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        datediff(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        day(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        days_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        days_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        extract(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        from_unixtime(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_STRING),
        from_utc_timestamp(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        hours_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        hours_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        int_months_between(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        microseconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        microseconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        millisecond(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        milliseconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        milliseconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        minutes_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        minutes_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        months_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        months_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        months_between(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        nanoseconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        nanoseconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        seconds_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        seconds_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        subdate(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        timeofday,
        timestamp_cmp(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        to_date(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        to_utc_timestamp(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        trunc(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_STRING),
        unix_timestamp0,
        unix_timestamp1str(ScalarFunctionArgType.FN_ARG_STRING),
        unix_timestamp1time(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        unix_timestamp2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        unix_timestamp(unix_timestamp0, unix_timestamp1str, unix_timestamp1time, unix_timestamp2),
        weekofyear(ScalarFunctionArgType.FN_ARG_TIMESTAMP),
        weeks_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        weeks_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        years_add(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        years_sub(ScalarFunctionArgType.FN_ARG_TIMESTAMP, ScalarFunctionArgType.FN_ARG_INTEGER),
        bin(ScalarFunctionArgType.FN_ARG_INTEGER),
        ceil(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dceil(ScalarFunctionArgType.FN_ARG_NUMERIC),
        convstr(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        convbigint(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        conv(convbigint, convstr),
        cosh(ScalarFunctionArgType.FN_ARG_NUMERIC),
        e,
        dexp(ScalarFunctionArgType.FN_ARG_NUMERIC),
        factorial(ScalarFunctionArgType.FN_ARG_INTEGER),
        dfloor(ScalarFunctionArgType.FN_ARG_NUMERIC),
        fmod(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        fnv_hash(ScalarFunctionArgType.FN_ARG_ANY),
        greatest(ScalarFunctionArgType.FN_ARG_ANY, false),
        hexstr(ScalarFunctionArgType.FN_ARG_STRING),
        hexbigint(ScalarFunctionArgType.FN_ARG_INTEGER),
        hex(hexstr, hexbigint),
        is_inf(ScalarFunctionArgType.FN_ARG_NUMERIC),
        is_nan(ScalarFunctionArgType.FN_ARG_NUMERIC),
        least(ScalarFunctionArgType.FN_ARG_ANY, false),
        ln(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dlog1(ScalarFunctionArgType.FN_ARG_NUMERIC),
        log2(ScalarFunctionArgType.FN_ARG_NUMERIC),
        max_int,
        max_tinyint,
        max_bigint,
        max_smallint,
        min_bigint,
        min_int,
        min_tinyint,
        min_smallint,
        negative(ScalarFunctionArgType.FN_ARG_NUMERIC),
        pmod(ScalarFunctionArgType.FN_ARG_SLC, ScalarFunctionArgType.FN_ARG_SLC),
        positive(ScalarFunctionArgType.FN_ARG_NUMERIC),
        pow(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        dpow(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        fpow(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_NUMERIC),
        precision(ScalarFunctionArgType.FN_ARG_NUMERIC),
        quotient(ScalarFunctionArgType.FN_ARG_SLC, ScalarFunctionArgType.FN_ARG_SLC),
        random0,
        random1(ScalarFunctionArgType.FN_ARG_INTEGER),
        random(random0, random1),
        dround1(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dround2(ScalarFunctionArgType.FN_ARG_NUMERIC, ScalarFunctionArgType.FN_ARG_INTEGER),
        dround(dround1, dround2),
        scale(ScalarFunctionArgType.FN_ARG_NUMERIC),
        sinh(ScalarFunctionArgType.FN_ARG_NUMERIC),
        dsqrt(ScalarFunctionArgType.FN_ARG_NUMERIC),
        tanh(ScalarFunctionArgType.FN_ARG_NUMERIC),
        unhex(ScalarFunctionArgType.FN_ARG_STRING),
        btrim1(ScalarFunctionArgType.FN_ARG_STRING),
        btrim2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        btrim(btrim1, btrim2),
        char_length(ScalarFunctionArgType.FN_ARG_STRING),
        character_length(ScalarFunctionArgType.FN_ARG_STRING),
        chr(ScalarFunctionArgType.FN_ARG_INTEGER),
        concat_ws(ScalarFunctionArgType.FN_ARG_STRING, false),
        find_in_set(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        initcap(ScalarFunctionArgType.FN_ARG_STRING),
        instr(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        lpad(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_STRING),
        parse_url2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        parse_url3(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        parse_url(parse_url2, parse_url3),
        regexp_extract(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        regexp_like2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        regexp_like3(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        regexp_like(regexp_like2, regexp_like3),
        regexp_replace(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        reverse(ScalarFunctionArgType.FN_ARG_STRING),
        rpad(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_STRING),
        split_part(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        substr2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        substr3(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        substr(substr2, substr3),
        strleft(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        strright(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_INTEGER),
        translate(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        trim(ScalarFunctionArgType.FN_ARG_STRING),
        decode(ScalarFunctionArgType.FN_ARG_ANY, false),
        isnull(ScalarFunctionArgType.FN_ARG_ANY, ScalarFunctionArgType.FN_ARG_ANY),
        isfalse(ScalarFunctionArgType.FN_ARG_ANY),
        isnotfalse(ScalarFunctionArgType.FN_ARG_ANY),
        istrue(ScalarFunctionArgType.FN_ARG_ANY),
        isnottrue(ScalarFunctionArgType.FN_ARG_ANY),
        nonnullvalue(ScalarFunctionArgType.FN_ARG_ANY),
        nullifzero(ScalarFunctionArgType.FN_ARG_NUMERIC),
        nullvalue(ScalarFunctionArgType.FN_ARG_ANY),
        nvl(ScalarFunctionArgType.FN_ARG_ANY, ScalarFunctionArgType.FN_ARG_ANY),
        zeroifnull(ScalarFunctionArgType.FN_ARG_NUMERIC),
        bitand(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        bitnot(ScalarFunctionArgType.FN_ARG_INTEGER),
        bitor(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        bitxor(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        countset2(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        countset1(ScalarFunctionArgType.FN_ARG_INTEGER),
        countset(countset1, countset2),
        getbit(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        rotateleft(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        rotateright(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        setbit2(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        setbit3(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        setbit(setbit2, setbit3),
        shiftleft(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        shiftright(ScalarFunctionArgType.FN_ARG_INTEGER, ScalarFunctionArgType.FN_ARG_INTEGER),
        typeof(ScalarFunctionArgType.FN_ARG_ANY),
        appx_median(ScalarFunctionArgType.FN_ARG_ANY),
        group_concat1(ScalarFunctionArgType.FN_ARG_STRING),
        group_concat2(ScalarFunctionArgType.FN_ARG_STRING, ScalarFunctionArgType.FN_ARG_STRING),
        group_concat(group_concat1, group_concat2),
        ndv(ScalarFunctionArgType.FN_ARG_ANY),
        variance(ScalarFunctionArgType.FN_ARG_SLC),
        variance_samp(ScalarFunctionArgType.FN_ARG_SLC),
        variance_pop(ScalarFunctionArgType.FN_ARG_SLC),
        var_samp(ScalarFunctionArgType.FN_ARG_SLC),
        stddev_samp(ScalarFunctionArgType.FN_ARG_SLC);

        private List<ScalarFunctionArgType> m_args;
        private List<ImpalaFnID> m_functions;
        private boolean m_limitSize = true;

        private ImpalaFnID() {
            this.m_args = Collections.unmodifiableList(Collections.emptyList());
        }

        private ImpalaFnID(ImpalaFnID ... impalaFnIDArray) {
            this.m_functions = Collections.unmodifiableList(Arrays.asList(impalaFnIDArray));
        }

        private ImpalaFnID(ScalarFunctionArgType ... scalarFunctionArgTypeArray) {
            this.m_args = Collections.unmodifiableList(Arrays.asList(scalarFunctionArgTypeArray));
        }

        private ImpalaFnID(ScalarFunctionArgType scalarFunctionArgType, boolean bl) {
            this.m_limitSize = bl;
            this.m_args = Collections.unmodifiableList(Arrays.asList(scalarFunctionArgType));
        }

        public List<ScalarFunctionArgType> getArguments() {
            return this.m_args;
        }

        public List<ImpalaFnID> getFunctions() {
            return this.m_functions;
        }

        public boolean getSizeLimits() {
            return this.m_limitSize;
        }
    }
}

