/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc.common;

import com.cloudera.impala.jdbc.common.DSTrustManager;
import com.cloudera.impala.jdbc.common.SSLSettings;
import com.cloudera.impala.jdbc.common.SSLTransportParameters;
import com.cloudera.impala.jdbc.core.DSDriver;
import com.cloudera.impala.jdbc.exceptions.CommonJDBCMessageKey;
import com.cloudera.impala.jdbc4.internal.apache.http.conn.ssl.SSLSocketFactory;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;

public class CommonUtils {
    private static final String PROTOCOL_SSL = "SSL";

    public static SSLSocketFactory getSocketFactory(String string, SSLSettings sSLSettings) throws ErrorException {
        SSLTransportParameters sSLTransportParameters = CommonUtils.createSSLTransportParams(sSLSettings);
        if (null == sSLTransportParameters) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_SSL_PARAMS_NOT_SET.name());
            throw errorException;
        }
        SSLContext sSLContext = CommonUtils.createSSLContext(sSLTransportParameters, string);
        SSLSocketFactory sSLSocketFactory = sSLSettings.m_certNamesMismatch || sSLSettings.m_allowSelfSigned ? new SSLSocketFactory(sSLContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new SSLSocketFactory(sSLContext);
        return sSLSocketFactory;
    }

    private static SSLTransportParameters createSSLTransportParams(SSLSettings sSLSettings) {
        SSLTransportParameters sSLTransportParameters = new SSLTransportParameters();
        if (null != sSLSettings.m_sslKeyStore) {
            sSLTransportParameters.setTrustStore(sSLSettings.m_sslKeyStore, sSLSettings.m_sslKeyStorePwd);
        }
        if (null != sSLSettings.m_sslTrustStore) {
            sSLTransportParameters.setTrustStore(sSLSettings.m_sslTrustStore, sSLSettings.m_sslTrustStorePwd);
        }
        sSLTransportParameters.requireClientAuth(false);
        sSLTransportParameters.allowSelfSigned(sSLSettings.m_allowSelfSigned);
        sSLTransportParameters.certNamesMismatch(sSLSettings.m_certNamesMismatch);
        sSLTransportParameters.hostNameInSAN(sSLSettings.m_hostNameInSAN);
        return sSLTransportParameters;
    }

    private static SSLContext createSSLContext(SSLTransportParameters sSLTransportParameters, String string) throws ErrorException {
        SSLContext sSLContext;
        try {
            Object object;
            TrustManager[] trustManagerArray;
            sSLContext = SSLContext.getInstance(sSLTransportParameters.getProtocol());
            KeyManager[] keyManagerArray = null;
            if (sSLTransportParameters.isKeyStoreSet) {
                trustManagerArray = KeyManagerFactory.getInstance(sSLTransportParameters.getKeyManagerType());
                object = KeyStore.getInstance(sSLTransportParameters.getKeyStoreType());
                char[] cArray = null;
                if (null != sSLTransportParameters.getKeyPass()) {
                    cArray = sSLTransportParameters.getKeyPass().toCharArray();
                }
                ((KeyStore)object).load(new FileInputStream(sSLTransportParameters.getKeyStore()), cArray);
                trustManagerArray.init((KeyStore)object, cArray);
                keyManagerArray = trustManagerArray.getKeyManagers();
            }
            trustManagerArray = new TrustManager[]{new DSTrustManager(sSLTransportParameters, string)};
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            object = sSLContext.createSSLEngine();
            ((SSLEngine)object).setEnabledProtocols(CommonUtils.removeSSLProtocols(((SSLEngine)object).getEnabledProtocols()));
        }
        catch (Exception exception) {
            ErrorException errorException = DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_CREATE_AUTHENTICATION_TRANSPORT_ERR.name(), exception.getMessage());
            errorException.initCause(exception);
            throw errorException;
        }
        return sSLContext;
    }

    private static String[] removeSSLProtocols(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input protocols = '");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            stringBuffer.append(string);
            stringBuffer.append(",");
            if (null == string || string.toUpperCase().contains(PROTOCOL_SSL)) continue;
            arrayList.add(string);
        }
        stringBuffer.append("', enabled protocols = '");
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append(",");
        }
        stringBuffer.append("'");
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

