/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.hive.service.rpc.thrift;

import com.cloudera.impala.jdbc4.internal.apache.thrift.TBase;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TBaseHelper;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TFieldIdEnum;
import com.cloudera.impala.jdbc4.internal.apache.thrift.annotation.Nullable;
import com.cloudera.impala.jdbc4.internal.apache.thrift.meta_data.FieldMetaData;
import com.cloudera.impala.jdbc4.internal.apache.thrift.meta_data.FieldValueMetaData;
import com.cloudera.impala.jdbc4.internal.apache.thrift.meta_data.ListMetaData;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TCompactProtocol;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TField;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TList;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocolException;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocolUtil;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TStruct;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TTupleProtocol;
import com.cloudera.impala.jdbc4.internal.apache.thrift.scheme.IScheme;
import com.cloudera.impala.jdbc4.internal.apache.thrift.scheme.SchemeFactory;
import com.cloudera.impala.jdbc4.internal.apache.thrift.scheme.StandardScheme;
import com.cloudera.impala.jdbc4.internal.apache.thrift.scheme.TupleScheme;
import com.cloudera.impala.jdbc4.internal.apache.thrift.transport.TIOStreamTransport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TI32Column
implements TBase<TI32Column, _Fields>,
Serializable,
Cloneable,
Comparable<TI32Column> {
    private static final TStruct STRUCT_DESC = new TStruct("TI32Column");
    private static final TField VALUES_FIELD_DESC = new TField("values", 15, 1);
    private static final TField NULLS_FIELD_DESC = new TField("nulls", 11, 2);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TI32ColumnStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TI32ColumnTupleSchemeFactory();
    @Nullable
    private List<Integer> values;
    @Nullable
    private ByteBuffer nulls;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TI32Column() {
    }

    public TI32Column(List<Integer> list, ByteBuffer byteBuffer) {
        this();
        this.values = list;
        this.nulls = TBaseHelper.copyBinary(byteBuffer);
    }

    public TI32Column(TI32Column tI32Column) {
        if (tI32Column.isSetValues()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(tI32Column.values);
            this.values = arrayList;
        }
        if (tI32Column.isSetNulls()) {
            this.nulls = TBaseHelper.copyBinary(tI32Column.nulls);
        }
    }

    @Override
    public TI32Column deepCopy() {
        return new TI32Column(this);
    }

    @Override
    public void clear() {
        this.values = null;
        this.nulls = null;
    }

    public int getValuesSize() {
        return this.values == null ? 0 : this.values.size();
    }

    @Nullable
    public Iterator<Integer> getValuesIterator() {
        return this.values == null ? null : this.values.iterator();
    }

    public void addToValues(int n) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(n);
    }

    @Nullable
    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<Integer> list) {
        this.values = list;
    }

    public void unsetValues() {
        this.values = null;
    }

    public boolean isSetValues() {
        return this.values != null;
    }

    public void setValuesIsSet(boolean bl) {
        if (!bl) {
            this.values = null;
        }
    }

    public byte[] getNulls() {
        this.setNulls(TBaseHelper.rightSize(this.nulls));
        return this.nulls == null ? null : this.nulls.array();
    }

    public ByteBuffer bufferForNulls() {
        return TBaseHelper.copyBinary(this.nulls);
    }

    public void setNulls(byte[] byArray) {
        this.nulls = byArray == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])byArray.clone());
    }

    public void setNulls(@Nullable ByteBuffer byteBuffer) {
        this.nulls = TBaseHelper.copyBinary(byteBuffer);
    }

    public void unsetNulls() {
        this.nulls = null;
    }

    public boolean isSetNulls() {
        return this.nulls != null;
    }

    public void setNullsIsSet(boolean bl) {
        if (!bl) {
            this.nulls = null;
        }
    }

    @Override
    public void setFieldValue(_Fields _Fields2, @Nullable Object object) {
        switch (_Fields2) {
            case VALUES: {
                if (object == null) {
                    this.unsetValues();
                    break;
                }
                this.setValues((List)object);
                break;
            }
            case NULLS: {
                if (object == null) {
                    this.unsetNulls();
                    break;
                }
                if (object instanceof byte[]) {
                    this.setNulls((byte[])object);
                    break;
                }
                this.setNulls((ByteBuffer)object);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields _Fields2) {
        switch (_Fields2) {
            case VALUES: {
                return this.getValues();
            }
            case NULLS: {
                return this.getNulls();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields _Fields2) {
        if (_Fields2 == null) {
            throw new IllegalArgumentException();
        }
        switch (_Fields2) {
            case VALUES: {
                return this.isSetValues();
            }
            case NULLS: {
                return this.isSetNulls();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TI32Column) {
            return this.equals((TI32Column)object);
        }
        return false;
    }

    public boolean equals(TI32Column tI32Column) {
        if (tI32Column == null) {
            return false;
        }
        if (this == tI32Column) {
            return true;
        }
        boolean bl = this.isSetValues();
        boolean bl2 = tI32Column.isSetValues();
        if (bl || bl2) {
            if (!bl || !bl2) {
                return false;
            }
            if (!((Object)this.values).equals(tI32Column.values)) {
                return false;
            }
        }
        boolean bl3 = this.isSetNulls();
        boolean bl4 = tI32Column.isSetNulls();
        if (bl3 || bl4) {
            if (!bl3 || !bl4) {
                return false;
            }
            if (!this.nulls.equals(tI32Column.nulls)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = n * 8191 + (this.isSetValues() ? 131071 : 524287);
        if (this.isSetValues()) {
            n = n * 8191 + ((Object)this.values).hashCode();
        }
        n = n * 8191 + (this.isSetNulls() ? 131071 : 524287);
        if (this.isSetNulls()) {
            n = n * 8191 + this.nulls.hashCode();
        }
        return n;
    }

    @Override
    public int compareTo(TI32Column tI32Column) {
        if (!this.getClass().equals(tI32Column.getClass())) {
            return this.getClass().getName().compareTo(tI32Column.getClass().getName());
        }
        int n = 0;
        n = Boolean.valueOf(this.isSetValues()).compareTo(tI32Column.isSetValues());
        if (n != 0) {
            return n;
        }
        if (this.isSetValues() && (n = TBaseHelper.compareTo(this.values, tI32Column.values)) != 0) {
            return n;
        }
        n = Boolean.valueOf(this.isSetNulls()).compareTo(tI32Column.isSetNulls());
        if (n != 0) {
            return n;
        }
        if (this.isSetNulls() && (n = TBaseHelper.compareTo(this.nulls, tI32Column.nulls)) != 0) {
            return n;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int n) {
        return _Fields.findByThriftId(n);
    }

    @Override
    public void read(TProtocol tProtocol) throws TException {
        TI32Column.scheme(tProtocol).read(tProtocol, (TI32Column)this);
    }

    @Override
    public void write(TProtocol tProtocol) throws TException {
        TI32Column.scheme(tProtocol).write(tProtocol, (TI32Column)this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TI32Column(");
        boolean bl = true;
        stringBuilder.append("values:");
        if (this.values == null) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.values);
        }
        bl = false;
        if (!bl) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("nulls:");
        if (this.nulls == null) {
            stringBuilder.append("null");
        } else {
            TBaseHelper.toString(this.nulls, stringBuilder);
        }
        bl = false;
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void validate() throws TException {
        if (!this.isSetValues()) {
            throw new TProtocolException("Required field 'values' is unset! Struct:" + this.toString());
        }
        if (!this.isSetNulls()) {
            throw new TProtocolException("Required field 'nulls' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(objectOutputStream)));
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.read(new TCompactProtocol(new TIOStreamTransport(objectInputStream)));
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol tProtocol) {
        return (StandardScheme.class.equals(tProtocol.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> enumMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        enumMap.put(_Fields.VALUES, new FieldMetaData("values", 1, new ListMetaData(15, new FieldValueMetaData(8))));
        enumMap.put(_Fields.NULLS, new FieldMetaData("nulls", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(enumMap);
        FieldMetaData.addStructMetaDataMap(TI32Column.class, metaDataMap);
    }

    private static class TI32ColumnTupleScheme
    extends TupleScheme<TI32Column> {
        private TI32ColumnTupleScheme() {
        }

        @Override
        public void write(TProtocol tProtocol, TI32Column tI32Column) throws TException {
            TTupleProtocol tTupleProtocol = (TTupleProtocol)tProtocol;
            tTupleProtocol.writeI32(tI32Column.values.size());
            Iterator iterator = tI32Column.values.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                tTupleProtocol.writeI32(n);
            }
            tTupleProtocol.writeBinary(tI32Column.nulls);
        }

        @Override
        public void read(TProtocol tProtocol, TI32Column tI32Column) throws TException {
            TTupleProtocol tTupleProtocol = (TTupleProtocol)tProtocol;
            TList tList = new TList(8, tTupleProtocol.readI32());
            tI32Column.values = new ArrayList(tList.size);
            for (int i = 0; i < tList.size; ++i) {
                int n = tTupleProtocol.readI32();
                tI32Column.values.add(n);
            }
            tI32Column.setValuesIsSet(true);
            tI32Column.nulls = tTupleProtocol.readBinary();
            tI32Column.setNullsIsSet(true);
        }
    }

    private static class TI32ColumnTupleSchemeFactory
    implements SchemeFactory {
        private TI32ColumnTupleSchemeFactory() {
        }

        public TI32ColumnTupleScheme getScheme() {
            return new TI32ColumnTupleScheme();
        }
    }

    private static class TI32ColumnStandardScheme
    extends StandardScheme<TI32Column> {
        private TI32ColumnStandardScheme() {
        }

        @Override
        public void read(TProtocol tProtocol, TI32Column tI32Column) throws TException {
            tProtocol.readStructBegin();
            while (true) {
                TField tField = tProtocol.readFieldBegin();
                if (tField.type == 0) break;
                switch (tField.id) {
                    case 1: {
                        if (tField.type == 15) {
                            TList tList = tProtocol.readListBegin();
                            tI32Column.values = new ArrayList(tList.size);
                            for (int i = 0; i < tList.size; ++i) {
                                int n = tProtocol.readI32();
                                tI32Column.values.add(n);
                            }
                            tProtocol.readListEnd();
                            tI32Column.setValuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(tProtocol, tField.type);
                        break;
                    }
                    case 2: {
                        if (tField.type == 11) {
                            tI32Column.nulls = tProtocol.readBinary();
                            tI32Column.setNullsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(tProtocol, tField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(tProtocol, tField.type);
                    }
                }
                tProtocol.readFieldEnd();
            }
            tProtocol.readStructEnd();
            tI32Column.validate();
        }

        @Override
        public void write(TProtocol tProtocol, TI32Column tI32Column) throws TException {
            tI32Column.validate();
            tProtocol.writeStructBegin(STRUCT_DESC);
            if (tI32Column.values != null) {
                tProtocol.writeFieldBegin(VALUES_FIELD_DESC);
                tProtocol.writeListBegin(new TList(8, tI32Column.values.size()));
                Iterator iterator = tI32Column.values.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    tProtocol.writeI32(n);
                }
                tProtocol.writeListEnd();
                tProtocol.writeFieldEnd();
            }
            if (tI32Column.nulls != null) {
                tProtocol.writeFieldBegin(NULLS_FIELD_DESC);
                tProtocol.writeBinary(tI32Column.nulls);
                tProtocol.writeFieldEnd();
            }
            tProtocol.writeFieldStop();
            tProtocol.writeStructEnd();
        }
    }

    private static class TI32ColumnStandardSchemeFactory
    implements SchemeFactory {
        private TI32ColumnStandardSchemeFactory() {
        }

        public TI32ColumnStandardScheme getScheme() {
            return new TI32ColumnStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VALUES(1, "values"),
        NULLS(2, "nulls");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int n) {
            switch (n) {
                case 1: {
                    return VALUES;
                }
                case 2: {
                    return NULLS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int n) {
            _Fields _Fields2 = _Fields.findByThriftId(n);
            if (_Fields2 == null) {
                throw new IllegalArgumentException("Field " + n + " doesn't exist!");
            }
            return _Fields2;
        }

        @Nullable
        public static _Fields findByName(String string) {
            return byName.get(string);
        }

        private _Fields(short s, String string2) {
            this._thriftId = s;
            this._fieldName = string2;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields _Fields2 : EnumSet.allOf(_Fields.class)) {
                byName.put(_Fields2.getFieldName(), _Fields2);
            }
        }
    }
}

