/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.jute;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Utils {
    private static final char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Utils() {
    }

    public static boolean bufEquals(byte[] onearray, byte[] twoarray) {
        boolean ret;
        if (onearray == twoarray) {
            return true;
        }
        boolean bl = ret = onearray.length == twoarray.length;
        if (!ret) {
            return ret;
        }
        for (int idx = 0; idx < onearray.length; ++idx) {
            if (onearray[idx] == twoarray[idx]) continue;
            return false;
        }
        return true;
    }

    static String toXMLString(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '%') {
                sb.append("%25");
                continue;
            }
            if (ch < ' ') {
                sb.append("%");
                sb.append(hexchars[ch / 16]);
                sb.append(hexchars[ch % 16]);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static int h2c(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97;
        }
        return 0;
    }

    static String fromXMLString(String s) {
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        while (idx < s.length()) {
            char ch;
            if ((ch = s.charAt(idx++)) == '%') {
                char ch1 = s.charAt(idx++);
                char ch2 = s.charAt(idx++);
                char res = (char)(Utils.h2c(ch1) * 16 + Utils.h2c(ch2));
                sb.append(res);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static String toCSVString(String s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        sb.append('\'');
        int len = s.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\u0000': {
                    sb.append("%00");
                    continue block8;
                }
                case '\n': {
                    sb.append("%0A");
                    continue block8;
                }
                case '\r': {
                    sb.append("%0D");
                    continue block8;
                }
                case ',': {
                    sb.append("%2C");
                    continue block8;
                }
                case '}': {
                    sb.append("%7D");
                    continue block8;
                }
                case '%': {
                    sb.append("%25");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static String fromCSVString(String s) throws IOException {
        if (s.charAt(0) != '\'') {
            throw new IOException("Error deserializing string.");
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len - 1);
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '%') {
                char ch1 = s.charAt(i + 1);
                char ch2 = s.charAt(i + 2);
                i += 2;
                if (ch1 == '0' && ch2 == '0') {
                    sb.append('\u0000');
                    continue;
                }
                if (ch1 == '0' && ch2 == 'A') {
                    sb.append('\n');
                    continue;
                }
                if (ch1 == '0' && ch2 == 'D') {
                    sb.append('\r');
                    continue;
                }
                if (ch1 == '2' && ch2 == 'C') {
                    sb.append(',');
                    continue;
                }
                if (ch1 == '7' && ch2 == 'D') {
                    sb.append('}');
                    continue;
                }
                if (ch1 == '2' && ch2 == '5') {
                    sb.append('%');
                    continue;
                }
                throw new IOException("Error deserializing string.");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String toXMLBuffer(byte[] barr) {
        if (barr == null || barr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 * barr.length);
        for (int idx = 0; idx < barr.length; ++idx) {
            sb.append(Integer.toHexString(barr[idx]));
        }
        return sb.toString();
    }

    static byte[] fromXMLBuffer(String s) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (s.length() == 0) {
            return stream.toByteArray();
        }
        int blen = s.length() / 2;
        byte[] barr = new byte[blen];
        for (int idx = 0; idx < blen; ++idx) {
            char c1 = s.charAt(2 * idx);
            char c2 = s.charAt(2 * idx + 1);
            barr[idx] = Byte.parseByte("" + c1 + c2, 16);
        }
        stream.write(barr);
        return stream.toByteArray();
    }

    static String toCSVBuffer(byte[] barr) {
        if (barr == null || barr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(barr.length + 1);
        sb.append('#');
        for (int idx = 0; idx < barr.length; ++idx) {
            sb.append(Integer.toHexString(barr[idx]));
        }
        return sb.toString();
    }

    static byte[] fromCSVBuffer(String s) throws IOException {
        if (s.charAt(0) != '#') {
            throw new IOException("Error deserializing buffer.");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (s.length() == 1) {
            return stream.toByteArray();
        }
        int blen = (s.length() - 1) / 2;
        byte[] barr = new byte[blen];
        for (int idx = 0; idx < blen; ++idx) {
            char c1 = s.charAt(2 * idx + 1);
            char c2 = s.charAt(2 * idx + 2);
            barr[idx] = Byte.parseByte("" + c1 + c2, 16);
        }
        stream.write(barr);
        return stream.toByteArray();
    }

    public static int compareBytes(byte[] b1, int off1, int len1, byte[] b2, int off2, int len2) {
        for (int i = 0; i < len1 && i < len2; ++i) {
            if (b1[off1 + i] == b2[off2 + i]) continue;
            return b1[off1 + i] < b2[off2 + i] ? -1 : 1;
        }
        if (len1 != len2) {
            return len1 < len2 ? -1 : 1;
        }
        return 0;
    }
}

