/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.thrift;

import com.cloudera.impala.jdbc4.internal.apache.thrift.AsyncProcessFunction;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TApplicationException;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TAsyncProcessor;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TBase;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TException;
import com.cloudera.impala.jdbc4.internal.apache.thrift.TProcessor;
import com.cloudera.impala.jdbc4.internal.apache.thrift.async.AsyncMethodCallback;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TMessage;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocol;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocolException;
import com.cloudera.impala.jdbc4.internal.apache.thrift.protocol.TProtocolUtil;
import com.cloudera.impala.jdbc4.internal.apache.thrift.server.AbstractNonblockingServer;
import com.cloudera.impala.jdbc4.internal.slf4j.Logger;
import com.cloudera.impala.jdbc4.internal.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Map;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public boolean process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            if (!fn.isOneway()) {
                TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return true;
        }
        TBase args = fn.getEmptyArgsInstance();
        try {
            args.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            if (!fn.isOneway()) {
                TApplicationException x = new TApplicationException(7, e.getMessage());
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return true;
        }
        in.readMessageEnd();
        if (fn.isOneway()) {
            fb.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn.getResultHandler(fb, msg.seqid);
        try {
            fn.start(this.iface, args, resultHandler);
        }
        catch (Exception e) {
            resultHandler.onError(e);
        }
        return true;
    }

    @Override
    public boolean process(TProtocol in, TProtocol out) throws TException {
        return false;
    }
}

