/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.zookeeper;

import com.cloudera.impala.jdbc4.internal.apache.yetus.audience.InterfaceAudience;
import com.cloudera.impala.jdbc4.internal.slf4j.Logger;
import com.cloudera.impala.jdbc4.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

@InterfaceAudience.Public
public class ServerAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(ServerAdminClient.class);

    private static long getMask(String mask) {
        long retv = 0L;
        if (mask.equalsIgnoreCase("CLIENT_REQUEST_TRACE_MASK")) {
            retv = 2L;
        } else if (mask.equalsIgnoreCase("CLIENT_DATA_PACKET_TRACE_MASK")) {
            retv = 4L;
        } else if (mask.equalsIgnoreCase("CLIENT_PING_TRACE_MASK")) {
            retv = 8L;
        } else if (mask.equalsIgnoreCase("SERVER_PACKET_TRACE_MASK")) {
            retv = 16L;
        } else if (mask.equalsIgnoreCase("SESSION_TRACE_MASK")) {
            retv = 32L;
        } else if (mask.equalsIgnoreCase("EVENT_DELIVERY_TRACE_MASK")) {
            retv = 64L;
        } else if (mask.equalsIgnoreCase("SERVER_PING_TRACE_MASK")) {
            retv = 128L;
        } else if (mask.equalsIgnoreCase("WARNING_TRACE_MASK")) {
            retv = 256L;
        }
        return retv;
    }

    private static long getMasks(String masks) {
        long retv = 0L;
        StringTokenizer st = new StringTokenizer(masks, "|");
        while (st.hasMoreTokens()) {
            String mask = st.nextToken().trim();
            retv |= ServerAdminClient.getMask(mask);
        }
        return retv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ruok(String host, int port) {
        Socket s = null;
        try {
            byte[] reqBytes = new byte[4];
            ByteBuffer req = ByteBuffer.wrap(reqBytes);
            req.putInt(ByteBuffer.wrap("ruok".getBytes()).getInt());
            s = new Socket();
            s.setSoLinger(false, 10);
            s.setSoTimeout(20000);
            s.connect(new InetSocketAddress(host, port));
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            os.write(reqBytes);
            byte[] resBytes = new byte[4];
            int rc = is.read(resBytes);
            String retv = new String(resBytes);
            System.out.println("rc=" + rc + " retv=" + retv);
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String host, int port) {
        Socket s = null;
        try {
            byte[] reqBytes = new byte[4];
            ByteBuffer req = ByteBuffer.wrap(reqBytes);
            req.putInt(ByteBuffer.wrap("dump".getBytes()).getInt());
            s = new Socket();
            s.setSoLinger(false, 10);
            s.setSoTimeout(20000);
            s.connect(new InetSocketAddress(host, port));
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            os.write(reqBytes);
            byte[] resBytes = new byte[1024];
            int rc = is.read(resBytes);
            String retv = new String(resBytes);
            System.out.println("rc=" + rc + " retv=" + retv);
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stat(String host, int port) {
        Socket s = null;
        try {
            byte[] reqBytes = new byte[4];
            ByteBuffer req = ByteBuffer.wrap(reqBytes);
            req.putInt(ByteBuffer.wrap("stat".getBytes()).getInt());
            s = new Socket();
            s.setSoLinger(false, 10);
            s.setSoTimeout(20000);
            s.connect(new InetSocketAddress(host, port));
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            os.write(reqBytes);
            byte[] resBytes = new byte[1024];
            int rc = is.read(resBytes);
            String retv = new String(resBytes);
            System.out.println("rc=" + rc + " retv=" + retv);
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void kill(String host, int port) {
        Socket s = null;
        try {
            byte[] reqBytes = new byte[4];
            ByteBuffer req = ByteBuffer.wrap(reqBytes);
            req.putInt(ByteBuffer.wrap("kill".getBytes()).getInt());
            s = new Socket();
            s.setSoLinger(false, 10);
            s.setSoTimeout(20000);
            s.connect(new InetSocketAddress(host, port));
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            os.write(reqBytes);
            byte[] resBytes = new byte[4];
            int rc = is.read(resBytes);
            String retv = new String(resBytes);
            System.out.println("rc=" + rc + " retv=" + retv);
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTraceMask(String host, int port, String traceMaskStr) {
        Socket s = null;
        try {
            byte[] reqBytes = new byte[12];
            ByteBuffer req = ByteBuffer.wrap(reqBytes);
            long traceMask = Long.parseLong(traceMaskStr, 8);
            req.putInt(ByteBuffer.wrap("stmk".getBytes()).getInt());
            req.putLong(traceMask);
            s = new Socket();
            s.setSoLinger(false, 10);
            s.setSoTimeout(20000);
            s.connect(new InetSocketAddress(host, port));
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            os.write(reqBytes);
            byte[] resBytes = new byte[8];
            int rc = is.read(resBytes);
            ByteBuffer res = ByteBuffer.wrap(resBytes);
            long retv = res.getLong();
            System.out.println("rc=" + rc + " retv=0" + Long.toOctalString(retv) + " masks=0" + Long.toOctalString(traceMask));
            assert (retv == traceMask);
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTraceMask(String host, int port) {
        Socket s = null;
        try {
            byte[] reqBytes = new byte[12];
            ByteBuffer req = ByteBuffer.wrap(reqBytes);
            req.putInt(ByteBuffer.wrap("gtmk".getBytes()).getInt());
            s = new Socket();
            s.setSoLinger(false, 10);
            s.setSoTimeout(20000);
            s.connect(new InetSocketAddress(host, port));
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            os.write(reqBytes);
            byte[] resBytes = new byte[8];
            int rc = is.read(resBytes);
            ByteBuffer res = ByteBuffer.wrap(resBytes);
            long retv = res.getLong();
            System.out.println("rc=" + rc + " retv=0" + Long.toOctalString(retv));
        }
        catch (IOException e) {
            LOG.warn("Unexpected exception", e);
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception", e);
                }
            }
        }
    }

    private static void usage() {
        System.out.println("usage: java [-cp CLASSPATH] org.apache.zookeeper.ServerAdminClient host port op (ruok|stat|dump|kill|gettracemask|settracemask) [arguments]");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            ServerAdminClient.usage();
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        String op = args[2];
        if (op.equalsIgnoreCase("gettracemask")) {
            ServerAdminClient.getTraceMask(host, port);
        } else if (op.equalsIgnoreCase("settracemask")) {
            ServerAdminClient.setTraceMask(host, port, args[3]);
        } else if (op.equalsIgnoreCase("ruok")) {
            ServerAdminClient.ruok(host, port);
        } else if (op.equalsIgnoreCase("kill")) {
            ServerAdminClient.kill(host, port);
        } else if (op.equalsIgnoreCase("stat")) {
            ServerAdminClient.stat(host, port);
        } else if (op.equalsIgnoreCase("dump")) {
            ServerAdminClient.dump(host, port);
        } else {
            System.out.println("Unrecognized op: " + op);
        }
    }
}

