/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum;

import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.Request;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.RequestProcessor;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.Leader;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.QuorumPeer;
import com.cloudera.impala.jdbc4.internal.slf4j.Logger;
import com.cloudera.impala.jdbc4.internal.slf4j.LoggerFactory;

class AckRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AckRequestProcessor.class);
    Leader leader;

    AckRequestProcessor(Leader leader) {
        this.leader = leader;
    }

    @Override
    public void processRequest(Request request) {
        QuorumPeer self = this.leader.self;
        if (self != null) {
            this.leader.processAck(self.getId(), request.zxid, null);
        } else {
            LOG.error("Null QuorumPeer");
        }
    }

    @Override
    public void shutdown() {
    }
}

