/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum;

import com.cloudera.impala.jdbc4.internal.apache.jute.Record;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.FinalRequestProcessor;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.Request;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.SyncRequestProcessor;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.ZKDatabase;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.ZooKeeperServer;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.persistence.FileTxnSnapLog;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.CommitProcessor;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.Follower;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.FollowerRequestProcessor;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.Learner;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.QuorumPeer;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.SendAckRequestProcessor;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.txn.TxnHeader;
import com.cloudera.impala.jdbc4.internal.slf4j.Logger;
import com.cloudera.impala.jdbc4.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FollowerZooKeeperServer
extends LearnerZooKeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(FollowerZooKeeperServer.class);
    CommitProcessor commitProcessor;
    SyncRequestProcessor syncProcessor;
    ConcurrentLinkedQueue<Request> pendingSyncs;
    LinkedBlockingQueue<Request> pendingTxns = new LinkedBlockingQueue();

    FollowerZooKeeperServer(FileTxnSnapLog logFactory, QuorumPeer self, ZooKeeperServer.DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        super(logFactory, self.tickTime, self.minSessionTimeout, self.maxSessionTimeout, treeBuilder, zkDb, self);
        this.pendingSyncs = new ConcurrentLinkedQueue();
    }

    public Follower getFollower() {
        return this.self.follower;
    }

    @Override
    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        this.commitProcessor = new CommitProcessor(finalProcessor, Long.toString(this.getServerId()), true, this.getZooKeeperServerListener());
        this.commitProcessor.start();
        this.firstProcessor = new FollowerRequestProcessor(this, this.commitProcessor);
        ((FollowerRequestProcessor)this.firstProcessor).start();
        this.syncProcessor = new SyncRequestProcessor(this, new SendAckRequestProcessor(this.getFollower()));
        this.syncProcessor.start();
    }

    public void logRequest(TxnHeader hdr, Record txn) {
        Request request = new Request(null, hdr.getClientId(), hdr.getCxid(), hdr.getType(), null, null);
        request.hdr = hdr;
        request.txn = txn;
        request.zxid = hdr.getZxid();
        if ((request.zxid & 0xFFFFFFFFL) != 0L) {
            this.pendingTxns.add(request);
        }
        this.syncProcessor.processRequest(request);
    }

    public void commit(long zxid) {
        if (this.pendingTxns.size() == 0) {
            LOG.warn("Committing " + Long.toHexString(zxid) + " without seeing txn");
            return;
        }
        long firstElementZxid = ((Request)this.pendingTxns.element()).zxid;
        if (firstElementZxid != zxid) {
            LOG.error("Committing zxid 0x" + Long.toHexString(zxid) + " but next pending txn 0x" + Long.toHexString(firstElementZxid));
            System.exit(12);
        }
        Request request = (Request)this.pendingTxns.remove();
        this.commitProcessor.commit(request);
    }

    public synchronized void sync() {
        if (this.pendingSyncs.size() == 0) {
            LOG.warn("Not expecting a sync.");
            return;
        }
        Request r = (Request)this.pendingSyncs.remove();
        this.commitProcessor.commit(r);
    }

    @Override
    public int getGlobalOutstandingLimit() {
        return super.getGlobalOutstandingLimit() / (this.self.getQuorumSize() - 1);
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        try {
            super.shutdown();
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception during shutdown", e);
        }
        try {
            if (this.syncProcessor != null) {
                this.syncProcessor.shutdown();
            }
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception in syncprocessor shutdown", e);
        }
    }

    @Override
    public String getState() {
        return "follower";
    }

    @Override
    public Learner getLearner() {
        return this.getFollower();
    }
}

