/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum;

import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.ZooKeeperServer;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.ZooKeeperServerBean;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.Leader;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.LeaderMXBean;
import com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.LearnerHandler;

public class LeaderBean
extends ZooKeeperServerBean
implements LeaderMXBean {
    private final Leader leader;

    public LeaderBean(Leader leader, ZooKeeperServer zks) {
        super(zks);
        this.leader = leader;
    }

    @Override
    public String getName() {
        return "Leader";
    }

    @Override
    public String getCurrentZxid() {
        return "0x" + Long.toHexString(this.zks.getZxid());
    }

    @Override
    public String followerInfo() {
        StringBuilder sb = new StringBuilder();
        for (LearnerHandler handler : this.leader.getLearners()) {
            sb.append(handler.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getElectionTimeTaken() {
        return this.leader.self.getElectionTimeTaken();
    }

    @Override
    public int getLastProposalSize() {
        return this.leader.getProposalStats().getLastProposalSize();
    }

    @Override
    public int getMinProposalSize() {
        return this.leader.getProposalStats().getMinProposalSize();
    }

    @Override
    public int getMaxProposalSize() {
        return this.leader.getProposalStats().getMaxProposalSize();
    }

    @Override
    public void resetProposalStatistics() {
        this.leader.getProposalStats().reset();
    }
}

