/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.jdbc4.internal.apache.zookeeper.server.quorum.auth;

import com.cloudera.impala.jdbc4.internal.slf4j.Logger;
import com.cloudera.impala.jdbc4.internal.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;

public class SaslQuorumServerCallbackHandler
implements CallbackHandler {
    private static final String USER_PREFIX = "user_";
    private static final Logger LOG = LoggerFactory.getLogger(SaslQuorumServerCallbackHandler.class);
    private String userName;
    private final Map<String, String> credentials = new HashMap<String, String>();
    private final Set<String> authzHosts;

    public SaslQuorumServerCallbackHandler(Configuration configuration, String serverSection, Set<String> authzHosts) throws IOException {
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(serverSection);
        if (configurationEntries == null) {
            String errorMessage = "Could not find a '" + serverSection + "' entry in this configuration: Server cannot start.";
            LOG.error(errorMessage);
            throw new IOException(errorMessage);
        }
        this.credentials.clear();
        for (AppConfigurationEntry entry : configurationEntries) {
            Map<String, ?> options = entry.getOptions();
            for (Map.Entry<String, ?> pair : options.entrySet()) {
                String key = pair.getKey();
                if (!key.startsWith(USER_PREFIX)) continue;
                String userName = key.substring(USER_PREFIX.length());
                this.credentials.put(userName, (String)pair.getValue());
            }
        }
        this.authzHosts = authzHosts;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                this.handleNameCallback((NameCallback)callback);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                this.handlePasswordCallback((PasswordCallback)callback);
                continue;
            }
            if (callback instanceof RealmCallback) {
                this.handleRealmCallback((RealmCallback)callback);
                continue;
            }
            if (!(callback instanceof AuthorizeCallback)) continue;
            this.handleAuthorizeCallback((AuthorizeCallback)callback);
        }
    }

    private void handleNameCallback(NameCallback nc) {
        if (this.credentials.get(nc.getDefaultName()) == null) {
            LOG.warn("User '{}' not found in list of DIGEST-MD5 authenticateable users.", (Object)nc.getDefaultName());
            return;
        }
        nc.setName(nc.getDefaultName());
        this.userName = nc.getDefaultName();
    }

    private void handlePasswordCallback(PasswordCallback pc) {
        if (this.credentials.containsKey(this.userName)) {
            pc.setPassword(this.credentials.get(this.userName).toCharArray());
        } else {
            LOG.warn("No password found for user: {}", (Object)this.userName);
        }
    }

    private void handleRealmCallback(RealmCallback rc) {
        LOG.debug("QuorumLearner supplied realm: {}", (Object)rc.getDefaultText());
        rc.setText(rc.getDefaultText());
    }

    private void handleAuthorizeCallback(AuthorizeCallback ac) {
        String authenticationID = ac.getAuthenticationID();
        String authorizationID = ac.getAuthorizationID();
        boolean authzFlag = false;
        authzFlag = authenticationID.equals(authorizationID);
        if (authzFlag) {
            String[] components = authorizationID.split("[/@]");
            if (components.length == 3) {
                authzFlag = this.authzHosts.contains(components[1]);
            }
            if (!authzFlag) {
                LOG.error("SASL authorization completed, {} is not authorized to connect", (Object)components[1]);
            }
        }
        ac.setAuthorized(authzFlag);
        if (ac.isAuthorized()) {
            ac.setAuthorizedID(authorizationID);
            LOG.info("Successfully authenticated learner: authenticationID={};  authorizationID={}.", (Object)authenticationID, (Object)authorizationID);
        }
        LOG.debug("SASL authorization completed, authorized flag set to {}", (Object)ac.isAuthorized());
    }
}

