/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.exceptions;

import com.cloudera.impala.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.impala.dsi.exceptions.OperationCanceledException;
import com.cloudera.impala.sqlengine.SQLEngineGenericContext;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineException;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineRuntimeException;
import com.cloudera.impala.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.impala.support.exceptions.DiagState;
import com.cloudera.impala.support.exceptions.ErrorException;
import com.cloudera.impala.support.exceptions.ExceptionType;
import java.util.EnumSet;

public class SQLEngineExceptionFactory {
    public static ErrorException featureNotImplementedException(String string) {
        ErrorException errorException = SQLEngineGenericContext.s_SQLEngineMessages.createGeneralException(SQLEngineMessageKey.FEATURE_NOT_SUPPORTED.name(), new String[]{string}, ExceptionType.FEATURE_NOT_IMPLEMENTED);
        return errorException;
    }

    public static ErrorException invalidParseTreeException() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_PARSE_TREE.name());
        return sQLEngineException;
    }

    public static ErrorException invalidAETreeException() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_AET.name());
        return sQLEngineException;
    }

    public static ErrorException invalidUpsertQueryException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_UPSERT_QUERY.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidSqlTypeForWrapperException(int n) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_SQL_TYPE_FOR_WRAPPER.name(), new String[]{String.valueOf(n) + " (" + TypeUtilities.sqlTypeToString((short)n) + ")"});
        return sQLEngineException;
    }

    public static ErrorException invalidScalarFunctionDataException(String string, int n) {
        return new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_SCALAR_FN_DATA.name(), new String[]{string, String.valueOf(n)});
    }

    public static ErrorException invalidScalarFnNameException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_SCALAR_FN_NAME.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidEscapeSequenceException() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_INVALID_ESC_SQNCE, SQLEngineMessageKey.INVALID_ESC_SQNCE.name());
        return sQLEngineException;
    }

    public static ErrorException aggrFnSemanticsException(SQLEngineMessageKey sQLEngineMessageKey) {
        if (!EnumSet.of(SQLEngineMessageKey.AGGR_FN_N_SUBQUERY_IN_GROUPBY, new SQLEngineMessageKey[]{SQLEngineMessageKey.AGGR_FN_IN_ON, SQLEngineMessageKey.AGGR_FN_IN_WHERE, SQLEngineMessageKey.AGGR_FN_NOT_IN_SEL_LIST_OR_HAVING, SQLEngineMessageKey.NESTED_AGGR_FN_NOT_ALLOWED, SQLEngineMessageKey.MULTI_COL_IN_AGGR_FN}).contains((Object)sQLEngineMessageKey)) {
            throw new IllegalArgumentException("Invalid message key: " + (Object)((Object)sQLEngineMessageKey));
        }
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, sQLEngineMessageKey.name());
        return sQLEngineException;
    }

    public static ErrorException invalidScalarFnArgumentCountException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_SCALAR_FN_ARG_COUNT.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidScalarFnArgumentTypeException(String string, int n, short s) {
        String string2 = TypeUtilities.sqlTypeToString(s);
        if (null == string2) {
            string2 = "UNKNOWN (" + s + ")";
        }
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_INVALID_CHAR_VAL_FOR_CAST, SQLEngineMessageKey.INCOMPATIBLE_ARG_TYPE_FOR_SCALAR_FN.name(), new String[]{string, String.valueOf(n), string2});
        return sQLEngineException;
    }

    public static OperationCanceledException operationCanceledException() {
        OperationCanceledException operationCanceledException = new OperationCanceledException(7, SQLEngineMessageKey.OPERATION_CANCELED.name());
        return operationCanceledException;
    }

    public static ErrorException unsupportedTypesException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_INVALID_SQL_DATA_TYPE, SQLEngineMessageKey.DATA_TYPE_NOT_SUPPORTED.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidOperationException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_OPERATION.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidCoercionException(String string, String string2, String string3) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_COERCION.name(), new String[]{string, string2, string3});
        return sQLEngineException;
    }

    public static ErrorException incompatibleTypesException(String string, String string2) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INCOMPATIBLE_TYPES.name(), new String[]{string, string2});
        return sQLEngineException;
    }

    public static ErrorException invalidFormatException(String string, String string2) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_INVALID_CHAR_VAL_FOR_CAST, SQLEngineMessageKey.INVALID_FORMAT_FOR_LITERAL.name(), new String[]{string, string2});
        return sQLEngineException;
    }

    public static ErrorException numericOverflowException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.NUMERIC_OVERFLOW.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidOrderByExprException() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_ORDER_BY_EXPR.name(), new String[0]);
        return sQLEngineException;
    }

    public static ErrorException invalidSetArgTypeException(String string, int n) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_OPERAND_TYPE_FOR_SET_FN.name(), new String[]{string, "" + n});
        return sQLEngineException;
    }

    public static ErrorException invalidOrderByColumnException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_ORDER_BY_COLUMN.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException orderByPositionOutOfRangeException() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ORDER_BY_POS_NUM_OUT_OF_RANGE.name(), new String[0]);
        return sQLEngineException;
    }

    public static ErrorException columnReferenceNotUniqueException(String string) {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.COLUMN_REF_NOT_UNIQUE.name(), new String[]{string});
        return sQLEngineException;
    }

    public static ErrorException invalidSecondArgumentToCastException() {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_SECOND_ARG_FOR_CAST.name());
    }

    public static ErrorException unsupportedFormatClauseInCastException() {
        return new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.FORMAT_CLAUSE_NOT_SUPPORTED_FOR_CAST.name());
    }

    public static ErrorException invalidSecondArgumentToConvertException() {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_SECOND_ARG_FOR_CONVERT.name());
    }

    public static ErrorException incompatibleInsertType(String string, short s, short s2) {
        String string2;
        String string3 = TypeUtilities.sqlTypeToString(s);
        if (null == string3) {
            string3 = "UNKNOWN (" + s + ")";
        }
        if (null == (string2 = TypeUtilities.sqlTypeToString(s2))) {
            string2 = "UNKNOWN (" + s2 + ")";
        }
        return new SQLEngineException(DiagState.DIAG_RESTRICTED_DATA_TYPE_ATTR_VIOLATION, SQLEngineMessageKey.INCOMPATIBLE_INSERT_TYPE.name(), new String[]{string, string3, string2});
    }

    public static ErrorException invalidTypeParameterException(String string) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_TYPE_PARAMS.name(), new String[]{string});
    }

    public static ErrorException numArithOverflowException() {
        return new SQLEngineException(DiagState.DIAG_NUM_VAL_OUT_OF_RANGE, SQLEngineMessageKey.ARITHMETIC_ERROR.name(), new String[]{"Overflow"});
    }

    public static ErrorException datetimeArithOverflowException() {
        return new SQLEngineException(DiagState.DIAG_DATETIME_OVERFLOW, SQLEngineMessageKey.ARITHMETIC_ERROR.name(), new String[]{"Overflow"});
    }

    public static ErrorException divByZeroException() {
        return new SQLEngineException(DiagState.DIAG_DIV_BY_ZERO, SQLEngineMessageKey.ARITHMETIC_ERROR.name(), new String[]{"Divided by zero"});
    }

    public static ErrorException conversionNotSupported(String string, String string2) {
        return new SQLEngineException(DiagState.DIAG_RESTRICTED_DATA_TYPE_ATTR_VIOLATION, SQLEngineMessageKey.CONVERSION_NOT_SUPPORTED.name(), new String[]{string, string2});
    }

    public static ErrorException requestedDataNotSet() {
        return new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.REQUESTED_DATA_NOT_SET.name());
    }

    public static ErrorException invalidTopLimitValue(String string) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_TOP_LIMIT_VALUE.name(), new String[]{string});
    }

    public static ErrorException failedToCreateFile(String string) {
        return new SQLEngineException(DiagState.DIAG_MEM_ALLOC_ERR, SQLEngineMessageKey.FILE_CREATION_ERROR.name(), new String[]{string});
    }

    public static ErrorException failedToDeleteFile(String string) {
        return new SQLEngineException(DiagState.DIAG_MEM_ALLOC_ERR, SQLEngineMessageKey.FILE_DELETION_ERROR.name(), new String[]{string});
    }

    public static ErrorException failedToCreateFile(String string, String string2) {
        return new SQLEngineException(DiagState.DIAG_MEM_ALLOC_ERR, SQLEngineMessageKey.FILE_CREATION_ERROR.name(), new String[]{string, string2});
    }

    public static ErrorException failedToReadData(Exception exception) {
        return new SQLEngineException(DiagState.DIAG_MEM_MGMT_ERR, SQLEngineMessageKey.READ_DATA_ERROR.name(), exception);
    }

    public static ErrorException failedToReadData() {
        return new SQLEngineException(DiagState.DIAG_MEM_MGMT_ERR, SQLEngineMessageKey.READ_DATA_ERROR.name());
    }

    public static ErrorException sortOnLongData(int n) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ATTEMPT_TO_SORT_ON_LONG_DATA.name(), new String[]{String.valueOf(n)});
    }

    public static ErrorException joinOnLongData(int n) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ATTEMPT_TO_JOIN_ON_LONG_DATA.name(), new String[]{String.valueOf(n)});
    }

    public static ErrorException failedToAllocateMemory(String string) {
        return new SQLEngineException(DiagState.DIAG_MEM_ALLOC_ERR, SQLEngineMessageKey.FAILED_TO_ALLOC_MEM.name(), new String[]{string});
    }

    public static ErrorException failedToWriteData(Exception exception) {
        return new SQLEngineException(DiagState.DIAG_MEM_MGMT_ERR, SQLEngineMessageKey.WRITE_DATA_ERROR.name(), exception);
    }

    public static SQLEngineRuntimeException runtimeException(Exception exception) {
        return new SQLEngineRuntimeException(exception);
    }

    public static ErrorException convertRuntimeException(Throwable throwable) {
        return new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.GENERAL_ERROR.name(), throwable);
    }

    public static ErrorException aggregateOnLongData() {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ATTEMPT_TO_AGGR_ON_LONG_DATA.name());
    }

    public static ErrorException invalidConfiguration() {
        return new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_CONFIG.name());
    }

    public static ErrorException invalidConfiguration(Exception exception) {
        return new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_CONFIG.name(), exception);
    }

    public static ErrorException invalidAETreeForPassdown() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_GENERAL_ERROR, SQLEngineMessageKey.INVALID_AET_PASSDOWN.name());
        return sQLEngineException;
    }

    public static ErrorException invalidValueSubquery() {
        SQLEngineException sQLEngineException = new SQLEngineException(DiagState.DIAG_CARDINALITY_VIOLATION_MORE_THAN_ONE_ROW, SQLEngineMessageKey.INVALID_VALUE_SUBQUERY.name());
        return sQLEngineException;
    }

    public static ErrorException invalidCustomScalarFnMetadataException(String string) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.INVALID_CUSTOM_SCALAR_FN_METADATA.name(), new String[]{string});
    }

    public static ErrorException oddNumberHexDigitsException(String string) {
        return new SQLEngineException(DiagState.DIAG_SYNTAX_ERR_OR_ACCESS_VIOLATION, SQLEngineMessageKey.ODD_NUMBER_HEX.name(), new String[]{string});
    }
}

