/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.relation.join;

import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.etree.temptable.column.BitsUtil;
import com.cloudera.impala.sqlengine.utilities.ExternalAlgorithmUtil;
import com.cloudera.impala.support.ILogger;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class FileRowTracker {
    private static final String PACKAGE_NAME = "com.cloudera.sqlengine.executor.etree.relation.join";
    private static final String CLASS_NAME = "FileRowTracker";
    private RandomAccessFile m_storage = null;
    private File m_fileUnderneath = null;
    private File m_sourceDirectory;
    private ILogger m_logger;
    private byte[] m_buffer;
    private long m_currentPage;
    private boolean m_dirty;
    private long m_maxPageNumber;

    public FileRowTracker(File file, long l, ILogger iLogger) {
        this.m_logger = iLogger;
        this.m_sourceDirectory = file;
        if (l > 0xFFFFFFFL) {
            l = 0xFFFFFFFL;
        }
        this.m_buffer = new byte[(int)l];
        this.m_currentPage = 0L;
        this.m_maxPageNumber = -1L;
        this.m_dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "close");
        }
        try {
            if (this.m_storage != null) {
                this.m_storage.close();
            }
            if (this.m_fileUnderneath != null && this.m_fileUnderneath.exists() && !this.m_fileUnderneath.delete() && null != this.m_logger) {
                this.m_logger.logError(this.getClass().getPackage().getName(), this.getClass().getName(), "close", "Cannot delete temprary file: " + this.m_fileUnderneath.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            if (null != this.m_logger) {
                this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "close", "Did not successfully close resources.");
            }
        }
        finally {
            this.m_storage = null;
            this.m_fileUnderneath = null;
        }
    }

    public void set(long l) throws ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logTrace(PACKAGE_NAME, CLASS_NAME, "set", "Row number " + l);
        }
        long l2 = l / 8L / (long)this.m_buffer.length;
        try {
            this.load(l2);
        }
        catch (IOException iOException) {
            throw SQLEngineExceptionFactory.failedToWriteData(iOException);
        }
        int n = (int)(l - this.m_currentPage * (long)this.m_buffer.length * 8L);
        BitsUtil.setBit(this.m_buffer, n);
        this.m_dirty = true;
    }

    public boolean isSet(long l) throws ErrorException {
        long l2 = l / 8L / (long)this.m_buffer.length;
        if (l2 != this.m_currentPage && l2 > this.m_maxPageNumber) {
            return false;
        }
        try {
            this.load(l2);
        }
        catch (IOException iOException) {
            throw SQLEngineExceptionFactory.failedToWriteData(iOException);
        }
        int n = (int)(l - this.m_currentPage * (long)this.m_buffer.length * 8L);
        boolean bl = BitsUtil.isSet(this.m_buffer, n);
        if (null != this.m_logger) {
            this.m_logger.logTrace(PACKAGE_NAME, CLASS_NAME, "set", l + (bl ? " is " : "is not") + "set");
        }
        return bl;
    }

    public void reset() {
        block3: {
            if (null != this.m_storage) {
                try {
                    this.m_storage.close();
                }
                catch (IOException iOException) {
                    if (null == this.m_logger) break block3;
                    this.m_logger.logError(PACKAGE_NAME, CLASS_NAME, "rest", "Could not delete temporary file.");
                }
            }
        }
        this.m_dirty = true;
        this.m_storage = null;
        Arrays.fill(this.m_buffer, (byte)0);
        this.m_currentPage = 0L;
        this.m_maxPageNumber = -1L;
    }

    private void load(long l) throws IOException, ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logTrace(PACKAGE_NAME, CLASS_NAME, "load", "page number: " + l);
        }
        if (l == this.m_currentPage) {
            return;
        }
        this.writeCurrentPage();
        this.m_currentPage = l;
        if (l <= this.m_maxPageNumber) {
            this.m_storage.seek(l * (long)this.m_buffer.length);
            int n = this.m_storage.read(this.m_buffer);
            this.m_dirty = false;
            assert (n == this.m_buffer.length);
        } else {
            Arrays.fill(this.m_buffer, (byte)0);
            this.m_dirty = true;
            while (this.m_maxPageNumber + 1L < this.m_currentPage) {
                ++this.m_maxPageNumber;
                this.m_storage.seek(this.m_maxPageNumber * (long)this.m_buffer.length);
                this.m_storage.write(this.m_buffer);
            }
        }
    }

    private void writeCurrentPage() throws IOException, ErrorException {
        if (!this.m_dirty) {
            return;
        }
        if (this.m_maxPageNumber < 0L) {
            this.createStorage();
        }
        this.m_storage.seek(this.m_currentPage * (long)this.m_buffer.length);
        this.m_storage.write(this.m_buffer);
        this.m_maxPageNumber = Math.max(this.m_currentPage, this.m_maxPageNumber);
    }

    private void createStorage() throws IOException, ErrorException {
        if (null != this.m_logger) {
            this.m_logger.logFunctionEntrance(PACKAGE_NAME, CLASS_NAME, "createStorage");
        }
        this.m_fileUnderneath = ExternalAlgorithmUtil.createTempFile(this.m_sourceDirectory, this.m_logger);
        this.m_storage = new RandomAccessFile(this.m_fileUnderneath, "rw");
    }
}

