/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.impala.sqlengine.executor.etree.value.scalar;

import com.cloudera.impala.dsi.dataengine.interfaces.IColumn;
import com.cloudera.impala.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.impala.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.impala.sqlengine.executor.etree.ETDataRequest;
import com.cloudera.impala.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.cloudera.impala.sqlengine.executor.etree.value.ETValueExpr;
import com.cloudera.impala.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.cloudera.impala.support.exceptions.ErrorException;
import java.util.List;

public class ETSoundexFn
extends ETScalarFn {
    private static final char MIN_ALPHA = 'A';
    private static final char MAX_ALPHA = 'z';
    private static final char NO_MAPPING_CODE = '\u0000';
    private static final char HW_CHAR_CODE = '7';
    private static final char VOWEL_CODE = '8';
    private static final char[] SOUNDEX_MAP;
    private static final int RESULT_SIZE = 4;

    public ETSoundexFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (iColumn.getTypeMetadata().isCharacterType());
        assert (iColumn.getColumnLength() >= 4L);
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(0);
        if (this.hasMoreData(0)) {
            throw SQLEngineExceptionFactory.invalidScalarFunctionDataException("SOUNDEX", 1);
        }
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper.getChar();
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '\u0000';
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c2;
            char c3 = string.charAt(i);
            if (c3 < 'A' || c3 > 'z' || '\u0000' == (c2 = SOUNDEX_MAP[c3])) continue;
            if (0 == n2) {
                cArray[n2++] = Character.toUpperCase(c3);
                c = c2;
                continue;
            }
            if ('8' == c2) {
                c = '\u0000';
                continue;
            }
            if ('7' == c2 || c == c2) continue;
            cArray[n2++] = c2;
            if (4 <= n2) break;
            c = c2;
        }
        eTDataRequest.getData().setChar(String.valueOf(cArray));
        return DataRetrievalUtil.retrieveCharData(eTDataRequest.getData(), eTDataRequest.getOffset(), eTDataRequest.getMaxSize());
    }

    static {
        char[] cArray = SOUNDEX_MAP = new char[123];
        cArray[118] = 49;
        cArray[86] = 49;
        cArray[112] = 49;
        cArray[80] = 49;
        cArray[102] = 49;
        cArray[70] = 49;
        cArray[98] = 49;
        cArray[66] = 49;
        cArray[122] = 50;
        cArray[90] = 50;
        cArray[120] = 50;
        cArray[88] = 50;
        cArray[115] = 50;
        cArray[83] = 50;
        cArray[113] = 50;
        cArray[81] = 50;
        cArray[107] = 50;
        cArray[75] = 50;
        cArray[106] = 50;
        cArray[74] = 50;
        cArray[103] = 50;
        cArray[71] = 50;
        cArray[99] = 50;
        cArray[67] = 50;
        cArray[116] = 51;
        cArray[84] = 51;
        cArray[100] = 51;
        cArray[68] = 51;
        cArray[108] = 52;
        cArray[76] = 52;
        cArray[110] = 53;
        cArray[78] = 53;
        cArray[109] = 53;
        cArray[77] = 53;
        cArray[114] = 54;
        cArray[82] = 54;
        cArray[121] = 56;
        cArray[89] = 56;
        cArray[117] = 56;
        cArray[85] = 56;
        cArray[111] = 56;
        cArray[79] = 56;
        cArray[105] = 56;
        cArray[73] = 56;
        cArray[101] = 56;
        cArray[69] = 56;
        cArray[97] = 56;
        cArray[65] = 56;
        cArray[104] = 55;
        cArray[72] = 55;
        cArray[119] = 55;
        cArray[87] = 55;
    }
}

