/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.ini;

import com.cfca.util.ini.INIFileLoader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;

public class ProFile {
    private HashMap content = new HashMap();
    private INIFileLoader loader = null;

    public void load(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        }
        this.loader = new INIFileLoader();
        try {
            this.content = this.loader.loadIniFromFile(file);
        }
        catch (Exception ex1) {
            System.out.println(ex1.toString());
        }
    }

    public void load(InputStream ins) {
        this.loader = new INIFileLoader();
        try {
            this.content = this.loader.loadIniFromStream(ins);
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public String[] getSections() {
        return this.convertObj(this.content.keySet().toArray());
    }

    public String[] getKeys(String section) {
        if (!this.isExistsSection(section)) {
            return null;
        }
        return this.convertObj(((HashMap)this.content.get(section)).keySet().toArray());
    }

    public String getValue(String section, String key) {
        if (!this.isExistsKey(section, key)) {
            return null;
        }
        String value = (String)((HashMap)this.content.get(section)).get(key);
        return this.convert(value);
    }

    public void storeValue(String section, String key, String value) {
        if (this.isExistsSection(section)) {
            if (this.isExistsKey(section, key)) {
                ((HashMap)this.content.get(section)).remove(key);
            }
            ((HashMap)this.content.get(section)).put(key, value);
        } else {
            this.createSection(section);
            ((HashMap)this.content.get(section)).put(key, value);
        }
    }

    public void writeToFile(String fileName) throws Exception {
        FileWriter fwriter = new FileWriter(fileName);
        String[] sections = this.getSections();
        for (int i = 0; i < sections.length; ++i) {
            fwriter.write("[" + sections[i] + "]");
            fwriter.write("\r\n");
            String[] keys = this.getKeys(sections[i]);
            if (keys != null) {
                for (int j = 0; j < keys.length; ++j) {
                    fwriter.write(keys[j] + "=" + (String)((HashMap)this.content.get(sections[i])).get(keys[j]));
                    fwriter.write("\r\n");
                }
            }
            fwriter.write("\r\n");
        }
        fwriter.close();
    }

    public void writeToOutputStream(OutputStream ous) throws Exception {
        PrintWriter writer = new PrintWriter(ous);
        String[] sections = this.getSections();
        for (int i = 0; i < sections.length; ++i) {
            writer.write("[" + sections[i] + "]");
            writer.write("\r\n");
            String[] keys = this.getKeys(sections[i]);
            if (keys != null) {
                for (int j = 0; j < keys.length; ++j) {
                    writer.write(keys[j] + "=" + (String)((HashMap)this.content.get(sections[i])).get(keys[j]));
                    writer.write("\r\n");
                }
            }
            writer.write("\r\n");
        }
        writer.close();
    }

    public void createSection(String section) {
        this.content.put(section, new HashMap());
    }

    public boolean isExistsSection(String section) {
        return this.content.containsKey(section);
    }

    public boolean isExistsKey(String section, String key) {
        if (!this.isExistsSection(section)) {
            return false;
        }
        return ((HashMap)this.content.get(section)).containsKey(key);
    }

    private String[] convertObj(Object[] obj) {
        if (obj.length == 0) {
            return null;
        }
        String[] s = new String[obj.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = obj[i].toString();
        }
        return s;
    }

    private String convert(String str) {
        StringBuffer sb = new StringBuffer();
        int index = -1;
        while ((index = str.indexOf(">")) != -1) {
            sb.append(str.substring(0, index));
            str = str.substring(index + 1);
        }
        sb.append(str);
        return sb.toString().trim();
    }

    public void clear() {
        this.loader = new INIFileLoader();
    }

    public static void main(String[] args) {
        ProFile pf = new ProFile();
        pf.storeValue("Student Name", "001", "Lijiandfgsdfgsdfgdsfgdsfgdfsgsdfgsdfgsdfgsdgasdfasdfasdfasdddddddddddddddddddfffffffffffffffffffaweeeeeeeeeeeeeeeeeeefffffffffffffffffffasdf");
        pf.storeValue("Student Name", "002", "Zhaozhiwei");
        pf.storeValue("Student Age", "lijian", "23");
        pf.storeValue("Student Age", "tangbin", "23");
        System.out.println("\n".getBytes()[0]);
        try {
            pf.writeToFile("c:/111.ini");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

