/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki;

import com.cfca.util.ini.ProFile;
import com.cfca.util.pki.PKIException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class PKIBaseConfig {
    private static final String PKIBASE = "PKIBASE";
    private static final String VERIFY_P10 = "VerifyP10Signature";
    private static final String REVERSE_DN = "ReverseDN";
    private static final String CERT_ZH_ENCODE = "X509CertZHEncode";
    private static final String DeviceID = "DeviceID";
    private static final String P11_LIB_FILE = "P11LibFile";
    private static final String P11_CONFIG_FILE = "P11ConfigFile";
    private static final String P11_PASSWORD = "P11Password";
    private static final String MASTERKEY_ENC = "MasterKeyEnc";
    private static final String MASTERKEY_TYPE = "MasterKeyType";
    private static final String MASTERKEY_VALUE = "MasterKeyValue";
    private static final String NOEXPORT_RSA_KEYTYPE = "NoExportRSAKeyType";
    private static final String NOEXPORT_RSA_KEYVALUE = "NoExportRSAKeyValue";
    private static final String NOEXPORT_RSA_PUBKEYVALUE = "NoExportRSAPubKeyValue";
    private static final String NOEXPORT_RSA_PRVKEYVALUE = "NoExportRSAPriKeyValue";
    private static final String P11_CFG_LIBRARY = "library";
    private static final String P11_CFG_NAME = "name";
    private static final String P11_CFG_DESCRIPTION = "description";
    private static final String P11_CFG_SLOTLISTINDEX = "slotListIndex";
    private static boolean verifyP10Signature = false;
    private static boolean reverseDN = true;
    private static boolean useUTF8String = true;
    private static String deviceID = "Device1";
    private static String p11File = null;
    private static String p11Config = null;
    private static String masterKeyEnc = null;
    private static String masterKeyType = null;
    private static String masterKeyValue = null;
    private static String noExportRSAKeyType = null;
    private static String noExportRSAPubKeyValue = null;
    private static String noExportRSAPriKeyValue = null;
    private static String noExportRSAKeyValue = null;
    private static String p11Password = null;
    private static String p11ProviderName = null;
    private static String p11Description = null;
    private static String p11SlotListIndex = null;
    private static String p11Library = "";
    private static boolean exists1 = true;
    private static boolean exists2 = true;

    public static boolean isReLoaded() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        if (!exists2) {
            throw new PKIException("8599", "couldn't find '" + p11Config + "' file");
        }
        return p11Library.equals(p11File);
    }

    public static boolean isReverseDN() {
        return reverseDN;
    }

    public static boolean isUseUTF8String() {
        return useUTF8String;
    }

    public static boolean isVerifyP10Signature() {
        return verifyP10Signature;
    }

    public static String getJniUse() {
        return deviceID;
    }

    public static String getMasterKeyEnc() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return masterKeyEnc;
    }

    public static String getNoExportRSAKeyType() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return noExportRSAKeyType;
    }

    public static String getNoExportRSAKeyValue() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return noExportRSAKeyValue;
    }

    public static String getNoExportRSAPriKeyValue() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return noExportRSAPriKeyValue;
    }

    public static String getNoExportRSAPubKeyValue() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return noExportRSAPubKeyValue;
    }

    public static String getP11Config() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return p11Config;
    }

    public static String getP11File() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return p11File;
    }

    public static String getP11Password() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return p11Password;
    }

    public static String getP11ProviderName() throws PKIException {
        if (!exists2) {
            throw new PKIException("8599", "couldn't find '" + p11Config + "' file");
        }
        return "SunPKCS11-" + p11ProviderName;
    }

    public static String getNoExportRSAKey(int keyID) throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return noExportRSAKeyValue + keyID;
    }

    public static String getMasterKeyType() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return masterKeyType;
    }

    public static String getMasterKeyValue() throws PKIException {
        if (!exists1) {
            throw new PKIException("8599", "couldn't find 'pkibase.ini' file");
        }
        return masterKeyValue;
    }

    public static String getP11Description() throws PKIException {
        if (!exists2) {
            throw new PKIException("8599", "couldn't find '" + p11Config + "' file");
        }
        return p11Description;
    }

    public static String getP11Library() throws PKIException {
        if (!exists2) {
            throw new PKIException("8599", "couldn't find '" + p11Config + "' file");
        }
        return p11Library;
    }

    public static String getP11SlotListIndex() throws PKIException {
        if (!exists2) {
            throw new PKIException("8599", "couldn't find '" + p11Config + "' file");
        }
        return p11SlotListIndex;
    }

    static {
        String path1 = "./pkibase.ini";
        String path2 = "./config/pkibase.ini";
        boolean usePath1 = true;
        File file = new File(path1);
        if (!file.exists()) {
            usePath1 = false;
            file = new File(path2);
            if (!file.exists()) {
                exists1 = false;
            }
        }
        if (exists1) {
            String strUseUTF8;
            String strReverseDN;
            ProFile proFile = new ProFile();
            if (usePath1) {
                proFile.load(path1);
            } else {
                proFile.load(path2);
            }
            String strVerifyP10Sig = proFile.getValue(PKIBASE, VERIFY_P10);
            if (strVerifyP10Sig.equalsIgnoreCase("true")) {
                verifyP10Signature = true;
            }
            if ((strReverseDN = proFile.getValue(PKIBASE, REVERSE_DN)).equalsIgnoreCase("false")) {
                reverseDN = false;
            }
            if (!(strUseUTF8 = proFile.getValue(PKIBASE, CERT_ZH_ENCODE)).equalsIgnoreCase("UTF8String")) {
                useUTF8String = false;
            }
            if ((p11File = proFile.getValue(deviceID = proFile.getValue(PKIBASE, DeviceID), P11_LIB_FILE)) != null) {
                p11File.replaceAll("\\\\\\\\", "/");
            }
            p11Config = proFile.getValue(deviceID, P11_CONFIG_FILE);
            masterKeyEnc = proFile.getValue(deviceID, MASTERKEY_ENC);
            masterKeyType = proFile.getValue(deviceID, MASTERKEY_TYPE);
            masterKeyValue = proFile.getValue(deviceID, MASTERKEY_VALUE);
            noExportRSAKeyType = proFile.getValue(deviceID, NOEXPORT_RSA_KEYTYPE);
            noExportRSAPubKeyValue = proFile.getValue(deviceID, NOEXPORT_RSA_PUBKEYVALUE);
            noExportRSAPriKeyValue = proFile.getValue(deviceID, NOEXPORT_RSA_PRVKEYVALUE);
            noExportRSAKeyValue = proFile.getValue(deviceID, NOEXPORT_RSA_KEYVALUE);
            p11Password = proFile.getValue(deviceID, P11_PASSWORD);
            file = new File(p11Config);
            if (!file.exists()) {
                exists2 = false;
            }
            if (exists2) {
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(p11Config));
                    p11ProviderName = props.getProperty(P11_CFG_NAME);
                    p11Library = props.getProperty(P11_CFG_LIBRARY);
                    p11Description = props.getProperty(P11_CFG_DESCRIPTION);
                    p11SlotListIndex = props.getProperty(P11_CFG_SLOTLISTINDEX);
                    if (p11Library != null) {
                        p11Library.replaceAll("\\\\\\\\\\\\", "/");
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }
}

