/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs12;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.BERSequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.pkcs.pkcs12.SafeBag;

public class SafeContents
implements DEREncodable {
    private SafeBag[] safeBag;

    public static SafeContents getInstance(Object o) {
        if (o == null || o instanceof SafeContents) {
            return (SafeContents)o;
        }
        if (o instanceof ASN1Sequence) {
            return new SafeContents((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("unknown object in factory " + o.getClass().getName());
    }

    public SafeContents(SafeBag[] _safeBag) {
        this.safeBag = _safeBag;
    }

    public SafeContents(ASN1Sequence seq) {
        this.safeBag = new SafeBag[seq.size()];
        for (int i = 0; i < this.safeBag.length; ++i) {
            this.safeBag[i] = SafeBag.getInstance(seq.getObjectAt(i));
        }
    }

    public SafeBag[] getSafeBag() {
        return this.safeBag;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < this.safeBag.length; ++i) {
            v.add(this.safeBag[i]);
        }
        return new BERSequence(v);
    }
}

