/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.pkcs.pkcs5;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.pkcs.pkcs5.EncryptionScheme;
import com.cfca.util.pki.asn1.pkcs.pkcs5.KeyDerivationFunc;
import com.cfca.util.pki.asn1.pkcs.pkcs5.PBKDF2Params;
import java.util.Enumeration;

public class PBES2Parameters
implements PKCSObjectIdentifiers,
DEREncodable {
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Parameters(ASN1Sequence obj) {
        Enumeration e = obj.getObjects();
        ASN1Sequence funcSeq = (ASN1Sequence)e.nextElement();
        this.func = funcSeq.getObjectAt(0).equals(PKCSObjectIdentifiers.id_PBKDF2) ? new PBKDF2Params(funcSeq) : new KeyDerivationFunc(funcSeq);
        this.scheme = new EncryptionScheme((ASN1Sequence)e.nextElement());
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.func);
        v.add(this.scheme);
        return new DERSequence(v);
    }
}

