/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1Encodable;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.x509.AccessDescription;
import com.cfca.util.pki.asn1.x509.GeneralName;
import java.util.Enumeration;
import java.util.Vector;

public class AuthorityInformationAccess
extends ASN1Encodable {
    public static final DERObjectIdentifier ID_AD_CA_ISSUERS = new DERObjectIdentifier("1.3.6.1.5.5.7.48.2");
    public static final DERObjectIdentifier ID_AD_OCSP = new DERObjectIdentifier("1.3.6.1.5.5.7.48.1");
    private DERObjectIdentifier accessMethod = null;
    private GeneralName accessLocation = null;
    private Vector vAccessDes = null;

    public AuthorityInformationAccess getInstance(Object obj) {
        if (obj instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new AuthorityInformationAccess((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public AuthorityInformationAccess(ASN1Sequence seq) {
        this.vAccessDes = new Vector();
        Enumeration e = seq.getObjects();
        if (e.hasMoreElements()) {
            DERSequence vec = (DERSequence)e.nextElement();
            if (vec.size() != 2) {
                throw new IllegalArgumentException("wrong number of elements in inner sequence");
            }
            AccessDescription accessDes = new AccessDescription(vec);
            this.vAccessDes.add(accessDes);
        }
    }

    public AuthorityInformationAccess(Vector vAccessDes) {
        this.vAccessDes = vAccessDes;
    }

    public AuthorityInformationAccess(DERObjectIdentifier oid, GeneralName location) {
        this.accessMethod = oid;
        this.accessLocation = location;
    }

    public DERObjectIdentifier getAccessMethod() {
        return this.accessMethod;
    }

    public GeneralName getAccessLocation() {
        return this.accessLocation;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (int i = 0; i < this.vAccessDes.size(); ++i) {
            AccessDescription accessDes = (AccessDescription)this.vAccessDes.get(i);
            vec.add(accessDes.toASN1Object());
        }
        return new DERSequence(vec);
    }

    public String toString() {
        return "AuthorityInformationAccess: Oid(" + this.accessMethod.getId() + ")";
    }
}

