/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1OctetString;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.DERUTF8String;
import com.cfca.util.pki.asn1.x509.OtherName;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.encoders.Hex;

public class GeneralName
implements DEREncodable {
    public static final String OTHER_NAME_UPN_OID = "1.3.6.1.4.1.311.20.2.3";
    DEREncodable obj;
    int tag;
    boolean isInsideImplicit = false;

    public GeneralName(X509Name directoryName) {
        this.obj = directoryName;
        this.tag = 4;
    }

    public GeneralName(DERObject name, int tag) {
        this.obj = name;
        this.tag = tag;
    }

    public static GeneralName getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralName) {
            return (GeneralName)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
            int tag = tagObj.getTagNo();
            switch (tag) {
                case 0: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 1: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 2: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 3: {
                    throw new IllegalArgumentException("unknown tag: " + tag);
                }
                case 4: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 5: {
                    return new GeneralName(tagObj.getObject(), tag);
                }
                case 6: {
                    return new GeneralName(DERIA5String.getInstance(tagObj, false), tag);
                }
                case 7: {
                    return new GeneralName(ASN1OctetString.getInstance(tagObj, false), tag);
                }
                case 8: {
                    return new GeneralName(DERObjectIdentifier.getInstance(tagObj, false), tag);
                }
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance");
    }

    public static GeneralName getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        return GeneralName.getInstance(ASN1TaggedObject.getInstance(tagObj, explicit));
    }

    public void markInsideImplicit(boolean isInsideImplicit) {
        this.isInsideImplicit = isInsideImplicit;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DEREncodable getName() {
        return this.obj;
    }

    public static String GeneralNameToString(ASN1TaggedObject tempGeneralName) {
        String retString = null;
        switch (tempGeneralName.getTagNo()) {
            case 0: {
                if (OTHER_NAME_UPN_OID.equals(OtherName.getInstance(tempGeneralName.getObject()).getTypeID().getId())) {
                    retString = ((DERUTF8String)OtherName.getInstance(tempGeneralName.getObject()).getValue()).getString();
                    break;
                }
                retString = new String(Hex.encode(((DEROctetString)OtherName.getInstance(tempGeneralName.getObject()).getValue().getDERObject()).getOctets()));
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                retString = DERIA5String.getInstance(tempGeneralName.getObject()).getString();
                break;
            }
            case 7: {
                int i;
                StringBuffer tempSB = new StringBuffer();
                byte[] tempByte = ((DEROctetString)tempGeneralName.getObject()).getOctets();
                int tempInt = 0;
                for (i = 0; i < 4; ++i) {
                    tempInt = tempByte[i];
                    if (tempInt < 0) {
                        tempInt = 256 + tempInt;
                    }
                    tempSB.append(String.valueOf(tempInt));
                    if (i >= 3) continue;
                    tempSB.append(".");
                }
                if (tempByte.length > 4) {
                    tempSB.append("/");
                    for (i = 4; i < tempByte.length; ++i) {
                        tempInt = tempByte[i];
                        if (tempInt < 0) {
                            tempInt = 256 + tempInt;
                        }
                        tempSB.append(String.valueOf(tempInt));
                        if (i >= tempByte.length - 1) continue;
                        tempSB.append(".");
                    }
                }
                retString = tempSB.toString();
                break;
            }
            case 8: {
                retString = DERObjectIdentifier.getInstance(tempGeneralName.getObject()).getId();
                break;
            }
            case 4: {
                retString = X509Name.getInstance(tempGeneralName.getObject()).toString();
            }
        }
        return retString;
    }

    public DERObject getDERObject() {
        if (this.tag == 4) {
            return new DERTaggedObject(true, this.tag, this.obj);
        }
        return new DERTaggedObject(false, this.tag, this.obj);
    }
}

