/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.DERTaggedObject;
import com.cfca.util.pki.asn1.DERUTF8String;

public class IdentifyCode
implements DEREncodable {
    private ASN1Set set = null;
    private DERPrintableString residenterCardNumber = null;
    private DERUTF8String militaryOfficerCardNumber = null;
    private DERPrintableString passportNumber = null;

    public IdentifyCode(ASN1Set set) {
        this.set = set;
        block5: for (int i = 0; i < set.size(); ++i) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)set.getObjectAt(i);
            switch (tagObj.getTagNo()) {
                case 0: {
                    this.residenterCardNumber = DERPrintableString.getInstance(tagObj);
                    continue block5;
                }
                case 1: {
                    this.militaryOfficerCardNumber = DERUTF8String.getInstance(tagObj);
                    continue block5;
                }
                case 2: {
                    this.passportNumber = DERPrintableString.getInstance(tagObj);
                }
            }
        }
    }

    public IdentifyCode(DERPrintableString residenterCardNumber, DERUTF8String militaryOfficerCardNumber, DERPrintableString passportNumber) {
        this.residenterCardNumber = residenterCardNumber;
        this.militaryOfficerCardNumber = militaryOfficerCardNumber;
        this.passportNumber = passportNumber;
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (residenterCardNumber != null && residenterCardNumber.getString() != null) {
            v.add(new DERTaggedObject(0, residenterCardNumber));
        }
        if (militaryOfficerCardNumber != null && militaryOfficerCardNumber.getString() != null) {
            v.add(new DERTaggedObject(1, militaryOfficerCardNumber));
        }
        if (passportNumber != null && passportNumber.getString() != null) {
            v.add(new DERTaggedObject(2, passportNumber));
        }
        this.set = new DERSet(v);
    }

    public static IdentifyCode getInstance(Object obj) {
        if (obj == null || obj instanceof IdentifyCode) {
            return (IdentifyCode)obj;
        }
        if (obj instanceof ASN1Set) {
            return new IdentifyCode((ASN1Set)obj);
        }
        throw new IllegalArgumentException("Invalid CFCAIdentifyCode: " + obj.getClass().getName());
    }

    public DERPrintableString getResidenterCardNumber() {
        if (this.residenterCardNumber != null) {
            return this.residenterCardNumber;
        }
        return null;
    }

    public DERUTF8String getMilitaryOfficerCardNumber() {
        if (this.militaryOfficerCardNumber != null) {
            return this.militaryOfficerCardNumber;
        }
        return null;
    }

    public DERPrintableString getPassportNumber() {
        if (this.passportNumber != null) {
            return this.passportNumber;
        }
        return null;
    }

    public DERObject getDERObject() {
        return this.set;
    }
}

