/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERGeneralizedTime;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERTaggedObject;

public class PrivateKeyUsagePeriod
implements DEREncodable {
    private ASN1Sequence seq;
    private DERGeneralizedTime notBefore;
    private DERGeneralizedTime notAfter;

    public PrivateKeyUsagePeriod(ASN1Sequence seq) {
        this.seq = seq;
        block4: for (int i = 0; i < seq.size(); ++i) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (obj.getTagNo()) {
                case 0: {
                    this.notBefore = DERGeneralizedTime.getInstance(obj, true);
                    continue block4;
                }
                case 1: {
                    this.notAfter = DERGeneralizedTime.getInstance(obj, true);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("illegal tag");
                }
            }
        }
    }

    public PrivateKeyUsagePeriod(DERGeneralizedTime notBefore, DERGeneralizedTime notAfter) {
        this.notBefore = notBefore;
        this.notAfter = notAfter;
    }

    public static PrivateKeyUsagePeriod getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PrivateKeyUsagePeriod.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PrivateKeyUsagePeriod getInstance(Object obj) {
        if (obj instanceof PrivateKeyUsagePeriod) {
            return (PrivateKeyUsagePeriod)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PrivateKeyUsagePeriod((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public DERGeneralizedTime getNotBefore() {
        return this.notBefore;
    }

    public DERGeneralizedTime getNotAfter() {
        return this.notAfter;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.notBefore != null) {
            v.add(new DERTaggedObject(0, this.notBefore));
        }
        if (this.notAfter != null) {
            v.add(new DERTaggedObject(1, this.notAfter));
        }
        return new DERSequence(v);
    }
}

