/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.asn1.x509;

import com.cfca.util.pki.PKIBaseConfig;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.ASN1TaggedObject;
import com.cfca.util.pki.asn1.DERBMPString;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DERIA5String;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.DERString;
import com.cfca.util.pki.asn1.DERUTF8String;
import com.cfca.util.pki.asn1.x509.X509NameTokenizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
    public static final DERObjectIdentifier EmailAddress;
    public static final DERObjectIdentifier E;
    public static final DERObjectIdentifier DC;
    public static final DERObjectIdentifier UID;
    public static Hashtable OIDLookUp;
    public static boolean DefaultReverse;
    public static boolean UseUTF8String;
    public static Hashtable DefaultSymbols;
    public static Hashtable RFC2253Symbols;
    public static Hashtable SymbolLookUp;
    public static Hashtable DefaultLookUp;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private Vector added = new Vector();
    private ASN1Sequence seq;

    public static X509Name getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Name.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static X509Name getInstance(Object obj) {
        if (obj == null || obj instanceof X509Name) {
            return (X509Name)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public X509Name(ASN1Sequence seq) {
        this.seq = seq;
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            for (int i = 0; i < set.size(); ++i) {
                ASN1Sequence s = (ASN1Sequence)set.getObjectAt(i);
                this.ordering.addElement(s.getObjectAt(0));
                this.values.addElement(((DERString)((Object)s.getObjectAt(1))).getString());
                this.added.addElement(i != 0 ? new Boolean(true) : new Boolean(false));
            }
        }
    }

    public X509Name(Hashtable attributes) {
        this(null, attributes);
    }

    public X509Name(Vector ordering, Hashtable attributes) {
        int i;
        if (ordering != null) {
            for (i = 0; i != ordering.size(); ++i) {
                this.ordering.addElement(ordering.elementAt(i));
                this.added.addElement(new Boolean(false));
            }
        } else {
            Enumeration e = attributes.keys();
            while (e.hasMoreElements()) {
                this.ordering.addElement(e.nextElement());
                this.added.addElement(new Boolean(false));
            }
        }
        for (i = 0; i != this.ordering.size(); ++i) {
            DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
            if (attributes.get(oid) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + oid.getId() + " - passed to distinguished name");
            }
            this.values.addElement(attributes.get(oid));
        }
    }

    public X509Name(Vector oids, Vector values) {
        if (oids.size() != values.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        for (int i = 0; i < oids.size(); ++i) {
            this.ordering.addElement(oids.elementAt(i));
            this.values.addElement(values.elementAt(i));
            this.added.addElement(new Boolean(false));
        }
    }

    public X509Name(String dirName) {
        this(DefaultReverse, DefaultLookUp, dirName);
    }

    public X509Name(boolean reverse, String dirName) {
        this(reverse, DefaultLookUp, dirName);
    }

    public X509Name(boolean reverse, Hashtable lookUp, String dirName) {
        reverse = DefaultReverse;
        X509NameTokenizer nTok = new X509NameTokenizer(dirName);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String name = token.substring(0, index);
            String value = token.substring(index + 1);
            DERObjectIdentifier oid = null;
            if (name.toUpperCase().startsWith("OID.")) {
                oid = new DERObjectIdentifier(name.substring(4));
            } else if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
                oid = new DERObjectIdentifier(name);
            } else {
                oid = (DERObjectIdentifier)lookUp.get(name.toLowerCase());
                if (oid == null) {
                    throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
                }
            }
            this.ordering.addElement(oid);
            this.values.addElement(value);
            this.added.addElement(new Boolean(false));
        }
        if (reverse) {
            Vector o = new Vector();
            Vector v = new Vector();
            for (int i = this.ordering.size() - 1; i >= 0; --i) {
                o.addElement(this.ordering.elementAt(i));
                v.addElement(this.values.elementAt(i));
                this.added.addElement(new Boolean(false));
            }
            this.ordering = o;
            this.values = v;
        }
    }

    public Vector getOIDs() {
        Vector v = new Vector();
        for (int i = 0; i != this.ordering.size(); ++i) {
            v.addElement(this.ordering.elementAt(i));
        }
        return v;
    }

    public Vector getValues() {
        Vector v = new Vector();
        for (int i = 0; i != this.values.size(); ++i) {
            v.addElement(this.values.elementAt(i));
        }
        return v;
    }

    private boolean canBePrintable(String str) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public DERObject getDERObject() {
        if (this.seq == null) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            for (int i = 0; i != this.ordering.size(); ++i) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
                v.add(oid);
                String str = (String)this.values.elementAt(i);
                if (str.charAt(0) == '#') {
                    str = str.toLowerCase();
                    byte[] data = new byte[str.length() / 2];
                    for (int index = 0; index != data.length; ++index) {
                        char left = str.charAt(index * 2 + 1);
                        char right = str.charAt(index * 2 + 2);
                        data[index] = left < 'a' ? (byte)(left - 48 << 4) : (byte)(left - 97 + 10 << 4);
                        if (right < 'a') {
                            int n = index;
                            data[n] = (byte)(data[n] | (byte)(right - 48));
                            continue;
                        }
                        int n = index;
                        data[n] = (byte)(data[n] | (byte)(right - 97 + 10));
                    }
                    ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(data));
                    try {
                        v.add(aIn.readObject());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("bad object in '#' string");
                    }
                } else if (oid.equals(EmailAddress)) {
                    v.add(new DERIA5String(str));
                } else if (this.canBePrintable(str)) {
                    v.add(new DERPrintableString(str));
                } else if (UseUTF8String) {
                    v.add(new DERUTF8String(str));
                } else {
                    v.add(new DERBMPString(str));
                }
                vec.add(new DERSet(new DERSequence(v)));
            }
            this.seq = new DERSequence(vec);
        }
        return this.seq;
    }

    public boolean equals(Object _obj, boolean inOrder) {
        if (_obj == this) {
            return true;
        }
        if (!inOrder) {
            return this.equals(_obj);
        }
        if (_obj == null || !(_obj instanceof X509Name)) {
            return false;
        }
        X509Name _oxn = (X509Name)_obj;
        int _orderingSize = this.ordering.size();
        if (_orderingSize != _oxn.ordering.size()) {
            return false;
        }
        for (int i = 0; i < _orderingSize; ++i) {
            char c2;
            int k;
            char c1;
            String _oid = ((DERObjectIdentifier)this.ordering.elementAt(i)).getId();
            String _val = (String)this.values.elementAt(i);
            String _oOID = ((DERObjectIdentifier)_oxn.ordering.elementAt(i)).getId();
            String _oVal = (String)_oxn.values.elementAt(i);
            if (!_oid.equals(_oOID) || (_val = _val.trim().toLowerCase()).equals(_oVal = _oVal.trim().toLowerCase())) continue;
            StringBuffer v1 = new StringBuffer();
            StringBuffer v2 = new StringBuffer();
            if (_val.length() != 0) {
                c1 = _val.charAt(0);
                v1.append(c1);
                for (k = 1; k < _val.length(); ++k) {
                    c2 = _val.charAt(k);
                    if (c1 != ' ' || c2 != ' ') {
                        v1.append(c2);
                    }
                    c1 = c2;
                }
            }
            if (_oVal.length() != 0) {
                c1 = _oVal.charAt(0);
                v2.append(c1);
                for (k = 1; k < _oVal.length(); ++k) {
                    c2 = _oVal.charAt(k);
                    if (c1 != ' ' || c2 != ' ') {
                        v2.append(c2);
                    }
                    c1 = c2;
                }
            }
            if (v1.toString().equals(v2.toString())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object _obj) {
        if (_obj == this) {
            return true;
        }
        if (_obj == null || !(_obj instanceof X509Name)) {
            return false;
        }
        X509Name _oxn = (X509Name)_obj;
        if (this.getDERObject().equals(_oxn.getDERObject())) {
            return true;
        }
        int _orderingSize = this.ordering.size();
        if (_orderingSize != _oxn.ordering.size()) {
            return false;
        }
        boolean[] _indexes = new boolean[_orderingSize];
        for (int i = 0; i < _orderingSize; ++i) {
            boolean _found = false;
            String _oid = ((DERObjectIdentifier)this.ordering.elementAt(i)).getId();
            String _val = (String)this.values.elementAt(i);
            for (int j = 0; j < _orderingSize; ++j) {
                char c2;
                int k;
                char c1;
                if (_indexes[j]) continue;
                String _oOID = ((DERObjectIdentifier)_oxn.ordering.elementAt(j)).getId();
                String _oVal = (String)_oxn.values.elementAt(j);
                if (!_oid.equals(_oOID)) continue;
                if ((_val = _val.trim().toLowerCase()).equals(_oVal = _oVal.trim().toLowerCase())) {
                    _indexes[j] = true;
                    _found = true;
                    break;
                }
                StringBuffer v1 = new StringBuffer();
                StringBuffer v2 = new StringBuffer();
                if (_val.length() != 0) {
                    c1 = _val.charAt(0);
                    v1.append(c1);
                    for (k = 1; k < _val.length(); ++k) {
                        c2 = _val.charAt(k);
                        if (c1 != ' ' || c2 != ' ') {
                            v1.append(c2);
                        }
                        c1 = c2;
                    }
                }
                if (_oVal.length() != 0) {
                    c1 = _oVal.charAt(0);
                    v2.append(c1);
                    for (k = 1; k < _oVal.length(); ++k) {
                        c2 = _oVal.charAt(k);
                        if (c1 != ' ' || c2 != ' ') {
                            v2.append(c2);
                        }
                        c1 = c2;
                    }
                }
                if (!v1.toString().equals(v2.toString())) continue;
                _indexes[j] = true;
                _found = true;
                break;
            }
            if (_found) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        ASN1Sequence seq = (ASN1Sequence)this.getDERObject();
        Enumeration e = seq.getObjects();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            hashCode ^= e.nextElement().hashCode();
        }
        return hashCode;
    }

    private void appendValue(StringBuffer buf, Hashtable oidSymbols, DERObjectIdentifier oid, String value) {
        String sym = (String)oidSymbols.get(oid);
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(oid.getId());
        }
        buf.append("=");
        buf.append(value);
        int end = buf.length();
        for (int index = buf.length(); index != end; ++index) {
            if (buf.charAt(index) != ',' && buf.charAt(index) != '\"' && buf.charAt(index) != '\\' && buf.charAt(index) != '+' && buf.charAt(index) != '<' && buf.charAt(index) != '>' && buf.charAt(index) != ';') continue;
            buf.insert(index, "\\");
            ++index;
            ++end;
        }
    }

    public String toString(boolean reverse, Hashtable oidSymbols) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        if (reverse) {
            for (int i = this.ordering.size() - 1; i >= 0; --i) {
                if (first) {
                    first = false;
                } else if (((Boolean)this.added.elementAt(i + 1)).booleanValue()) {
                    buf.append(" + ");
                } else {
                    buf.append(",");
                }
                this.appendValue(buf, oidSymbols, (DERObjectIdentifier)this.ordering.elementAt(i), (String)this.values.elementAt(i));
            }
        } else {
            for (int i = 0; i < this.ordering.size(); ++i) {
                if (first) {
                    first = false;
                } else if (((Boolean)this.added.elementAt(i)).booleanValue()) {
                    buf.append(" + ");
                } else {
                    buf.append(",");
                }
                this.appendValue(buf, oidSymbols, (DERObjectIdentifier)this.ordering.elementAt(i), (String)this.values.elementAt(i));
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }

    static {
        E = EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
        DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
        UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
        OIDLookUp = new Hashtable();
        DefaultReverse = PKIBaseConfig.isReverseDN();
        UseUTF8String = PKIBaseConfig.isUseUTF8String();
        DefaultSymbols = OIDLookUp;
        RFC2253Symbols = new Hashtable();
        SymbolLookUp = new Hashtable();
        DefaultLookUp = SymbolLookUp;
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SN");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(T, "T");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(SN, "SN");
        RFC2253Symbols.put(EmailAddress, "EMAILADDRESS");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC2253Symbols.put(SURNAME, "SURNAME");
        RFC2253Symbols.put(GIVENNAME, "GIVENNAME");
        RFC2253Symbols.put(INITIALS, "INITIALS");
        RFC2253Symbols.put(GENERATION, "GENERATION");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
    }
}

