/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.cert;

import com.cfca.util.pki.PKIConstant;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.ASN1Set;
import com.cfca.util.pki.asn1.DERBitString;
import com.cfca.util.pki.asn1.DERInteger;
import com.cfca.util.pki.asn1.DERObject;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERPrintableString;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.SubjectPublicKeyInfo;
import com.cfca.util.pki.asn1.x509.TBSCertificateStructure;
import com.cfca.util.pki.asn1.x509.Time;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.asn1.x509.X509Extension;
import com.cfca.util.pki.asn1.x509.X509Extensions;
import com.cfca.util.pki.asn1.x509.X509Name;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.extension.AuthorityInformationAccessExt;
import com.cfca.util.pki.extension.AuthorityKeyIdentifierExt;
import com.cfca.util.pki.extension.BasicConstraintsExt;
import com.cfca.util.pki.extension.CRLDistributionPointsExt;
import com.cfca.util.pki.extension.CertificatePoliciesExt;
import com.cfca.util.pki.extension.ExtendedKeyUsageExt;
import com.cfca.util.pki.extension.Extension;
import com.cfca.util.pki.extension.ICRegistrationNumberExt;
import com.cfca.util.pki.extension.IdentifyCodeExt;
import com.cfca.util.pki.extension.InsuranceNumberExt;
import com.cfca.util.pki.extension.IssuerAlternativeNamesExt;
import com.cfca.util.pki.extension.KeyUsageExt;
import com.cfca.util.pki.extension.NameConstraintsExt;
import com.cfca.util.pki.extension.OrganizationCodeExt;
import com.cfca.util.pki.extension.PolicyConstraintsExt;
import com.cfca.util.pki.extension.PolicyMappingsExt;
import com.cfca.util.pki.extension.SelfDefExtension;
import com.cfca.util.pki.extension.SubjectAltNameExt;
import com.cfca.util.pki.extension.SubjectKeyIdentifierExt;
import com.cfca.util.pki.extension.TaxationNumberExt;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;

public class X509Cert {
    private final String head = "-----BEGIN CERTIFICATE-----";
    private final String end = "-----END CERTIFICATE-----";
    private X509CertificateStructure cert = null;
    private X509Extensions extensions = null;

    public X509Cert(byte[] certData) throws PKIException {
        byte[] derData = this.parseCertData(certData);
        this.initCert(derData);
    }

    public X509Cert(InputStream is) throws PKIException {
        byte[] certIS = null;
        try {
            int i;
            int length = is.available();
            certIS = new byte[length];
            for (int readLen = is.read(certIS); readLen < length; readLen += i) {
                byte[] temp = new byte[length - readLen];
                i = is.read(temp);
                System.arraycopy(temp, 0, certIS, readLen, i);
            }
            is.close();
        }
        catch (IOException ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        byte[] derData = this.parseCertData(certIS);
        this.initCert(derData);
    }

    private byte[] parseCertData(byte[] certData) throws PKIException {
        try {
            byte[] tempHead = new byte["-----BEGIN CERTIFICATE-----".length()];
            System.arraycopy(certData, 0, tempHead, 0, tempHead.length);
            if (Parser.isBase64Encode(certData)) {
                certData = Parser.convertBase64(certData);
                return Base64.decode(certData);
            }
            if (Arrays.equals(tempHead, "-----BEGIN CERTIFICATE-----".getBytes())) {
                int length = certData.length;
                byte[] withoutHead = new byte[length - "-----BEGIN CERTIFICATE-----".length()];
                System.arraycopy(certData, "-----BEGIN CERTIFICATE-----".length(), withoutHead, 0, withoutHead.length);
                byte[] withoutEnd = new byte[withoutHead.length - ("-----END CERTIFICATE-----".length() + 2)];
                System.arraycopy(withoutHead, 0, withoutEnd, 0, withoutEnd.length);
                byte[] withoutEnter = Parser.convertBase64(withoutEnd);
                return Base64.decode(withoutEnter);
            }
            return certData;
        }
        catch (Exception ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
    }

    private void initCert(byte[] certData) throws PKIException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certData);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.cert = new X509CertificateStructure(seq);
        }
        catch (Exception ex) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850411", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25");
        }
    }

    public X509Cert(X509CertificateStructure certStructure) {
        this.cert = certStructure;
    }

    public X509CertificateStructure getCertStructure() {
        return this.cert;
    }

    public byte[] getEncoded() throws PKIException {
        byte[] encoded = null;
        try {
            encoded = Parser.writeDERObj2Bytes(this.cert);
        }
        catch (Exception ex) {
            throw new PKIException("850412", "\u83b7\u5f97\u8bc1\u4e66\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public int getVersion() {
        return this.cert.getVersion();
    }

    public String getIssuer() {
        X509Name x509IssuerName = this.cert.getIssuer();
        return x509IssuerName.toString();
    }

    public String getSubject() {
        X509Name x509SubjectName = this.cert.getSubject();
        return x509SubjectName.toString();
    }

    public Date getNotBefore() {
        Time startTime = this.cert.getStartDate();
        return startTime.getDate();
    }

    public Date getNotAfter() {
        Time endTime = this.cert.getEndDate();
        return endTime.getDate();
    }

    public BigInteger getSerialNumber() {
        DERInteger derSN = this.cert.getSerialNumber();
        return derSN.getValue();
    }

    public String getStringSerialNumber() {
        DERInteger derSN = this.cert.getSerialNumber();
        return derSN.getValue().toString(16).toUpperCase();
    }

    public String getSignatureAlgName() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        boolean isContain = PKIConstant.oid2SigAlgName.containsKey(oid);
        if (!isContain) {
            return this.getSignatureAlgOID();
        }
        String sigAlgName = (String)PKIConstant.oid2SigAlgName.get(oid);
        return sigAlgName;
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        DERObjectIdentifier oid = algID.getObjectId();
        return oid.getId();
    }

    public JKey getPublicKey() throws PKIException {
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        JKey pubKey = null;
        try {
            pubKey = Parser.SPKI2Key(spki);
        }
        catch (Exception ex) {
            throw new PKIException("850305", "\u4e3b\u9898\u516c\u94a5\u4fe1\u606f\u8f6c\u6362\u4e3a\u516c\u94a5\u5931\u8d25", ex);
        }
        return pubKey;
    }

    public byte[] getTBSCertificate() throws PKIException {
        TBSCertificateStructure tbsCert = this.cert.getTBSCertificate();
        byte[] tbsCertData = null;
        try {
            tbsCertData = Parser.writeDERObj2Bytes(tbsCert.getDERObject());
        }
        catch (Exception ex) {
            throw new PKIException("850409", "TBS\u8bc1\u4e66\u8f6cbyte[]\u6570\u7ec4\u5931\u8d25", ex);
        }
        return tbsCertData;
    }

    public byte[] getSignature() {
        DERBitString signature = this.cert.getSignature();
        return signature.getBytes();
    }

    public byte[] getSubjectUniqueId() {
        DERBitString subjectUniqueId = this.cert.getSubjectUniqueId();
        if (subjectUniqueId != null) {
            return subjectUniqueId.getBytes();
        }
        return null;
    }

    public byte[] getIssuerUniqueId() {
        DERBitString issuerUniqueId = this.cert.getSubjectUniqueId();
        if (issuerUniqueId != null) {
            return issuerUniqueId.getBytes();
        }
        return null;
    }

    public boolean verify(JKey pubKey, Session session) throws PKIException {
        DERObjectIdentifier oid = this.cert.getSignatureAlgorithm().getObjectId();
        Mechanism mechanism = null;
        if (oid.equals(PKCSObjectIdentifiers.md2WithRSAEncryption)) {
            mechanism = new Mechanism("MD2withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.md5WithRSAEncryption)) {
            mechanism = new Mechanism("MD5withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption)) {
            mechanism = new Mechanism("SHA1withRSAEncryption");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithECEncryption)) {
            mechanism = new Mechanism("SHA1withECDSA");
        } else if (oid.equals(PKCSObjectIdentifiers.sha1WithDSA)) {
            mechanism = new Mechanism("SHA1withDSA");
        } else {
            throw new PKIException("850400", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5:" + oid.getId());
        }
        byte[] tbsData = this.getTBSCertificate();
        boolean verify = false;
        try {
            verify = session.verifySign(mechanism, pubKey, tbsData, this.getSignature());
        }
        catch (Exception ex) {
            throw new PKIException("06", "\u9a8c\u8bc1\u7b7e\u540d\u64cd\u4f5c\u5931\u8d25", ex);
        }
        return verify;
    }

    public KeyUsageExt getKeyUsage() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.KeyUsage);
            if (derObj == null) {
                return null;
            }
            KeyUsageExt keyUsage = new KeyUsageExt((DERBitString)derObj);
            this.getExtensionCritical(keyUsage);
            return keyUsage;
        }
        catch (Exception e) {
            throw new PKIException("850507", "\u6784\u9020\u5bc6\u94a5\u7528\u6cd5\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public InsuranceNumberExt getInsuranceNumber() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.InsuranceNumber);
            if (derObj == null) {
                return null;
            }
            InsuranceNumberExt insuranceNum = new InsuranceNumberExt((DERPrintableString)derObj);
            this.getExtensionCritical(insuranceNum);
            return insuranceNum;
        }
        catch (Exception e) {
            throw new PKIException("850508", "\u6784\u9020\u4e2a\u4eba\u793e\u4f1a\u4fdd\u9669\u53f7\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public ICRegistrationNumberExt getICRegistrationNumber() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.ICRegistrationNumber);
            if (derObj == null) {
                return null;
            }
            ICRegistrationNumberExt icRegistrationNum = new ICRegistrationNumberExt((DERPrintableString)derObj);
            this.getExtensionCritical(icRegistrationNum);
            return icRegistrationNum;
        }
        catch (Exception e) {
            throw new PKIException("850509", "\u6784\u9020\u4f01\u4e1a\u5de5\u5546\u6ce8\u518c\u53f7\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public TaxationNumberExt getTaxationNumber() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.TaxationNumber);
            if (derObj == null) {
                return null;
            }
            TaxationNumberExt taxNum = new TaxationNumberExt((DERPrintableString)derObj);
            this.getExtensionCritical(taxNum);
            return taxNum;
        }
        catch (Exception e) {
            throw new PKIException("850511", "\u6784\u9020\u4f01\u4e1a\u7a0e\u53f7\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public OrganizationCodeExt getOrganizationCode() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.OrganizationCode);
            if (derObj == null) {
                return null;
            }
            OrganizationCodeExt orgCode = new OrganizationCodeExt((DERPrintableString)derObj);
            this.getExtensionCritical(orgCode);
            return orgCode;
        }
        catch (Exception e) {
            throw new PKIException("850510", "\u6784\u9020\u4f01\u4e1a\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public IdentifyCodeExt getIdentifyCode() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.IdentifyCode);
            if (derObj == null) {
                return null;
            }
            return new IdentifyCodeExt((ASN1Set)derObj);
        }
        catch (Exception e) {
            throw new PKIException("850512", "\u6784\u9020\u4e2a\u4eba\u8eab\u4efd\u6807\u8bc6\u7801\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public SelfDefExtension getSelfDefExtension(String oid) throws PKIException {
        DERObject asnSet = null;
        DERObjectType derobjtype = new DERObjectType();
        try {
            asnSet = this.getSelfDefExtensionData(new DERObjectIdentifier(oid), derobjtype);
        }
        catch (Exception e) {
            throw new PKIException("850526", "8505\u6784\u9020\u81ea\u5b9a\u4e49\u6269\u5c55\u57df\u5931\u8d25", e);
        }
        if (asnSet == null) {
            return null;
        }
        SelfDefExtension selfDefExtesion = new SelfDefExtension(asnSet, derobjtype.GetType());
        this.getExtensionCritical(selfDefExtesion);
        return selfDefExtesion;
    }

    public SubjectKeyIdentifierExt getSubjectKeyIdentifier() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.SubjectKeyIdentifier);
            if (derObj == null) {
                return null;
            }
            SubjectKeyIdentifierExt subjectKeyId = new SubjectKeyIdentifierExt((DEROctetString)derObj);
            this.getExtensionCritical(subjectKeyId);
            return subjectKeyId;
        }
        catch (Exception e) {
            throw new PKIException("850514", "\u6784\u9020\u4e3b\u9898\u5bc6\u94a5\u6807\u8bc6\u7b26\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public BasicConstraintsExt getBasicConstraints() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.BasicConstraints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            BasicConstraintsExt basicConstraints = new BasicConstraintsExt(asn1Sequence);
            this.getExtensionCritical(basicConstraints);
            return basicConstraints;
        }
        catch (Exception e) {
            throw new PKIException("850516", "\u6784\u9020\u57fa\u672c\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public PolicyConstraintsExt getPolicyConstraints() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.PolicyConstraints);
            if (derObj == null) {
                return null;
            }
            PolicyConstraintsExt policyConstraint = new PolicyConstraintsExt((ASN1Sequence)derObj);
            this.getExtensionCritical(policyConstraint);
            return policyConstraint;
        }
        catch (Exception e) {
            throw new PKIException("850517", "\u6784\u9020\u7b56\u7565\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public CertificatePoliciesExt getCertificatePolicies() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.CertificatePolicies);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            CertificatePoliciesExt certPolicy = new CertificatePoliciesExt(asn1Sequence);
            this.getExtensionCritical(certPolicy);
            return certPolicy;
        }
        catch (Exception e) {
            throw new PKIException("850515", "\u6784\u9020\u8bc1\u4e66\u7b56\u7565\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public PolicyMappingsExt getPolicyMappings() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.PolicyMappings);
            if (derObj == null) {
                return null;
            }
            PolicyMappingsExt policyMappings = new PolicyMappingsExt((ASN1Sequence)derObj);
            this.getExtensionCritical(policyMappings);
            return policyMappings;
        }
        catch (Exception e) {
            throw new PKIException("850518", "\u6784\u9020\u7b56\u7565\u6620\u5c04\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public ExtendedKeyUsageExt getExtendedKeyUsage() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.ExtendedKeyUsage);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            ExtendedKeyUsageExt extendedKeyUsage = new ExtendedKeyUsageExt(asn1Sequence);
            this.getExtensionCritical(extendedKeyUsage);
            return extendedKeyUsage;
        }
        catch (Exception e) {
            throw new PKIException("850519", "\u6784\u9020\u589e\u5f3a\u5bc6\u94a5\u7528\u6cd5\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public NameConstraintsExt getNameConstraints() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.NameConstraints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            NameConstraintsExt nameConstraints = new NameConstraintsExt(asn1Sequence);
            this.getExtensionCritical(nameConstraints);
            return nameConstraints;
        }
        catch (Exception e) {
            throw new PKIException("850520", "\u6784\u9020\u540d\u79f0\u9650\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public IssuerAlternativeNamesExt getIssuerAlternativeNames() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.IssuerAlternativeName);
            if (derObj == null) {
                return null;
            }
            IssuerAlternativeNamesExt issuerAltName = new IssuerAlternativeNamesExt((ASN1Sequence)derObj);
            this.getExtensionCritical(issuerAltName);
            return issuerAltName;
        }
        catch (Exception e) {
            throw new PKIException("850523", "\u6784\u9020\u9881\u53d1\u8005\u5907\u7528\u540d\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public SubjectAltNameExt getSubjectAltName() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.SubjectAlternativeName);
            if (derObj == null) {
                return null;
            }
            SubjectAltNameExt subjectAltName = new SubjectAltNameExt((ASN1Sequence)derObj);
            this.getExtensionCritical(subjectAltName);
            return subjectAltName;
        }
        catch (Exception e) {
            throw new PKIException("850522", "\u6784\u9020\u4e3b\u9898\u66ff\u6362\u540d\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public CRLDistributionPointsExt getCRLDistributionPoints() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.CRLDistributionPoints);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            CRLDistributionPointsExt crlDistributPoints = new CRLDistributionPointsExt(asn1Sequence);
            this.getExtensionCritical(crlDistributPoints);
            return crlDistributPoints;
        }
        catch (Exception e) {
            throw new PKIException("850521", "\u6784\u9020CRL\u5206\u5e03\u70b9\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public AuthorityInformationAccessExt getAuthorityInfoAccess() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.AuthorityInfoAccess);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            AuthorityInformationAccessExt aia = new AuthorityInformationAccessExt(asn1Sequence);
            this.getExtensionCritical(aia);
            return aia;
        }
        catch (Exception e) {
            throw new PKIException("850528", "\u89e3\u6790\u673a\u6784\u4fe1\u606f\u8bbf\u95ee\u63a7\u5236\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    private DERObject getExtensionData(DERObjectIdentifier oid) throws Exception {
        return this.ByteToDERObject(this.getExtensionByteData(oid));
    }

    private DERObject ByteToDERObject(byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream derIns = new ASN1InputStream(bis);
        return derIns.readObject();
    }

    private DERObject getSelfDefExtensionData(DERObjectIdentifier oid, DERObjectType type) throws Exception {
        byte[] data = this.getExtensionByteData(oid);
        DERObject derobj = null;
        switch (data[0]) {
            case 1: {
                type.SetType("Boolean");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 22: {
                type.SetType("IA5 String");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 2: {
                type.SetType("Integer");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 19: {
                type.SetType("Printable String");
                derobj = this.ByteToDERObject(data);
                break;
            }
            case 12: {
                type.SetType("UTF-8 String");
                derobj = this.ByteToDERObject(data);
                break;
            }
            default: {
                type.SetType("User Defined");
                derobj = new DEROctetString(data);
            }
        }
        return derobj;
    }

    private byte[] getExtensionByteData(DERObjectIdentifier oid) throws Exception {
        TBSCertificateStructure tbsCert = this.cert.getTBSCertificate();
        this.extensions = tbsCert.getExtensions();
        if (this.extensions == null) {
            return null;
        }
        X509Extension extension = this.extensions.getExtension(oid);
        if (extension == null) {
            return null;
        }
        return extension.getValue().getOctets();
    }

    private void getExtensionCritical(Extension extension) {
        DERObjectIdentifier oid = new DERObjectIdentifier(extension.getOID());
        X509Extension ext = this.extensions.getExtension(oid);
        extension.setCritical(ext.isCritical());
    }

    public AuthorityKeyIdentifierExt getAuthorityKeyIdentifier() throws PKIException {
        DERObject derObj = null;
        try {
            derObj = this.getExtensionData(X509Extensions.AuthorityKeyIdentifier);
            if (derObj == null) {
                return null;
            }
            ASN1Sequence asn1Sequence = (ASN1Sequence)derObj;
            AuthorityKeyIdentifierExt authorityKeyIdentifier = new AuthorityKeyIdentifierExt(asn1Sequence);
            this.getExtensionCritical(authorityKeyIdentifier);
            return authorityKeyIdentifier;
        }
        catch (Exception e) {
            throw new PKIException("850527", "\u89e3\u6790\u673a\u6784\u5bc6\u94a5\u6807\u8bc6\u7b26\u6269\u5c55\u57df\u5bf9\u8c61\u5931\u8d25", e);
        }
    }

    public static void main(String[] args) {
        try {
            FileInputStream is = new FileInputStream("C:/test/testCert.cer");
            X509Cert cert = new X509Cert(is);
            KeyUsageExt kue = cert.getKeyUsage();
            NameConstraintsExt nce = cert.getNameConstraints();
            Date date = cert.getNotAfter();
            JKey pubKey = cert.getPublicKey();
            byte[] signture = cert.getSignature();
            String issuername = cert.getIssuer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class DERObjectType {
        private String Type = null;

        private DERObjectType() {
        }

        public void SetType(String value) {
            this.Type = value;
        }

        public String GetType() {
            return this.Type;
        }
    }
}

