/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.certpair;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1InputStream;
import com.cfca.util.pki.asn1.ASN1Sequence;
import com.cfca.util.pki.asn1.x509.CertificatePair;
import com.cfca.util.pki.asn1.x509.X509CertificateStructure;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CertPair {
    private CertificatePair certPair = null;

    public CertPair(byte[] certPairData) throws PKIException {
        try {
            byte[] bCertPair = this.parseData(certPairData);
            ByteArrayInputStream bis = new ByteArrayInputStream(bCertPair);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certPair = new CertificatePair(seq);
        }
        catch (Exception ex) {
            throw new PKIException("850701", "\u521d\u59cb\u5316\u8bc1\u4e66\u5bf9\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850701", "\u521d\u59cb\u5316\u8bc1\u4e66\u5bf9\u5931\u8d25");
        }
    }

    public CertPair(InputStream certPairIS) throws PKIException {
        byte[] bCertPair = null;
        try {
            int i;
            int length = certPairIS.available();
            bCertPair = new byte[length];
            for (int readLen = certPairIS.read(bCertPair); readLen < length; readLen += i) {
                byte[] temp = new byte[length - readLen];
                i = certPairIS.read(temp);
                System.arraycopy(temp, 0, bCertPair, readLen, i);
            }
            certPairIS.close();
            bCertPair = this.parseData(bCertPair);
            ByteArrayInputStream bis = new ByteArrayInputStream(bCertPair);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.certPair = new CertificatePair(seq);
        }
        catch (Exception ex) {
            throw new PKIException("850701", "\u521d\u59cb\u5316\u8bc1\u4e66\u5bf9\u5931\u8d25", ex);
        }
        catch (Throwable ex) {
            throw new PKIException("850701", "\u521d\u59cb\u5316\u8bc1\u4e66\u5bf9\u5931\u8d25");
        }
    }

    public X509Cert getForward() {
        X509CertificateStructure certStructure = this.certPair.getForward();
        if (certStructure != null) {
            return new X509Cert(certStructure);
        }
        return null;
    }

    public X509Cert getReverse() {
        X509CertificateStructure certStructure = this.certPair.getReverse();
        if (certStructure != null) {
            return new X509Cert(certStructure);
        }
        return null;
    }

    private byte[] parseData(byte[] certPairData) throws PKIException {
        try {
            if (Parser.isBase64Encode(certPairData)) {
                certPairData = Parser.convertBase64(certPairData);
                return Base64.decode(certPairData);
            }
            return certPairData;
        }
        catch (Exception ex) {
            throw new PKIException("850701", "\u521d\u59cb\u5316\u8bc1\u4e66\u5bf9\u5931\u8d25", ex);
        }
        catch (Throwable th) {
            throw new PKIException("850701", "\u521d\u59cb\u5316\u8bc1\u4e66\u5bf9\u5931\u8d25");
        }
    }
}

